<?php
/**
 * Description of CartJoinSkuLogic
 *
 * @author xrx
 */
class CartJoinSkuLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'CartJoinSkuView';
        $this->cache_type = 'goods_list';
    }
    /**
     * 读取购物车数据
     */
    public function getListByUserId($user_id, $language_id, $get_cache=true)
    {
      global $data_cache_dir;
      $cart_session  = Common::queryStr(_s('cart_cache'), _c('PHPSESSID'));
      if(!$user_id)$user_id=0;
      $key = $user_id . '_' . $language_id . '_' . $cart_session . '_cart_cache';
      $chk = _chkcahce($key, $this->cache_type);
      if(!$get_cache || !$chk || !$cart_session)
      {
         if($user_id)
          {
            $cond   = 'c.user_id ='. $user_id . ' and l.language_id=' . $language_id;
            $chk = $this->findAll($cond);
            $productLogic = $this->load('product');
            foreach($chk as $k=>$v)
            { 
                $master_property = explode('_', $v['sku_code']);
                $cond = 'goods_id='.$v['goods_id'].' and property_id='.$master_property[0];
                $productinfo  = $productLogic->getOne($cond);
                if($productinfo['image']){
                    $chk[$k]['image'] = $productinfo['image'];
                }
                if($chk[$k]['market_price']<=0)
                {
                    $chk[$k]['market_price'] = $chk[$k]['gmarket_price'];
                }
                if($chk[$k]['price']<=0)
                {
                    $chk[$k]['price'] = $chk[$k]['gprice'];
                }
                if($chk[$k]['cost_price']<=0)
                {
                    $chk[$k]['cost_price'] = $chk[$k]['gcost_price'];
                }
                if($chk[$k]['old_price']<=0)
                {
                    $chk[$k]['old_price'] = $chk[$k]['gold_price'];
                }
                if($chk[$k]['weight']<=0)
                {
                    $chk[$k]['weight'] = $chk[$k]['gweight'];
                }
            }
          }
          else
          {
            $cart_data = _c('cartsku') ? json_decode(_c('cartsku')) : array();
            $skuProductLangLogic = $this->load('skuProductLanguage');                    
              foreach($cart_data as $item)
              {             
                $sku = $skuProductLangLogic->getOneByGoodsIdAndCodeShow((int)$item->goods_id, $item->sku_code, $language_id);              
				if($sku)
                {
                    $sku['sku_id'] = $sku['id'];
                    $sku['product_num'] = intval($item->product_num);
                    $sku['create_time'] = $item->create_time;
                    if($sku['market_price']<=0)
                    {
                        $sku['market_price'] = $sku['gmarket_price'];
                    }
                    if($sku['price']<=0)
                    {
                        $sku['price'] = $sku['gprice'];
                    }
                    if($sku['cost_price']<=0)
                    {
                        $sku['cost_price'] = $sku['gcost_price'];
                    }
                    if($sku['old_price']<=0)
                    {
                        $sku['old_price'] = $sku['gold_price'];
                    }
                    if($sku['weight']<=0)
                    {
                        $sku['weight'] = $sku['gweight'];
                    }
                    $chk[] = $sku;
                }
              }
          }
          if($chk)
          {
            _setcahce($key, $chk, $this->cache_type);
            _setSession('cart_cache', _c('PHPSESSID'));
          } 
      }
        return $chk;
    }
    public function getCartInfo($user_id,  $language_id, $get_cache=true)
    {
        $goodsProRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $offerJoinLangLogic   = $this->load('offerJoinLanguage');
        $goodsJoinLangLogic   = $this->load('goodsJoinLanguage');
        $skuLogic             = $this->load('sku');
        $product_promotion = json_decode(_s('product_promotion'), TRUE);
        $cart_promotion    = _s('cart_promotion');
        $cart_counpon      = _s('cart_coupon') ? explode('_', _s('cart_coupon')) : array(0);
        $promotionlist     = $offerJoinLangLogic->getListByLanguageId($language_id);
        $promotion_gift    = json_decode(_s('gift_promotion'), TRUE);       
        $orderitems   = array();
        $totalPrice   = 0;
        $totalQty     = 0;        
        $totalSave    = 0;
        $offer_save   = 0;
        $totalweight  = 0;
        $giftQty      = 0;
        $subtotalprice= 0; 
        $gift_outside_price = 0;
        $cart_data    = $this->getListByUserId($user_id, $language_id, $get_cache);
        foreach ($cart_data as $key => $item)
        {
            $property_ids = explode('_', $item['sku_code']);
            $properties   = $goodsProRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
            $price        = floatval($item['price']);
            $cur_price    = AppController::toolPrice($price);//当前货币的价格
            $qty          = intval($item['product_num']);                        
            $subtotal     = $cur_price * $qty;
            $save         = 0;
            $giftprice    = 0;
            $giftweight   = 0;
            $goods_gifts  = array();
            //注意用户第一次进入购物车默认选中的促销已经用户取消选择促销的情况
            $promotions   = $goodsJoinLangLogic->getPromotionOffer($item['goods_id'], $subtotal, $item['product_num'], $language_id, $promotionlist);
            $is_promotion = isset($product_promotion[$item['sku_id']]) && $product_promotion[$item['sku_id']] ? $product_promotion[$item['sku_id']] : FALSE; 
           if(!$is_promotion && $promotions)
            {
              foreach ($promotions as $pk => $pro)
              {
                if($pro['max_offer'] == 1)
                {
                  $product_promotion[$item['sku_id']] = $pk;
                  $is_promotion = $pk;
                }
              }
            }
            if($is_promotion && $is_promotion != 'nothing')
            {             
               $offer = $offerJoinLangLogic->getProductOffer($item, $is_promotion, $qty, $language_id);
               if(isset($offer['gifts']) && $offer['gifts'] && !isset($promotion_gift[$item['sku_id']]))
               {
                  foreach ($offer['gifts'] as $g)
                  {                                          
                      $gift_sku_code = '';
                      if(!empty($g['attr']))
                      {
                          foreach ($g['attr'] as $key => $attr)
                          {
                            if(!$gift_sku_code)
                            {
                              $gift_sku_code = $key;
                            }                            
                          }                      
                      }  
                      else
                      {
                          $gift_sku_code = '0_0';
                      }
                          $promotion_gift[$item['sku_id']][$g['goods_id']] = array(
                              'offer_id' => $is_promotion,
                              'goods_id' => $g['goods_id'],
                              'sku_code' => $gift_sku_code,
                          );                     
                  }
               }
               $is_gift = isset($promotion_gift[$item['sku_id']]) && $promotion_gift[$item['sku_id']] ? $promotion_gift[$item['sku_id']] : FALSE;
               if($offer)
                {
                    $subtotal  = $offer['subtotal'];
                    $pro_save  = isset($offer['save']) ? $offer['save'] : 0;
                    $totalPrice -= $pro_save;
                    $save      = $pro_save + $save;// _debug($is_gift);
                    if($is_gift && isset($offer['gifts']) && $offer['gifts'])
                    {                        
                      foreach ($is_gift as $gift)
                      {                    
                         $offerGift = isset($offer['gifts'][$gift['goods_id']]) ? $offer['gifts'][$gift['goods_id']] : 0;
                         if($offerGift && $gift['sku_code'])
                         { 
                           $gift_cond = 'goods_id=' . $gift['goods_id'] . ' and sku_code ="'. $gift['sku_code'] . '" and status=1 and stock_nums>0';
                           $gift_sku  = $skuLogic->getOne($gift_cond);
                           if($gift_sku)
                           {
                              $offerGift['sku_price']  = $gift_sku['price'];
                              $offerGift['cost_price'] = $gift_sku['cost_price'];
                              $offerGift['weight']     = $gift_sku['weight'];
                              $offerGift['sku_code']   = $gift['sku_code'];
                              $offerGift['attributes'] = $goodsProRelLangLogic->getListByGoodsIdAndPropertyIds($gift['goods_id'], explode('_', $gift['sku_code']), $language_id);
                              $giftprice     = AppController::toolPrice($offerGift['price']) + $giftprice;
                              $giftweight    = $gift_sku['weight']*$gift['num'] + $giftweight;
                              $goods_gifts[] = $offerGift;
                              $giftQty      += $gift['num'];
                              $totalPrice += AppController::toolPrice($giftprice)*$gift['num'];
                           }                          
                         }
                      }
                    }
                }              
            }
            $market_price = AppController::toolPrice($item['market_price']);
            $offset_price = 0;       
            $old_price = AppController::toolPrice($item['old_price']);
            if($item['special_status']==1 && $old_price > $cur_price && $item['end_time'] > time())
            {
                $offset_price = ($old_price- $cur_price) * $qty;
            }
            $totalPrice  += $cur_price * $qty + $giftprice;
            $subtotalprice = $subtotal + $subtotalprice + $giftprice;
            $totalQty    = $qty + $totalQty;           
            $totalSave   = $offset_price + $totalSave + $save;
            $offer_save  = $save + $offer_save;
            $totalweight = $item['weight'] * $qty + $totalweight + $giftweight;
            $gift_outside_price = $gift_outside_price + $subtotal;            
            $image = $item['image'];
            if(!$image)
            {
              $image = $goodsJoinLangLogic->getImage((int)$item['goods_id'], $language_id);
            }//_debug($promotions);
			if(!$item['gstatus'] || !$item['lstatus'])
			{
				$item['stock_nums'] = -99999999 ;	
			}
            $orderitems[$key]  = array(
                'default_base_name'  => $item['default_base_name'],
                'goods_id'   => $item['goods_id'],
                'product_id' => $item['product_id'],
                'base_name'  => $item['base_name'],               
                'codeno'     => $item['codeno'],
				'itemno'     => $item['itemno'],
                'stock_nums'     => $item['stock_nums'],
                'image'      => $image,
                'price'      => $cur_price,
                'market_price' => $market_price,
                'old_price'      => $old_price,
                'special_status'      => $item['special_status'],
                'end_time'      => $item['end_time'],
                'cost_price' => AppController::toolPrice($item['cost_price']),
                'weight'     => $item['weight'],
                'qty'        => $item['product_num'],
                'sku_id'     => $item['sku_id'],
                'sku_code'   => $item['sku_code'],
                'save'       => $offset_price,
                'discount'   => ceil($price/$item['old_price'] *100),
                'aftersave'  => $save,
                'subtotal'   => $subtotal,
                'attributes' => $properties,
                'offer_id'   => $is_promotion  ? $is_promotion : '',
                'rule_id'    => $is_promotion && $is_promotion != 'nothing' && isset($offer['rule_id']) ? $offer['rule_id'] : 0,
                'gifts'      => $goods_gifts,
                'promotions' => $promotions,
                'add_cart_time'  => $item['create_time'],
                'promotion_save' => $pro_save,
            ); 
        }
        $car_offer   = array();
        $cart_promotion_save = 0;
        $cart_coupon_save    = 0;
        $promotion_offer     = '';
        $coupon_offer        = '';
        $promotion_rule_id   = 0;
        $coupon_rule_id      = 0;
        if(($cart_promotion && $cart_promotion != 'nothing') || $cart_counpon[0])
        {
           $promotion_after_amount = AppController::toolPrice($gift_outside_price, TRUE);
           //购物车促销
           $car_offer1   = $offerJoinLangLogic->getCartOffer($cart_promotion, $promotion_after_amount, $totalQty, $language_id);          
          if($car_offer1)
           {
              if(isset($car_offer1['gifts']) && $car_offer1['gifts'] && !isset($promotion_gift['cart']))
              {    

                  foreach ($car_offer1['gifts'] as $g)
                  {                                          
                      $gift_sku_code = '';
                      if(!empty($g['attr']))
                      {
                          foreach ($g['attr'] as $key => $attr)
                          {
                            if(!$gift_sku_code)
                            {
                              $gift_sku_code = $key;
                            }                            
                          }                      
                      }  
                      else
                      {
                          $gift_sku_code = '0_0';
                      }
                          $promotion_gift['cart'][$g['goods_id']] = array(
                              'offer_id' => $cart_promotion,
                              'goods_id' => $g['goods_id'],
                              'sku_code' => $gift_sku_code,
                          );                     
                  }  
              }
              $promotion_offer     = $car_offer1['offer'];
              $promotion_rule_id   = $car_offer1['rule_id'];
              $cart_promotion_save = isset($car_offer1['cart_save']) ? $car_offer1['cart_save'] : 0;
              $cart_promotion_dis  = isset($car_offer1['cart_discount']) ? $car_offer1['cart_discount'] : 1;
              $car_offer['cart_save']    = $cart_promotion_save;
              $car_offer['cart_discount'] = $cart_promotion_dis;
              $car_offer['free_ship']     = $car_offer1['free_ship'];
              if($cart_promotion_save)
             {
                $subtotalprice = $subtotalprice - $cart_promotion_save;
             }
             elseif ($cart_promotion_dis) 
             {
                 $subtotalprice = $subtotalprice * $cart_promotion_dis;
             }
             $promotion_after_amount = $subtotalprice;
           }
           //优惠券使用
          $car_offer2   = $offerJoinLangLogic->getCartOffer($cart_counpon[0], $promotion_after_amount, $totalQty, $language_id, $cart_data);
          
          if ($car_offer2) 
          {              
             $cond = 'coupon_code="' . $cart_counpon[1] . '"';
             $couponLogic = $this->load('coupon');
             $couponuserLogic = $this->load('couponUser');
             $coupon = $couponLogic->getOne($cond);
             //$days  = ceil((SYS_TIME-$coupon['create_time'])/86400);

            $cart_counpon[2] = $car_offer2['offer']['base_name'];
            $using_num = $car_offer2['offer']['using_num'];
            $cond2  = 'user_id='. $user_id . ' and offer_id=' . $car_offer2['offer']['id'];
            if($car_offer2['offer']['coupon_type']==1)
            {
               $used_num  = $couponuserLogic->getCount($cond2);
            }
            else
            {
               $cond2 .= ' and status=2';//已使用状态#1可用0#不可用2#已使用
               $used_num  = $couponLogic->getCount($cond2);
            }
             if($using_num == 0 || $using_num >= ($used_num + 1))
             {
                $coupon_offer     = $car_offer2['offer'];
                $coupon_rule_id   = $car_offer1['rule_id'];
                $cart_coupon_save    = isset($car_offer2['cart_save']) ? $car_offer2['cart_save'] : 0;
                $cart_coupon_dis     = isset($car_offer2['cart_discount']) ? $car_offer2['cart_discount'] : 1;
                $car_offer['cart_save']     = $cart_coupon_save + $cart_promotion_save;
                $car_offer['cart_discount'] = $cart_coupon_dis; 
                if($cart_coupon_save)
                {
                   $subtotalprice = $subtotalprice - $cart_coupon_save;
                }
                elseif ($cart_coupon_dis) 
                {
                    $subtotalprice = $subtotalprice * $cart_coupon_dis;
                }
             }
             else
             {
                 $cart_counpon = array(0);
                 _setSession('cart_coupon', '');
             }
           }
           else
           {
               $cart_counpon = array(0);
               _setSession('cart_coupon', '');
           }
        }
        $cart_gift = array();
        if(isset($promotion_gift['cart']))
        {
          foreach($promotion_gift['cart'] as $gift)
          {
            $offerGift = isset($promotionlist['gifts'][$cart_promotion][$promotion_rule_id][$gift['goods_id']]) ? $promotionlist['gifts'][$cart_promotion][$promotion_rule_id][$gift['goods_id']] : 0;           
            if($offerGift && $gift['sku_code'])
            { 
              $gift_cond = 'goods_id=' . $gift['goods_id'] . ' and sku_code ="'. $gift['sku_code'] . '" and status=1 and stock_nums>0';
              $gift_sku  = $skuLogic->getOne($gift_cond);
              if($gift_sku)
              {
                $offerGift['sku_price']  = $gift_sku['price'];
                $offerGift['cost_price'] = $gift_sku['cost_price'];
                $offerGift['weight']     = $gift_sku['weight'];
                $offerGift['sku_code']   = $gift['sku_code'];
                $offerGift['attributes'] = $goodsProRelLangLogic->getListByGoodsIdAndPropertyIds($gift['goods_id'], explode('_', $gift['sku_code']), $language_id);
                $subtotalprice  = AppController::toolPrice($offerGift['price']) + $subtotalprice;
                $giftweight  = $gift_sku['weight']*$offerGift['num'] + $giftweight;
                $cart_gift[] = $offerGift;
                $giftQty    += $offerGift['num'];
                $totalPrice += AppController::toolPrice($offerGift['price']);
              }
            }
          }
        }
       //促销信息存放到cookie
        _setSession('product_promotion', json_encode($product_promotion));
        _setSession('gift_promotion', json_encode($promotion_gift));
        return array(
            'orderitems' => $orderitems,
            'totalqty'   => $totalQty,
            'final_qty'  => $totalQty + $giftQty,
            'totalprice' => AppController::price_format($totalPrice),//还没有参与优惠的总金额
            'totalsave'  => AppController::price_format($totalSave),//总的优惠（特价与原价相比）
            'offer_save' => AppController::price_format($offer_save),//商品优惠总额
            'totalweight'   => $totalweight,
            'cart_promotion'=> $cart_promotion,
            'cart_coupon'   => $cart_counpon,//数组            
            'cart_save'     => isset($car_offer['cart_save']) ? AppController::price_format($car_offer['cart_save']) : '',//购物车促销优惠节省金额
            'cart_discount' => isset($car_offer['cart_discount']) ? $car_offer['cart_discount'] : '',//购物车促销优惠折扣
            'subtotalprice' => AppController::price_format($subtotalprice),//购物车优惠后的价格
            'promotion_save'   => $cart_promotion_save,
            'coupon_save'      => $cart_coupon_save,
            'promotion_offer'  => $promotion_offer,
            'coupon_offer'     => $coupon_offer,
            'promotion_rule_id'=> $promotion_rule_id,
            'coupon_rule_id'   => $coupon_rule_id,
            'cart_gift'        => $cart_gift,
            'free_ship'        => $car_offer['free_ship'] ? $car_offer['free_ship'] : ($car_offer2['free_ship'] ? $car_offer2['free_ship'] : 0),
        );
    }
    /**
     * 获取购物车价格
     * @param type $user_id
     * @param type $product_promotion
     * @param type $promotion_gift
     * @param type $language_id
     * @return type 
     */
    public function getCartPrice($user_id, $product_promotion, $promotion_gift, $language_id, $cart_promotion=0, $cart_counpon=NULL)
    {
      $offerJoinLangLogic = $this->load('offerJoinLanguage');
      $totalPrice   = 0;
      $totalQty     = 0;
      $totalSave    = 0;
      $totalweight  = 0;
      $giftQty      = 0;
      $cart_data  = $this->getListByUserId($user_id, $language_id);
      $gift_outside_price = 0;
      foreach ($cart_data as $item)
      {
          $price        = floatval($item['price']);
          $cur_price    = AppController::toolPrice($price);
          $qty          = intval($item['product_num']);
          $is_promotion = isset($product_promotion[$item['sku_id']]) && $product_promotion[$item['sku_id']] ? $product_promotion[$item['sku_id']] : FALSE;
          $is_gift      = isset($promotion_gift[$item['sku_id']]) && $promotion_gift[$item['sku_id']] ? $promotion_gift[$item['sku_id']] : FALSE;
          $market_price = AppController::toolPrice(floatval($item['market_price']));
          $save         = 0;
          $subtotal     = 0;
          $giftprice    = 0;
          if($market_price > $cur_price)
          {
            $save = ($market_price - $cur_price) * $qty;
          }
          if($is_promotion && $is_promotion != 'nothing')
          {              
            $offer = $offerJoinLangLogic->getProductOffer($item, $is_promotion, $qty, $language_id);
            if($offer)
            {
                $subtotal  = $offer['subtotal'];
                $save      = (isset($offer['save']) ? $offer['save'] : 0) + $save;// _debug($is_gift);
                if($is_gift && $offer['gifts'])
                {

                  foreach ($is_gift as $gift)
                  {
                      $offerGift = isset($offer['gifts'][$gift['goods_id']]) ? $offer['gifts'][$gift['goods_id']] : 0;
                      if($offerGift)
                      {
                        $giftprice = AppController::toolPrice($offerGift['price']) + $giftprice;
                        $giftQty  += $offerGift['num'];
                      }
                  }
                }
            }
            else
            {
                $subtotal   = $cur_price * $qty;
            }
          }
          else
          {
            $subtotal   = $cur_price * $qty;
          }       
          $totalPrice  = $subtotal + $giftprice + $totalPrice;
          $totalQty    = $qty + $totalQty;
          $totalSave   = $save + $totalSave;
          $totalweight = intval($item['weight']) + $totalweight;
          $gift_outside_price = $gift_outside_price + $subtotal;
      }
       $cart_counpon      = $cart_counpon ? explode('_', $cart_counpon) : array(0);
        $car_offer   = array();
        $cart_promotion_save = 0;
        $cart_coupon_save    = 0;
        $promotion_offer     = '';
        $coupon_offer        = '';
        $promotion_rule_id   = 0;
        $coupon_rule_id      = 0;
        $subtotalprice       = $totalPrice;
        if($cart_promotion || $cart_counpon[0])
        {
          $promotion_after_amount = AppController::toolPrice($gift_outside_price, TRUE);
           //购物车促销
           $car_offer1   = $offerJoinLangLogic->getCartOffer($cart_promotion, $promotion_after_amount, $totalQty, $language_id);          
          if($car_offer1)
           {
              $promotion_offer     = $car_offer1['offer'];
              $promotion_rule_id   = $car_offer1['rule_id'];
              $cart_promotion_save = isset($car_offer1['cart_save']) ? $car_offer1['cart_save'] : 0;
              $cart_promotion_dis  = isset($car_offer1['cart_discount']) ? $car_offer1['cart_discount'] : 1;
              $car_offer['cart_save']    = $cart_promotion_save;
              $car_offer['cart_discount'] = $cart_promotion_dis;
              $car_offer['free_ship']     = $car_offer1['free_ship'];
              if($car_offer1['gifts'])
              {
                  $car_offer['gifts'] = $car_offer1['gifts'];
              }
              if($cart_promotion_save)
             {
                $subtotalprice = $subtotalprice - $cart_promotion_save;
             }
             elseif ($cart_promotion_dis) 
             {
                 $subtotalprice = $subtotalprice * $cart_promotion_dis;
             }
             $promotion_after_amount = $subtotalprice;
           }
           //优惠券使用
          $car_offer2   = $offerJoinLangLogic->getCartOffer($cart_counpon[0], $promotion_after_amount, $totalQty, $language_id, $cart_data);
          if ($car_offer2) {
             $coupon_offer     = $car_offer2['offer'];
             $coupon_rule_id   = $car_offer1['rule_id'];
             $cart_coupon_save    = isset($car_offer2['cart_save']) ? $car_offer2['cart_save'] : 0;
             $cart_coupon_dis     = isset($car_offer2['cart_discount']) ? $car_offer2['cart_discount'] : 1;
             $car_offer['cart_save']     = $cart_coupon_save + $cart_promotion_save;
             $car_offer['cart_discount'] = $cart_coupon_dis; 
             if($car_offer2['free_ship'])
             {
                 $car_offer['free_ship']     = $car_offer2['free_ship'];
             }
             if($cart_coupon_save)
             {
                $subtotalprice = $subtotalprice - $cart_coupon_save;
             }
             elseif ($cart_coupon_dis) 
             {
                 $subtotalprice = $subtotalprice * $cart_coupon_dis;
             }
           }
        }
        
        
        $cart_gifts = array();
        if($car_offer['gifts'])
        {
          foreach ($car_offer['gifts'] as $item)
          {                       
                $gift_sku_code = '';
                $attr_html     = '';
                if(!empty($item['attr']))
                {
                    foreach ($item['attr'] as $key => $attr)
                    {
                      if(!$gift_sku_code)
                      {
                          $gift_sku_code = $key;
                      }
                      $attr_html .= '<option value="'.$key.'">' . $attr. '</option>';
                    }
                    if($promotion_gift['cart'][$item['goods_id']]['sku_code'])
                    {
                        $gift_sku_code = $promotion_gift['cart'][$item['goods_id']]['sku_code'];
                    }
                    $promotion_gift['cart'][$item['goods_id']] = array(
                        'offer_id' => $cart_promotion,
                        'goods_id' => $item['goods_id'],
                        'sku_code' => $gift_sku_code,
                    );
                    $cartgiftprice = 0;
                    $cartgiftprice = AppController::toolPrice($item['price']);
                    $subtotalprice += $cartgiftprice;
                    $totalPrice += $cartgiftprice;
                    $giftQty       += $item['num'];
                    $cart_gifts[] = array(
                      'image'     => $item['image'],
                      'goods_id'  => $item['goods_id'],
                      'base_name' => $item['base_name'],
                      'num'       => $item['num'],
                      'price'     => AppController::toolPrice($item['price']),
                      'attr'      => $attr_html,
                    );
                }
            }
            _setSession('gift_promotion', json_encode($promotion_gift));
        }   

      return array(
          'totalprice'  => $totalPrice,
          'subtotalprice'  => $subtotalprice,
          'totalqty'    => $totalQty,
          'totalsave'   => $totalSave + $cart_coupon_save + $cart_promotion_save,
          'totalweight' => $totalweight,
          'cart_save'     => isset($car_offer['cart_save']) ? AppController::price_format($car_offer['cart_save']) : '',//购物车促销优惠节省金额
          'coupon_save'    => $cart_coupon_save,
          'coupon_offer'    => $car_offer2,
          'promotion_save'    => $cart_promotion_save,
          'final_qty'   => $totalQty + $giftQty,
          'gifts'       => $cart_gifts,
      );
    }
    
     /**
     * 读取购车商品的数量
     * @param type $user_id
     * @return type 
     */
    public function getCartCount($user_id, $language_id)
    {  
	   $count = 0;
       $data = $this->getListByUserId($user_id, $language_id);
       foreach ($data as $value)
       {
         $count += $value['product_num'];
       }
       return $count;
    }
}

?>
