<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of CouponLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class CouponLogic extends BaseLogic
{
  public function __construct()
  {
    parent::__construct();
    $this->table = 'CouponTable';
  }
  public function save($data, $primary = 0)
    {
      $map = Zhtx::createDataMap();
      $map->createEntry($data);
      if($primary)
      {
        return $this->updateById($map, $primary);
      }
      else
      {
        return $this->insert($map);
      }
    }
    
    
    public function SendCoupon($user_id,$offer_id){
        $offer    = $this->load("offer")->getOneById($offer_id);
        $send_limits = $offer['send_limit']-1;
        $send_nums   = $offer['send_num']+1;
        //优惠券编号构造
        $coupon_code     = strtoupper($offer['prefix'].date('ymdHis', time()).Common::random(3));
        $coupon_data = array(
            'offer_id'    => $offer_id,
            'user_id'    => $user_id,
            'coupon_code' => $coupon_code,
            'create_time' => SYS_TIME,
            'status'      => 1,
        );
        $this->save($coupon_data);
        $offer_data = array(
            'send_limit' => $send_limits,
            'send_num'  => $send_nums,
        );
        $this->load("offer")->save($offer_data, $offer_id);
    }
    
    /**
     * 读取用户提交验证有效优惠券
     */
    public function getValidCommon()
    {
       $coupon_code_str = _s('coupon_code_list');
       $coupon_code_list = array();
       if($coupon_code_str)
       {
           $coupon_code_list = unserialize($coupon_code_str);
           $conpons = $this->findAll("id in(".join(",",$coupon_code_list).") and status=1");

            $offer_ids   = array();
            $coupon_time = array();
            $coupon_codes= array();
            foreach($conpons as $val)
            {
              $offer_ids[] = $val['offer_id'];
              $coupon_time[$val['offer_id']] = $val['create_time'];
              $coupon_codes[$val['offer_id']] = $val['coupon_code'];
            }
            if(!empty($offer_ids))
            {
               $languageLogic = $this->load('language');
               $language_id = $languageLogic->language_id;
               $now        = time();
               $offer_cond = 'o.id in (' . implode(',', $offer_ids) . ') and o.offer_type=2 and o.status=1 and o.start_time<='.$now.' and o.end_time>' . $now.' and language_id='.$language_id;
               $offerJoinLangLogic = $this->load('offerJoinLanguage');
               $offerList = $offerJoinLangLogic->findAll($offer_cond, TRUE);     
                foreach($conpons as $_val)
                {
                  $value = $offerList[$_val['offer_id']];
                  //$days = ($now - intval($_val['create_time']))/86400;                
                  //if($days < $value['days'] || $value['days']==0)
                  //{
                      $value['coupon_code'] = $_val['coupon_code'];
                      $value['using_time'] = $_val['using_time'];
                      $value['face_value'] = $_val['face_value'];
                      $result[] = $value;
                 // }
                }         
            }
            return $result;
       }
       return false;
    }

    /**
     * 读取用户有效优惠券
     * @param type $user_id
     * @param type $status
     * @return type 
     */
    public function getValidByUserId($user_id)
    {
      $result    = array();
      $cond      = 'user_id=' . $user_id . ' and status=1';
      $conpons   = $this->findAll($cond);
      $offer_ids   = array();
      $coupon_time = array();
      $coupon_codes= array();
      foreach($conpons as $val)
      {
        $offer_ids[] = $val['offer_id'];
        $coupon_time[$val['offer_id']] = $val['create_time'];
        $coupon_codes[$val['offer_id']] = $val['coupon_code'];
      }
      if(!empty($offer_ids))
      {
         $languageLogic = $this->load('language');
         $language_id = $languageLogic->language_id;
         $now        = time();
         $offer_cond = 'o.id in (' . implode(',', $offer_ids) . ') and o.offer_type=2 and o.status=1 and o.start_time<='.$now.' and o.end_time>' . $now.' and language_id='.$language_id;
         $offerJoinLangLogic = $this->load('offerJoinLanguage');
         $offerList = $offerJoinLangLogic->findAll($offer_cond, TRUE);     
          foreach($conpons as $_val)
          {
            $value = $offerList[$_val['offer_id']];
            if($value)
            {
                //$days = ($now - intval($_val['create_time']))/86400;                
                //if($days < $value['days'] || $value['days']==0)
                //{
                    $value['coupon_code'] = $_val['coupon_code'];
                    $value['using_time'] = $_val['using_time'];
                    $value['face_value'] = $_val['face_value'];
                    $result[] = $value;
                //}
            }
          }         
      }
      return $result;
    }
    /**
     * 读取用户所有优惠券
     * @param type $user_id
     * @return type 
     */
    public function getListByUserId($user_id)
    {
      $result    = array();
      $cond      = 'user_id=' . $user_id . ' order by create_time desc';
      $conpons   = $this->findAll($cond);
      $offer_ids   = array();
      foreach($conpons as $val)
      {
        $offer_ids[] = $val['offer_id'];
      }
      if(!empty($offer_ids))
      {
         $languageLogic = $this->load('language');
         $language_id = $languageLogic->language_id;
         $now        = time();
         $offer_cond = 'o.id in (' . implode(',', $offer_ids) . ') and o.offer_type=2 and o.is_cart=1';
         if($language_id)
         {
            $offer_cond .= ' and language_id='.$language_id;
         }
         $offerJoinLangLogic = $this->load('offerJoinLanguage');
         $offerList = $offerJoinLangLogic->findAll($offer_cond, TRUE);       
          foreach($conpons as $_val)
          {
            $value = $offerList[$_val['offer_id']];
            $days = ($now - intval($_val['create_time']))/86400;
            $value['valid'] = 1;
            if($value['days'] && $days > $value['days'])
            {   
              $value['valid'] = 0;
            }
            else if($value['status'] == 0)
            {
                $value['valid'] = 0;
            }
            else if($value['end_time'] < $now)
            {
                $value['valid'] = 0;
            }
            $value['coupon_code'] = $_val['coupon_code'];
            $value['using_time'] = $_val['using_time'];
            $value['face_value'] = $_val['face_value'];
            $result[] = $value;
          }
                      
      }
      return $result;
    }
    /**
    * 获取有用为发送的的优惠券
    *  
    */
   public function getUsefulCoupon()
   {
     $offerLogic  = $this->load('offer');
     $offer_cond  = 'offer_type=2' . ' and status=1 and start_time <' . SYS_TIME . ' and end_time >' . SYS_TIME;
     $offers = $offerLogic->findAll($offer_cond, TRUE);
     $offer_ids = array();
     foreach($offers as $value)
     {
       $offer_ids[] = $value['id'];
     }
     if(empty($offer_ids))
     {
       return false;
     }
     $coupon_cond = 'offer_id in(' . implode(',', $offer_ids) . ') and user_id=0 and status=1 and send_status=0';
     $coupons = $this->findAll($coupon_cond);
     $result = array();
     foreach($coupons as $val)
     {
       $days = (SYS_TIME - intval($val['create_time']))/86400;
       $valid_days = $offers[$val['id']]['days'];
       if($valid_days == 0 || ($days < $valid_days))
       {
         $val['offer'] = $offers[$val['id']];
         $result[] = $val;
       }
       
     }
     return $result;
   }
   /**
    * 通过优惠ID随机获取有效优惠券编号
    * @param type $offer_id 优惠ID
    * @param type $random_num 随机数量
    * @param type $language_id 站点ID
    * @return  不符合要求 返回false 有优惠券 返回 array 包含优惠、优惠编码
    */
   public function getRandomConpon($offer_id, $random_num, $language_id)
   {
     $offerLogic  = $this->load('offer');
     $offerLangLogic  = $this->load('offerJoinLanguage');
     $offer_cond  = 'o.id=' . $offer_id . ' and o.offer_type=2 and o.status=1 and o.start_time <' . SYS_TIME . ' and o.end_time >' . SYS_TIME . ' and l.language_id=' . $language_id;
     $offer = $offerLangLogic->getOne($offer_cond);
     if(!$offer || ($offer['using_time'] && $random_num > $offer['using_time']) || ($offer['send_num'] + $random_num) >= $offer['send_limit'])
     {
       return FALSE;
     }
     $send_limit = intval($offer['send_limit']);
     $send_num   = intval($offer['send_num']);
     $coupons    = array();
      for($i=0; $i < $random_num; $i++)
      {
        //优惠券编号构造
        $coupon_code     = strtoupper($offer['prefix'].date('ymdHis', time()).Common::random(3));
        $coupon_data = array(
            'offer_id'    => $offer_id,
            'coupon_code' => $coupon_code,
            'create_time' => SYS_TIME,
            'status'      => 1,
            'send_status' => 1,
        );
        $c_result = $this->save($coupon_data);
        if($c_result)
        { 
          $coupons[] = $coupon_code;
          $send_limit--; 
          $send_num++;
        }
      }
      $offer_data = array(
          'send_limit' => $send_limit,
          'send_num'  => $send_num,
      );
      $offerLogic->save($offer_data, $offer_id);
      return array('offer'=> $offer, 'coupon' => $coupons);
   }
}

?>
