<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of CreditDetailLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class CreditDetailLogic extends BaseLogic
{
  public function __construct()
  {
    parent::__construct();
    $this->table = 'CreditDetailTable';
  }
  public function save($data, $id = 0)
  {
      $map = Zhtx::createDataMap();
      $map->createEntry($data);
      if($id)
      {
          $res = $this->update($map, 'id='.$id); 
      }
      else
      {
          $res = $this->insert($map);
      }
      return $res;
  }
  /**
   * 获取积分
   * 1、用户注册的时候
   * 2、订单支付成功的时候
   * 3、用户评论审核通过(一个产品只赠送一次)
   * @param type $type 
   */
  public function getCredit($type = 'register', $user_id=0, $language_id=0, $order_no=null, $order_id=0)
  {        
    $creditCondLogic = $this->load('creditCond');   
    $userLogic = $this->load('user');          
    $ip = Common::_ip2long(Common::ip());
    if($type == 'register')
    {
      $user      = $userLogic->getOneById($user_id);
      $ipJoinCountryLogic = $this->load('ipJoinCountry');
      $settingLogic = $this->load('creditSetting');
      $limit_time   = $settingLogic->getValidDate();//获取过期时间
      //注册送积分
      $cond = $creditCondLogic->getOne('status=1 and type=' . 4);
	  if($cond)
	  {
      $user_credit_data = array(
          'user_id' => $user['id'],
          'total_credit'  => $cond['credit_value'],
          'useful_credit' => $cond['credit_value'],
          'create_time'   => SYS_TIME,
          'language_id'   => $language_id,
          'country_id'    => $ipJoinCountryLogic->getCountryId($ip),
          'domain'      => SITE_URL,
          'ip'          => $ip,
          'remark'      => 'register_sent',
          'limit_time'  => $limit_time,
      );
      $this->save($user_credit_data);
          }
      //推荐会员
      $cond = $creditCondLogic->getOne('status=1 and type=' . 2);
      if(!$cond || !$user['parent_user_id'])
      {
        return;
      }
      $parent_user = $userLogic->getOneById($user['parent_user_id']);
      if(!$parent_user)
      {
        return;
      }
      $data = array(
          'user_id' => $parent_user['id'],
          'total_credit'  => $cond['credit_value'],
          'useful_credit' => $cond['credit_value'],
          'create_time'   => SYS_TIME,
          'language_id'   => $language_id,
          'country_id'    => $ipJoinCountryLogic->getCountryId($ip),
          'domain'      => SITE_URL,
          'ip'          => $ip,
          'remark'      => 'recommend_user_sent',
          'limit_time'  => $limit_time,
      );
      if($this->save($data))
      {
        $parent_credit = $parent_user['credit'] + $cond['credit_value'];
        $map = Zhtx::createDataMap();
        $map->addEntry('credit', $parent_credit, DB::INT);
        $userLogic->updateById($map,$parent_user['id']);
      }
    }
    else if($type == 'order')
    {
      $orderLogic = $this->load('order');
      if($order_no)
      {
        $order = $orderLogic->getOne('itemno="' . $order_no . '"');
      }
      else if($order_id)
      {
        $order = $orderLogic->getOneById($order_id);
      }
      if(!$order)
      {
        return;
      }
      $user_id = $order['user_id'];
      $user      = $userLogic->getOneById($user_id);
      if($order['payment_status'] == 201 && $order['credit_status'] != 1)
      {
         $creditConds = $creditCondLogic->findAll('status=1 and type!=2');
         foreach ($creditConds as $value)
         {
           if($value['type'] == 1)
           {
             $currencyLogic  = $this->load('currency');
             $currency_code  = $order['currency_code'];//货币三位符
             $currency_conde = 'standard_code="' . $currency_code . '"';
             $currency       = $currencyLogic->getOne($currency_conde);
             //下单并支付成功
             $formula_pre = 0;
             if($value['formula_pre'] == 1)
             {
               $formula_pre = AppController::speChangePrice($order['final_amount'], $currency, TRUE);
             }
             else if($value['formula_pre'] == 2)
             {
               $formula_pre = AppController::speChangePrice($order['total_amount'], $currency, TRUE);
             }
             else if($value['formula_pre'] == 3)
             {
                $formula_pre = AppController::speChangePrice($order['cost_payment'], $currency, TRUE);
             }
             $credit_value = 0;
             switch ($value['formula_operation'])
             {
               case 1:
                 $credit_value = $formula_pre + $value['formula_value'];                 
                 break;
               case 2:
                 $credit_value = $formula_pre - $value['formula_value'];                 
                 break;
               case 3:
                 $credit_value = $formula_pre * $value['formula_value'];                 
                 break;
               case 4:
                 $credit_value = $formula_pre / $value['formula_value'];                 
                 break;
               default:
                 break;
             }             
              $settingLogic = $this->load('creditSetting');
              $limit_time   = $settingLogic->getValidDate();//获取过期时间
              $data = array(
                  'user_id' => $user_id,
                  'total_credit'  => $credit_value,
                  'useful_credit' => $credit_value,
                  'create_time'   => SYS_TIME,
                  'language_id'   => $order['language_id'],
                  'country_id'    => $order['country_id'],
                  'domain'      => $order['domain'],
                  'ip'          => $order['ip'],
                  'remark'      => 'order_paid_sent',
                  'limit_time'  => $limit_time,
              );
              if($this->save($data))
              {
                $user_credit = $user['credit'] + $credit_value;
                $map = Zhtx::createDataMap();
                $map->addEntry('credit', $user_credit, DB::INT);
                $userLogic->updateById($map,$user['id']);
                //更新订单
                $order_map = Zhtx::createDataMap();
                $order_map->addEntry('credit_status', 1, DB::INT);
                $orderLogic->updateById($order_map,$order['id']);
              }             
           }
           else if($value['type'] ==3)
           {
             //推荐会员首次下单并支付成功
             if(!$user['parent_user_id'])
             {
               return;
             }
             $parent_user = $userLogic->getOneById($user['parent_user_id']);
              if(!$parent_user)
              {
                return;
              }
              $where = 'create_time <' . $order['create_time'] . ' and user_id=' . $user_id;
              $count = $orderLogic->getCount($where);
              if($count > 0 )
              {
                return;
              }
              $settingLogic = $this->load('creditSetting');
              $limit_time   = $settingLogic->getValidDate();//获取过期时间
              $data = array(
                  'user_id' => $parent_user['id'],
                  'total_credit'  => $value['credit_value'],
                  'useful_credit' => $value['credit_value'],
                  'create_time'   => SYS_TIME,
                  'language_id'   => $order['language_id'],
                  'country_id'    => $order['country_id'],
                  'domain'      => $order['domain'],
                  'ip'          => $order['ip'],
                  'remark'      => 'recommend_user_first_order_paid_sent',
                  'limit_time'  => $limit_time,
              );
              if($this->save($data))
              {
                $parent_credit = $parent_user['credit'] + $cond['credit_value'];
                $map = Zhtx::createDataMap();
                $map->addEntry('user_credit', $parent_credit, DB::INT);
                $userLogic->updateById($map,$parent_user['id']);
                $order_map = Zhtx::createDataMap();
                $order_map->addEntry('credit_status', 1, DB::INT);
                $orderLogic->updateById($order_map,$order['id']);
              }
           }else if($value['type'] == 7)
           {
             //推荐会员下单支付成功
             if(!$user['parent_user_id'])
             {
               return;
             }
             $parent_user = $userLogic->getOneById($user['parent_user_id']);
              if(!$parent_user)
              {
                return;
              }
             $currencyLogic  = $this->load('currency');
             $currency_code  = $order['currency_code'];//货币三位符
             $currency_conde = 'standard_code="' . $currency_code . '"';
             $currency       = $currencyLogic->getOne($currency_conde);
             //下单并支付成功
             $formula_pre = 0;
             if($value['formula_pre'] == 1)
             {
               $formula_pre = AppController::speChangePrice($order['final_amount'], $currency, TRUE);
             }
             else if($value['formula_pre'] == 2)
             {
               $formula_pre = AppController::speChangePrice($order['total_amount'], $currency, TRUE);
             }
             else if($value['formula_pre'] == 3)
             {
                $formula_pre = AppController::speChangePrice($order['cost_payment'], $currency, TRUE);
             }
             $credit_value = 0;
             switch ($value['formula_operation'])
             {
               case 1:
                 $credit_value = $formula_pre + $value['formula_value'];                 
                 break;
               case 2:
                 $credit_value = $formula_pre - $value['formula_value'];                 
                 break;
               case 3:
                 $credit_value = $formula_pre * $value['formula_value'];                 
                 break;
               case 4:
                 $credit_value = $formula_pre / $value['formula_value'];                 
                 break;
               default:
                 break;
             }             
              $settingLogic = $this->load('creditSetting');
              $limit_time   = $settingLogic->getValidDate();//获取过期时间
              $data = array(
                  'user_id' => $parent_user['id'],
                  'total_credit'  => $credit_value,
                  'useful_credit' => $credit_value,
                  'create_time'   => SYS_TIME,
                  'language_id'   => $order['language_id'],
                  'country_id'    => $order['country_id'],
                  'domain'      => $order['domain'],
                  'ip'          => $order['ip'],
                  'remark'      => 'order_paid_sent',
                  'limit_time'  => $limit_time,
              );
              if($this->save($data))
              {
                $user_credit = $parent_user['credit'] + $credit_value;
                $map = Zhtx::createDataMap();
                $map->addEntry('credit', $user_credit, DB::INT);
                $userLogic->updateById($map,$parent_user['id']);
                //更新订单
                $order_map = Zhtx::createDataMap();
                $order_map->addEntry('credit_status', 1, DB::INT);
                $orderLogic->updateById($order_map,$order['id']);
              }             
           }
           
         }
      }
    }
    else if($type == 'goods_comment_sent_credit')
    {
      $user      = $userLogic->getOneById($user_id);
      $ipJoinCountryLogic = $this->load('ipJoinCountry');
      $settingLogic = $this->load('creditSetting');
      $limit_time   = $settingLogic->getValidDate();//获取过期时间
      //评论审核通过送积分
      $cond = $creditCondLogic->getOne('status=1 and type=5');
      if($cond){
        $user_credit_data = array(
            'user_id' => $user['id'],
            'total_credit'  => $cond['credit_value'],
            'useful_credit' => $cond['credit_value'],
            'create_time'   => SYS_TIME,
            'language_id'   => $language_id,
            'country_id'    => $ipJoinCountryLogic->getCountryId($ip),
            'domain'      => SITE_URL,
            'ip'          => $ip,
            'remark'      => 'goods_comment_sent_credit',
            'limit_time'  => $limit_time,
        );
        $this->save($user_credit_data);
      }
    }
    else if($type == 'daily_login_sent_credit')
    {
      $user      = $userLogic->getOneById($user_id);
      $ipJoinCountryLogic = $this->load('ipJoinCountry');
      $settingLogic = $this->load('creditSetting');
      $limit_time   = $settingLogic->getValidDate();//获取过期时间
      //每日登陆送积分
      $cond = $creditCondLogic->getOne('status=1 and type=6');
      if($cond){
        $user_credit_data = array(
            'user_id' => $user['id'],
            'total_credit'  => $cond['credit_value'],
            'useful_credit' => $cond['credit_value'],
            'create_time'   => SYS_TIME,
            'language_id'   => $language_id,
            'country_id'    => $ipJoinCountryLogic->getCountryId($ip),
            'domain'      => SITE_URL,
            'ip'          => $ip,
            'remark'      => 'daily_login_sent_credit',
            'limit_time'  => $limit_time,
        );
        $this->save($user_credit_data);
      }
    }
    return;
  }
  /**
   * 检测过期积分
   * @param type $value 
   */
  public function checkCredit()
  {
    $user_id = AppController::checkLogin();
    if(!$user_id)
    {
      return;
    }
    $checkCredit = _c('check_credit');
    if(!$checkCredit)
    {      
      $cond     = 'useful_credit > 0 and limit_time!=0 and limit_time <=' . time();
      $creadits = $this->findAll($cond);
      $out_creadits = 0;            
      foreach($creadits as $value)
      {
        $map = Zhtx::createDataMap();
        $map->addEntry('useful_credit', 0, DB::INT);
        if($this->updateById($map, $value['id']))
        {
          $out_creadits += $value['useful_credit'];
        }
      }
      if($out_creadits)
      {
        $userLogic = $this->load('user');
        $user = $userLogic->getOneById($user_id);
        $user_credit = 0;
        if($user['credit'] > $out_creadits)
        {
          $user_credit = $user['credit'] - $out_creadits;
        }
        $map = Zhtx::createDataMap();
        $map->addEntry('credit', $user_credit, DB::INT);
        $userLogic->updateById($map, $user_id);
      }
      setcookie('check_credit', 1, time()+86400);
    }
  }
  /**
   * 消费积分
   * @param type $use_credit 消费积分值
   * @return type 
   */
  public function expCredit($use_credit)
  {
    $credit  = $use_credit;
    $user_id = AppController::checkLogin();
    $cond    = 'user_id= '. $user_id .' and useful_credit > 0 and (limit_time=0 or limit_time >' . time() . ') order by limit_time asc';
    while ($use_credit > 0)
    {
      $detail = $this->getOne($cond);
      if(!$detail)
      {
        $use_credit = 0; return;
      }
      $offset_credit = 0;
      if($detail['useful_credit'] > $use_credit)
      {
        $offset_credit = $use_credit;
      }
      else
      {
        $offset_credit = $detail['useful_credit'];
      }
      $useful_credit = $detail['useful_credit'] - $offset_credit;
      $used_credit   = $detail['used_credit'] + $offset_credit;
      $map = Zhtx::createDataMap();
      $map->addEntry('useful_credit', $useful_credit, DB::INT);
      $map->addEntry('used_credit', $used_credit, DB::INT);
      $res = $this->updateById($map, $detail['id']);
      if($res)
      {
        $use_credit = $use_credit - $offset_credit;
      }
    }
    $userLogic = $this->load('user');
    $map = Zhtx::createDataMap();
    $map->addEntry('credit', 'credit-' . $credit, DB::INT);
    $userLogic->updateById($map, $user_id);
  }
  
}

?>
