<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of CreditSettingLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class CreditSettingLogic extends BaseLogic
{
   public function __construct()
   {
     parent::__construct();
     $this->table = 'CreditSettingTable';
   }
   public function save($data)
  {
      $conf = $this->getOne();
      if($conf)unset($data['create_time']);
      $map = Zhtx::createDataMap();      
      $map->createEntry($data);      
      if($conf)
      {          
          $res = $this->update($map, 'id='.$conf['id']); 
          return $res ? $conf['id'] : 0;
      }
      else
      {
          return  $this->insert($map);
      }     
  }
  /**
   * 获取最近的过期时间 
   */
  public function getValidDate()
  {
    $conf   = $this->getOne();
    //获取年份
    $year   = date('Y', SYS_TIME);
    $result = 0;   
    switch ($conf['limit_date'])
    {
      case 1://无过期时间         
        break;
      case 2://按季度过期
         $one   = strtotime($year.'0331');
         $two   = strtotime($year.'0630');
         $there = strtotime($year.'0930');
         $four  = strtotime($year.'1231');
         if(SYS_TIME < $one)
         {
           $result = $one;
         }
         else if(SYS_TIME < $two)
         {
           $result = $two;
         }
         else if(SYS_TIME < $there)
         {
           $result = $there;
         }
         else if(SYS_TIME < $four)
         {
           $result = $four;
         }
        break;
      case 3://按半年过期
        $last  = strtotime($year.'0630');
        $next  = strtotime($year.'1231');
        if(SYS_TIME < $last)
         {
           $result = $last;
         }
         else if(SYS_TIME < $next)
         {
           $result = $next;
         }
        break;
      case 4://按一年过期
        $result = strtotime($year.'1231');
        break;     
      default:
        break;
    }
    return $result;
  }
  
  /**
   * 金额要以基准货币为主
   * @param type $total_credit 总积分
   * @param type $cost_payment 商品实际支付金额（不含运费）
   * @param type $order_amount 订单的实际金额（含运费）
   */
  public function getCreditInfo($total_credit, $cost_payment,  $order_amount)
  {
    $config = $this->getOne();
    if(!$config)
    {
      return FALSE;
    }
    $max_exp_credit = 0;
    switch ($config['exchange_type'])
    {
      case 1://不含运费
        $max_exp_credit = (AppController::toolPrice($cost_payment, TRUE) * $config['exchange_amount_scale'] / 100) *  $config['exchange_credit_scale'];         
        break;
      case 3://含运费
        $max_exp_credit = (AppController::toolPrice($order_amount, TRUE) * $config['exchange_amount_scale'] / 100) *  $config['exchange_credit_scale'];
        break;
      default : break;
    }
    if($max_exp_credit > $total_credit)
    {
       $max_exp_credit = $total_credit;  
    }
    $max_exp_credit = ceil($max_exp_credit);
    $max_exp_amount = AppController::toolPrice($max_exp_credit/$config['exchange_credit_scale']);
    return array('max_exp_credit' => $max_exp_credit, 'max_exp_amount' => $max_exp_amount, 'exchange_credit_scale' => $config['exchange_credit_scale'], 'is_spec' => $config['is_spec']);
  }
}

?>
