<?php
/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
class EventLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = "EventTable";
    }
    public function save($data, $primary)
    {
        $map = Zhtx::createDataMap();
        $map->createEntry($data);
        if($primary)
        {
            $result = $this->updateById($map, $primary);
        }
        else
        {
            $result = $this->insert($map);
        }
        return $result;
    }
    /**
     * 通过唯一编码获取事件的条件
     * @param string $codeno 唯一编码
     * @param array $params  参数（订单金额，创建时间）
     * @return boolean 
     */
    public function getCond($codeno, $language_id, $params) 
    { 
      $cond  = 'codeno="' . $codeno . '" and status=1';
      $event = $this->getOne($cond);
      if(!$event)
      {
        return FALSE;
      }
      if($event['start_time'] && $event['start_time'] > SYS_TIME)
      {       
        return FALSE;
      }
      if ($event['end_time'] && $event['end_time'] < SYS_TIME)
      {       
        return FALSE;
      }
      $pay_amount  = isset($params['final_amount']) ? $params['final_amount'] : 0;
      $create_time = isset($params['create_time']) ? $params['create_time'] : 0;
      $cond2       = 'event_id=' . $event['id'];    
      if($event['is_order_cond'])
      {
        $eventCondLogic = $this->load('eventCond');
        $econd   = $eventCondLogic->getOne($cond2);
        if($econd)
        {
          $type = $econd['event_cond_type'];
          if($type == 1)
          {
            $compare = $econd['compare'];
            if($compare == 1 && $pay_amount <= $econd['amount'])
            {
              return FALSE;
            }
            else if($compare == 2 && $pay_amount >= $econd['amount'])
            {
              return FALSE;
            }
            else if ($compare == 3 && $pay_amount != $econd['amount'])
            {
              return FALSE;
            }
          }
          else
          {
            if($econd['start_time'] && $econd['start_time'] > $create_time)
              {
                return FALSE;
              }
              if ($econd['end_time'] && $econd['end_time'] < $create_time)
              {
                return FALSE;
              }
          }
        }
      }
      $ecoupon = array();
      if($event['is_coupon'])
      {
        $eventCouponLogic = $this->load('eventCoupon');      
        $ecoupon = $eventCouponLogic->getOne($cond2);       
      }
      $mailLogic = $this->load('mailTplJoinLanguage');
      $where  = ' m.id = ' . $event['email_tpl_id'] . ' and l.language_id='. $language_id; 
//    Common::log('email_tpl_id=' . $event['email_tpl_id'] . ' language_id='.$language_id);
      $email  = $mailLogic->getOne($where);
//    Common::log('error5');
      if(!$email)
      {
        //return FALSE;
      }
      $where  = ' m.id = ' . $event['msg_tpl_id'] . ' and l.language_id='. $language_id; 
//    Common::log('email_tpl_id=' . $event['email_tpl_id'] . ' language_id='.$language_id);
      $msg  = $mailLogic->getOne($where);

      $result = array(
          'task_id'      => $event['task_id'],
          'codeno'       => $codeno,
          'event_id'     => $event['id'],
          'email_tpl_id' => $event['email_tpl_id'],
          'msg_tpl_id'   => $event['msg_tpl_id'],
          'sms_tpl_id'   => $event['sms_tpl_id'],
          'title'        => $email['base_name'],
          'msg_title'        => $msg['base_name'],
          'var_descript' => $email['var_descript'],
          'trigger_type' => $event['trigger_type'],
          'trigger_time' => $event['trigger_time'],
          'is_coupon'    => $event['is_coupon'],
          'coupon'       => $ecoupon,
      );
      return $result;
    }
    public function test()
    {
      $mailLogic = $this->load('MailTplJoinLanguage');
      $where     = 'm.id = ' . 1 . ' and l.language_id='. 1;
      return $mailLogic->findAll();
    }
}

?>
