<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoodsCategoryJoinLangLogic
 *
 * @author xrx
 */
class GoodsCategoryJoinLangLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table      = 'GoodsCategoryJoinLangView'; 
        $this->cache_type = 'category';
    }
    /**
     * 查找子集
     * @param type $parent_id
     * @param type $language_id
     * @param type $limit  限制数量 （默认不限制）
     * @param type $rec_type 推荐类型（暂无）
     * @param type $get_cache
     * @return type 
     */
    public function getListByLanguageId($parent_id = 0, $language_id = 0, $rec_type=0, $limit=0, $get_cache = TRUE)
    {
       global $data_cache_dir;
        if(!$language_id)
        {
            $languageLogic = $this->load('language');
            $language_id   = $languageLogic->language_id;
        }
        $cond    = 'c.parent_id =' . $parent_id . ' and l.language_id='.$language_id ;
        $key     = $parent_id . '_' . $language_id . '_category_list';
        if($rec_type>0)
        {
            $cond    .= ' and disp & '.$rec_type.'='.$rec_type;
            $key     .= '_disp'.$rec_type;
        }
        $cond    .= ' and c.status=1 and l.status=1 order by c.listorder desc,c.id desc';
        if($limit>0)
        {
            $cond    .= ' limit '.$limit; 
            $key     .= '_limit'.$limit;
        }
        $result  = _chkcahce($key, $this->cache_type, TRUE);               
        if(!$get_cache || !$result)
        { 
            $result = $this->findAll($cond, TRUE);
            foreach ($result as $vkey => $value)
            {
                $tempcate = $this->getOne('c.parent_id='.$value['id'].' and l.language_id='.$language_id);            
                if($tempcate)
                {
                    $result[$vkey]["hasson"] = true;
                }
            }
            _setcahce($key, $result, $this->cache_type);
        }
       return $result;
    }
    /**
     * 所有分类 按语言分
     * @param type $language_id
     * @param type $get_cache
     * @return type \
     */
    public function getAllByLanguageId($language_id = 0, $parent_id=-1, $get_cache = TRUE)
    {
      global $data_cache_dir;
      if(!$language_id)
        {
            $languageLogic = $this->load('language');
            $language_id   = $languageLogic->language_id;
        }        
        $ckey    = $language_id . '_category_list';
        $result  = _chkcahce($ckey, $this->cache_type, TRUE);
        if(!$get_cache || !$result)
        {
            $cond     = 'c.status=1 and l.language_id='.$language_id . ' and l.status=1 order by c.listorder desc,c.id desc';
			$result   = $this->findAll($cond, true);
            $parentId = $parent_id;
            foreach ($result as $key => $value)
            {
                $parentId = $result[$key]["parent_id"];
                if($parentId >= 0)
                {
                    $result[$parentId]["son"][] = $value;
					$result[$parentId]["hasson"] = true ;
                }
            }
            foreach ($result as $vkey => $value)
           {
              foreach ($value['son'] as $k => $v)
              {
                   if( $result[$v['id']]["hasson"] )
				   	$result[$vkey]["son"][$k]["hasson"] = true;
               }
            }
            _setcahce($ckey, $result, $this->cache_type);
        }
	
	   if($parent_id >= 0)
	   {
			return $result[$parent_id];   
	   }
	   else
	   {
			return $result;
	   }      
    }
    
    public function getCurrentCategory($category_ids, $language_id=0)
    {
      if(empty($category_ids))
      {
        return FALSE;
      }
      $cond = 'c.id in (' . implode(',', $category_ids) . ') and l.language_id='.$language_id . ' order by c.sort_weight desc';
      return $this->getOne($cond);
    }
	
	public function getItem($id, $language_id=0, $get_cache=true)
	{
		global $data_cache_dir;
       	$key     = $language_id . '_category_list';
        $result  = _chkcahce($key, $this->cache_type);
        if(!$get_cache || !$result)
        {
        	$cond = 'c.id =' . $id . ' AND l.status=1  AND l.language_id =' . $language_id;
          	$result = $this->getOne($cond);
			return $result;
		}
		else
		{
			return $result[$id];	
		}
	}
}

?>
