<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoodsCategoryLogic
 *
 * @author xrx
 */
class GoodsCategoryLogic extends BaseLogic {

    public function __construct() {
        parent::__construct();
        $this->table = 'GoodsCategoryTable';
        $this->cache_type = 'category';
    }

    public function save($data, $id = 0) {
        $tag_map = Zhtx::createDataMap();
        $tag_map->createEntry($data);
        if ($id) {
            $res = $this->updateById($tag_map, $id);
        } else {
            $res = $this->insert($tag_map);
        }
        return $res;
    }

    public function getSun($category_id, $path_id = 0, $get_cache = TRUE) {
        global $data_cache_dir;
        $key = $category_id . '_category_sun';
        $category_array = array();
        $chk = _chkcahce($key, $this->cache_type);
        if (!$get_cache || !$chk) {
            if (!$path_id) {
                $cols = array('id', 'path_id');
                $category = $this->getOneById($category_id, $cols);
                $path_id = $category ? $category['path_id'] : 0;
            }
            $cols2 = array('id', 'goods_type_id');
            $cond2 = 'path_id like "' . $path_id . '%"';
            $categorylist = $this->getCols($cond2, $cols2);
            foreach ($categorylist as $list) {
                $category_array['ids'][] = $list['id'];
                $category_array['goods_type_id'][$list['goods_type_id']] = $list['goods_type_id'];
            }
            _setcahce($key, $category_array, $this->cache_type);
        } else {
            $category_array = $chk;
        }

        return $category_array;
    }

    public function updateCache($path_id) {
        global $data_cache_dir;
        foreach (explode(',', $path_id) as $value) {
            if ($value) {
                $key = $value . '_category_sun';
                $category_ids = array();
                $cols = array('id', 'path_id');
                $category = $this->getOneById($value, $cols);
                if ($category) {
                    $cols2 = array('id');
                    $cond2 = 'path_id like "' . $category['path_id'] . '%"';
                    $categorylist = $this->getCols($cond2, $cols2);
                    foreach ($categorylist as $list) {
                        $category_ids[] = $list['id'];
                    }
                }
                _setcahce($key, $category_ids, $this->cache_type);
            }
        }
    }

    public function updateListCache($language_id) {
        global $data_cache_dir;
        $key = $language_id . '_category_list';
        _delcahce($key, '', $this->cache_type);
    }

    /**
     *  效验商品分类的商品数量
     */
    public function checkGoodsCount() {
        $goodsCategoryRelJoinGoodsLogic = $this->load('goodsCategoryRelJoinGoods');
        $cols = array('id', 'parent_id', 'path_id');
        $categories = $this->getCols('', $cols, TRUE);

        $LanguageLogic = $this->load('language');
        $base_site_id = Common::validSiteConfig();
        $languages = $LanguageLogic->getOne('id='.$base_site_id.' and status=1', array('id'));

        $goodsLanguageLogic = $this->load('goodsLanguage');
        $sql = "select count(*) as num,category_path from z_goods_language where language_id= " . $languages['id'] . " and status=1  GROUP by category_path ";
        $rels = $goodsLanguageLogic->query($sql);
        foreach ($rels as $key => $value) {
            $category_arr = explode(',', $value['category_path']);
            foreach ($category_arr as $id) {
                $result[$id] = $result[$id] + $value['num'];
            }
        }

        if($result)
        {   
            $intdata = array('goods_count' => 0);
            $this->saveByCond($intdata, '1=1');
            foreach ($result as $key => $val) {
                if (!$key)
                    continue;
                $data = array('goods_count' => $val);
                $this->save($data, $key);
            }
        }
        else
        {
            $data = array('goods_count' => 0);
            $this->saveByCond($data, '1=1');
        }
    }

}

?>
