<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoodsCategoryRelLogic
 *
 * @author xrx
 */
class GoodsCategoryRelLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table      = 'GoodsCategoryRelTable';
        $this->cache_type = 'goods_list';
    }
    public function save($data, $id=0)
    {
        $goods_cat_map = Zhtx::createDataMap();
        $goods_cat_map->createEntry($data);
        if($id)
        {
            $this->update($goods_cat_map);
        }
        else
        {
            $this->insert($goods_cat_map);
        }
        
    }
    public function getListByGoodsId($goods_id)
    {
        $res = $this->getList('goods_id ='. $goods_id);
        return $res['list'];
    }
    /**
     * 通过分类集合获取商品的id集合
     * @param type $category_ids
     * @param type $offet
     * @param type $limit
     * @return type 
     */
    public function getGoodsIds($category_ids, $offet = 0, $limit = 20, $get_cache = TRUE)
    {
        global $data_cache_dir;
        $cols   = array('goods_id');
        $cond   = 'goods_category_id in ('. implode(',', $category_ids) . ') limit ' . $offet . ',' . $limit;
        $key    = md5($cond);
        $chk    = _chkcahce($key, $this->cache_type);
        $array  = array();
        if(!$get_cache || !$chk)
        {
            $result = $this->getCols($cond, $cols);        
            foreach ($result as $value)
            {
                $array[]     = $value['goods_id'];                
            }
            _setcahce($key, $array, $this->cache_type); 
        }
        else
        {
            $array = $chk;
        }
        
        return $array;
    }
   
}

?>
