<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoodsJoinLanguageLogic
 *
 * @author xrx
 */
class GoodsJoinLanguageLogic extends BaseLogic
{

    public function __construct()
    {
        parent::__construct();
        $this->table = 'GoodsJoinLanguageView';
        $this->cache_type = "goods_info";
    }

    /**
     * 商品详情
     * @global type $data_cache_dir
     * @param type $goods_id
     * @param type $language_id
     * @param type $get_cache
     * @return boolean 
     */
    public function getDetailByGoodsId($goods_id, $language_id, $get_cache = true)
    {
        global $data_cache_dir;
        $key = $goods_id . "_" . $language_id . '_detail';
        $chk = _chkcahce($key, $this->cache_type);
        $result = array();
		
		$language_id = (int) $language_id ;
		$goods_id  = (int) $goods_id ;
		
		
        if (!$get_cache || !$chk)
        {
            $cond = 'l.goods_id =' . $goods_id . ' AND l.language_id =' . $language_id;
            $goods = $this->getOne($cond);
            if (!$goods)
            {
                return FALSE;
            }
            $productLogic = $this->load('product');
            $imageLogic = $this->load('productOtherImage');
            $catRelLogic = $this->load('goodsCategoryRel');
            $goodsPropertyRelLogic = $this->load('goodsPropertyRel');
            $products = $productLogic->getListByGoodsId($goods_id, $get_cache);
            $propertylist = $goodsPropertyRelLogic->getListByGoodsIdAndL($goods_id, $language_id);
            $images = $imageLogic->getListByGoodsId($goods_id);
            $catlist = $catRelLogic->findAll('goods_id=' . $goods_id);
            $cat_ids = array();
            foreach ($catlist as $cat)
            {
                $cat_ids[] = $cat['goods_category_id'];
            }
            $result = array(
                'goods' => $goods,
                'products' => $products,
                'propertylist' => $propertylist,
                'images' => $images,
                'category_ids' => $cat_ids,
            );
            _setcahce($key, $result, $this->cache_type);
        }
        else
        {
            $result = $chk;
        }
        return $result;
    }

    /**
     * 获取商品的一张图片
     * @param type $goods_id
     * @param type $language_id
     * @return type 
     */
    public function getImage($goods_id, $language_id)
    {
        $detail = $this->getDetailByGoodsId($goods_id, $language_id);
        foreach($detail['images'] as $val){
            if($val['image']){
                return $val['image'];
            }
        }       
    }

    /**
     * query goods list
     * @global type $data_cache_dir
     * @param type $goods_ids
     * @param type $language_id
     * @param type $get_cache
     * @return type 
     */
    public function getListByGoodsIds($goods_ids, $language_id, $get_cache = TRUE)
    {
        global $data_cache_dir;
        $cond = 'l.goods_id in (' . implode(',', $goods_ids) . ') AND l.status=1  AND l.language_id =' . $language_id . ' order by g.listorder asc';
        $key = md5($cond);
        $cache_type = 'goods_list';
        $chk = _chkcahce($key, $cache_type);
        $result = array();
        if (!$get_cache || !$chk)
        {
            $result = $this->findAll($cond);
            _setcahce($key, $result, $cache_type);
        }
        else
        {
            $result = $chk;
        }
        return $result;
    }

    public function getOneByGoodsId($goods_id, $language_id)
    {
        $goods_id = (int)$goods_id ;
		$language_id = (int)$language_id ;
		$cond = 'l.goods_id =' . $goods_id . ' AND l.language_id =' . $language_id;
        return $this->getOne($cond);
    }

    /**
     * goods list search cond
     * @global type $data_cache_dir
     * @param type $categroy_id
     * @param type $goods_type_ids
     * @param type $goods_type_id
     * @param type $language_id
     * @param type $get_cache
     * @return type 
     */
    public function getSearchCond($params, $get_cache = true)
    {
        global $data_cache_dir;
        $categroy_id = isset($params['category_id']) ? $params['category_id'] : 0;
        $brand_id = isset($params['brand_id']) ? $params['brand_id'] : 0;
        $language_id = isset($params['language_id']) ? $params['language_id'] : 0;
        $property_ids = isset($params['property_ids']) ? $params['property_ids'] : 0;
        $tag_id = isset($params['tag_id']) ? $params['tag_id'] : 0;
        //是否要统计
        $is_count = isset($params['is_count']) && $params['is_count'] == 1 ? $params['is_count'] : 0;
        if (!$language_id)
        {
            $language_id = $this->load('language')->language_id;
        }
        $cache_type = 'goods_list';
        $key = $language_id . '_category_' . $categroy_id . '_brand_' . $brand_id . '_search';
        if ($is_count == 1)
        {
            $key = $language_id . '_category_' . $categroy_id . '_brand_' . $brand_id . '_search_count';
        }
        $chk = _chkcahce($key, $cache_type);
        if (!$get_cache || !$chk)
        {
            $brandJoinLangLogic = $this->load('brandJoinLanguage');
            $brands = $brandJoinLangLogic->getListByLanguageId($language_id);
            $category = array();
            $search_brand = array();
            $propery_ids = array();
            $brand_ids = array();
            $tag_ids = array();
            if ($categroy_id)
            {
                $categoryLogic = $this->load('goodsCategory');
                $category = $categoryLogic->getOneById($categroy_id);
                $goods_type_id = $category['goods_type_id'];
                foreach ($brands as $item)
                {
                    $item_goods_type_ids = explode(',', $item['goods_type_ids']);
                  //  if (in_array($goods_type_id, $item_goods_type_ids))
                   // {

                  //  }
					$search_brand[$item['id']] = $item;
					$brand_ids[] = $item['id'];
                } 
                $goodsTypeProperty = $this->load('goodsTypeProperty');
                $cond = 'goods_type_id =' . $goods_type_id . ' and status=1';
                foreach ($goodsTypeProperty->findAll($cond) as $val)
                {
                    $propery_ids[] = $val['property_id'];
                }
            }
            $propertyJoinLangLogic = $this->load('PropertyJoinLanguage');
            $result_property = array();
            $result_pro_ids = array();
            if (!empty($propery_ids))
            {
                $propery_ids = array_unique($propery_ids);
                $property_cond = '(p.id in (' . implode(',', $propery_ids) . ') or p.parent_id in (' . implode(',', $propery_ids) . ')) and p.search =1';
                $property_cond .= ' and p.status=1 and l.language_id =' . $language_id . ' order by p.listorder desc';
                $properyList = $propertyJoinLangLogic->findAll($property_cond, true);
                foreach ($properyList as $value)
                {
                    $result_pro_ids[] = $value['id'];
                }
            }
            $tagJoinLangLogic = $this->load('goodsTagJoinLanguage');
            $tags = $tagJoinLangLogic->getListByLanguageId($language_id);
            $tags_as_search = array();
            foreach ($tags as $vkey => $_value)
            {
                if ($_value['is_search'])
                {
                    $tags_as_search[$vkey] = $_value;
                    $tag_ids[] = $vkey;
                }
            }
            //对所有的筛选条件进行统计
            $pro_count_asarray = array();
            if ($is_count == 1)
            {
                $prop_mid_sql = ""; //属性筛选集合
                if ($property_ids)
                {
                    $property_ids = array_map('intval',$property_ids);
                    $property_ids = array_filter($property_ids);
                    $propertyLogic = $this->load('property');
                    if($property_ids)
                    {
                        $propertys = $propertyLogic->findAll('id in('.join(',',$property_ids).')');
                        $property_arrs = array();
                        foreach ($propertys as $ptskey => $value)
                        {
                            $property_arrs[$value['parent_id']][] = $value['id'];
                        }
                        foreach ($property_arrs as $vk => $value)
                        {
                            $alias = 'p' . $vk;
                            $prop_mid_sql .= ' inner join ' . TABLE_PREFIX . '_goods_property_rel as ' . $alias . ' on l.goods_id=' . $alias . '.goods_id and ' . $alias . '.vid  in (' . join(',',$value) . ")";
                        }
                    }
//                    foreach ($property_ids as $vk => $value)
//                    {
//                        $alias = 'p' . $vk;
//                        $prop_mid_sql .= ' inner join ' . TABLE_PREFIX . '_goods_property_rel as ' . $alias . ' on l.goods_id=' . $alias . '.goods_id and ' . $alias . '.vid  in (' . $value . ")";
//                    }
                }

                if (count($brand_ids))
                {
                    if ($categroy_id)
                    {
                        $cond = 'l.category_path like"' . $category['path_id'] . '%" and g.brand_id in (' . implode(',', $brand_ids) . ')';
                    }
                    else
                    {
                        $cond = 'g.brand_id in (' . implode(',', $brand_ids) . ')';
                    }
                    
                    $cond .= ' and g.status=1 AND l.language_id =' . $language_id . ' and l.status=1';
                    $brand_sql = "select g.brand_id as brand_id,count(DISTINCT g.id) as num from z_goods_language as l left join z_goods_property_rel as p on p.goods_id = l.goods_id ";
                    $brand_sql = $brand_sql . $prop_mid_sql . " left join z_goods as g on g.id = l.goods_id";
                    if($tag_id){
                        $brand_sql .= ' left join z_goods_tag_rel as t on g.id=t.goods_id ';
                        $cond .= ' and t.tag_id in (' . join(',', $tag_id) . ')';
                    }
                    $brand_sql .= " where " . $cond . " group by g.brand_id";
                    $categoryRelGoodsJoinLangLogic = $this->load('categoryRelGoodsJoinLang');
                    $cache_key = md5($brand_sql);
                    $chk = _chkcahce($cache_key, $cache_type);
                    //var_dump($chk);
                    if(!$chk)
                    {
                        $brand_count = $categoryRelGoodsJoinLangLogic->query($brand_sql);
                        $res = _setcahce($cache_key, $brand_count, $cache_type);
                    }
                    else
                    {
                        $brand_count = $chk;
                    }
                }
                if (count($result_pro_ids))
                {

                    $cond = 'l.category_path like"' . $category['path_id'] . '%" and p.vid in(' . implode(',', $result_pro_ids) . ')';
                    if ($brand_id)
                    {
                        $cond .= ' and g.brand_id in (' . implode(',', $brand_id) . ')';
                    }
                    $cond .= '  and g.status=1  AND l.language_id =' . $language_id . ' and l.status=1 group by p.vid';
                    $mid_sql = "select p.vid as property_id,count(DISTINCT g.id) as num from z_goods_language as l left join z_goods_property_rel as p on p.goods_id = l.goods_id ";

                    $mid_sql = $mid_sql . $prop_mid_sql . " left join z_goods as g on g.id = l.goods_id";
                    if($tag_id)
                    {
                        $mid_sql .= ' inner join z_goods_tag_rel as t on t.goods_id = g.id and t.tag_id in (' . join(',', $tag_id) . ')';
                    }
                    $catJoinPropertyJoinGoodsJoinLangLogic = $this->load('catJoinPropertyJoinGoodsJoinLang');
                    $mid_sql .= " where $cond";
                    $cache_key = md5($mid_sql);
                    $chk = _chkcahce($cache_key, $cache_type);
                    //var_dump($chk);
                    if(!$chk)
                    {
                        $pro_count = $catJoinPropertyJoinGoodsJoinLangLogic->query($mid_sql);
                        $res = _setcahce($cache_key, $pro_count, $cache_type);
                    }
                    else
                    {
                        $pro_count = $chk;
                    }
                    if ($brand_count)
                    {
                        foreach ($brand_count as $value)
                        {
                            $search_brand[$value['brand_id']]['num'] = $value['num'];
                        }
                        $search_brand['display'] = 1;
                    }
                    if (count($tag_ids))
                    {
                        $cond = 'l.category_path like"' . $category['path_id'] . '%" and t.tag_id in (' . implode(',', $tag_ids) . ')';
                        if ($brand_id)
                        {
                            $cond .= ' and g.brand_id in (' . implode(',', $brand_id) . ')';
                        }
                        $cond .= ' and g.status=1  AND l.language_id =' . $language_id . ' and l.status=1 group by t.tag_id';
                        //cat tag brand 
                        $CatJoinTagJoinGoodsJoinLanguageLogic = $this->load('categoryJoinTagJoinGoodsJoinLanguage');
                        $tag_sql = "select t.tag_id as tag_id,count(DISTINCT g.id) as num from z_goods_language as l left join z_goods_property_rel as p on p.goods_id = l.goods_id ";
                        $tag_sql = $tag_sql . $prop_mid_sql . " left join z_goods as g on g.id = l.goods_id left join z_goods_tag_rel as t on g.id=t.goods_id";
                        $tag_sql .= " where " . $cond;
                        $cache_key = md5($tag_sql);
                        $chk = _chkcahce($cache_key, $cache_type);
                        //var_dump($chk);
                        if(!$chk)
                        {
                            $tag_count = $CatJoinTagJoinGoodsJoinLanguageLogic->query($tag_sql);
                            if($tag_count)
                            {
                                $tags_as_search['display'] = 1;
                            }
                            foreach ($tag_count as $tvalue)
                            {
                                $tags_as_search[$tvalue['tag_id']]['num'] = $tvalue['num'];
                            }
                            //var_dump($tag_count);
                            $res = _setcahce($cache_key, $tag_count, $cache_type);
                            //var_dump($res);
                        }
                        else
                        {
                            $tag_count = $chk;
                            if($tag_count)
                            {
                                $tags_as_search['display'] = 1;
                            }
                            foreach ($tag_count as $tvalue)
                            {
                                $tags_as_search[$tvalue['tag_id']]['num'] = $tvalue['num'];
                            }
                        }
                    }

                    foreach ($pro_count as $pvalue)
                    {
                        $pro_count_asarray[$pvalue['property_id']] = $pvalue['num'];
                    }
                   
                }
            }
            
            //重组数组
            $properyListBak = array();
            foreach ($properyList as $value)
            {
                $value['num'] = 0;
                $value["urlid"] = $value["id"];
                $properyListBak[$value["id"]] = $value;
                if (isset($pro_count_asarray[$value['id']]) && $pro_count_asarray[$value['id']])
                {
                    $value['num'] = $pro_count_asarray[$value['id']];
                }
                if ($value['parent_id'] == 0 && $value['base_name'])
                {
                    $result_property['parents'][$value['id']] = $value;
                }
                else
                {

                    $result_property['childs'][$value['parent_id']][] = $value;
                }
            }
//            _debug($result_property);
           foreach ($result_property['parents'] as $value)
           {
               //判断子属性数量
               foreach ($result_property['childs'][$value['id']] as $v){
                   if($v['num']){
                       $result_property['parents'][$value['id']]['num'] = 1;
                       continue;
                   }
               }
           }
            foreach ($property_ids as $key => $val)
            {
                $parent_id = $properyListBak[$val]["parent_id"];
                foreach ($result_property['childs'][$parent_id] as $k => $v)
                {
                    if ($v["id"] != $val)
                    {
                        $result_property['childs'][$parent_id][$k]["urlid"] = $result_property['childs'][$parent_id][$k]["urlid"] . "," . $val;
                    }
                }
            }
            
            Common::sort_rows($search_brand,'num',SORT_DESC);
            Common::sort_rows($tags_as_search,'num',SORT_DESC);
            foreach ($result_property['childs'] as $key => $value) {
                Common::sort_rows($result_property['childs'][$key],'num',SORT_DESC);
            }
            $chk = array(
                'brands' => $search_brand,
                'taglist' => $tags_as_search,
                'propertylist' => $result_property,
            );
            _setcahce($key, $chk, $cache_type);
        }
        return $chk;
    }

    /**
     * 获取单品牌下的筛选条件
     * @global type $data_cache_dir
     * @param type $brand_id
     * @param type $language_id
     * @param type $get_cache
     * @return type 
     */
    public function getSearchCondByBrand($brand_id, $language_id, $get_cache = true)
    {
        global $data_cache_dir;
        $key = $language_id . '_brand_' . $brand_id . '_search';
        $cache_type = 'goods_list';
        $chk = _chkcahce($key, $cache_type);
        if (!$get_cache || !$chk)
        {
            $brandJoinLangLogic = $this->load('brandJoinLanguage');
            $brand_cond = ' b.id =' . $brand_id;
            $brand = $brandJoinLangLogic->getOne($brand_cond);
            $search_brand = array();
            $result_property = array();
            if ($brand)
            {
                $search_brand[$brand['id']] = $brand;
                $propery_ids = array();
                $goodsTypeProperty = $this->load('goodsTypeProperty');
                $cond = 'goods_type_id in(' . $brand['goods_type_ids'] . ')';
                foreach ($goodsTypeProperty->findAll($cond) as $val)
                {
                    $propery_ids[$val['property_id']] = $val['property_id'];
                }

                $propertyJoinLangLogic = $this->load('PropertyJoinLanguage');
                if (!empty($propery_ids))
                {
                    $property_cond = '(p.id in (' . implode(',', $propery_ids) . ') or p.parent_id in (' . implode(',', $propery_ids) . ')) and p.search =1';
                    $property_cond .= ' and p.status=1 and l.language_id =' . $language_id . ' order by p.listorder desc';
                    $properyList = $propertyJoinLangLogic->findAll($property_cond, true);
                    foreach ($properyList as $value)
                    {

                        if ($value['parent_id'] == 0 && $value['base_name'])
                        {
                            $result_property['parents'][$value['base_name']] = $value;
                        }
                        else
                        {
                            $result_property['childs'][$value['parent_id']][] = $value;
                        }
                    }
                }
            }
            $chk = array(
                'brands' => $search_brand,
                'propertylist' => $result_property,
            );
            _setcahce($key, $chk, $cache_type);
        }
        return $chk;
    }

    /**
     * 获取购物车符合条件的商品促销
     * @param type $goods_id 商品ID
     * @param type $amount  商品总金额
     * @param type $quantity 商品总数量
     * @param type $language_id  站点ID
     * @param type $all_promotions 所有促销
     * @return type 
     */
    public function getPromotionOffer($goods_id, $amount, $quantity, $language_id, $all_promotions)
    {
        $result = array();
        $current_promotion = array();
        $detail = $this->getDetailByGoodsId($goods_id, $language_id);
        //分类促销
        if (isset($detail['category_ids']))
        {
            foreach ($detail['category_ids'] as $item)
            {
                if (isset($all_promotions['category'][$item]))
                    $current_promotion[] = $all_promotions['category'][$item];
            }
        }
        //品牌促销
        if (isset($detail['goods']))
        {
            $goods = $detail['goods'];
            if (isset($all_promotions['brand'][$goods['brand_id']]))
                $current_promotion[] = $all_promotions['brand'][$goods['brand_id']];
        }
        if (isset($all_promotions['goods'][$goods_id]))
        {
            $current_promotion[] = $all_promotions['goods'][$goods_id];
        }
        if (!count($current_promotion))
        {
            return $result;
        }
        $user_group_id = 0;
        if (AppController::checkLogin())
        {
            $user_group_id = _c('user_group') ? _c('user_group') : _s('user_group');
        }
        $minus = array();
        $discount = array();
        foreach ($current_promotion as $list)
        {
            foreach ($list as $key => $val)
            {
                if ($val['start_time'] <= SYS_TIME && $val['end_time'] > SYS_TIME && $key > 0 && ($val['user_group_id'] == 0 || $val['user_group_id'] == $user_group_id) && $val['offer_type']==1)
                {
                    foreach ($all_promotions['rules'][$key] as $value)
                    {
                        if ($amount >= $value['min_amount'] && $quantity >= $value['min_buynum'])
                        {
                            if ($value['discount'] > 0)
                            {
                                $save_amount = $amount * (10 - $value['discount']) / 10;
                                $discount[$key] = $save_amount;
                            }
                            $minus[$key] = $value['minus'];
                            $result[$key] = $val;
                        }
                    }
                }
            }
        }
        if (!count($result))
        {
            return $result;
        }
        $minus_total_key = array_search(max($minus), $minus);
        $dis_total_key = array_search(max($discount), $discount);
        $minus_save = $minus[$minus_total_key];
        $discount_save = $discount[$dis_total_key];
        if ($minus_save > $discount_save)
        {
            $result[$minus_total_key]['max_offer'] = 1;
        }
        else
        {
            $result[$dis_total_key]['max_offer'] = 1;
        }
        return $result;
    }

    /**
     * 读取促销信息
     * smarty 调用
     * @param type $goods_id 
     */
    public function getPromotions($goods_id, $language_id)
    {
        $language_id = (int) $language_id ;
		$goods_id = (int) $goods_id ;
		
		if (!$language_id)
        {
            $langLogic = $this->load('language');
            $language_id = $langLogic->language_id;
        }
        $result = array();
        $user_group_id = 0;
        if (AppController::checkLogin())
        {
            $user_group_id = _c('user_group') ? _c('user_group') : _s('user_group');
        }
        if (CACHE)
        {
            $current_promotion = array();
            $offerJoinLangLogic = $this->load('offerJoinLanguage');
            $detail = $this->getDetailByGoodsId($goods_id, $language_id);
            $all_promotions = $offerJoinLangLogic->getListByLanguageId($language_id);
            //分类促销
            if (isset($detail['category_ids']))
            {
                foreach ($detail['category_ids'] as $item)
                {
                    if (isset($all_promotions['category'][$item]))
                        $current_promotion[] = $all_promotions['category'][$item];
                }
            }

            //品牌促销
            if (isset($detail['goods']))
            {
                $goods = $detail['goods']; //这里要考虑读取商品的缓存
                if (isset($all_promotions['brand'][$goods['brand_id']]))
                    $current_promotion[] = $all_promotions['brand'][$goods['brand_id']];
            }
            if (isset($all_promotions['goods'][$goods_id]))
            {
                $current_promotion[] = $all_promotions['goods'][$goods_id];
            }
            foreach ($current_promotion as $list)
            {
                foreach ($list as $key => $val)
                {
                    if ($val['start_time'] <= time() && $val['end_time'] > time() && ($val['user_group_id'] == 0 || $val['user_group_id'] == $user_group_id))
                    {
                        $result[$key] = $val;
                    }
                }
            }
        }
        else
        {
            $cond = 'l.goods_id=' . $goods_id . ' and l.language_id=' . $language_id;
            $goods = $this->getOne($cond);
            $catRelLogic = $this->load('goodsCategoryRel');
            $catlist = $catRelLogic->findAll('goods_id=' . $goods_id);
            $cat_ids = array();
            foreach ($catlist as $item)
            {
                $cat_ids[] = $item['goods_category_id'];
            }
            $offerItemLogic = $this->load('offerItem');
            $goods_offers = $offerItemLogic->findAll('goods_id =' . $goods_id);
            $goods_offer_ids = array();
            foreach ($goods_offers as $value)
            {
                $goods_offer_ids[] = $value['offer_id'];
            }
            $cat_str_ids = !empty($cat_ids) ? implode(',', $cat_ids) : 0;
            if (!empty($goods_offer_ids))
            {
                $cond = '(id in (' . implode(',', $goods_offer_ids) . ') or brand_id=' . $goods['brand_id'] . ' or category_id in (' . $cat_str_ids . ')) and offer_type=1 and status=1 and is_cart=0';
            }
            else
            {
                if($goods['brand_id']){
                    $cond = '(brand_id=' . $goods['brand_id'] . ' or category_id in (' . $cat_str_ids . ')) and offer_type=1 and status=1 and is_cart=0';
                }else{
                    $cond = 'category_id in (' . $cat_str_ids . ') and offer_type=1 and status=1 and is_cart=0';
                }
            }

            $offerLogic = $this->load('offer');
            $offerList = $offerLogic->findAll($cond);
            $offer_ids = array();
            foreach ($offerList as $val)
            {
                if ($val['start_time'] <= time() && $val['end_time'] > time() && ($val['user_group_id'] == 0 || $val['user_group_id'] == $user_group_id))
                {
                    $offer_ids[] = $val['id'];
                }
            }
            $offer_str_ids = !empty($offer_ids) ? implode(',', array_unique($offer_ids)) : 0;
            $offerLangLogic = $this->load('OfferJoinLanguage');
            $lang_cond = 'l.language_id=' . $language_id . ' and l.offer_id in (' . $offer_str_ids . ') and o.offer_type=1 and is_cart=0 order by o.is_goods desc,o.is_category desc';
            $offer_langs = $offerLangLogic->findAll($lang_cond);
            foreach ($offer_langs as $lang)
            {
                $result[$lang['id']] = $lang;
            }
        }

        return $result;
    }

    public function getItem($id, $language_id = 0)
    {
        $result = $this->getDetailByGoodsId($id, $language_id);
        return $result['goods'];
    }

    /**
     * 标签商品
     * @param type $params
     * @return type 
     */
    public function getGoodsListByTag($params)
    {
        $tag_id = isset($params['tag_id']) ? $params['tag_id'] : 0;
        $language_id = isset($params['language_id']) ? $params['language_id'] : 0;
        $offset = isset($params['offset']) ? $params['offset'] : 0;
        $limit = isset($params['limit']) ? $params['limit'] : 20;
        if (!$language_id)
        {
            $langLogic = $this->load('language');
            $language_id = $langLogic->language_id;
        }
        $tagRelLogic = $this->load('goodsTagRel');
        $cond = 'tag_id = ' . $tag_id;
        $goods_ids = array();
        foreach ($tagRelLogic->findAll($cond) as $value)
        {
            $goods_ids[$value['goods_id']] = $value['goods_id'];
        }
        if (empty($goods_ids))
        {
            return false;
        }
        $ids_str = implode(',', $goods_ids);
        $cond = 'l.goods_id in (' . $ids_str . ') and l.language_id=' . $language_id . ' limit ' . $offset . ',' . $limit;
        return $this->findAll($cond);
    }

    /**
     * 浏览记录
     * @param type $params
     * @return type 
     */
    public function getGoodsListByHistory($params)
    {
        if (_c('goods_history'))
        {
            $goods_history = json_decode(_c('goods_history'),true);
            $language_id = isset($params['language_id']) ? $params['language_id'] : 0;
            $limit = isset($params['limit']) ? $params['limit'] : 20;
            if (!$language_id)
            {
                $langLogic = $this->load('language');
                $language_id = $langLogic->language_id;
            }
            $result = array();
            $offset = 0;
            // 取得列的列表
			$goods_ids = array(0);
			//$goods_history = array_reverse($goods_history) ;
            foreach ($goods_history as $key => $row) {
                $time[$row['id']]  = $key;
				$goods_ids[] = $row['id'];
            }
            //array_multisort($time, SORT_DESC, $goods_history);
           
		   
		   $logic = AppController::load('goodsJoinLanguage');
           $where .= " l.status=1  and l.language_id=" . $language_id . " and l.goods_id in (".join(',',$goods_ids).") limit ".$limit;
            $result = $logic->findAll($where, false, '');
		   foreach($result as $key => $value)
		   {
				$result[$key]['index_history']  = $time[$value['id']] ;
		   }
		   Common::sort_rows($result , "index_history" , SORT_DESC);

            /*
              $goods_ids_str  = implode(',', !empty($goods_history) ? $goods_history : array(0));
              $cond  = 'g.id in (' . $goods_ids_str . ') and g.status=1 and g.stock_nums>0 and l.language_id=' . $language_id . ' limit ' . $limit;
              $result = $this->findAll($cond);
             * 
             */
            return $result;
        }
    }

    public function getGoodsListByNewSale($params)
    {
        $language_id = isset($params['language_id']) ? $params['language_id'] : 0;
        $offset = isset($params['offset']) ? $params['offset'] : 0;
        $limit = isset($params['limit']) ? $params['limit'] : 20;
        if (!$language_id)
        {
            $langLogic = $this->load('language');
            $language_id = $langLogic->language_id;
        }
        $cond = 'l.status=1  and l.language_id=' . $language_id . ' order by g.buy_counts desc limit ' . $offset . ',' . $limit;
        return $this->findAll($cond);
    }

    /**
     * 通过分类ID 找商品
     * @param type $params
     * @return type 
     */
    public function getGoodsListByCat($params)
    {
        $category_id = isset($params['category_id']) ? $params['category_id'] : 0;
        $language_id = isset($params['language_id']) ? $params['language_id'] : 0;
        $offset = isset($params['offset']) ? $params['offset'] : 0;
        $limit = isset($params['limit']) ? $params['limit'] : 20;
        if (!$language_id)
        {
            $langLogic = $this->load('language');
            $language_id = $langLogic->language_id;
        }
        $catRelGoodsLogic = $this->load('goodsCategoryRel');
        $cond = 'goods_category_id=' . $category_id;
        $catRel = $catRelGoodsLogic->getOne($cond);
        $goods_ids = array();
        if ($catRel)
        {
            $cond1 = "category_path like '" . $catRel['category_path'] . "%'";
            foreach ($catRelGoodsLogic->findAll($cond1) as $value)
            {
                $goods_ids[$value['goods_id']] = $value['goods_id'];
            }
        }
        if (empty($goods_ids))
        {
            return false;
        }
        $goods_ids_str = implode(',', $goods_ids);
        $cond = 'l.goods_id in (' . $goods_ids_str . ') and l.status=1  and l.language_id=' . $language_id . ' limit ' . $offset . ',' . $limit;
        return $this->findAll($cond);
    }

    /**
     * 查找关联商品
     * @param type $params
     * @return type 
     */
    public function getGoodsListByRel($params)
    {
        $goods_id = isset($params['goods_id']) ? $params['goods_id'] : 0;
        $language_id = isset($params['language_id']) ? $params['language_id'] : 0;
        $offset = isset($params['offset']) ? $params['offset'] : 0;
        $limit = isset($params['limit']) ? $params['limit'] : 20;
        if (!$language_id)
        {
            $langLogic = $this->load('language');
            $language_id = $langLogic->language_id;
        }
        $selfRelLogic = $this->load('goodsSelfRel');
        $cond = 'goods_id=' . $goods_id;
        $goods_ids = array();
        foreach ($selfRelLogic->findAll($cond) as $value)
        {
            $goods_ids[$value['goods_rel_id']] = $value['goods_rel_id'];
        }
        if (empty($goods_ids))
        {
            return FALSE;
        }
        $goods_ids_str = implode(',', $goods_ids);
        $cond = 'l.goods_id in (' . $goods_ids_str . ') and l.status=1  and l.language_id=' . $language_id . ' limit ' . $offset . ',' . $limit;
        return $this->findAll($cond);
    }

    /**
     * 查找品牌商品
     * @param type $params
     * @return type 
     */
    public function getGoodsListByBrand($params)
    {
        $brand_id = isset($params['brand_id']) ? $params['brand_id'] : 0;
        $language_id = isset($params['language_id']) ? $params['language_id'] : 0;
        $offset = isset($params['offset']) ? $params['offset'] : 0;
        $limit = isset($params['limit']) ? $params['limit'] : 20;
        if (!$language_id)
        {
            $langLogic = $this->load('language');
            $language_id = $langLogic->language_id;
        }
        $cond = 'g.brand_id =' . $brand_id . ' and l.status=1 and l.language_id=' . $language_id . ' limit ' . $offset . ',' . $limit;
        return $this->findAll($cond);
    }

    /**
     * 记录浏览记录
     * @param type $goods_id 
     */
    public function setHistory($goods_id)
    {
        $goods_history = array();
		// 最多保存 40个
        if (_c('goods_history'))
        {
            $goods_history = json_decode(_c('goods_history'),true);
            $goods_ids = array();
            foreach($goods_history as $key => $rows)
            {
                $goods_ids[] = $rows['id'];
                if($rows['id']!=$goods_id)
                {
                    //$rows['time'] = time();
                    $goods_new_histry[] = $rows ;
                }
            }
            
           
			$goods = array('id'=>$goods_id);
            $goods_new_histry[] = $goods;
			
			$goods_new_histry = array_slice($goods_new_histry, 0, 40);
            setcookie('goods_history', json_encode($goods_new_histry), time() + 86400, '/');
        }
        else
        {
            $goods = array('id'=>$goods_id);
            $goods_history[] = $goods;
            setcookie('goods_history', json_encode($goods_history), time() + 86400, '/');
        }
    }

    /**
     * 记录搜索记录
     * @param type $goods_keyword 
     */
    public function setSearchHistory($goods_keyword)
    {
        $goods_search_history = array();
        if (_c('goods_search_history'))
        {

            $goods_search_history = json_decode(_c('goods_search_history'));
            if (!in_array($goods_keyword, $goods_search_history))
            {
                array_push($goods_search_history, $goods_keyword);
                setcookie('goods_search_history', json_encode($goods_search_history), time() + 86400, '/');
            }
            else
            {
                array_unique($goods_search_history);
                foreach ($goods_search_history as $key => $value)
                {
                    if ($goods_keyword == $value)
                    {
                        array_splice($goods_search_history, $key, 1);
                    }
                }
                array_push($goods_search_history, $goods_keyword);
                setcookie('goods_search_history', json_encode($goods_search_history), time() + 86400, '/');
            }
        }
        else
        {
            $goods_search_history[] = $goods_keyword;
            setcookie('goods_search_history', json_encode($goods_search_history), time() + 86400, '/');
        }
    }

    /**
     * 搜索记录
     * @param type $goods_keyword 
     */
    public function getSearchHistory()
    {
        if (_c('goods_search_history'))
        {
            $goods_search_history = json_decode(_c('goods_search_history'));
            krsort($goods_search_history);
            return $goods_search_history;
        }
    }

    /**
     * 清空搜索记录
     * @param type $goods_keyword 
     */
    public function clearSearchHistory()
    {
        setcookie('goods_search_history', '', time() + 86400, '/');
    }

    /**
     * 清空浏览记录
     * @param type $goods_keyword 
     */
    public function clearHistory()
    {
        setcookie('goods_history', '', time() + 86400, '/');
    }

    /**
     * 验证是否访问过
     * @param type $goods_id 
     */
    public function validRead($goods_id, $count)
    {
        $is_read = FALSE;
        $goods_read = array();
        if (_c('goods_visit'))
        {
            $goods_read = json_decode(_c('goods_visit'));
            if (!in_array($goods_id, $goods_read))
            {
                array_push($goods_read, $goods_id);
                setcookie('goods_visit', json_encode($goods_read));
            }
            else
            {
                $is_read = TRUE;
            }
        }
        else
        {
            $goods_read[] = $goods_id;
            setcookie('goods_visit', json_encode($goods_read));
        }
        if (!$is_read)
        {
            $goodsLogic = $this->load('goods');
            $map = Zhtx::createDataMap();
            $map->addEntry('visit_counts', $count + 1, DB::INT);
            $goodsLogic->updateById($map, $goods_id);
        }
    }

    public function getCountByKey($key, $count = 0)
    {
        global $data_cache_dir;
        $cache_type = 'goods_list';
        $cache_key = 'goods_cache_count';
        $chk = _chkcahce($cache_key, $cache_type, TRUE);
        if ($count === 0)
        {
            if (!$chk || !isset($chk[$key]))
            {
                return FALSE;
            }
            else
            {
                return $chk[$key];
            }
        }
        else if ($count > 0)
        {
            $chk[$key] = $count;
            _setcahce($cache_key, $chk, $cache_type);
        }
        return $chk[$key];
    }

    public function getGoodsList($where, $pages, $get_cache = true)
    {
        $cols = array(
            'g.id as id',
            'g.base_name as default_base_name',
            'g.codeno as codeno',
            'g.image as image',
            'g.price as price',
            'g.cost_price as cost_price',
            'g.market_price as market_price',
            'g.weight as weight',
            'g.brand_id as brand_id',
            'g.goods_type_id as type_id',
            'g.listorder as listorder',
            'g.status as status',
            'g.page_url as page_url',
            'g.template_page as template_page',
            'g.up_time as up_time',
            'g.modify_time as modify_time',
            'g.create_time as create_time',
            'g.visit_counts as visit_counts',
            'g.buy_counts as buy_counts',
            'g.wishlist_counts as wishlist_counts',
            'g.comment_counts as comment_counts',
            'g.comment_value as comment_value',
            'g.is_free_shipping as is_free_shipping',
            'g.start_time as start_time',
            'g.end_time as end_time',
            'g.discount as discount',
            'g.special_status as special_status',
            'l.base_name as base_name',
            'g.old_price as old_price',
            'g.stock_nums as stock_nums',
            'l.detail as detail',
            'l.descript as descript',
        );
        if ($pages > 10)
        {
            return $this->getCols($where, $cols);
        }
        global $data_cache_dir;
        $key = md5($where);
        $cache_type = 'goods_list';
        $chk = _chkcahce($key, $cache_type);
        if (!$get_cache || !$chk)
        {
            $chk = $this->getCols($where, $cols);
            _setcahce($key, $chk, $cache_type);
        }
        return $chk;
    }

}

?>
