<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoodsLogic
 *
 * @author xrx
 */
class GoodsLogic extends BaseLogic {

    public function __construct() {
        parent::__construct();
        $this->table = 'GoodsTable';
        $this->cache_type = 'goods_list';
    }

    public function save($data, $id = 0) {
        $goods_map = Zhtx::createDataMap();
        $goods_map->createEntry($data);
        if ($id) {
            $results = $this->update($goods_map, 'id=' . $id);
        } else {
            $results = $this->insert($goods_map);
        }
        return $results;
    }

    public function updateCommentCount($goods_id = 0) {
        $goodsCommentLogic = $this->load('goodsComment');
        $comment_counts = $goodsCommentLogic->getCount('status=1 and goods_id=' . $goods_id);
        $sql = 'select sum(value) as comment_value from z_goods_comment where status=1 and goods_id=' . $goods_id;
        $comment_value = $this->query($sql);
        $map = Zhtx::createDataMap();
        $map->addEntry('comment_counts', (int)$comment_counts, DB::INT);
        $map->addEntry('comment_value', (int)$comment_value[0]['comment_value'], DB::INT);
        $this->updateById($map, $goods_id);
    }

    public function updateWishlistCount($goods_id = 0, $del = false) {
        $map = Zhtx::createDataMap();
        $wishlist_counts = 'wishlist_counts+1';
        if($del)
            $wishlist_counts = 'wishlist_counts-1';
        $map->addEntry('wishlist_counts', $wishlist_counts, DB::INT);
        $this->updateById($map, $goods_id);
    }
    
    public function updateBuyCounts($order_id = 0) {
        $order = $this->load('order')->getOne('id=' . $order_id);
        if ($order) {
            $cols = array('goods_id', 'sku_code', 'buy_num', 'return_num');
            $orderItems = $this->load('orderItem')->getCols('order_id=' . $order_id, $cols);
            if (count($orderItems)) {
                foreach ($orderItems as $item) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('buy_counts', 'buy_counts+' . (int)$item['buy_num'] , DB::INT);
                    $this->updateById($map, $item['goods_id']);
                }
            }
        }
    }

    public function updateStockNums($id = 0, $is_order = false) {
        if ($is_order) {
            $order = $this->load('order')->getOne('id=' . $id);
            if ($order) {
               $cols = array('goods_id', 'sku_code', 'buy_num', 'return_num');
                $orderItems = $this->load('orderItem')->getCols('order_id=' . $id, $cols);
                if (count($orderItems)) {
                    foreach ($orderItems as $item) {
                        $this->updateStock($item['goods_id']);
                    }
                }
            }
        } else {
            $this->updateStock($id);
        }
    }

    public function updateStock($id = 0) {
        $skuLogic = $this->load('sku');
        $goodsLanguageLogic = $this->load('goodsLanguage');
        $cols = array('goods_id', 'sum(stock_nums) as stock_nums');
        $stock_nums = $skuLogic->getCols('goods_id=' . $id, $cols);
        $count = (int)$stock_nums[0]['stock_nums'];
        $goods = $this->getOne('id=' . $id);
        $status = $goods['status'];
        if ($count <= 0) {
            $status = 0;
        }
        $goods_data = array('stock_nums' => $count, 'modify_time' => SYS_TIME, 'status' => $status);
        global $cfg;
        $default_goods_status = $cfg['sites'][0]['default_goods_status'];
        if ($default_goods_status) {
            $this->saveByCond($goods_data, 'id=' . $id);
            if ($count <= 0) {
                $goodsLanguageLogic->saveByCond(array('status' => 0), 'goods_id=' . $id);
            }
        } else {
            unset($goods_data['status']);
            $this->saveByCond($goods_data, 'id=' . $id);
        }
        $goodsLanguageLogic->updateCache($id);
    }

}

?>
