<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoodsPropertyRelLanguageLogic
 * 商品属性关联、属性、语言联合查询 （用goods_property_rel中的vid建立关系）
 *
 * @author xrx
 */
class GoodsPropertyRelLanguageLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'GoodsPropertyRelLanguageView';
    }
    
    public function getSalePropertys($goods_id, $language_id, $is_master_sale=1)
    {
      $goodsDetailLogic  = $this->load('goodsJoinLanguage');
        $goodsDetail = $goodsDetailLogic->getDetailByGoodsId($goods_id, $language_id);
        $propertyList = $goodsDetail['propertylist'];
        $res = array();
        foreach($propertyList['sale'] as $sale)
        {
          if($sale['property_type'] == $is_master_sale)
          {
             $res[$sale['vid']] = $sale;
          }
        }       
        return $res;        
    }
    /**
     * 获取商品的sku名称
     * @param type $goods_id
     * @param type $property_ids
     * @param type $language_id
     * @return type 
     */
    public function getListByGoodsIdAndPropertyIds($goods_id, $property_ids, $language_id)
    {        
        $goodsDetailLogic  = $this->load('goodsJoinLanguage');
        $goodsDetail = $goodsDetailLogic->getDetailByGoodsId($goods_id, $language_id);
        $propertyList = $goodsDetail['propertylist'];
        $res = array();
        foreach($propertyList['sale'] as $sale)
        {
          if((is_array($property_ids) && in_array($sale['vid'], $property_ids)) || $sale['vid'] == $property_ids)
          {
             $res[$sale['vid']] = $sale;
          }
        }    
        //$res['codeno'] = $goodsDetail['goods']['codeno'];
        return $res;
    }
}

?>
