<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoodsPropertyRelLogic
 *
 * @author xrx
 */
class GoodsPropertyRelLogic extends BaseLogic
{
    private $propertyJoinLanguageLogic;
    public function __construct()
    {
        parent::__construct();
        $this->table      = 'GoodsPropertyRelTable';
        $this->propertyJoinLanguageLogic = $this->load('goodsPropertyJoinLanguage');
        $this->cache_type = "goods_info";
    }
    public function save($data, $id=0)
    {
        $pro_rel_map = Zhtx::createDataMap();
        $pro_rel_map->createEntry($data);
        if($id)
        {
            $result = $this->update($pro_rel_map, 'id='.$id);
        }
        else
        {
            $result = $this->insert($pro_rel_map);
        }
        return $result;
    }
    /**
     * 读取商品属性
     * @param int $goods_id 商品pk
     * @return array 
     */
    public function getExistProperty($goods_id)
    {
        $where  = 'goods_id =' . $goods_id;
        $result = $this->getList($where);
        $data   = array(); 
        foreach($result['list'] as $value)
        {
            if(!$value['product_id'])
            {
                $data['common'][] = $value;
            }
            else
            {
                $data['sale'][]   = $value;
            }
        }
        return $data;
    }
    /**
     * 根据商品和语言查询
     * @param type $goods_id
     * @param type $language_id
     * @return type 
     */
    public function getListByGoodsIdAndL($goods_id, $language_id)
    {
         $where  = 'goods_id =' . $goods_id;
          $result = $this->findAll($where);
          $property_ids = array();
          foreach($result as $value)
          {
            $property_ids[] = $value['property_id'];
            $property_ids[] = $value['vid'];            
          }
          $str_ids      = !empty($property_ids) ? implode(',', array_unique($property_ids)) : 0;
          $lang_where   = 'l.language_id ='. $language_id . ' and p.id in ('. $str_ids . ') order by p.listorder desc';
          $lang_cols    = array('p.id as property_id', 'l.base_name as base_name', 'p.listorder as listorder');
          $propertyList = $this->propertyJoinLanguageLogic->getCols($lang_where, $lang_cols);        
          $propertysArrayAsId = array();
          foreach($propertyList as $list)
          {
            $propertysArrayAsId[$list['property_id']] = array('base_name' => $list['base_name'], 'listorder' => $list['listorder']);
          }
          $data = array();
          foreach($result as $value)
          {   
            $value['property_name']  = isset($propertysArrayAsId[$value['property_id']]) ? $propertysArrayAsId[$value['property_id']]['base_name'] : $value['property_name'];
            $value['value_name']     = isset($propertysArrayAsId[$value['vid']]) ? $propertysArrayAsId[$value['vid']]['base_name'] : $value['value_name'];
            $value['parent_base_name']  = $value['property_name'];
            $value['base_name']  = $value['value_name'];
            $value['listorder']  = isset($propertysArrayAsId[$value['vid']]) ? $propertysArrayAsId[$value['vid']]['listorder'] : 0;
            if(!$value['product_id'])
            {
                $data['common'][$value['property_id']]['parent'] = $value['property_name'];
                $data['common'][$value['property_id']]['sun'][] = $value;
				$data['common'][$value['property_id']]['parent_listorder'] = $propertysArrayAsId[$value['property_id']]['listorder'] ;
            }
            else
            {
                $data['sale'][]   = $value;
            }
          }
		  Common::sort_rows($data['common'],"parent_listorder",SORT_DESC);
        return $data;
    }
    
	public function getPropertyList($goods_id)
    {
        $where  = 'goods_id =' . $goods_id;
        $result = $this->getList($where);
        $data   = array(); 
        foreach($result['list'] as $value)
        {
        	$data[]   = $value;
        }
        return $data;
    }
   
}

?>
