<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GrowthEventLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class GrowthEventLogic extends BaseLogic
{

  public function __construct()
  {
    parent::__construct();
    $this->table = 'GrowthEventTable';
  }

  public function save($data, $id = 0)
  {
    $map = Zhtx::createDataMap();
    $map->createEntry($data);
    if ($id)
    {
      $res = $this->update($map, 'id=' . $id);
    }
    else
    {
      $res = $this->insert($map);
    }
    return $res;
  }

  /**
   * 成长值管理
   * @param type $codeno
   * @return type 
   */
  public function manageGrowth($codeno, $user_id = 0, $language_id = 0, $order = array())
  {
    $cond = 'codeno = "' . $codeno . '" and status=1';
    $growth = $this->getOne($cond);
    if (!$growth)
    {
      return; //是否有该项规则
    }
    if (!isset($order['first']) && (($growth['start_time'] > 0 && $growth['start_time'] > SYS_TIME) || ($growth['end_time'] > 0 && $growth['end_time'] < SYS_TIME)))
    {
      return; //是否在有效期范围内
    }
    $userLogic = $this->load('user');
    $user = $userLogic->getOneById($user_id);
    if ($growth['user_group_id'] && $growth['user_group_id'] != $user['user_group_id'])
    {
      return; //是否满足用户组的要求
    }
    if($growth['growth_type'])
    {
        $growth_value = Common::queryInt($order['final_amount'] * $growth['formula_value']);
    }else{
        $growth_value = Common::queryInt($growth['growth']);
    }
    $order_id = 0;
    if (!empty($order))
    {
      $ip = $order['ip'];
      $country_id = $order['country_id'];
      $domain   = $order['domain'];
      $order_id = $order['id'];
    }
    else
    {
      $ipJoinCountryLogic = $this->load('ipJoinCountry');
      $ip = Common::_ip2long(Common::ip());
      $country_id = $ipJoinCountryLogic->getCountryId($ip);
      $domain = SITE_URL;
    }
    $flag = true;
    switch ($growth['type'])
    {
      case 1:
        break;
      case 2://首次添加到购物车（有漏洞暂不做考虑）        
        break;
      case 3://首次下单 支付成功（在特定时段 处理了）        
        break;
      case 4://推荐会员(如果该用户属于某用户推荐的，需检查某用户是否符合赠送成长值的要求)       
        if (!$user['parent_user_id'])
        {
          $flag = false;
          break;
        }
        $recommend_cond = 'codeno = "recommend_user_sent"  and status=1';
        $recommend_growth = $this->getOne($recommend_cond);
        if ($recommend_growth && (($recommend_growth['start_time'] == 0 || $recommend_growth['start_time'] < SYS_TIME) && ($recommend_growth['end_time'] == 0 || $recommend_growth['end_time'] > SYS_TIME)))
        {
          $parent_user = $userLogic->getOneById($user['parent_user_id']);
          if ($parent_user['user_group_id'] == $recommend_growth['user_group_id'] || $recommend_growth['user_group_id'] == 0)
          {
            $this->dealGrowth($parent_user, $recommend_growth['growth'], $language_id, $country_id, $domain, $ip, 0, 'recommend_user_sent');
          }
        }
        return $recommend_growth;
      case 5://特定时段下单 支付完成
        $detailLogic = $this->load('growthDetail');
        $cond = 'user_id=' . $order['user_id'] . ' and order_id=' . $order['id'];
        $count = $detailLogic->getCount($cond);
        if ($count > 0)
        {
          return; //如果已经增送了就返回
        }
        if ($order['first'])
        {
          $first_cond = 'codeno = "first_order_paid_sent"  and status=1';
          $first_growth = $this->getOne($first_cond);
          if ($first_growth && (($first_growth['start_time'] == 0 || $first_growth['start_time'] < SYS_TIME) && ($first_growth['end_time'] == 0 && $first_growth['end_time'] > SYS_TIME)))
          {
            $this->dealGrowth($user, $first_growth['growth'], $language_id, $country_id, $domain, $ip, $order['id'], 'first_order_paid_sent');
          }         
        }
        if ((($growth['start_time'] > 0 && $growth['start_time'] > SYS_TIME) || ($growth['end_time'] > 0 && $growth['end_time'] < SYS_TIME)))
        {
          return; //是否在有效期范围内
        }
        break;
      case 6://连续未登录天数 减少        
        $loginLogic = $this->load('userLoginLog');
        $cond = 'user_id =' . $user_id . ' order by create_day DESC limit 0,2';
        $logs = $loginLogic->findAll($cond);
        $last = isset($logs[0]) ? intval($logs[0]['create_day']) : 0;
        $prev = isset($logs[1]) ? intval($logs[1]['create_day']) : 0;
        if (($last - $prev) < $growth['cond_value'])
        {
          return;
        }
        $growth_value = '-' . $growth_value;
        break;
      case 7://连续下单未支付 减少
        //连续未支付订单数        
        $cond_value = $growth['cond_value'];
        $orderLogic = $this->load('order');
        $cond = 'user_id = ' . $user_id . ' order by create_day DESC limit 0,' . $cond_value;
        $orders = $orderLogic->findAll($cond);
        $flag = FALSE;
        foreach ($orders as $value)
        {
          if ($value['payment_status'] > 200)
          {
            $flag = true;
            break;
          }
        }
        if ($flag)
        {
          return;
        }
        $growth_value = '-' . $growth_value;
        break;
      case 8://退货 或者 拒收 减少       
        $growth_value = '-' . $growth_value;
        break;
      case 9://换货减少       
        $growth_value = '-' . $growth_value;
        break;
      case 10://用户评论审核通过      
        break;
      case 11://推荐会员首次付款成功      
        break;
      case 12://每日登陆        
        $loginLogic = $this->load('userLoginLog');
        $cond = 'user_id =' . $user_id . ' and create_day="' . date('Ymd') . '"';
        $logs = $loginLogic->getCount($cond);
        if ($logs>1)
        {
          return;
        }
        break;
      default:
        break;
    }
    if ($flag)
    {
        $this->dealGrowth($user, $growth_value, $language_id, $country_id, $domain, $ip, $order_id, $codeno);
        return $growth;
    }
  }

  /**
   * 处理成长值
   * @param type $user
   * @param type $growth_value
   * @param type $language_id
   * @param type $country_id
   * @param type $domain
   * @param type $ip 
   */
  public function dealGrowth($user, $growth_value, $language_id, $country_id, $domain, $ip, $order_id = 0 ,$codeno = 'system_manual_add')
  {
    
    $data = array(
        'user_id' => $user['id'],
        'growth' => $growth_value,
        'language_id' => $language_id,
        'country_id' => $country_id,
        'domain' => $domain,
        'ip' => $ip,
        'order_id' => $order_id,
        'create_time' => SYS_TIME,
        'remark' => $codeno,
    );
    $detailLogic = $this->load('growthDetail');
    $res = $detailLogic->save($data);
    if ($res)
    {
      $groupLogic = $this->load('userGroup');
      $groupLogic->updateUserGroupId($user, $growth_value);     
    }
  }

}

?>
