<?php

/**
 * Description of LanguageLogic
 *
 * @author xrx
 */
class LanguageLogic extends BaseLogic
{

    public $language_id;
    public $language_name;
    public $theme_id;
    public $theme_name;
    public $is_mobile;

    public function __construct()
    {
        parent::__construct();
        $this->table = 'LanguageTable';
        if (Core::$site == 'front')
        {
            //只有前台的时候使用
            $lang_data = $this->getLang();
            $this->language_id = $lang_data['language_id'];
            $this->real_language_id = $lang_data['real_language_id'];
            $this->language_name = $lang_data['language_name'];
            $this->theme_id = $lang_data['theme_id'];
            $this->theme_name = $lang_data['theme_name'];
            $this->is_mobile = $lang_data['is_mobile'];
        }
    }

    /**
     * 通过别名查询语言
     * @param type $alias_name
     * @return type 
     */
    public function getOneByAliasName($alias_name)
    {
        $where = "language_name = '" . $alias_name . "'";
        $language = $this->getOne($where);
        return $language;
    }

    public function getLang()
    {
        $language_id = 0;
        $real_language_id = 0;
        $language_name = '';
        $theme_id = 0;
        $theme_name = '';
        $wap_lang_id = 0;
        $is_mobile = 0;
        $ShowFull = _g('ShowFull');   // 1=强制显示PC  2=清楚强制显示PC，并跳转到WAP 
		$c_ShowFull = _c('c_showFull') ;
        require_once(APP_ROOT . 'libary/MobileDetect.php');
        $detect = new Mobile_Detect;
        //判断是否已安装
//        if(is_dir(APP_ROOT.'install') && !is_file(APP_ROOT.'install/install.lock'))
//        {
//            @header("location:http://" . $_SERVER['SERVER_NAME'].FOLDER_ROOT.'install');
//            die();
//        }
        $lang_res = $this->getOne("domain_name like '".strtolower(SITE_URL)."'");
        //var_dump($lang_res);
        if(!$lang_res)
        {
            $language_list = $this->findAll('status=1', true);
            foreach ($language_list as $list)
            {
                $alias_domain = str_replace(array("\r\n", "\r", "\n"), array(",", "", ","), $list['alias_domain']);
                $arr_alias_domain = split(",", $alias_domain);
                if (in_array(SITE_URL, $arr_alias_domain) && SITE_URL != $list['domain_name'])
                {
                    if (strpos($_SERVER["REQUEST_URI"], '?') === FALSE)
                    {
                        $source = '?source=301_' . $_SERVER['SERVER_NAME'];
                    }
                    else
                    {
                        $source = '&source=301_' . $_SERVER['SERVER_NAME'];
                    }
                    @header('HTTP/1.1 301 Moved Permanently');
                    @header("Location:http://" . $list['domain_name'] . $_SERVER["REQUEST_URI"] . $source);
                    die();
                }
            }
			echo "Website Not Found";
			die();
        }
        else
        {
            if(!$detect->isMobile() && $lang_res['is_mobile']==0)//PC访问
            {
				if($lang_res['status']==0)
				{
					echo "Website Close";
					die();
				}
                $real_language_id = $lang_res['id'];
                $language_id = $lang_res['id'];
                $theme_id = $lang_res['theme_id'];
                $is_mobile = 0;
                $wap_lang_id = $lang_res['wap_language_id']; 
            }
            else if($detect->isMobile() && $lang_res['is_mobile']==0 )//手机访问PC站点
            {
                    if($lang_res['status']==0)
					{
						echo "Website Close";
						die();
					}
					if($ShowFull==2)
                    {
                            //clean_cookie();
                        setcookie('c_showFull', '', -1, '/');
						$c_ShowFull = '';
                    }
					if($ShowFull==1 || $c_ShowFull || $lang_res['wap_language_id']==0) //用户主动浏览pc或pc站没有关联wap站时
                    {
                            // 返回 PC RES	
                            if ($ShowFull)
                            setcookie('c_showFull', 1, time() + (86400 * 15), '/');
                            $language_name = $lang_res['language_name'];
                            $real_language_id = $lang_res['id'];
                            $language_id = $lang_res['id'];
                            $theme_id = $lang_res['theme_id'];
                            $is_mobile = 0;
                            $wap_lang_id = $lang_res['wap_language_id']; 
                    }
                    else if($lang_res['wap_language_id'])
                    {	
                            // 获取对应移动端站点
                            // 301 到 WAP
                            $wap_lang_res = $this->getOne("id =".$lang_res['wap_language_id']);
                            if(!$wap_lang_res)
							{
								echo "Wap Website Not Found";
								die();
							}
							$redirect_url = "http://" . $wap_lang_res['domain_name'];
							if (_g())
							{
								$redirect_url .= $_SERVER['REQUEST_URI'];
							}
                            @header("location:" . $redirect_url);
                            die();
                    }
            }
            else if($lang_res['is_mobile']==1)//$detect->isMobile() && 
            {
                    
                    $pc_lang_res = $this->getOne("status=1 and wap_language_id =".$lang_res['id']);
					if(!$pc_lang_res)
					{
						echo "Main Data Website Not Found";
						die();	
					}
                    if( MERGE_DATA_MODEL && $pc_lang_res)
                    {
                            $language_name = $pc_lang_res['language_name'];
                            $real_language_id = $lang_res['id'];
                            $language_id = $pc_lang_res['id'];
                            $theme_id = $lang_res['theme_id'];
                            $is_mobile = 1;
                            $wap_lang_id = 0;
                    }
                    else
                    {
                        $language_name = $lang_res['language_name'];
                        $real_language_id = $lang_res['id'];
                        $language_id = $lang_res['id'];
                        $theme_id = $lang_res['theme_id'];
                        $is_mobile = 1;
                        $wap_lang_id = 0; 
                    }
            }
            
            $theme_id = $theme_id ? $theme_id : 0;
            $themeLogic = $this->load('theme');
            $theme = $themeLogic->getOneById($theme_id);
            $theme_name = $theme ? $theme['theme_dir'] : '';
            setcookie('auth_language_id', $language_id);
            setcookie('real_language_id', $real_language_id);
            _setSession('auth_language_id', $language_id);
            _setSession('real_language_id', $real_language_id);
            _setSession('front_lang', $language_name ? $language_name : $lang_res['language_name']);
            _setSession('theme_id', $theme_id);
            _setSession('theme_name', $theme_name);
            _setSession('is_mobile', $is_mobile);
            _setSession('wap_language_id', $wap_lang_id);
        }
        $return = array('language_id' => $language_id, 'real_language_id' => $real_language_id, 'language_name' => $language_name, 'theme_id' => $theme_id, 'theme_name' => $theme_name, 'is_mobile' => $is_mobile);
        //var_dump($return);
        return $return;
    }

    /**
     * 前台获取当前语言
     * @return type 
     */
    public function getLang_bak()
    {
        if($_GET['dev'])
        {
             return $this->getLang1();
        }
        global $cfg;
        $language_id = _c('auth_language_id') ? _c('auth_language_id') : _s('auth_language_id');
        $real_language_id = _c('real_language_id') ? _c('real_language_id') : _s('real_language_id');
        $language_name = _s('front_lang');
        $theme_id = _s('theme_id');
        $theme_name = _s('theme_name');
        $ShowFull = _g('ShowFull');
        require_once(APP_ROOT . 'libary/MobileDetect.php');
        $detect = new Mobile_Detect;
        if (($ShowFull || _c('c_showFull')) && $detect->isMobile())
        {
            if ($ShowFull)
                setcookie('c_showFull', 1, time() + (86400 * 15), '/');
            $is_mobile = 0;
            $wap_lang_id = 1;
        }
        else if ($detect->isTablet())
        {
            $is_mobile = 0;
            $wap_lang_id = 1;
        }
        else
        {
            setcookie('c_showFull', '', time() + (86400 * 15), '/');
            $is_mobile = _s('is_mobile');
            $wap_lang_id = _s('wap_language_id');
        }
        $flag = false;
        if (($detect->isMobile() || $detect->isTablet()) && !$is_mobile && $wap_lang_id)
        {
            $flag = TRUE;
        }
        if (!$language_name || !$language_id || !$theme_id || !$theme_name || $flag)
        {
            $language_list = $this->findAll('1=1', true);
            foreach ($language_list as $list)
            {
                $alias_domain = str_replace(array("\r\n", "\r", "\n"), array(",", "", ","), $list['alias_domain']);
                $arr_alias_domain = split(",", $alias_domain);
                if (in_array(SITE_URL, $arr_alias_domain) && SITE_URL != $list['domain_name'])
                {
                    if (strpos($_SERVER["REQUEST_URI"], '?') === FALSE)
                    {
                        $source = '?source=301_' . $_SERVER['SERVER_NAME'];
                    }
                    else
                    {
                        $source = '&source=301_' . $_SERVER['SERVER_NAME'];
                    }
                    @header('HTTP/1.1 301 Moved Permanently');
                    @header("Location:http://" . $list['domain_name'] . $_SERVER["REQUEST_URI"] . $source);
                    exit;
                }
                if (strtolower(SITE_URL) == strtolower($list['domain_name']))
                {
                    $language_name = $list['language_name'];
                    $real_language_id = $list['id'];
                    if (MERGE_DATA_MODEL && $list['is_mobile'])
                    {
                        foreach ($language_list as $l)
                        {
                            if ($l['wap_language_id'] == $real_language_id)
                            {
                                $language_id = $l['id'];
                            }
                        }
                    }
                    else
                    {
                        $language_id = $list['id'];
                    }
                    $theme_id = $list['theme_id'];
                    $is_mobile = $list['is_mobile'];
                    $wap_lang_id = $list['wap_language_id'];
                    break;
                }
            }
            if (($flag && $wap_lang_id && !_c('c_showFull') && !$detect->isTablet()) || ($detect->isMobile() && $wap_lang_id && !_c('c_showFull') && !$detect->isTablet()))
            {
                $redirect_url = "http://" . $language_list[$wap_lang_id]['domain_name'];
                if (_g())
                {
                    $redirect_url .= $_SERVER['REQUEST_URI'];
                }
                if ($language_list[$wap_lang_id]['status'] && $wap_lang_id != $language_id)
                {
                    @header("location:" . $redirect_url);
                    exit;
                }
            }
            if ($detect->isTablet())
            {
                $is_mobile = 0;
            }
            $theme_id = $theme_id ? $theme_id : 0;
            $themeLogic = $this->load('theme');
            $theme = $themeLogic->getOneById($theme_id);
            $theme_name = $theme ? $theme['theme_dir'] : '';
            $alias_domain = $language_list[$language_id]['alias_domain'];
            setcookie('auth_language_id', $language_id);
            setcookie('real_language_id', $real_language_id);
            _setSession('auth_language_id', $language_id);
            _setSession('real_language_id', $real_language_id);
            _setSession('front_lang', $language_name ? $language_name : $language_list[0]['language_name']);
            _setSession('theme_id', $theme_id);
            _setSession('theme_name', $theme_name);
            _setSession('is_mobile', $is_mobile);
            _setSession('wap_language_id', $wap_lang_id);
        }
        return array('language_id' => $language_id, 'real_language_id' => $real_language_id, 'language_name' => $language_name, 'theme_id' => $theme_id, 'theme_name' => $theme_name, 'is_mobile' => $is_mobile);
    }

    public function save($data, $primary)
    {
        $language_map = Zhtx::createDataMap();
        $language_map->createEntry($data);
        if ($primary)
        {
            $result = $this->updateById($language_map, $primary);
        }
        else
        {
            $result = $this->insert($language_map);
        }
        return $result;
    }

    /**
     * 前台
     * 读取站点货币
     */
    public function getCurrentCurrency()
    {
        $currencyLogic = $this->load('currency');
        $site = $this->getOneById($this->language_id);
        $currency_id = $site['currency_id'];
        if ($this->getCurrencyId())
        {
            $currency_id = $this->getCurrencyId();
        }
        if (!$currency_id)
        {
            exit("Currency_id Empty");
        }
        $res = $currencyLogic->getOneById($currency_id);
        if (!$res)
        {
            exit("Currency 404");
        }
        return $res;
    }

    /**
     * 前台
     * 读取$_SESSION["currency_id"]
     */
    public function getCurrencyId()
    {
        $currency_id = _s("change_currency_id", 0);
        if ($currency_id != "")
        {
            $currencyLogic = $this->load('currency');
            $currency_res = $currencyLogic->getOneById($currency_id);
            if (!$currency_res)
            {
                $currency_id = 0;
            }
        }
        return $currency_id;
    }

    /**
     * 获取当前页面URL地址(不包含http://或者 https://)
     */
    public function getUrl()
    {
        $php_self = $_SERVER['PHP_SELF'] ? self::safeReplace($_SERVER['PHP_SELF']) : self::safeReplace($_SERVER['SCRIPT_NAME']);
        $path_info = isset($_SERVER['PATH_INFO']) ? self::safeReplace($_SERVER['PATH_INFO']) : '';
        $relate_url = isset($_SERVER['REQUEST_URI']) ? self::safeReplace($_SERVER['REQUEST_URI']) : $php_self . (isset($_SERVER['QUERY_STRING']) ? '?' . self::safeReplace($_SERVER['QUERY_STRING']) : $path_info);
        return (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '') . $relate_url;
    }

    /**
     * 安全过滤函数
     * @param $string
     * @return string
     */
    public function safeReplace($string)
    {
        $string = str_replace('%20', '', $string);
        $string = str_replace('%27', '', $string);
        $string = str_replace('%2527', '', $string);
        $string = str_replace('*', '', $string);
        $string = str_replace('"', '&quot;', $string);
        $string = str_replace("'", '', $string);
        $string = str_replace('"', '', $string);
        $string = str_replace(';', '', $string);
        $string = str_replace('<', '&lt;', $string);
        $string = str_replace('>', '&gt;', $string);
        $string = str_replace("{", '', $string);
        $string = str_replace('}', '', $string);
        return $string;
    }

    public function checkSiteLang($languages)
    {
        $result = array();
        $currentUrl = Common::getUrl();
        foreach ($languages as $list)
        {
            if (strpos($currentUrl, $list['domain_name']) !== FALSE)
            {
                $result['language_name'] = $list['language_name'];
                $result['language_id'] = $list['id'];
                $result['theme_id'] = $list['theme_id'];
                break;
            }
        }
        return $result;
    }

}

?>
