<?php

/**
 * Description of UrlalisaLogic
 *
 * @author CYM
 */
class MailSenderLogic extends BaseLogic
{

    private $mailer;

    public function __construct()
    {
        parent::__construct();
    }

    public function init($language_id)
    {
        global $cfg;
        $type = $cfg['sites'][$language_id]['mail_type'];
//      if(!$type)
//      {
        $type = "mailerPHP";
//      }	      
        $email_params = array(
            'mail_type' => $type,
            'Host' => $cfg['sites'][$language_id]['mail_smtp'],
            'Username' => $cfg['sites'][$language_id]['mail_username'],
            'Password' => $cfg['sites'][$language_id]['mail_pwd'],
            'Port' => $cfg['sites'][$language_id]['mail_port'] ? $cfg['sites'][$language_id]['mail_port'] : 25,
            'From' => $cfg['sites'][$language_id]['sender_email'],
            'FromName' => $cfg['sites'][$language_id]['sender_name'],
            'SSL' => isset($cfg['sites'][$language_id]['mail_ssl']) ? $cfg['sites'][$language_id]['mail_ssl'] : '',
            'Replay' => $cfg['sites'][$language_id]['replay_email'],
        );
        $script_file = APP_ROOT . "libary/mailer/" . $type . "/script.php";
        if (file_exists($script_file))
        {
            require_once($script_file);
            $this->mailer = new $type();
            $this->mailer->init($email_params);
        }
        else
            return false;
    }

    public function sendTo($email, $title, $content)
    {
        return $this->mailer->sendTo($email, $title, $content);
    }

    public function responseMsg()
    {
        if ($this->mailer)
            return $this->mailer->responseMsg();
        else
            return false;
    }

}

?>