<?php

/**
 * Description of MailtplLogic
 *
 * @author HHH
 */
class MailTplJoinLanguageLogic extends BaseLogic
{

    public function __construct()
    {
        parent::__construct();
        $this->table = 'MailTplJoinLanguageView';
    }
    
    /**
     * 获得所有多语言对应的模板信息
     * @param int id 
     * @param mixed languageList
     */
    public function getAllMailtplLangage($id, $languageList){
        $mailtplLanguageList = $this->getList('mail_tpl_id = ' . $id);
        //获得对应语言对应的邮件多语言模板信息
        $mailtplLanguage = array();
        foreach ($languageList as $langValue)
        {
            foreach ($mailtplLanguageList['list'] as $mailValue)
            {
                if ($langValue['id'] == $mailValue['language_id'])
                {
                    $mailtplLanguage[$langValue['id']] = $mailValue;
                }
            }
        }
        return $mailtplLanguage;
    }
    
   /**
     * 插入信息
     * @param array data 要插入的信息
     */
    public function insertData($data){
        $mailLanguage = Zhtx::createDataMap();
        $mailLanguage->addEntry('mail_tpl_id', $data['mail_tpl_id'], DB::INT);
        $mailLanguage->addEntry('language_id', $data['language_id'], DB::INT);
        $mailLanguage->addEntry('detail', $data['detail'], DB::TEXT);
        $mailLanguage->addEntry('base_name', $data['base_name'], DB::VARCHAR);
        return $this->insert($mailLanguage);
    }
    
    /**
     * 更新信息
     * @param array data 要更新的信息
     * @param int id 要更新的信息主键
     */
    public function updateData($data, $id){
        $mailLanguage = Zhtx::createDataMap();
        $mailLanguage->addEntry('mail_tpl_id', $data['mail_tpl_id'], DB::INT);
        $mailLanguage->addEntry('language_id', $data['language_id'], DB::INT);
        $mailLanguage->addEntry('detail', $data['detail'], DB::TEXT);
        $mailLanguage->addEntry('base_name', $data['base_name'], DB::VARCHAR);
        
        return $this->replaceByCond($mailLanguage, "mail_tpl_id = {$id} AND language_id = {$data['language_id']}");
        //replaceByCond($map, $cond, $table = "")
         /*
//                     * 没有replace操作,所以要先查询一遍是否有当前mail_tpl_id 和 language_id的数据值
//                     * 如果没有,则添加数据,否则更新数据
//                     */
//                    if ($this->mailtplLanguageLogic->getOne("mail_tpl_id = {$id} AND language_id = {$values}"))
//                    {
//                        $this->mailtplLanguageLogic->update($mailLanguage, "mail_tpl_id = {$id} AND language_id = {$values}");
//                    } else
//                    {
//                        $this->mailtplLanguageLogic->insert($mailLanguage);
//                    }
    }
    
    /**
     * 邮件模板内容 变量替换
     * @param type $content 邮件内容
     * @param array $params 变量集合
     * @return type 
     */
    public function getContentByParams($content, array $params = array())
    {
        $search  = array();
        $replace = array();
        foreach ($params as $key => $values) {
           if(is_array($values)){
                foreach ($values as $k => $v) {
                    $search[]  = '{' . $key . '.' . $k . '}';
                    $replace[] = $v;
                }
            }else{
                 $search[]  = '{' . $key . '}';
                 $replace[] = $values;
            }
        }
        return str_replace($search, $replace, $content);
    }

}

?>
