<?php

/**
 * Description of MailtplLogic
 *
 * @author HHH
 */
class MailTplLogic extends BaseLogic
{

    public function __construct()
    {
        parent::__construct();
        $this->table = 'MailTplTable';
    } 
    
    
    /**
     * 获得所有mailtpl信息
     */
    public function getAllMailtpl($where = 'ORDER BY id DESC'){
        $mailtpl = $this->getList($where);
        return $mailtpl['list'];
    }
    
    /**
     * 插入信息
     * @param array data 要插入的信息
     */
    public function insertData($data){
        $mailtpl = Zhtx::createDataMap();
        $mailtpl->addEntry('base_name', $data['base_name'], DB::VARCHAR);
        $mailtpl->addEntry('descript', $data['descript'], DB::VARCHAR);
        $mailtpl->addEntry('var_descript',$data['var_descript'], DB::VARCHAR);
        $mailtpl->addEntry('create_time', SYS_TIME, DB::INT);
        return $this->insert($mailtpl);
    }
    
    /**
     * 更新信息
     * @param array data 要更新的信息
     * @param int id 要更新的信息主键
     */
    public function updateData($data, $id){
        $mailtpl = Zhtx::createDataMap();
        $mailtpl->addEntry('base_name', $data['base_name'], DB::VARCHAR);
        $mailtpl->addEntry('descript', $data['descript'], DB::VARCHAR);
        $mailtpl->addEntry('var_descript',$data['var_descript'], DB::VARCHAR);
        $mailtpl->addEntry('create_time', SYS_TIME, DB::INT);
        return $this->update($mailtpl, 'id = ' . $id);
    }

}

?>
