<?php

/**
 * Description of SeotplLogic
 *
 * @author HHH
 */
class NewsletterLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'NewsletterTable';
    }
    public function save($data, $primary = 0)
    {
      $map = Zhtx::createDataMap();
      $map->createEntry($data);
      if($primary)
      {
        return $this->updateById($map, $primary);
      }
      else
      {
        return $this->insert($map);
      }
    }
    public function saveByCond($data, $cond)
    {
      $map = Zhtx::createDataMap();
      $map->createEntry($data);
      return $this->replaceByCond($map, $cond);
    }
    public function saveRegisterEmail($email = '') {
        if (!Common::isEmail($email))
        {
            return false;
        }
        require_once(APP_ROOT . 'libary/MobileDetect.php');
        $detect = new Mobile_Detect;
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $ip = Common::_ip2long(Common::ip());
        $source = AppController::getSource() ? AppController::getSource() : SITE_URL;
        $langLogic = $this->load('language');
        $map = Zhtx::createDataMap();
        $map->addEntry('email', $email, DB::VARCHAR);
        $map->addEntry('source', $source, DB::VARCHAR);
        $map->addEntry('language_id', $langLogic->language_id, DB::VARCHAR);
        $map->addEntry('domain', $_SERVER['SERVER_NAME'], DB::VARCHAR);
        $map->addEntry('ip', $ip, DB::INT);
        $map->addEntry('status', 1, DB::INT);
        $map->addEntry('create_time', SYS_TIME, DB::INT);
        $map->addEntry('source_device', $deviceType, DB::VARCHAR);
        $results = $this->insert($map);
        return $results;
    }
}

?>
