<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of OfferJoinLanguageLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class OfferJoinLanguageLogic extends BaseLogic
{
  public function __construct()
  {
    parent::__construct();
    $this->table = 'OfferJoinLanguageView';
    $this->cache_type = 'promotions';    
  }
  /**
   * 所有促销信息
   * offer 与 offer_rule 一对多关心
   * @global type $data_cache_dir
   * @param type $language_id
   * @param type $get_cache
   * @return type 
   */
  public function getListByLanguageId($language_id, $get_cache = TRUE)
  {
     global $data_cache_dir;    
     if(!$language_id)
     {
       $langLogic   = $this->load('language');
       $language_id = $langLogic->language_id;
     }
     $key    = $language_id . '_promotion_list';
     $result = _chkcahce($key, $this->cache_type);
     if(!$get_cache || !$result)
     {
        $offerItemLogic = $this->load('offerItem');
        $offerRuleLogic = $this->load('offerRule');
        $cond = 'o.status = 1 and o.end_time >'. time() . ' and l.language_id='.$language_id;
        $offerlist = $this->findAll($cond);
        $offerIds  = array();
        $end_times = array();
        $goods_promotion = array();
        $categoryLogic   = $this->load('goodsCategory');
        foreach ($offerlist as $list)
        {
          $offerIds[]  = $list['id'];
          $end_times[] = $list['end_time'];
          if($list['is_category'])
          {
            $cur_category_id = $list['category_id'];
            $cur_cat = $categoryLogic->getOneById($cur_category_id);
            if($cur_cat)
            {
              $result['category'][$list['category_id']][$list['id']] = $list;
              $cat_cond = 'path_id like "' . $cur_cat['path_id'] . '%"';
              $cols     = array('id');
              $son_cats = $categoryLogic->getCols($cat_cond, $cols);
              foreach ($son_cats as $son)
              {
                $result['category'][$son['id']][$list['id']] = $list;
              }
            }            
          }
          else if($list['is_brand'])
          {
            $result['brand'][$list['brand_id']][$list['id']] = $list;
          }
          else if($list['is_goods'])
          {
            $goods_promotion[$list['id']] = $list;
          }
          else if($list['is_cart'])
          {
             $result['cart'][$list['id']] = $list;
          }
        }
        if(empty($offerIds))
        {
           return FALSE;
        }
        $rule_cond = 'offer_id in (' . implode(',', $offerIds) . ') order by listorder desc';
        $offerRules = $offerRuleLogic->findAll($rule_cond);
        $offer_rule = array();//同一个促销可能有多条规则
        foreach($offerRules as $rule)
        {
          $offer_rule[$rule['offer_id']][$rule['id']] = $rule;          
        }
        $cond2 = 'offer_id in (' . implode(',', $offerIds) . ')';
        $offerItems = $offerItemLogic->findAll($cond2);
        foreach($offerItems as $item)
        {
          if(isset($goods_promotion[$item['offer_id']]))
          {
             $result['goods'][$item['goods_id']][$item['offer_id']] = $goods_promotion[$item['offer_id']];
          }
          
        }
        $gift_cond = 'o.offer_id in (' . implode(',', $offerIds) . ') and g.status=1 and g.stock_nums>0 and l.language_id=' . $language_id;
        $giftJoinGoodsLogic    = $this->load('giftGoodsJoinLang');
        $propertyJoinLangLogic = $this->load('propertyJoinLanguage');
        $offerGifts = $giftJoinGoodsLogic->findAll($gift_cond);
        $offer_gift = array();
        foreach ($offerGifts as $value)
        {
           $value['attr'] = $propertyJoinLangLogic->getPropertyByGoodsId($value['goods_id'], $language_id);
           $offer_gift[$value['offer_id']][$value['rule_id']][$value['goods_id']] = $value; 
        }
        $result['rules'] = $offer_rule;
        $result['gifts'] = $offer_gift;
        $cache_time      = $data_cache_dir[$this->cache_type]["time"];
        sort($end_times);
        $cache_time_out = isset($end_times[0]) ? $end_times[0] - $cache_time : SYS_TIME;
        _setcahce($key, $result, $this->cache_type, $cache_time_out);
     }
     return $result;
  }
  /**
   * 读取列表页促销
   * @param type $goods_ids
   * @param type $category_ids
   * @param type $brand_id 
   */
  public function getPromotionsList($goods_ids, $category_ids=array(0), $brand_id=0, $language_id=0)
  {
    $result  = array();
    $all_promotions = $this->getListByLanguageId($language_id);
    //分类促销
    $cat_promotions = array();
    foreach ($category_ids as $item)
    {
        if(isset($all_promotions['category'][$item]))
        $cat_promotions[] = $all_promotions['category'][$item];
    }        
    //品牌促销
    if($brand_id)
    {
      $cat_promotions[] = $all_promotions['brand'][$brand_id];
    }
    $goods_promotions = array();
    foreach($goods_ids as $goods_id)
    {
      if(isset($all_promotions['goods'][$goods_id]))
      {           
        $goods_promotions[$goods_id] = array_merge($cat_promotions, array($all_promotions['goods'][$goods_id]));
      }
      else
      {
        $goods_promotions[$goods_id] = $cat_promotions;
      }
    }
    $user_group_id = 0;
    if(AppController::checkLogin()){
      $user_group_id = _c('user_group') ? _c('user_group') : _s('user_group');
    }
    foreach ($goods_promotions as $key=>$list)
    {
      foreach($list as $vals )
      {
        foreach($vals as $val )
        {   
          if($val['start_time'] <= time() && $val['end_time'] > time() && ($val['user_group_id'] == 0 || $val['user_group_id'] == $user_group_id))
          {
            $result[$key][] = $val;
                       
          }             
        }
      }        
    }
    return $result;
  }

  /**
   * 购物车商品促销算法
   * return 单商品总价 优惠金额 折扣 礼品
   * @param type $sku_id
   * @param type $offer_id
   * @param type $qty
   * @param type $language_id
   * @return boolean 
   */
  public function getProductOffer($sku, $offer_id, $qty, $language_id)
  {
      $subtotal        = $sku['price']*$qty;
      $promotionlist   = $this->getListByLanguageId($language_id);
      $offer           = array();
      if(isset($promotionlist['goods'][$sku['goods_id']][$offer_id]))
      {
        $offer = $promotionlist['goods'][$sku['goods_id']][$offer_id];
      }
      else
      {
        $goods = $this->load('goods')->getOneById($sku['goods_id']);
         if(isset($promotionlist['brand'][$goods['brand_id']][$offer_id]))
        {
          $offer = $promotionlist['brand'][$goods['brand_id']][$offer_id];
        }
        else
        {
          $cond = 'goods_id=' . $sku['goods_id'];
          foreach ($this->load('goodsCategoryRel')->findAll($cond) as $cat)
          {
             if(isset($promotionlist['category'][$cat['goods_category_id']][$offer_id]))
            {
              $offer = $promotionlist['category'][$cat['goods_category_id']][$offer_id];
              break;
            }
          }
        }
      }
      $offer_rule      = isset($promotionlist['rules'][$offer_id]) ? $promotionlist['rules'][$offer_id] : FALSE;
      if($offer && $offer['start_time'] <= time() && $offer['end_time'] > time() && $offer_rule)
      {
        $rule      = array();//获取优先级较高的规则
        $listorder = -1;
        foreach ($offer_rule as $key => $value)
        {
           if($qty >= $value['min_buynum'] && $subtotal >= $value['min_amount'])
           {
             if($value['listorder'] > $listorder)
             {
                $rule      = $value;
                $listorder = $value['listorder'];
             }
           }
        }
        $is_gift = isset($rule['is_gift'])? $rule['is_gift'] : FALSE;
        if($is_gift)
        {
            foreach ($promotionlist['gifts'] as $key=>$val){
            if($key == $offer_id && isset($val[$rule['id']]))
            {
              $result['gifts'] = $val[$rule['id']];//以goods_id 为下标
              break;
            }
          }
        }        
        $minus    = isset($rule['minus']) ? AppController::toolPrice($rule['minus']) : 0;
        $discount = isset($rule['discount']) ? $rule['discount'] /10 : 0;
        $subtotal_true = AppController::toolPrice($sku['price'])*$qty;
        $result['rule_id'] = isset($rule['id']) ? $rule['id'] : 0;
        if($minus)
        {
          $result['subtotal'] = $subtotal_true- $minus;
          $result['save']     = $minus;
        }
        else if($discount)
        {
          $result['subtotal'] = $subtotal_true*$discount;
          $result['discount'] = $discount;
          $result['save']     = $subtotal_true*(1-$discount);              
        }
        else
        {
          $result['subtotal'] = $subtotal_true;
        }
        $result['offer'] = isset($promotionlist['goods'][$sku['goods_id']][$offer_id]) ? $promotionlist['goods'][$sku['goods_id']][$offer_id] : '';
      }
      else
      {
          $result = FALSE;
      } 
      return $result;
  }
  private function getTotalByBrandId($brand_id,$cart_data)
  {
      $totalnum = 0;
      $totalprice = 0;
      foreach($cart_data as $key =>$sku)
      {
          $goods = $this->load('goods')->getOneById($sku['goods_id']);
          if($goods['brand_id'] == $brand_id)
          {
              $totalnum += $sku['product_num'];
              $totalprice += $sku['price']*$sku['product_num'];
          }
      }
      return array('totalnum'=>$totalnum, 'totalprice'=>$totalprice);
  }
  private function getTotalByCategoryId($category_id,$cart_data)
  {
      $totalnum = 0;
      $totalprice = 0;
      foreach($cart_data as $key =>$sku)
      {
          $cond = 'goods_id=' . $sku['goods_id'];
          foreach ($this->load('goodsCategoryRel')->findAll($cond) as $cat)
          {
                if($cat['goods_category_id'] == $category_id)
                {
                    $totalnum += $sku['product_num'];
                    $totalprice += $sku['price']*$sku['product_num'];
                }
          }
      }
      return array('totalnum'=>$totalnum, 'totalprice'=>$totalprice);
  }
  private function getTotalByOfferId($offer_id,$cart_data,$promotionlist)
  {
      $totalnum = 0;
      $totalprice = 0;
      foreach($cart_data as $key =>$sku)
      {
          if(isset($promotionlist['goods'][$sku['goods_id']][$offer_id]))
          {
              $totalnum += $sku['product_num'];
              $totalprice += $sku['price']*$sku['product_num'];
          }
      }
      return array('totalnum'=>$totalnum, 'totalprice'=>$totalprice);
  }
  public function getCartOffer($offer_id, $totalprice, $totalqty, $language_id, $cart_data = array())
  {
    $promotionlist     = $this->getListByLanguageId($language_id);
    $is_cart_promotoin = isset($promotionlist['cart'][$offer_id]) ? $promotionlist['cart'][$offer_id] : FALSE;
    $offer_rule        = isset($promotionlist['rules'][$offer_id]) ? $promotionlist['rules'][$offer_id] : 0;    
    $result = array();
    if(!$is_cart_promotoin)
    {
        //只有优惠券才会传递$cart_data
        foreach($cart_data as $key =>$sku)
        {
            $goods = $this->load('goods')->getOneById($sku['goods_id']);
            if(isset($promotionlist['brand'][$goods['brand_id']][$offer_id]))
            {
                $total = $this->getTotalByBrandId($goods['brand_id'],$cart_data);     
                foreach ($offer_rule as $key => $value)
                {
                  if($total['totalnum'] >= $value['min_buynum'] && $total['totalprice'] >= $value['min_amount'])
                  {
                      $is_cart_promotoin = $promotionlist['brand'][$goods['brand_id']][$offer_id];
                      break;
                  }
                }                
            }
            else if(isset($promotionlist['goods'][$sku['goods_id']][$offer_id]))
            {
                $total = $this->getTotalByOfferId($offer_id,$cart_data,$promotionlist);  
                foreach ($offer_rule as $key => $value)
                {
                  if($total['totalnum'] >= $value['min_buynum'] && $total['totalprice'] >= $value['min_amount'])
                  {
                      $is_cart_promotoin = $promotionlist['goods'][$sku['goods_id']][$offer_id];
                      break;
                  }
                }   
            }
            else
            {
              $cond = 'goods_id=' . $sku['goods_id'];
              foreach ($this->load('goodsCategoryRel')->findAll($cond) as $cat)
              {
                 if(isset($promotionlist['category'][$cat['goods_category_id']][$offer_id]))
                {
                     $total = $this->getTotalByCategoryId($cat['goods_category_id'],$cart_data);
                    foreach ($offer_rule as $key => $value)
                    {
                        if($total['totalnum'] >= $value['min_buynum'] && $total['totalprice'] >= $value['min_amount'])
                        {
                            $is_cart_promotoin = $promotionlist['category'][$cat['goods_category_id']][$offer_id];
                            break;
                        }
                    }
                }
              }
            }
        }
    }
    //var_dump($offer_rule);
    if($is_cart_promotoin)
    {
        $is_cart_promotoin['offer_rule'] = $offer_rule;
    }
    if($offer_rule && $is_cart_promotoin && $is_cart_promotoin['start_time'] <= time() && $is_cart_promotoin['end_time'] > time())
    {
          $rule      = array();//获取优先级较高的规则
          $listorder = -1;
          foreach ($offer_rule as $key => $value)
          {
            if($totalqty >= $value['min_buynum'] && $totalprice >= $value['min_amount'])
            {
              if($value['listorder'] > $listorder)
              {
                  $rule = $value;
                  $listorder = $value['listorder'];
              }
            }
          }
          $is_gift = isset($rule['is_gift'])? $rule['is_gift'] : FALSE;
          if($is_gift)
          {
              foreach ($promotionlist['gifts'] as $key=>$val){
              if($key == $offer_id && isset($val[$rule['id']]))
              {
                $result['gifts'] = $val[$rule['id']];//以goods_id 为下标
                break;
              }
            }
          }
         $minus    = isset($rule['minus']) ? AppController::toolPrice($rule['minus']) : 0;
         $discount = isset($rule['discount']) ? $rule['discount'] /10 : 0;
         $result['rule_id']   = isset($rule['id']) ? $rule['id'] : 0;
         $result['free_ship'] = isset($rule['free_ship']) ? $rule['free_ship'] : 0;//是否免运费
         $cur_price  = AppController::toolPrice($totalprice);
          if($minus)
          {
            $result['cart_save']     = $minus;
            $result['subtotalprice'] = $cur_price-$minus;
            $result['cart_discount'] = round(($cur_price-$minus) / $cur_price, 2);
          }
          else if($discount)
          {
            if($is_cart_promotoin['offer_type']==2 && $is_cart_promotoin['is_cart']==0)
            {
                $result['cart_discount'] = $discount;
                $result['subtotalprice'] = $cur_price - AppController::toolPrice($total['totalprice'])*(1-$discount);
                $result['cart_save']     = AppController::toolPrice($total['totalprice'])*(1-$discount);
            }
            else
            {
                $result['cart_discount'] = $discount;
                $result['subtotalprice'] = $cur_price *$discount;
                $result['cart_save']     = $cur_price *(1-$discount);
            }
          }
          else
          {
            $result['subtotalprice'] = $cur_price;
          }
          $result['offer'] = $is_cart_promotoin;
     }
     return !empty($result) ? $result :FALSE;
  }
  /**
   * 满足促销条件的所有购物车促销
   * @param type $totalprice
   * @param type $totalqty
   * @param type $language_id
   * @return type 
   */
  public function getCartOffers($totalprice, $totalqty, $language_id)
  {
     $promotionlist = $this->getListByLanguageId($language_id);     
     $offer = array();
     $minus    = array();
     $discount = array();
     $user_group_id = 0;
    if(AppController::checkLogin()){
      $user_group_id = _c('user_group') ? _c('user_group') : _s('user_group');
    }
     foreach ($promotionlist['cart'] as $list)
     {                
        if($list['offer_type'] == 1 && isset($promotionlist['rules'][$list['id']]) && $list['start_time'] <= SYS_TIME && $list['end_time'] >= SYS_TIME && ($list['user_group_id'] == 0 || $list['user_group_id'] == $user_group_id))
        {
          foreach ($promotionlist['rules'][$list['id']] as $key => $value)
          {
            if($totalqty >= $value['min_buynum'] && $totalprice >= $value['min_amount'])
            {
              if($value['discount'] > 0)
              {
                $save_amount = $totalprice*(10-$value['discount'])/10;
                $discount[$list['id']] = $save_amount;
              }
               $minus[$list['id']]    = $value['minus'];               
               $offer[$list['id']] = $list;
            }
          }
        }
     }
     if(!count($offer))
     {
       return $offer;
     }
     
      $minus_total_key = array_search(max($minus), $minus);
      $dis_total_key   = array_search(max($discount), $discount);
      $minus_save      = $minus[$minus_total_key];
      $discount_save   = $discount[$dis_total_key];
      if($minus_save > $discount_save)
      {
        $offer[$minus_total_key]['cart_save'] = $minus_save;
        $offer[$minus_total_key]['max_offer'] = 1;
      }
      else
      {
        $offer[$dis_total_key]['cart_save'] = $discount_save;
        $offer[$dis_total_key]['max_offer'] = 1;
      }
     return $offer;
  }
  /**
   * 验证优惠是否有效
   * @param type $rule_id
   * @param type $total_amount
   * @param type $total_qty
   * @return boolean 
   */
  public function validOffer($rule_id, $total_amount=0, $total_qty=0)
  {
     return true;
  }
}

?>
