<?php

/**
 * Description of ShippingLogic
 *
 * @author HHH
 */
class OrderDeliveryLogic extends BaseLogic
{

    public function __construct()
    {
        parent::__construct();
        $this->table = 'OrderDeliveryTable';
    }
	public function save($data, $primary=0)
   {
      $map = Zhtx::createDataMap();
      $map->createEntry($data);
      if($primary)
      {
        return $this->updateById($map, $primary);
      }
      else
      {
        return $this->insert($map);
      }
   }
	
	/*
	$cart_param 购物车参数
	$shipping_param 关联的配置信息 json的文本格式
	$shipping_formula 关联的公式
	return 如果为false,那么上级必须删除这个配送方式
	*/
	public  function getShippingCost($cart_param,$shipping_param,$shipping_formula)
	{
		$script_file = APP_ROOT."api/shipping/".$shipping_formula."/script.php";
//        _debug($script_file);
		if (file_exists($script_file))
		{
			require_once($script_file);
			$shipping = new $shipping_formula();
			return $shipping->getShippingCost($cart_param,$shipping_param);
		}
		return false;
	}

}

?>
