<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of OrderItemLogic
 *
 * @author xrx
 */
class OrderItemLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'OrderItemTable';
    }
    public function save($data, $primary = 0)
    {
      $map = Zhtx::createDataMap();
      $map->createEntry($data);
      if($primary)
      {
        return $this->updateById($map, $primary);
      }
      else
      {
        return $this->insert($map);
      }
    }
    
    public function getListByOrderId($order_id)
    {
        $cond   = 'order_id ='. $order_id;
        $result = $this->getList($cond);
        return $result['list'];
    }
    /**
     * 支付成功后的情况
     * 更新sku 商品库存
     * @param type $order_id
     */
    public function updateStock($order_id)
    {
      $cols = array('goods_id', 'sku_code', 'buy_num', 'return_num');
      $orderItems     = $this->getCols('order_id=' . $order_id, $cols);      
      if(count($orderItems))
      {
        $skuLogic = $this->load('sku');
        $goodsLogic = $this->load('goods');
        $goodsLangLogic = $this->load('goodsLanguage');
        $goods_stock = array();
        $goods_ids   = array();
        foreach ($orderItems as $item)
        {
          $reduce_num = $item['buy_num'] - $item['return_num'];
          $sku_cond   = 'goods_id=' . $item['goods_id'] . ' and sku_code="' . $item['sku_code'] . '"';
          $map = Zhtx::createDataMap();
          $map->addEntry('stock_nums', 'stock_nums - (' . $reduce_num . ')', DB::INT);
          $map->addEntry('freeze_nums', 'freeze_nums - (' . $reduce_num . ')', DB::INT);
          $map->addEntry('delivery_nums', 'delivery_nums + (' . $reduce_num . ')', DB::INT);
          $map->addEntry('update_time', SYS_TIME, DB::INT);
          $goods_ids[$item['goods_id']]   = $item['goods_id'];
          $goods_stock[$item['goods_id']] = isset($goods_stock[$item['goods_id']]) ? $goods_stock[$item['goods_id']] + $reduce_num : $reduce_num;
          $skuLogic->update($map, $sku_cond);
        }
        if(count($goods_ids))
        {
          $goods_cond = 'id in(' . implode(',', $goods_ids) . ')';
          $goods_cols = array('id', 'stock_nums');
          $goodsList  = $goodsLogic->getCols($goods_cond, $goods_cols);
          $goodsLanguageLogic = $this->load('goodsLanguage');
          foreach ($goodsList as $val)
          {
            /*
            $cur_stock = $val['stock_nums'] - $goods_stock[$val['id']];
            if(($val['stock_nums'] - $goods_stock[$val['id']]) < 0)
            {
              $cur_stock = 0; 
            }
            $status = $cur_stock === 0 ? 0 : 1;
            $goods_data = array('stock_nums' => $cur_stock, 'modify_time' => SYS_TIME, 'status' => $status);
            $goodsLogic->saveByCond($goods_data, 'id=' . $val['id']);
            if ($cur_stock === 0)
            {
              $goodsLangLogic->saveByCond(array('status' => 0), 'goods_id=' . $val['id']);
            }
            $goodsLanguageLogic->updateCache($val['id']);
            */
            //更新库存
            $this->load('goods')->updateStockNums($val['id']);
          }
        }
      }
    }
}

?>
