<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of OrderPaymentLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class OrderPaymentLogic extends BaseLogic
{
    public function __construct()
    {
      parent::__construct();
      $this->table = 'OrderPaymentTable';      
    }
    public function save($data, $primary = 0)
    {
      $map = Zhtx::createDataMap();
      $map->createEntry($data);
      if($primary)
      {
        return $this->updateById($map, $primary);
      }
      else
      {
        return $this->insert($map);
      }
    }
    public function updateByCond($data)
    {       
       $map = Zhtx::createDataMap();
       $map->createEntry($data);
       $cond = 'order_id=' . $data['order_id'] . ' and user_id=' . $data['user_id'] . ' and status !=1 limit 1';
       return  $this->replaceByCond($map, $cond);      
    }
    /**
     * 更新收款单状态
     * @param type $cond
     * @param type $status
     * @return type 
     */
    public function updateStatus($cond, $status)
    {
       $map = Zhtx::createDataMap();
       $map->addEntry('status', $status, DB::INT);      
       return $this->update($map, $cond);
    }
    /**
     * 计算退货后的退款金额 
     */
    public function getRefundAmount($order_id)
    {
      //查找退货的订单项
      $orderItemLogic = $this->load('orderItem');
      $cond = 'order_id=' . $order_id . ' and status=2';
      $total_refund_amount = 0; //总退款金额
      $return_items = $orderItemLogic->findAll($cond);
      foreach ($return_items as $item)
      {
        $total_refund_amount += $item['price'] * $item['return_num'];
      }
      $refunded_amount = 0;//已退金额
      $refunded_amount_cond = 'order_id=' . $order_id . ' and payment_type=2 and status=1';
      $refunded_payments    = $this->findAll($refunded_amount_cond);
      foreach ($refunded_payments as $value)
      {
        $refunded_amount += $value['amount'];
      }
      return $total_refund_amount - $refunded_amount;
    }
}

?>
