<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ProductLogic
 *
 * @author xrx
 */
class ProductLogic extends BaseLogic
{
    protected $sku_table;
    protected $sku_dao;
    public function __construct() {
        parent::__construct();
        $this->table      = 'ProductTable';
        $this->sku_table  = Zhtx::getTable('SkuTable');
        $this->sku_dao    = Zhtx::getDAO($this->sku_table);
        $this->cache_type = "goods_info";
    }
    /**
     * 效验表单数据
     * @param type $data
     * @return boolean 
     */
    public function validate($data)
    {
        
    }
    public function save($data, $id=0)
    {
        $product_map   = Zhtx::createDataMap();
        $product_map->createEntry($data);        
        if($id)
        {
            $result = $this->update($product_map, 'id=' . $id);
        }
        else
        {
            $result = $this->insert($product_map);
        }
        return $result;
    }
    /**
     * 查找单品 以主销售属性为下标
     * @param type $goods_id
     * @return type 
     */
    public function getlistByGoodsId($goods_id, $status=TRUE)
    {
        $cond = 'goods_id=' . $goods_id;
        $res  = $this->findAll($cond);
        $list = array();
        foreach ($res as $value)
        {
            $list[$value['property_id']] = $value;
        }
        return $list;
    }
    /**
     * 读取列表页所有单品
     * @global type $data_cache_dir
     * @param type $goods_ids
     * @param type $get_cache
     * @return type 
     */
     public function getlistByGoodsIds($goods_ids, $get_cache = true)
     {
       global $data_cache_dir;
       $cond = 'goods_id in(' . implode(',', $goods_ids) . ') and stock_nums>0';
       $key  = md5($cond);
       $type = 'goods_list';
       $chk  = _chkcahce($key, $type);
       if(!$get_cache || !$chk)
       {
         $result = $this->findAll($cond);
         foreach ($result as $val)
         {
           $chk[$val['goods_id']][] = $val;
         }
          _setcahce($key, $chk, $type);
       }
        return $chk;
     }
    /**
     * 有两种销售属性的情况下 通过主销售读取sku列表
     * @param type $goods_id
     * @param type $property_id
     * @return type 
     */
    public function getSkusByMaster($goods_id, $property_id)
    {
        $where   = 'goods_id ='.$goods_id . ' AND sku_code like "' . $property_id . '_%" and status=1';
        $skulist = $this->sku_dao->getAllSelectiveWithCond(array("*"), null, $where);
        if(!$skulist)
        {
            $skulist[] = $this->getSku($goods_id, $property_id);
        }
        return $skulist;
    }
    /**
     * 有两种销售属性的情况下 通过销售属性读取sku列表
     * @param type $goods_id
     * @param type $property_id
     * @return type 
     */
    public function getSkusBySale($goods_id, $property_id)
    {
        $where   = 'goods_id ='.$goods_id . ' AND sku_code like "%_' . $property_id . '" and status=1';
        $skulist = $this->sku_dao->getAllSelectiveWithCond(array("*"), null, $where);
         if(!$skulist)
        {
            $skulist[] = $this->getSku($goods_id, $property_id);
        }
        return $skulist;
    }
    /**
     * 只有一种销售属性的情况下
     * @param type $goods_id
     * @param type $property_id
     * @return type 
     */
    public function getSku($goods_id, $property_id)
    {
        $where   = 'goods_id ='.$goods_id . ' AND sku_code ="' . $property_id . '" and status=1';
        $skulist = $this->sku_dao->getRowWithCond('', $where);
        return $skulist;
    }
    
   public function updateByCond($data)
    {
        $cond = 'goods_id ='. $data['goods_id'] . ' and property_id='.$data['property_id'];
        $map = Zhtx::createDataMap();
        $map->createEntry($data);        
        return $this->replaceByCond($map, $cond);

    }
    
}

?>
