<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of PropertyJoinLanguageLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class PropertyJoinLanguageLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'PropertyJoinLanguageView';
    }
    public function getListById($id)
    {
        $cond = 'p.id=' . $id . ' or p.parent_id =' . $id;
        return $this->findAll($cond);
    }
    /**
     * 获取商品的销售属性
     * @param type $goods_id
     * @param type $language_id
     * @return type 
     */
    public function getPropertyByGoodsId($goods_id, $language_id)
    {
       $skuLogic = $this->load('sku');
       $goodsPropertyRelLogic = $this->load('goodsPropertyRel');
       $cond = 'goods_id=' . $goods_id . ' and status =1 and stock_nums > 0';
       $skulist = $skuLogic->findAll($cond);
       $property_ids = array();
       foreach($skulist as $value)
       {
         $sku_code_array = explode('_', $value['sku_code']);
         if($sku_code_array[0])
         {
           $property_ids[] = $sku_code_array[0];
         }
         if($sku_code_array[1])
         {
           $property_ids[] = $sku_code_array[1];
         }
       }
       $result = array();
       if($property_ids)
       {
            $vid_sql = implode(',', array_unique($property_ids));
            $cond3   = 'vid in (' . $vid_sql . ')';
            $cols    = array('distinct property_id');
            $parents = $goodsPropertyRelLogic->getCols($cond3, $cols);
            foreach ($parents as $pid)
            {
              $property_ids[] = $pid['property_id'];
            }
            if(!empty($property_ids))
            {
               $cond2 = 'p.id in (' . implode(',', array_unique($property_ids)) . ') and p.type !=0 and l.language_id=' . $language_id;
               $array = $this->findAll($cond2);
               $attr  = array();
               foreach ($array as $item)
               {       
                   if($item['parent_id'] == 0)
                   {
                     if( $item['type'] == 1)
                     {
                       $attr['master'] = $item;
                     }
                     else if( $item['type'] == 2)
                     {
                       $attr['sale'] = $item;
                     }
                   }
                   else
                   {
                     $attr['attr'][$item['id']] = $item;
                   }                          
               }
               foreach($skulist as $value)
               {
                 $sku_code_array = explode('_', $value['sku_code']);
                 $master = '';
                 $sale   = '';
                 if($sku_code_array[0])
                 {
                   $master = $attr['master']['base_name'].':'. $attr['attr'][$sku_code_array[0]]['base_name'];
                 }
                 if($sku_code_array[1])
                 {
                   $sale = $attr['sale']['base_name'].':'. $attr['attr'][$sku_code_array[1]]['base_name'];;
                 }
                 $result[$value['sku_code']] = $master. ' ' . $sale;
               }
            }
       }
       return $result;
    }
	
	public function getItem($id, $language_id=0,$get_cache=true)
	{
		global $data_cache_dir;
       	$key     = $language_id . '_property_detail';
        $result  = _chkcahce($key, $this->cache_type);
        if(!$get_cache || !$result)
        {
        	$cond = 'p.id =' . $id . ' AND l.language_id =' . $language_id;
          	$result = $this->getOne($cond);
			return $result;
		}
		else
		{
			return $result;	
		}
	}
}

?>
