<?php

/**
 * Description of LanguageLogic
 *
 * @author xrx
 */
class PropertyLanguageLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'PropertyLanguageTable';
    }
    /**
     * 获取相应语言的属性
     * @param type $language_id
     * @param type $property_ids
     * @return type 
     */
    public function getListByLanguageId($language_id, $property_ids)
    {
        $cond = 'language_id = '. $language_id;
        if(is_array($property_ids))
        {
            $cond .= ' AND property_id in (' . implode(',', $property_ids) . ')';
        }
        else
        {
            $cond .= ' AND property_id = ' . $property_ids;
        }
        $result = $this->getList($cond);
        return isset($result['list']) ? $result['list'] : '';
    }
    public function save($data, $primary = 0)
    {
        $map = Zhtx::createDataMap();
        $map->createEntry($data);
        if($primary)
        {
            $result = $this->updateById($map, $primary);
        }
        else
        {
            $result = $this->insert($map);
        }
        return $result;
    }
    public function updateByCond($data)
    {
        $cond = 'property_id='. $data['property_id'] . ' AND language_id=' . $data['property_id'];
        $map = Zhtx::createDataMap();
        $map->createEntry($data);
        return $this->replaceByCond($map, $cond);
    }
}

?>
