<?php

/**
 * Description of LanguageLogic
 *
 * @author xrx
 */
class PropertyLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'PropertyTable';
        $this->cache_type = 'property';
    }
    public function save($data, $primary)
    {
        $pro_value_map = Zhtx::createDataMap();
        foreach ($data as $key => $value)
        {
            $pro_value_map->addEntry($key, $value);
        }       
        if($primary)
        {
            $res = $this->updateById($pro_value_map, $primary);
        }
        else
        {
            $res = $this->insert($pro_value_map);
        }
        return $res;
    }
    public function updateByCond($data)
    {
        $cond = 'parent_id=' . $data['parent_id'] . ' and base_name="' . $data['base_name'] . '"';
        $map = Zhtx::createDataMap();
        $map->createEntry($data);
        return $this->replaceByCond($map, $cond);
    }
    public function getSkuAttr($sku_code)
    {
       if($sku_code == '0_0')
       {
          return '没有销售属性';
       }      
       $property_ids = str_replace('_', ',',  $sku_code);
       $properties   = $this->findAll('id in (' . $property_ids . ')' );
       $son        = array();
       $parent_ids = array();
       foreach($properties as $pro)
       {
         $parent_ids[] = $pro['parent_id'];
         $son[$pro['parent_id']] = $pro['base_name'];
       }
       $parents = $this->findAll('id in (' . implode(',', $parent_ids) . ')' , true);
       $result  = '';
       foreach ( $son as $key => $value)
       {
         $result .=  $parents[$key]['base_name'] . ' : ' . $value . ' ';
       }
       return $result;
    }
    
    /**
     * 通过ids获取父级和子属性值的数组，结果如：array(父级ID => array(属性值ID1,属性值ID2))。
     * @param type $property_ids
     * @param type $get_cache
     */
    public function getParentAndSonByIds($property_ids, $get_cache=true)
    {
        if(!$property_ids)
        {
            return;
        }
        if(!is_array($property_ids))
        {
            $property_ids = explode(',', $property_ids);
        }
       	$key     = 'property_ids_parentandsonarray_'.join('_',$property_ids);
        $result  = _chkcahce($key, $this->cache_type);
        if(!$get_cache || !$result)
        {
            $properties   = $this->findAll('id in (' . join(',',$property_ids) . ')' );
            foreach($properties as $pkey => $rows)
            {
                $result[$rows['parent_id']][] = $rows;
            }
            _setcahce($key, $result, $this->cache_type);
        }
        return $result;
    }
}

?>
