<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SeoMetaMakerLogic
 *
 * @author xrx
 */
class SeoMetaMakerLogic extends BaseLogic
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getIndexMeta($language_id, $tpl_id)
    {
        global $cfg;
        $seo = array();
        $seoTpl = AppController::load('SeoTplJoinLanguage');
        $arr = $seoTpl->getItem($tpl_id, $language_id);
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        $seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];
		foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
        return $seo;
    }

    public function getArticleMeta($language_id, $tpl_id, $article_id)
    {
        global $cfg;
        $seo = array();
        $seoTpl = AppController::load('SeoTplJoinLanguage');
        $articleCategoryRel = AppController::load('articleCategoryRelation');
        $articleLanguageLogic = AppController::load('articleJoinLanguage');
        $arr = $seoTpl->getItem($tpl_id, $language_id);
        $seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];

        $replace = array();
        $article = $articleLanguageLogic->getItem($article_id, $language_id);
        $arr_category = $articleCategoryRel->getCategoryList($article_id);
        $all_category = "";
        foreach ($arr_category as $key => $value)
        {
            $all_category .= $value["article_category_path"];
            $arr_article_category_path = split(',', $value["article_category_path"] . "0");
            $current_category[] = $arr_article_category_path[count($arr_article_category_path) - 2];
        }
        $all_category .= "0";
        $arr_all_category = split(',', $all_category);
        $arr_all_category = array_unique($arr_all_category);
        $articleCategoryJoinLanguageLogic = AppController::load('articleCategoryJoinLanguage');
        foreach ($arr_all_category as $value)
        {
            if ($value == 0)
                continue;
            $articleCategory = $articleCategoryJoinLanguageLogic->getItem($value, $language_id);
            if (in_array($value, $current_category))
            {
                $last_category[] = $articleCategory["base_name"];
            }
            $category[] = $articleCategory["base_name"];
        }

        $replace[] = array("{article_name}", $article["base_name"]);
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
        foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[category split='(.*)'](.*)\[\/category\]/", $value, $matche))
            {
                foreach ($last_category as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
        foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[path split='(.*)'](.*)\[\/path\]/", $value, $matche))
            {
                foreach ($category as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
        $seo["title"] = ($article["title"] == "") ? $seo["title"] : $article["title"];
        $seo["keywords"] = ($article["keywords"] == "") ? $seo["keywords"] : $article["keywords"];
        $seo["descript"] = ($article["descript"] == "") ? $seo["descript"] : $article["descript"];
        return $seo;
    }

    public function getArticleCategoryMeta($language_id, $tpl_id, $article_category_id, $page)
    {
        global $cfg;
        $lang = Common::lang("home", "module", Core::$language);
        $page = $page ? $page : 1;
        $seo = array();
        $seoTpl = AppController::load('SeoTplJoinLanguage');
        $articleCategoryLogic = AppController::load('articleCategory');
        $articleCategoryJoinLanguage = AppController::load('articleCategoryJoinLanguage');
        $arr = $seoTpl->getItem($tpl_id, $language_id);
        $seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];
        $replace = array();
        $article_category = $articleCategoryLogic->getOne("id=" . $article_category_id);

        $path = split(',', $article_category["path_id"] . "0");
        foreach ($path as $value)
        {
            if ($value == 0)
                continue;
            $category = $articleCategoryJoinLanguage->getItem($value, $language_id);
            $arr_category_name[] = $category["base_name"];
            if ($value == $article_category_id)
            {
                $current_category = $category;
            }
        }
        if (!$current_category)
        {
            $current_category['base_name'] = $lang['article'];
        }
        $replace[] = array("{category_name}", $current_category["base_name"]);
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
        $replace[] = array("{page}", $page);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }

        foreach ($seo as $key => $value)
        {
            if (preg_match("/\[category split='(.*)'](.*)\[\/category\]/", $value, $matche))
            {
                foreach ($arr_category_name as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }

        $seo["title"] = ($current_category["title"] == "") ? $seo["title"] : $current_category["title"];
        $seo["keywords"] = ($current_category["keywords"] == "") ? $seo["keywords"] : $current_category["keywords"];
        $seo["descript"] = ($current_category["descript"] == "") ? $seo["descript"] : $current_category["descript"];
        return $seo;
    }

    public function getCategoryMeta($language_id, $tpl_id, $category_id, $page)
    {
        global $cfg;
        $page = $page ? $page : 1;
        $seo = array();
        $seoTpl = AppController::load('SeoTplJoinLanguage');
        $goodsCategoryLogic = AppController::load('goodsCategoryJoinLang');
        $category = $goodsCategoryLogic->getOne("l.goods_category_id=" . $category_id . ' and l.language_id=' . $language_id);
        if ($category['title'] || $category['keywords'] || $category['descript'])
        {
            $seo["title"] = $category["title"] ? $category["title"] : $category["base_name"];
            $seo["keywords"] = $category["keywords"];
            $seo["descript"] = $category["descript"];
            return $seo;
        }        
        //获取SEO模板id
       
        if($category['seo_tpl_id'])
        {
            $tpl_id = $category['seo_tpl_id'];
        }
		
        $arr = $seoTpl->getItem($tpl_id, $language_id);
        $seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];
        $replace = array();
        $replace[] = array("{category_name}", $category["base_name"]);
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
        $replace[] = array("{page}", $page);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
		
		$path = split(',', $category["path_id"] . "0");
        foreach ($path as $value)
        {
            if ($value == 0)
                continue;
            $p_category = $goodsCategoryLogic->getItem($value, $language_id);
            $arr_category_name[] = $p_category["base_name"];
           
        }
		
        foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[path split='(.*)'](.*)\[\/path\]/", $value, $matche))
            {
                foreach ($arr_category_name as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
        return $seo;
    }

    public function getBrandMeta($language_id, $tpl_id, $brand_id, $page)
    {
        global $cfg;
        $page = $page ? $page : 1;
        $seo = array();
        $seoTpl = AppController::load('SeoTplJoinLanguage');
        $brandJoinLanguage = AppController::load('brandJoinLanguage');
        $arr = $seoTpl->getItem($tpl_id, $language_id);
        $seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];
        $brand = $brandJoinLanguage->getItem($brand_id, $language_id);
        $replace[] = array("{brand_name}", $brand["base_name"]);
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
        $replace[] = array("{page}", $page);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
        $seo["title"] = ($brand["title"] == "") ? $seo["title"] : $brand["title"];
        $seo["keywords"] = ($brand["keywords"] == "") ? $seo["keywords"] : $brand["keywords"];
        $seo["descript"] = ($brand["descript"] == "") ? $seo["descript"] : $brand["descript"];
        return $seo;
    }

    public function getTagMeta($language_id, $tpl_id, $tag_id, $page)
    {
        global $cfg;
        $page = $page ? $page : 1;
        $seo = array();
        $seoTpl = AppController::load('SeoTplJoinLanguage');
        $goodsTagJoinLanguage = AppController::load('GoodsTagJoinLanguage');
        $arr = $seoTpl->getItem($tpl_id, $language_id);
        $seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];
        $tag = $goodsTagJoinLanguage->getItem($tag_id, $language_id);
        $replace[] = array("{tag_name}", $tag["base_name"]);
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
        $replace[] = array("{page}", $page);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
        $seo["title"] = ($tag["title"] == "") ? $seo["title"] : $tag["title"];
        $seo["keywords"] = ($tag["keywords"] == "") ? $seo["keywords"] : $tag["keywords"];
        $seo["descript"] = ($tag["descript"] == "") ? $seo["descript"] : $tag["descript"];
        return $seo;
    }

    public function getNarrowPageMeta($language_id, $tpl_id, $category_id, $brand_id, $tag_id, $property_id, $page)
    {
        global $cfg;
        $page = $page ? $page : 1;
        $seo = array();
        if ($category_id)
        {
            $goodsCategoryLogic = AppController::load('goodsCategoryJoinLang');
            $category = $goodsCategoryLogic->getOne("l.goods_category_id=" . $category_id . ' and l.language_id=' . $language_id);
            //$search[] = $category["base_name"];
        }

        $seoTpl = AppController::load('SeoTplJoinLanguage');
        $arr = $seoTpl->getItem($tpl_id, $language_id);
        $seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];

        foreach ($brand_id as $item_id)
        {
            $brandJoinLanguage = AppController::load('brandJoinLanguage');
            $brand = $brandJoinLanguage->getItem($item_id, $language_id);
            $search[] = $brand["base_name"];
        }
        foreach ($tag_id as $item_id)
        {
            $goodsTagJoinLanguage = AppController::load('GoodsTagJoinLanguage');
            $tag = $goodsTagJoinLanguage->getItem($item_id, $language_id);
            $search[] = $tag["base_name"];
        }
        if (count($property_id) > 0)
        {
            $propertyJoinLanguageLogic = AppController::load('propertyJoinLanguage');
            $cond = 'p.id in (' . implode(',', $property_id) . ') and p.status=1 and language_id='.$language_id;
            $properties = $propertyJoinLanguageLogic->findAll($cond);
            foreach ($properties as $value)
            {
                $search[] = $value["base_name"];
            }
        }
        $replace[] = array("{page}", $page);
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
		$replace[] = array("{category_name}", $category["base_name"]);
        foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
        foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[search split='(.*)'](.*)\[\/search\]/", $value, $matche))
            {
                foreach ($search as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
        return $seo;
    }

    public function getProductMeta($language_id, $tpl_id, $goods_id, $sku_code ="")
    {
        global $cfg;
        $page = $page ? $page : 1;
        $seo = array();
        $seoTpl = AppController::load('SeoTplJoinLanguage');
        $goodLanguageLogic = AppController::load('GoodsJoinLanguage');
        $brandLanguageLogic = AppController::load('BrandJoinLanguage');
        $goodsTagRel = AppController::load('GoodsTagRel');
        $goodsTagJoinLanguage = AppController::load('GoodsTagJoinLanguage');

        $goods_detail = $goodLanguageLogic->getDetailByGoodsId($goods_id, $language_id);
        $goods = $goods_detail['goods'];
        if ($goods['title'] || $goods['keywords'] || $goods['descript'])
        {
            $seo["title"] = $goods["title"] ? $goods['title'] : $goods['base_name'];
            $seo["keywords"] = $goods["keywords"];
            $seo["descript"] = $goods["descript"];
            return $seo;
        }
        $category_ids = $goods_detail['category_ids'];
        //取主分类id获取SEO模板id
       
        $replace = array();
        if ($goods["brand_id"])
        {
            $brand = $brandLanguageLogic->getItem($goods["brand_id"], $language_id);
        }
		
		if($sku_code)
		{
			$temp_sku_arr = split('_',$sku_code);
			$master_id = $temp_sku_arr[0] ;
			$slave_id = $temp_sku_arr[1] ;
			print_r();
			foreach ($goods_detail['propertylist']['sale'] as $value)
			{
				if($value['vid']==$master_id)
					$sku[] = $value["value_name"];
			}
			foreach ($goods_detail['propertylist']['sale'] as $value)
			{
				if($value['vid']==$slave_id)
					$sku[] = $value["value_name"];
			}

		}

        $propertys = $goods_detail['propertylist'];
        foreach ($propertys['sale'] as $value)
        {
            $property[] = $value["value_name"];
        }
        foreach ($propertys['common'] as $value)
        {
            foreach ($value['sun'] as $_v)
            {
                $property[] = $_v["value_name"];
            }
        }
        $property = array_unique($property);
        $taglist = $goodsTagRel->getTagList($goods_id);
        $tag_ids = array();
        foreach ($taglist as $value)
        {
            $tag_ids[] = $value['id'];
        }
        if (count($tag_ids) > 0)
        {
            $tags_array = $goodsTagJoinLanguage->getListByLanguageId($language_id);
            foreach ($tags_array as $key => $value)
            {
                if (in_array($key, $tag_ids))
                {
                    $tags[] = $value['base_name'];
                }
            }
        }
        $tags = array_unique($tags);

        
        $goodsCategoryJoinLanguageLogic = AppController::load('GoodsCategoryJoinLang');
        $all_category = $goodsCategoryJoinLanguageLogic->getAllByLanguageId($language_id);
        foreach ($all_category as $value)
        {
            if (in_array($value['id'], $category_ids))
            {
                $last_category[] = $value["base_name"];
            }
        }
		$goods_category_path = $goods['category_path'];
		$temp = split(',',$goods_category_path);
		$category_id = $temp[count($temp)-1];
		if($all_category[$category_id]['seo_goods_tpl_id'])
        {
            $tpl_id = $category['seo_tpl_id'];
        }
		
        $arr = $seoTpl->getItem($tpl_id, $language_id);
        $seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];
		
        $replace[] = array("{goods_name}", $goods["base_name"]);
		$replace[] = array("{goods_codeno}", $goods["codeno"]);
		$replace[] = array("{lcoin}", $_SESSION["symbol_left"]);
		if($_SESSION["symbol_left"]=="JPY")
			$replace[] = array("{goods_price}", (int)$goods["price"]);
		else
			$replace[] = array("{goods_price}",  Common::toolPrice($goods["price"]));
        $replace[] = array("{brand_name}", $brand["base_name"]);
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
        foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[category split='(.*)'](.*)\[\/category\]/", $value, $matche))
            {
                foreach ($last_category as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
        foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[property split='(.*)'](.*)\[\/property\]/", $value, $matche))
            {
                foreach ($property as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
        foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[path split='(.*)'](.*)\[\/path\]/", $value, $matche))
            {
                foreach ($category as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
        foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[tag split='(.*)'](.*)\[\/tag\]/", $value, $matche))
            {
                foreach ($tag as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
		foreach ($seo as $key => $value)
        {
            $arr_replace = array();
            if (preg_match("/\[sku split='(.*)'](.*)\[\/sku\]/", $value, $matche))
            {
                foreach ($sku as $value2)
                {
                    $arr_replace[] = str_replace("{VAR}", $value2, $matche[2]);
                }
                $str_replace = join($matche[1], $arr_replace);
                $seo[$key] = str_replace($matche[0], $str_replace, $seo[$key]);
            }
        }
        return $seo;
    }
    
	 public function getDealsMeta($language_id, $tpl_id, $deals_id, $page)
    {
        global $cfg;
        $page = $page ? $page : 1;
        $seo = array();
		$deals_id = (int)$deals_id ;
		$seoTpl = AppController::load('SeoTplJoinLanguage');
        $arr = $seoTpl->getItem($tpl_id, $language_id);
		$seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];
		
        $logic = AppController::load('SpecialOffer');
        $row = $logic->getOneById($deals_id);
		$row['base_name'] = $row['base_name']? $row['base_name']:"Deals";
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        $replace[] = array("{deals_name}", $row['base_name']);
		$replace[] = array("{page}", $page);
		foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
        return $seo;
    }
	
	public function getSearchMeta($language_id, $tpl_id, $param, $page)
    {
        global $cfg;
        $page = $page ? $page : 1;
        $seo = array();
		$seoTpl = AppController::load('SeoTplJoinLanguage');
        $arr = $seoTpl->getItem($tpl_id, $language_id);
		$seo["title"] = $arr["title"];
        $seo["keywords"] = $arr["keywords"];
        $seo["descript"] = $arr["descript"];
		
        if($param['category_id'])
		{
			$goodsCategoryLogic = AppController::load('goodsCategoryJoinLang');
			$category = $goodsCategoryLogic->getOne("l.goods_category_id=" . $param['category_id'] . ' and l.language_id=' . $language_id);
		}
        $replace[] = array("{shop_name}", $cfg['sites'][$language_id]['shop_name']);
		$replace[] = array("{domain}", $_SERVER['SERVER_NAME']);
        $replace[] = array("{search_name}", $param['keywords']);
		$replace[] = array("{category_name}", $category['base_name']);
		$replace[] = array("{page}", $page);
		foreach ($replace as $value)
        {
            $seo["title"] = str_replace($value[0], $value[1], $seo["title"]);
            $seo["keywords"] = str_replace($value[0], $value[1], $seo["keywords"]);
            $seo["descript"] = str_replace($value[0], $value[1], $seo["descript"]);
        }
        return $seo;
    }
    
    private function getCategorySeoId($categories,$id)
    {
        if($categories[$id]['seo_tpl_id'])
        {
            return $categories[$id]['seo_tpl_id'];
        }
        else if($categories[$id]['parent_id'])
        {
            return $this->getCategoryGoodsSeoId($categories,$categories[$id]['parent_id']);
        }
        else
        {
            return 0;
        }
    }
    
    private function getCategoryGoodsSeoId($categories,$id)
    {
        if($categories[$id]['seo_goods_tpl_id'])
        {
            return $categories[$id]['seo_goods_tpl_id'];
        }
        else if($categories[$id]['parent_id'])
        {
            return $this->getCategoryGoodsSeoId($categories,$categories[$id]['parent_id']);
        }
        else
        {
            return 0;
        }
    }
}

?>