<?php

/**
 * Description of UrlalisaLogic
 *
 * @author HHH
 */
class UrlAlisaLogic extends BaseLogic
{

    public function __construct() 
    {
        parent::__construct();
        $this->table = 'UrlAliasTable'; 
    }
    
    /**
     * 获得所有url别名信息
     */
    public function getAllUrlalisa($where = 'ORDER BY id DESC'){
        $urlAlisa = $this->getList($where);
        return  $urlAlisa['list'];
    }
    
    /**
     * 获得单个url别名信息
     */
    public function getUrlalisa($id){
        if(!empty($id)){
             $where = 'id = ' . $id;
             $urlAlisa = $this->getOne($where);
             return $urlAlisa;
        }
        return false;
    }
    /**
     * 创建一个自定义URL
     * @param type $url
     * @param type $route
     * @param type $is_dir 
     */
    public function createDiyUrl($url, $route, $is_dir=FALSE)
    {
      $url = str_replace(array('?', '&', '%'), '-', $url);
      $limit_count = substr_count($url, '.');
      if($url && !preg_match("/^[(a-z)(A-Z)(0-9)(\/)(\_)(\-)(\.)]+$/", $url))
      {
            return false;
      }
      if($limit_count>1)
      {
          return false;
      }
      $cond2 = 'route = "' . $route . '"';
      if(!$url)
      {
        return $this->delete($cond2);
      }
      $urll_md5 = md5(strtolower($url));
      if($is_dir)
      {
        if(substr($url, strlen($url)-1) != '/')
        {
          $url = strtolower($url.'/');
          $urll_md5 = md5($url);
        }
      }
      else if(strpos($url, '.html') === FALSE && strpos($url, '.htm') === FALSE)
      {
        return false;
      }
      $cond   = "url_md5 = '" . $urll_md5 . "'";
      $diy_url = $this->getOne($cond);
      if($diy_url && $diy_url['route'] != $route)
      {
        return false;
      }
      $map = Zhtx::createDataMap();
      $map->addEntry('route', $route, DB::VARCHAR);
      $map->addEntry('url', Common::strEscape($url), DB::VARCHAR);
      $map->addEntry('url_md5', $urll_md5, DB::VARCHAR);
      $is_exist = $this->getOne($cond2);
      if($is_exist)
      {
        return $this->update($map, $cond2);
      }
      else
      {
        return $this->insert($map);
      }
    }
    
    public function deleteDiyUrl($url)
    {
      $cond   = "url = '" . $url . "'";
      $diy_url = $this->getOne($cond);
      if($diy_url)
      {
        return $this->delete($cond);
      }
      return false;
    }
}

?>
