<?php

/**
 * Description of UrlalisaLogic
 *
 * @author CYM
 */
class UrlMakerLogic extends BaseLogic {

    public function __construct() {
        parent::__construct();
    }

    /** 基准语言或者语种语言
     * 0 用基准语言
     * 1 用html作为前缀
     * 2
     * 3 分级目录形式
     * 4 目录/数字模式 product/23.html
     */
    public function getProductUrl($id, $product_id, $language_id, $rewrite, $res = array()) {
        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        if (!$res) {
            $goodsLogic = AppController::load('GoodsJoinLanguage');
            $res = $goodsLogic->getItem($id, $language_id, false);
        }
        if ($rewrite_name_type == "")
            $res["rewrite_name"] = $res["default_base_name"];
        else
            $res["rewrite_name"] = $res["base_name"];
        if ($res["page_url"])
            return FOLDER_ROOT . $res["page_url"];
        switch ($rewrite_type) {
            case 0:
                return FOLDER_ROOT . Common::makeUrlName($res["rewrite_name"]) . "-p" . $id . ".html";
                break;
            case 1:
                return FOLDER_ROOT . "html-p" . $id . ".html";
                break;
            case 2:
                return FOLDER_ROOT . "product/" . $id . ".html";
                break;
        }
    }

    public function getCommentUrl($id, $language_id, $rewrite, $page = 1, $res = array()) {
        if ($id) {
            return FOLDER_ROOT . "Comment/p" . $id . "/list-r" . $page . ".html";
        } else {
            return FOLDER_ROOT . "Comment/list-r" . $page . ".html";
        }
    }

    public function getBrandUrl($id, $language_id, $rewrite, $page = "", $res = array()) {
        if (is_array($id)) {
            $id = $id[0];
        }
        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        if ($page)
            $string_page = "-" . $page;
        if (!$res) {
            $brandLogic = AppController::load('brandJoinLanguage');
            $res = $brandLogic->getItem($id, $language_id, false);
        }
        if ($rewrite_name_type == "")
            $res["rewrite_name"] = $res["default_base_name"];
        else
            $res["rewrite_name"] = $res["base_name"];
        $page_url = $res["page_url"];
        if ($page_url) {

            if (substr($page_url, strlen($page_url) - 1) != '/') {
                $page_url = $page_url . '/';
            }
            if ($page)
                return FOLDER_ROOT . $page_url . "p" . $page . ".html";
            else
                return FOLDER_ROOT . $page_url;
        }
        switch ($rewrite_type) {
            case 0:
                return FOLDER_ROOT . Common::makeUrlName($res["rewrite_name"]) . "-b" . $id . $string_page . ".html";
                break;
            case 1:
                return FOLDER_ROOT . "html-b" . $id . $string_page . ".html";
                break;
            case 2:
                return FOLDER_ROOT . "brand/" . $id . $string_page . ".html";
                break;
        }
    }

    public function getCategoryUrl($id, $language_id, $rewrite, $page = "", $res = array()) {
        $rewrite_type = $rewrite["type"];
        if ($page == 1) {
            // $rewrite_type = 3;
        }
        $rewrite_name_type = $rewrite["name_type"];
        if ($page)
            $string_page = "-" . $page;
        if (!$res) {
            $categoryLogic = AppController::load('GoodsCategoryJoinLang');
            $res = $categoryLogic->getItem($id, $language_id, false);
        }
        if ($rewrite_name_type == "")
            $res["rewrite_name"] = $res["default_base_name"];
        else
            $res["rewrite_name"] = $res["base_name"];
        $page_url = $res["page_url"];
        if ($page_url) {

            if (substr($page_url, strlen($page_url) - 1) != '/') {
                //$page_url = $page_url.'/';
            }
            if ($page) {
                if (substr($page_url, strlen($page_url) - 1) == '/')
                    return FOLDER_ROOT . $page_url . "p" . $page . ".html";
                else
                    return FOLDER_ROOT . $page_url . "/p" . $page . ".html";
            } else
                return FOLDER_ROOT . $page_url;
        }
        $keywords = _g('keywords');

        switch ($rewrite_type) {
            case -1:
                return FOLDER_ROOT . "index.php?m=home&c=product&a=list&category_id=" . $id . "&page=" . $page;
                break;
            case 0:
                return FOLDER_ROOT . Common::makeUrlName($res["rewrite_name"]) . "-c" . $id . $string_page . ".html";
                break;
            case 1:
                return FOLDER_ROOT . "html-c" . $id . $string_page . ".html";
                break;
            case 2:
                return FOLDER_ROOT . "category/" . $id . $string_page . ".html";
                break;
            case 3:
                return FOLDER_ROOT . Common::makeUrlName($res["rewrite_name"]) . "-c" . $id . ".html";
                break;
        }
    }

    public function getMCategoryUrl($id, $language_id, $rewrite, $page = "", $res = array()) {
        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        if ($page)
            $string_page = "-" . $page;
        if (!$res) {
            $categoryLogic = AppController::load('GoodsCategoryJoinLang');
            $res = $categoryLogic->getItem($id, $language_id, false);
        }
        if ($rewrite_name_type == "")
            $res["rewrite_name"] = $res["default_base_name"];
        else
            $res["rewrite_name"] = $res["base_name"];
        $page_url = $res["page_url"];
        if ($page_url) {

            if (substr($page_url, strlen($page_url) - 1) != '/') {
                $page_url = $page_url . '/';
            }
            if ($page)
                return FOLDER_ROOT . $page_url . "p" . $page . ".html";
            else
                return FOLDER_ROOT . $page_url;
        }
        switch ($rewrite_type) {
            case -1:
                return FOLDER_ROOT . "index.php?m=wap&c=product&a=list&category_id=" . $id . "&page=" . $page;
                break;
            case 0:
                return FOLDER_ROOT . 'm-' . Common::makeUrlName($res["rewrite_name"]) . "-c" . $id . $string_page . ".html";
                break;
            case 1:
                return FOLDER_ROOT . "m-html-c" . $id . $string_page . ".html";
                break;
            case 2:
                return FOLDER_ROOT . "m/category/" . $id . $string_page . ".html";
                break;
        }
    }

    public function getNavPageUrl($id, $language_id, $rewrite, $res = array()) {
        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        if (!$res) {
            $navPageLogic = AppController::load('NavPageJoinLanguage');
            $res = $navPageLogic->getItem($id, $language_id, false);
        }
        if ($rewrite_name_type == "")
            $res["rewrite_name"] = $res["default_base_name"];
        else
            $res["rewrite_name"] = $res["base_name"];
        if ($res["page_url"])
            return FOLDER_ROOT . $res["page_url"];

        switch ($rewrite_type) {
            case 0:
                return FOLDER_ROOT . "page/" . $id . ".html";
                break;
            case 1:
                return FOLDER_ROOT . "page/" . $id . ".html";
                break;
            case 2:
                return FOLDER_ROOT . "page/" . $id . ".html";
                break;
        }
    }

    public function getTagUrl($id, $language_id, $rewrite, $page = "", $res = array()) {
        if (is_array($id)) {
            $id = $id[0];
        }
        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        if ($page)
            $string_page = "-" . $page;
        if (!$res) {
            $tagLogic = AppController::load('GoodsTagJoinLanguage');
            $res = $tagLogic->getItem($id, $language_id, false);
        }
        if ($rewrite_name_type == "")
            $res["rewrite_name"] = $res["default_base_name"];
        else
            $res["rewrite_name"] = $res["base_name"];
        $page_url = $res["page_url"];
        if ($page_url) {

            if (substr($page_url, strlen($page_url) - 1) != '/') {
                $page_url = $page_url . '/';
            }
            if ($page)
                return FOLDER_ROOT . $page_url . "p" . $page . ".html";
            else
                return FOLDER_ROOT . $page_url;
        }
        switch ($rewrite_type) {
            case 0:
                return FOLDER_ROOT . Common::makeUrlName($res["rewrite_name"]) . "-t" . $id . $string_page . ".html";
                break;
            case 1:
                return FOLDER_ROOT . "html-t" . $id . $string_page . ".html";
                break;
            case 2:
                return FOLDER_ROOT . "tag/" . $id . $string_page . ".html";
                break;
        }
    }

    public function getArticleUrl($id, $language_id, $rewrite, $res = array()) {
        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        if (!$res) {
            $articleLogic = AppController::load('articleJoinLanguage');
            $res = $articleLogic->getItem($id, $language_id, false);
        }
        if ($rewrite_name_type == "")
            $res["rewrite_name"] = $res["default_base_name"];
        else
            $res["rewrite_name"] = $res["base_name"];
        if ($res["page_url"])
            return FOLDER_ROOT . $res["page_url"];
        switch ($rewrite_type) {
            case 0:
                return FOLDER_ROOT . Common::makeUrlName($res["rewrite_name"]) . "-n" . $id . ".html";
                break;
            case 1:
                return FOLDER_ROOT . "html-n" . $id . $string_page . ".html";
                break;
            case 2:
                return FOLDER_ROOT . "article/" . $id . $string_page . ".html";
                break;
        }
    }

    public function getArticleCategoryUrl($id, $language_id, $rewrite, $page = "", $res = array()) {
        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        if ($page)
            $string_page = "-" . $page;
        if (!$res) {
            $articlecategoryLogic = AppController::load('articleCategoryJoinLanguage');
            $res = $articlecategoryLogic->getItem($id, $language_id, false);
        }
        if (!$res) {
            $res['default_base_name'] = "article";
            $res['base_name'] = "article";
        }
        if ($rewrite_name_type == "")
            $res["rewrite_name"] = $res["default_base_name"];
        else
            $res["rewrite_name"] = $res["base_name"];
        $page_url = $res["page_url"];
        if ($page_url) {

            if (substr($page_url, strlen($page_url) - 1) != '/') {
                $page_url = $page_url . '/';
            }
            if ($page)
                return FOLDER_ROOT . $page_url . "p" . $page . ".html";
            else
                return FOLDER_ROOT . $page_url;
        }
        switch ($rewrite_type) {
            case 0:
                return FOLDER_ROOT . "article-nc" . $id . $string_page . ".html";
                break;
            case 1:
                return FOLDER_ROOT . "article-nc" . $id . $string_page . ".html";
                break;
            case 2:
                return FOLDER_ROOT . "article-nc" . $id . $string_page . ".html";
                break;
        }
    }

    public function getNarrowPageUrl($param, $language_id, $page, $rewrite, $paramRes = array()) {
        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        $url = FOLDER_ROOT . "Narrow/";
        if ($param["category_id"]) {
            $url .= "c" . $param["category_id"] . "/";
        }

        foreach ($param["brand_id"] as $value) {
            $url .= "b" . $value . "/";
        }

        foreach ($param["tag_id"] as $value) {
            $url .= "t" . $value . "/";
        }
        foreach ($param["property_id"] as $value) {
            $url .= "p" . $value . "/";
        }
        $url .= "list-" . $param["oquery"] . "r" . $page . ".html";
        return $url;
    }

    public function getNarrowPanelUrl($id, $id_type, $param, $language_id, $page, $rewrite) {

        $rewrite_type = $rewrite["type"];
        $rewrite_name_type = $rewrite["name_type"];
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Narrow/";
        if ($param["category_id"]) {
            $url .= "c" . $param["category_id"] . "/";
        }

        $brand_id = $param["brand_id"];
        if ($id_type == "brand_id") {
            if (!$param["bcancel"]) {
                $b_list[] = $id;
                foreach ($brand_id as $key => $value) {
                    if ($id != $value) {
                        $b_list[] = $value;
                    }
                }
                $temp = array();
                foreach ($b_list as $item) {
                    $tem_rows = array();
                    $tem_rows["id"] = $item;
                    $tem_rows["listorder"] = $param["res"][$item]["listorder"];
                    $temp[] = $tem_rows;
                }
                Common::sort_rows($temp, "listorder", SORT_ASC);
                $b_list = array();
                foreach ($temp as $item) {
                    if ($id != 0) {
                        $b_list[] = $item["id"];
                    }
                }
            } else {
                $b_list[] = $id;
                foreach ($brand_id as $key => $value) {
                    if ($id != $value) {
                        $b_list[] = $value;
                    }
                }
                $temp = array();
                foreach ($b_list as $item) {
                    $tem_rows = array();
                    $tem_rows["id"] = $item;
                    $tem_rows["listorder"] = $param["res"][$item]["listorder"];
                    $temp[] = $tem_rows;
                }
                Common::sort_rows($temp, "listorder", SORT_ASC);
                $b_list = array();
                foreach ($temp as $item) {
                    if ($param["bcancel"] != $item['id'] && $id != 0) {
                        $b_list[] = $item["id"];
                    }
                }
            }
        } else {
            $b_list = $brand_id;
        }
        foreach ($b_list as $value) {
            $url .= "b" . $value . "/";
        }


        $tag_id = $param["tag_id"];
        if ($id_type == "tag_id") {

            if (!$param["tcancel"]) {
                $t_list[] = $id;
                foreach ($tag_id as $key => $value) {
                    if ($id != $value) {
                        $t_list[] = $value;
                    }
                }
                $temp = array();
                foreach ($t_list as $item) {
                    $tem_rows = array();
                    $tem_rows["id"] = $item;
                    $tem_rows["listorder"] = $param["res"][$item]["listorder"];
                    $temp[] = $tem_rows;
                }
                Common::sort_rows($temp, "listorder", SORT_ASC);
                $t_list = array();
                foreach ($temp as $item) {
                    if ($id != 0) {
                        $t_list[] = $item["id"];
                    }
                }
            } else {
                $t_list[] = $id;
                foreach ($tag_id as $key => $value) {
                    if ($id != $value) {
                        $t_list[] = $value;
                    }
                }
                $temp = array();
                foreach ($t_list as $item) {
                    $tem_rows = array();
                    $tem_rows["id"] = $item;
                    $tem_rows["listorder"] = $param["res"][$item]["listorder"];
                    $temp[] = $tem_rows;
                }
                Common::sort_rows($temp, "listorder", SORT_ASC);
                $t_list = array();
                foreach ($temp as $item) {
                    if ($param["tcancel"] != $item['id'] && $id != 0) {
                        $t_list[] = $item["id"];
                    }
                }
            }
        } else {
            $t_list = $tag_id;
        }
        foreach ($t_list as $value) {
            $url .= "t" . $value . "/";
        }

        if ($id_type == "property_id") {
            $property_type = $param["res"];
            foreach ($property_type['parents'] as $key => $value) {
                foreach ($property_type['childs'][$value['id']] as $key1 => $value1) {
                    $pdata[$value1['id']] = array("parent_id" => $value['id'], "listorder" => $value['listorder']);
                }
            }
            $property_id = $param["property_id"];
            if ($param["pcancel"]) {
                foreach ($property_id as $key => $value) {
                    if ((int) $id == (int) $pdata[$value]['parent_id']) {
                        continue;
                    }
                    if ($param["pcancel"] != $value) {
                        $pro_list[] = $value;
                    }
                }
            } else {

                $p_list[] = $id;
                foreach ($property_id as $key => $value) {
                    // if ($pdata[$id]["parent_id"] != $pdata[$value]["parent_id"])
                    // {
                    //$p_list[] = $value;
                    // }
                    if ($id != $value) {
                        $p_list[] = $value;
                    }
                }
                // 排列顺序
                $temp = array();
                foreach ($p_list as $item) {
                    $tem_rows = array();
                    $tem_rows["id"] = $item;
                    $tem_rows["listorder"] = $pdata[$item]["listorder"];
                    $temp[] = $tem_rows;
                }
                Common::sort_rows($temp, "listorder", SORT_ASC);
                $p_list = array();
                foreach ($temp as $item) {
                    $pro_list[] = $item["id"];
                }
            }
        } else {
            $pro_list = $param["property_id"];
        }
        foreach ($pro_list as $value) {
            $url .= "p" . $value . "/";
        }
        if ($id_type == "oquery") {
            $oquery = "";
            if ($param["oquery"] == "")
                $arr = array_fill(0, 8, "");
            else {
                $arr = split('-', $param["oquery"]);
                array_pop($arr);
            }

            if ($param["oq_value"]) {
                $oq_value = $param["oq_value"];
            } else {
                $oq_value = "";
            }
            $arr[$param["oq_index"]] = $oq_value;
            $arr[3] = $param['oq_index_3'] ? $param['oq_index_3'] : 1;

            $oquery = join('-', $arr) . "-";
        } else {
            $oquery = $param["oquery"];
        }
        $url .= "list-" . $oquery . "r" . $page . ".html";
        return $url;
    }

    public function getNewPageUrl($rewrite, $page) {
        $rewrite_type = $rewrite['type'];
        switch ($rewrite_type) {
            case -1:
                return FOLDER_ROOT . "index.php?m=home&c=article&a=list&page=" . $page;
                break;
            default :
                return FOLDER_ROOT . "h-article-list-p" . $page . ".html";
                break;
        }
    }

    public function getSearchPageUrl($param, $page, $rewrite) {
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Search/";
        $url .= urlencode($param['keywords']) . "/";
        if ($param["category_id"]) {
            $url .= "c" . $param["category_id"] . "/";
        }
        $url .= "list-" . $param["oquery"] . "r" . $page . ".html";
        return $url;
    }

    public function getDealsUrl($param, $page, $rewrite) {
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Deals/";
        if ($param["offer_id"]) {
            $url .= "c" . $param["offer_id"] . "/";
        }
        $url .= "list-" . $param["oquery"] . "r" . $page . ".html";
        return $url;
    }

    public function getAllPoductUrl($param, $page, $rewrite) {
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Products/";
        $url .= "list-" . $param["oquery"] . "r" . $page . ".html";
        return $url;
    }

    public function getAllProductPanelUrl($param, $page, $rewrite) {
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Products/";
        $oquery = "";
        if ($param["oquery"] == "")
            $arr = array_fill(0, 8, "");
        else {
            $arr = split('-', $param["oquery"]);
            array_pop($arr);
        }
        $oq_value = $param["oq_value"] == 0 ? "" : $param["oq_value"];
        $arr[$param["oq_index"]] = $oq_value;
        $arr[3] = $param['oq_index_3'] ? $param['oq_index_3'] : 1;
        $oquery = join('-', $arr) . "-";
        $url .= "list-" . $oquery . "r" . $page . ".html";
        return $url;
    }

    public function getDealsPanelUrl($param, $page, $rewrite) {
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Deals/";
        if ($param["offer_id"]) {
            $url .= "c" . $param["offer_id"] . "/";
        }
        $oquery = "";
        if ($param["oquery"] == "")
            $arr = array_fill(0, 8, "");
        else {
            $arr = split('-', $param["oquery"]);
            array_pop($arr);
        }
        $oq_value = $param["oq_value"] == 0 ? "" : $param["oq_value"];
        $arr[$param["oq_index"]] = $oq_value;
        $arr[3] = $param['oq_index_3'] ? $param['oq_index_3'] : 1;
        $oquery = join('-', $arr) . "-";
        $url .= "list-" . $oquery . "r" . $page . ".html";
        return $url;
    }

    public function getDailyUrl($param, $page, $rewrite) {
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Daily/";
        if ($param["create_time"]) {
            $url .= "" . $param["create_time"] . "/";
        }
        $url .= "list-" . $param["oquery"] . "r" . $page . ".html";
        return $url;
    }

    public function getDailyPanelUrl($param, $page, $rewrite) {
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Daily/";
        if ($param["create_time"]) {
            $url .= "" . $param["create_time"] . "/";
        }
        $oquery = "";
        if ($param["oquery"] == "")
            $arr = array_fill(0, 8, "");
        else {
            $arr = split('-', $param["oquery"]);
            array_pop($arr);
        }
        $oq_value = $param["oq_value"] == 0 ? "" : $param["oq_value"];
        $arr[$param["oq_index"]] = $oq_value;
        $arr[3] = $param['oq_index_3'] ? $param['oq_index_3'] : 1;
        $oquery = join('-', $arr) . "-";
        $url .= "list-" . $oquery . "r" . $page . ".html";
        return $url;
    }

    public function getSearchFunctionPanelUrl($param, $page, $rewrite) {
        $page = $page == "" ? 1 : $page;
        $url = FOLDER_ROOT . "Search/";
        $url .= urlencode($param['keywords']) . "/";
        if ($param["category_id"]) {
            $url .= "c" . $param["category_id"] . "/";
        }
        $oquery = "";
        if ($param["oquery"] == "")
            $arr = array_fill(0, 8, "");
        else {
            $arr = split('-', $param["oquery"]);
            array_pop($arr);
        }
        $oq_value = $param["oq_value"] == 0 ? "" : $param["oq_value"];
        $arr[$param["oq_index"]] = $oq_value;
        $arr[3] = $param['oq_index_3'] ? $param['oq_index_3'] : 1;
        $oquery = join('-', $arr) . "-";
        $url .= "list-" . $oquery . "r" . $page . ".html";
        return $url;
    }

}

?>