<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of UserCartLogic
 *
 * @author xrx
 */
class UserCartLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'UserCartTable';
    }
    public function save($data, $id)
    {
        $map = Zhtx::createDataMap();
        $map->createEntry($data);
        if($id)
        {
            return $this->update($map, 'id='.$id);
        }
        else
        {
            return $this->insert($map);
        }
    }
    public function getOneByUserId($user_id, $goods_id, $sku_code)
    {
        $cond = 'user_id =' . $user_id . ' and goods_id=' . $goods_id . ' and sku_code ="'. $sku_code . '"';
        return $this->getOne($cond);
    }
    public function getListByUserId($user_id)
    {
        $cond = 'user_id = '. $user_id ;
        $result = $this->getList($cond);
        return $result['list'];
    }
    /**
     * 更新购物车缓存
     * @param int $user_id
     * @param type $language_id 
     */
    public function clearCartCache($user_id, $language_id)
    {
      $cache_type   = 'goods_list';
      $cart_session = Common::queryStr(_s('cart_cache'), _c('PHPSESSID'));;
      if(!$user_id)$user_id=0;
      $key = $user_id . '_' . $language_id . '_' . $cart_session . '_cart_cache';
      return _delcahce($key, '', $cache_type);
    }
    public function clearCart($user_id, $language_id)
    {
      $this->clearCartCache($user_id, $language_id);
      if($user_id)
      {
        $del_cart_cond = 'user_id=' . $user_id;
        $this->delete($del_cart_cond);
      }
      setcookie('product_promotion', '');
      setcookie('gift_promotion', '');
      setcookie('cart_promotion', '');
      setcookie('cart_coupon', '');
      setcookie('cartsku', '');
      _setSession('product_promotion', '');
      _setSession('gift_promotion', '');
      _setSession('cart_promotion', '');
      _setSession('cart_coupon', '');
      return true;
    }
   
    public function addToCart($goods_id, $sale_id, $master_sale_id, $qty)
    {
        $this->skuLogic = $this->load('sku');
        $this->skuProductLangLogic = $this->load('skuProductLanguage');
        $this->languageLogic = $this->load('language');
        $this->goodsProRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $this->cartJoinSkuLogic = $this->load('cartJoinSku');
        $this->goodsLangLogic = $this->load('goodsJoinLanguage');
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $msg = '';
        $status = 0;
        $offset = $qty;
        $user_id = AppController::checkLogin(); //用户ID；           
        $sku_code = $master_sale_id . '_' . $sale_id;
        $sku = $this->skuLogic->getOneByCode($goods_id, $sku_code, 1);
        $language_id = $this->languageLogic->language_id;   
        $goods = $this->goodsLangLogic->getOne('l.goods_id='.$goods_id.' and g.status=1 and l.status=1');
        if(!$goods)
        {
            $msg = $lang['add_failure'];
        }
        else if (!$sku)
        {
            //提示信息
            $msg = $lang['please_select_property'];
        }
        else
        {
            $cart_promotion = Common::queryInt(_c('cart_promotion'));
            $cart_counpon = _c('cart_coupon');
            $cartInfo = $this->cartJoinSkuLogic->getCartPrice($user_id, json_decode(_c('product_promotion'), true), json_decode(_c('gift_promotion'), true), $language_id, $cart_promotion, $cart_counpon);
            $cart_data = array(
                'goods_id' => $goods_id,
                'sku_code' => $sku['sku_code'],
                'product_num' => $qty,
                'user_id' => $user_id ? $user_id : 0,
                'create_time' => SYS_TIME,
            );
            if ($qty > $sku['stock_nums'])
            {
                //缺货的提示
                $msg = $lang['not_enough_stock'];
            }
            else
            {
                if ($user_id)
                {
                    $cart_cond = 'user_id=' . $user_id . ' and goods_id =' . $goods_id . ' and sku_code="' . $sku['sku_code'] . '"';
                    $cart = $this->getOne($cart_cond);
                    $cart_id = 0;
                    if ($cart)
                    {
                        $cart_id = $cart['id'];
                        //$offset = $qty - $cart['product_num'];
                        $cart_data['product_num'] = $cart_data['product_num']+$cart['product_num'];
                    }
                    
                    if ($cart_data['product_num'] > $sku['stock_nums'])
                    {
                        //缺货的提示
                        $status = 0;
                        $msg = $lang['not_enough_stock'];
                    }
                    else
                    {
                        $res = $this->save($cart_data, $cart_id);
                        if ($res)
                        {
                            setcookie('cartsku', '', time() + 30, '/');
                            $status = 1;
                            $msg = $lang['add_success'];
                        }
                        else
                        {
                            $status = 0;
                            $msg = $lang['add_failure'];
                        }
                    }
                }
                else
                {
                    if($cartInfo['totalqty']>=20)
                    {
                        $return = array(
                            'status' => 0,
                            'msg' => $lang['cookie_character_limit'],
                        );
                        return $return;
                    }
                    $cartSku = _c('cartsku') ? json_decode(_c('cartsku')) : array();
                    $exist_cart = FALSE;
                    $add_cartSku = array();
                    $allows_add = true;
                    foreach ($cartSku as $cart)
                    {
                        if ($cart->goods_id == $goods_id && $cart->sku_code == $sku_code)
                        {
                            //$offset = $qty - intval($cart->product_num);
                            $cart->product_num = $qty+intval($cart->product_num);
                            
                            if ($cart->product_num > $sku['stock_nums'])
                            {
                                //缺货的提示
                                $msg = $lang['not_enough_stock'];
                                $status = 0;
                                $allows_add = false;
                                break;
                            }
                            $exist_cart = TRUE;
                        }
                    }
                    if($allows_add)
                    {
                        if (!$exist_cart)
                        {
                            $cartSku[] = $cart_data;
                            $add_cartSku = $cart_data;
                        }
                        $flag = setcookie('cartsku', json_encode($cartSku), time() + 7 * 86400, '/');
                        if ($flag)
                        {
                            $status = 1;
                            $msg = $lang['add_success'];
                        }
                        else
                        {
                            $status = 0;
                            $msg = $lang['cookie_character_limit'];
                        }
                    }
                }
                //报表数据采集
                if ($offset)
                {
                    $country_id = $this->load('ipJoinCountry')->getCountryId(Common::_ip2long(Common::ip()));
                    ReportFactory::goodsReportAndGoodsLanguageReport($goods_id, $language_id, $country_id, array('cart_counts' => $offset));
                    if ($user_id)
                    {
                        ReportFactory::userSalesReport($user_id, array('cart_counts' => $offset));
                    }
                }
            }
        }
        $total_qty = 0;
        $total_price = 0;
        if ($status == 1)
        {
            $total_qty = $cartInfo['totalqty'] + $offset;
            $price = AppController::toolPrice($sku['price']);
            $price = $price ? $price : $goods['price'];
            $total_price = $cartInfo['totalprice'] + $offset * $price;
        }
        $return = array(
            'status' => $status,
            'msg' => $msg,
            'offset' => $offset,
            'price' => $price,
            'add_cartSku' => $add_cartSku,
            'totalqty' => $total_qty,
            'totalprice' => $total_price,
        );
        return $return;
    }
    
}


?>
