<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of UserGroupLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class UserGroupLogic extends BaseLogic
{
  public function __construct()
  {
    parent::__construct();
    $this->table = 'UserGroupTable';
    $this->cache_type = 'user_group';
  }
   public function save($data, $primary = 0)
  {
    $map = Zhtx::createDataMap();
    $map->createEntry($data);
    if($primary)
    {
      return $this->updateById($map, $primary);
    }
    else
    {
      return $this->insert($map);
    }
  }
  public function getAll($get_cache = true)
  {
      global $data_cache_dir;       
      $key = "user_group_list"; //缓存key        
      $chk = _chkcahce($key, $this->cache_type, TRUE);
      if (!$get_cache || !$chk )
      {  
          $chk  = $this->findAll('', TRUE);
          _setcahce($key, $chk, $this->cache_type);
      }                       
      return $chk;
  }
   public function updateCache()
    {
      global $data_cache_dir;
      $key = "user_group_list";
      _delcahce($key, '', $this->cache_type);     
    }
    public function updateUserGroupId($user, $growth_value, $add=TRUE)
    {
      $cur_growth = $user['growth'] + ($growth_value);
      if(!$add)
      {
        $cur_growth = $user['growth'] - ($growth_value);
      }      
      $res_group_id = $user['user_group_id'];
      foreach ($this->getAll() as $key => $value)
      {
        if ($cur_growth >= $value['min_growth'] && ($value['max_growth'] == 0 || $cur_growth < $value['max_growth']))
        {
          $res_group_id = $key;
          break;
        }
      }
      $map = Zhtx::createDataMap();
      $map->addEntry('growth', $cur_growth, DB::INT);
      $map->addEntry('user_group_id', $res_group_id, DB::INT);
      $map->addEntry('update_time', SYS_TIME, DB::INT);
      $this->load('user')->updateById($map, $user['id']);
    }
    public function getDefaultGroupId()
    {
        $default_group_id = 0;
        foreach ($this->getAll() as $key => $value)
        {
            if ($value['is_default'] == 1)
            {
                $default_group_id = $key;
            }
        }
        return $default_group_id;
    }
}

?>
