<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of UserLogic
 *
 * @author xrx
 */
class UserLogic extends BaseLogic
{
    public function __construct()
    {
        parent::__construct();
        $this->table = 'UserTable';
    }
    public function save($data, $id = 0)
    {
        $map = Zhtx::createDataMap();
        $map->createEntry($data);       
        if($id)
        {
            $result = $this->update($map, 'id='.$id);
        }
        else
        {
            $result = $this->insert($map);
        }
        return $result;
    }
    public function isExistName($name)
    {
        $cond = 'base_name ="'. $name . '"';
        $count = $this->getCount($cond);
        return $count > 0 ? TRUE : FALSE;
    }
    public function login($name, $password,$ismd5=false)
    {
        if($ismd5)
        {
            $cond = 'status=1 and base_name="'. $name . '" and password = "' . $password . '"';
        }
        else
        {
            $cond = 'status=1 and base_name="'. $name . '" and password = "' . md5(md5($password)) . '"';
        }
        $user = $this->getOne($cond);
        if($user)
        {
            _setSession('user_id', $user['id']);
            _setSession('user_base_name',  $user['base_name']);
            _setSession('user_sign', md5(md5($user['base_name'].$user['id'])));
            _setSession('user_group', $user['user_group_id']);
            setcookie('user_id', $user['id'], 0, '/');
            setcookie('user_base_name', $user['base_name'], time() + 86400*7, '/');
            setcookie('user_sign', md5(md5($user['base_name'].$user['id'])), 0, '/');
            setcookie('user_group', $user['user_group_id'], 0, '/');
            $user_data = array(        
                'update_time' => SYS_TIME,
            );
            $this->save($user_data,$user['id']);
        }
        return $user;
    }
    public function isExistEmail($security_email)
    {
        $cond  = 'security_email ="'. $security_email . '"';
        $count = $this->getCount($cond);
        return $count > 0 ? TRUE : FALSE;
    }
    
    /**
     * 检查cookie是有购物车产品 
     */
    public function _checkCookieCart($user_id)
    {
        $cartSku    = _c('cartsku') ? json_decode(_c('cartsku')) : array();
        $cartLogic  = $this->load('userCart');
        $exist_cart = $cartLogic->getListByUserId($user_id);
        $offset     = 0;
        $language_id = $this->load('language')->language_id;
        foreach ($cartSku as $value)
        {
            $is_exist = FALSE;
            foreach ($exist_cart as $cart)
            {
                if($value->goods_id == $cart['goods_id'] && $value->sku_code == $cart['sku_code'])
                {                   
                    if(intval($value->product_num) > intval($cart['product_num']))
                    {
                        $result = $cartLogic->save(array('product_num' => $value->product_num), $cart['id']);
                         if($result)
                          {
                            $offset +=  (intval($value->product_num) - intval($cart['product_num']));
                          }                        
                    }
                    $is_exist = TRUE;
                    break;
                }
            }
            if(!$is_exist)
            {
                $cart_data = array(
                    'goods_id'    => $value->goods_id,
                    'sku_code'    => $value->sku_code,
                    'product_num' => $value->product_num,                        
                    'user_id'     => $user_id,
                    'create_time' => $value->create_time,
                    'language_id' => $language_id,
                );
                $res = $cartLogic->save($cart_data);
                if($res)
                {
                  $offset += $value->product_num;
                }
                
            }            
        }
        setcookie('cartsku', '', time() + 30, '/');
        
        $cartLogic->clearCartCache(0, $language_id); 
        $cartLogic->clearCartCache($user_id, $language_id);
        if($offset > 0)
        {
           ReportFactory::userSalesReport($user_id, array('cart_counts'=> $offset));
        }
    }
    /**
     * 注册一个新的用户
     * @param type $email 
     */
    public function register($email)
    {
      $flag = $this->isExistName($email);
      $user = array();
      if($flag)
      {
        $cond = 'base_name = "' . $email . '"';
        $user = $this->getOne($cond);
        _setSession('user_id', $user['id']);
        _setSession('user_base_name',  $user['base_name']);
        _setSession('user_sign', md5(md5($user['base_name'].$user['id'])));
        setcookie('user_id', $user['id'], 0, '/');
        setcookie('user_base_name', $user['base_name'], time() + 86400*7, '/');
        setcookie('user_sign', md5(md5($user['base_name'].$user['id'])), 0, '/');
        $this->_checkCookieCart($user['id']);
      }
      else
      {
        $domain    = SITE_URL;
        $langLogic = $this->load('language');
        $ipJoinCountryLogic = $this->load('ipJoinCountry');
        $ip = Common::_ip2long(Common::ip());
        $groupLogic = $this->load('userGroup');
        $default_group_id = 0;
        foreach ($groupLogic->getAll() as $key => $value)
        {
          if($value['is_default'] == 1)
          {
            $default_group_id = $key;
          }
        }
        $password = Common::random(8);
        $user     = array(        
            'base_name'   => $email,
            'password'    => md5(md5($password)),
            'status'      => 1,
            'ip'          => $ip,
            'domain'      => Common::strEscape($domain),
            'source'      => AppController::getSource(),
            'language_id' => $langLogic->language_id ,
            'country_id'  => $ipJoinCountryLogic->getCountryId($ip),
            'user_group_id' => $default_group_id,
            'create_time'   => SYS_TIME,
            'update_time' => SYS_TIME,
            'parent_user_id' => (int)AppController::getUserSource(),
        );
        $register = $this->save($user);
        AppController::cleanUserSource();
		if($register)
        {
           $user['id'] = $register;
           _setSession('user_id', $register);
            _setSession('user_base_name', $email);
            _setSession('user_sign', md5(md5($email.$register)));
            setcookie('user_id', $register);
            setcookie('user_base_name', $email);
            setcookie('user_sign', md5(md5($email.$register)));
            $this->_checkCookieCart($register);
            $now = time();
            $log_data = array(
                'language_id' => $langLogic->language_id,
                'user_id'     => $register,
                'create_year' => date('Y',$now),
                'create_month'=> date('Ym',$now),
                'create_day'  => date('Ymd',$now),
                'last_ip'     => $ip,
            );
            $logLogic = $this->load('userLoginLog');
            $logLogic->save($log_data); 
        }
        else
        {
          $user = NULL;
        }
      }
      
      return $user;
    }
    
    /**
     * 重写 getOne
     * @param type $cond
     * @param type $cols
     * @param type $table
     */
    public function getOne($cond, $cols = array(), $table = "")
    {
        $user = parent::getOne($cond, $cols, $table);
        if($user)
        {
            $creditDetailLogic = $this->load('creditDetail');
            $all_credits = $creditDetailLogic->findAll('user_id=' . $user['id']);
            $total_credits = 0;
            foreach($all_credits as $key => $data)
            {
                $total_credits += $data['useful_credit'];
            }
            $user['credit'] = $total_credits;
        }
        return $user;
    }
    /**
     * 重写 getOneById
     * @param type $primary
     * @param type $cols
     * @param type $table
     */
    public function getOneById($primary, $cols = array(), $table = "")
    {
        $user = parent::getOneById($primary, $cols, $table);
        if($user)
        {
            $creditDetailLogic = $this->load('creditDetail');
            $all_credits = $creditDetailLogic->findAll('user_id=' . $user['id']);
            $total_credits = 0;
            foreach($all_credits as $key => $data)
            {
                $total_credits += $data['useful_credit'];
            }
            $user['credit'] = $total_credits;
        }
        return $user;
    }
}

?>
