<?php
define('ROOT_PATH', dirname(__FILE__).'/../');
class checkConfig {

    //安装需求
    private $php_version = '5.2.0';
    private $must_extension = array('mysql', 'gd', 'xml', 'session', 'iconv', 'mbstring', 'zip', 'curl');
    private $recom_extension = array('memcache', 'openssl');
    private $writeable_dir = array('.', 'conf', 'install', 'upload', 'cache', 'conf/auth.conf.php', 'conf/deploy.conf.php', 'conf/version.conf.php');
    private $readable_dir = array('index.php', 'conf/site.conf.php', 'conf/api.conf.php', 'conf/db.conf.php', 'conf/rewriteRule.conf.php');
    private $php_ini = array('safe_mode' => array('type' => '=', 'value' => false), 'allow_url_fopen' => array('type' => '=', 'value' => '1'), 'memory_limit' => array('type' => '>', 'value' => '12M'));
    private $php_function = array('unlink', 'mkdir', 'filemtime', 'fopen', 'fwrite', 'fclose', 'session_start', 'pfsockopen','get_magic_quotes_gpc');
    private $clear_dir = array('cache/email', 'cache/tpl');
    private $must_exist_file = array('conf/site.conf.php', 'conf/version.conf.php', 'conf/auth.conf.php', 'conf/db.conf.php', 'conf/deploy.conf.php', 'conf/ip.conf.php', 'conf/log.conf.php', 'conf/order.conf.php', 'conf/event.conf.php', 'conf/rewriteRule.conf.php');
    private $web_exist_dir = array(
        'api',
        'app/system/controller',
        'app/system/logic',
        'app/system/table',
        'app/user/controller',
        'app/user/logic',
        'app/user/table',
        'cache/data',
        'cache/email',
        'cache/log',
        'cache/tpl',
        'cache/log/sqllog',
        'conf',
        'languages',
        'plugins',
        'res',
        'upload/attachment',
        'upload/excel_import',
        'upload/font',
        'upload/payment',
        'upload/shipping',
        'upload/sns',
        'upload/system',
        'upload/other/flag',
    );
    //记录检查结果
    private static $npass_must_num = 0;
    private static $npass_recom_num = 0;

    //安装前清空缓存目录文件
    public function c_clearDir() {
        foreach ($this->clear_dir as $value) {
            if (defined('ROOT_PATH') == false) {
                die('缺少ROOT_PATH常量,无法找到程序路径');
            }
            $dirName = ROOT_PATH . './' . $value . '/';
            if ($handle = opendir($dirName)) {
                while (false !== ( $item = readdir($handle) )) {
                    if ($item != "." && $item != "..") {
                        $file = $dirName . $item;
                        if (is_dir($file)) {
                            $this->delDirFile($file);
                        } else if (is_file($file)) {
                            @unlink($file);
                        }
                    }
                }
                closedir($handle);
            }
        }
    }

    /**
     * 检测是否缺少目录
     * @return string
     */
    public function c_dirExist() {
        $return = array();
        foreach ($this->web_exist_dir as $value) {
            if (defined('ROOT_PATH') == false) {
                die('缺少ROOT_PATH常量,无法找到程序路径');
            }
            $fileName = ROOT_PATH . './' . $value;
            if (!is_dir($fileName)) {
                self::$npass_must_num++;
                $return[] = $fileName;
            }
        }
        return $return;
    }

    /**
     * 检测是否有缺少的文件
     * @return string
     */
    public function c_fileExist() {
        $return = array();
        foreach ($this->must_exist_file as $value) {
            if (defined('ROOT_PATH') == false) {
                die('缺少ROOT_PATH常量,无法找到程序路径');
            }
            $fileName = ROOT_PATH . './' . $value;
            if (!file_exists($fileName)) {
                self::$npass_must_num++;
                $return[] = $fileName;
            }
        }
        return $return;
    }

    //删除目录文件
    public function delDirFile($dirName) {
        if (substr($dirName, strlen($dirName) - 1, 1) != '/')
            $dirName .= '/';
        if ($handle = opendir($dirName)) {
            while (false !== ( $item = readdir($handle) )) {
                if ($item != "." && $item != "..") {
                    $file = $dirName . $item;
                    if (is_file($file)) {
                        @unlink($file);
                    }
                }
            }
            closedir($handle);
        }
    }

    //检查php函数
    public function c_functionExists() {
        $return = array();
        foreach ($this->php_function as $key => $val) {
            $is_pass = function_exists($val);
            if (!$is_pass) {
                self::$npass_must_num++;
            }
            $return[$val] = $is_pass;
        }
        return $return;
    }

    //检查php版本
    public function c_phpVersion() {
        $is_pass = version_compare(phpversion(), $this->php_version);
        if (!$is_pass) {
            self::$npass_must_num++;
        }
        return $is_pass;
    }

    //获取程序所需的php版本号
    public function getPHPVersion() {
        return $this->php_version;
    }

    //检查目录权限
    public function c_writeableDir() {
        if (defined('ROOT_PATH') == false) {
            die('缺少ROOT_PATH常量,无法找到程序路径');
        }
        $return = array();
        foreach ($this->writeable_dir as $key => $val) {
            $is_pass = is_writable(ROOT_PATH . './' . $val);
            if (!$is_pass) {
                self::$npass_must_num++;
            }

            //根目录
            if ($val == '.') {
                $val = '根目录';
            }
            $return[$val] = $is_pass;
        }
        return $return;
    }

    //检查目录可读性
    public function c_readableDir() {
        if (defined('ROOT_PATH') == false) {
            die('缺少ROOT_PATH常量,无法找到程序路径');
        }
        $return = array();
        foreach ($this->readable_dir as $key => $val) {
            $is_pass = is_readable(ROOT_PATH . './' . $val);
            if (!$is_pass) {
                self::$npass_must_num++;
            }
            $return[$val] = $is_pass;
        }
        return $return;
    }

    //检查php_ini配置
    public function c_phpIni() {
        $return = array();
        foreach ($this->php_ini as $key => $val) {
            $localIni = @ini_get($key);
            if ($val['type'] == '=' && $localIni == $val['value']) {
                $return[$key] = true;
                continue;
            }

            if ($val['type'] == '>' && floatval($localIni) >= floatval($val['value'])) {
                $return[$key] = true;
                continue;
            }

            self::$npass_must_num++;
            $return[$key] = false;
        }
        return $return;
    }

    //检查必备php扩展
    public function c_must_extension() {
        $return = array();
        foreach ($this->must_extension as $key => $val) {
            $is_pass = extension_loaded($val);

            //考虑GD库的FreeType字体库是否存在
            if ($is_pass == true && $val == 'gd') {
                $is_pass = $this->checkGD();
            }

            $return[$val] = $is_pass;

            if ($is_pass == false) {
                self::$npass_must_num++;
            }
        }
        return $return;
    }

    //检查建议php扩展
    public function c_recom_extension() {
        $return = array();
        foreach ($this->recom_extension as $key => $val) {
            $is_pass = extension_loaded($val);
            $return[$val] = $is_pass;

            if ($is_pass == false) {
//				self::$npass_recom_num++;
            }
        }
        return $return;
    }

    //获取检测数据
    public function getNpassMustNum() {
        return self::$npass_must_num;
    }

    //检查GD库是否完整
    private function checkGD() {
        $gdInfo = gd_info();
        if (isset($gdInfo['FreeType Support']) && $gdInfo['FreeType Support'] == '1') {
            return true;
        }
        return false;
    }

}

$checkObj = new checkConfig;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title>IMCart 系统安装向导</title>
        <link rel="stylesheet" href="statics/css/style.css"  type="text/css" />
        <script type="text/javascript" src="statics/js/jquery.js"></script>
        <!--[if IE 6]><script type="text/javascript" src="statics/js/pngfix.js"></script><![endif]-->
    </head>
    
    <body>
        <div id="step1" class="install_box">
            <div class="install_top"><a class="close" href="javascript:;"></a></div>
            <?php
                //安装保护
                if (file_exists('../install/install.lock')){
            ?>
            <div class="install_con">
                <h3>欢迎使用IMCart多语言外贸电子商务管理系统</h3>
                <div class="agreement_con">
                    安装程序已经被锁定。
                    <p>如果您确定要重新安装 IMCart多语言外贸电子商务管理系统，请删除install目录下的 install.lock。</p>
                </div>
                <div class="clear"></div>
                <div class="action_box">
                    <div class="agreement_check">
                    </div>
                    <a id="returen_index" href="javascript:;" class="next_btn">返回首页</a>
                </div>
                <div class="clearboth"></div>
            </div>
            <?php
                }else{
            ?>
            <div class="install_con">
                <h3>欢迎使用IMCart多语言外贸电子商务管理系统</h3>
                <div class="agreement_con">
                    
                    </p>
                    
                  <p>在订购使用任何IMCart开发的应用(以下简称“应用”)之前，请您仔细阅读下述许可协议条款。<br />
                      一旦您点击同意本协议，即表示您已接受了以下所述的条款和条件，同意受本协议约束。如果您不同意接受全部的条款和条件，那么您将无法使用IMCart。</p>
                    <p>一、本许可协议的缔约方为IMCart和用户，本许可协议具有合同效力。</p>
                    <p>二、定义 <br />
                      2.1 应用：指由IMCart基于IMCart独立网店系统开发的软件或服务</p>
                    <p>三、应用使用方式 <br />
                      3.1 用户需凭其合法方式取得的IMCart用户名和密码订购和使用应用。对于通过其他手段登录、使用所造成的后果，IMCart将不承担任何责任。 <br />
                      3.2 IMCart仅根据用户的ID以及授权码来确认使用应用的用户身份。用户应妥善保管用户登录名及密码，并对其使用及其遗失自行承担责任。</p>
                    <p>四、软件许可费 <br />
                      4.1 软件许可费公示于应用订购页面。 <br />
                      4.2 IMCart同意在一段时间内，向用户免费提供应用的使用许可。免费的试用服务，不应视为IMCart放弃收费的权利。</p>
                    <p>五、用户的权利义务 <br />
                      5.1 用户保证其使用应用的各项行为均符合国家法律法规的规定，其通过应用所从事的一切活动都是合法的、真实的，不侵害任何第三方的合法权益。<br />
                      以下是禁止用户进行的一些有害活动的示例，包括但不限于： <br />
                      1）禁止出售、转售或复制、开发IMCart授予的使用权限；<br />
                      2）禁止复制和模仿IMCart的设计理念、界面、功能和图表； <br />
                      3）禁止未经IMCart许可基于应用或其内容进行修改或制造派生其他产品； <br />
                      5.2 用户进一步同意对应用和/或应用任何部分（软件产品、页面标识、服务品牌、资讯、信息）不进行复制、翻译、修改、适应、增强、反编译、反汇编、反向工程、分解拆卸、出售、转租或作任何商业目的的使用。<br />
                      用户同意约束其有必要使用应用的员工、代理、咨询者或顾问遵守前述之义务，并就其违反前述规定的行为对IMCart负责就如同用户自身违反一样。 <br />
                      5.3 用户应按时足额向IMCart支付软件许可费用（如有），否则IMCart保留随时终止用户关于应用使用许可的权利，并对因终止协议而可能造成的损害不承担任何责任。 <br />
                      5.4用户承诺通过应用进行的活动所引发的一切法律后果，由用户承担全部责任。如因用户使用应用的行为，导致IMCart或任何第三方为此承担了相关的责任，则用户需全额赔偿IMCart或任何第三方的相关支出及损失，包括合理的律师费用。 <br />
                      5.5 用户同意在使用应用的同时，接受IMCart提供的各类信息服务。 <br />
                      5.6 用户理解并同意，应用因现有技术限制，可能存在瑕疵，因使用应用所致的任何损害，用户同意责任人的最高赔偿限额不应超过用户向IMCart支付的许可费用。<br />
                      如因网络问题，或产品瑕疵导致应用无法按指定的时间正常使用的，则用户了解并同意，IMCart或其它责任人所需承担的唯一责任就是延长用户对应用的使用期限，延长的时间应相当于用户无法正常使用应用的时间。 <br />
                      5.7 用户同意将应用用于其功能所指向的合法的目的和用途，并不进行任何竞争性、破坏性或非法的使用。 </p>
                    <p>六、IMCart的权利义务 <br />
                      6.1 IMCart保证其有合法权利向用户提供应用的使用许可，并保证与应用运行相关的其它软件产品版权的合法性。<br />
                      IMCart承诺其向用户提供应用使用许可之行为未对任何第三方合法权益，包括但不限于第三方知识产权构成侵害。 <br />
                      6.2 IMCart保证应用的稳定可靠，负责应用的系统调试、开通、优化、升级和扩容工作，并保证前述工作不影响用户的正常使用。<br />
                      6.3 IMCart负责及时对应用进行更新、维护和管理。 <br />
                      6.4 IMCart有权向用户收取相应的软件许可费。</p>
                    <p>七、终止 <br />
                      出现下列情况之一的，IMCart有权在提前三个工作日通知用户的情况下，终止用户使用应用的权利，而无需承担任何责任： <br />
                      1）用户软件许可期限届满后未继续付费购买后续期间的软件许可的； <br />
                      2）用户违反本协议有关保证、同意、承诺条款的约定，且自IMCart通知其纠正后仍未纠正的；</p>
                    <p>八、协议修改 <br />
                      9.1 如本许可协议的任何内容发生变动，IMCart应通过适当方式向用户提示修改内容。 <br />
                      9.2 如用户不同意IMCart对本许可协议相关条款所做的修改，用户有权停止使用应用。如用户继续使用应用，则视为用户接受IMCart对本许可协议相关条款所做的修改。</p>
                    <p>九、不可抗力 <br />
                      如果由于黑客攻击或政府管制或网络通讯瘫痪等对其发生和后果不能预见的事件，IMCart和用户均确认此属不可抗力；<br />
                      在不可抗力下，用户同意IMCart及第三方无须对合同的延期履行、不能履行承担任何责任。</p>
                    <p>十、法律及争议解决 <br />
                      11.1 本协议适用中华人民共和国法律。 <br />
                      11.2 因双方就本协议的签订、履行或解释发生争议，双方应努力友好协商解决。如协商不成，任何一方均应向被告所在地人民法院起诉。</p>
                    <p>十一、其他 <br />
                      12.1 本协议构成用户和IMCart间就使用应用的完整的协议，并取代双方就有关本协议 所载任何事项于先前以口头及书面达成的共识。 <br />
                      12.2 如本协议的任何条款被视作无效或无法执行，则上述条款可被分离，其余部分则仍具有法律效力。 <br />
                      12.3 本协议的标题仅为方便阅读所设，非对条款的定义、限制、解释或描述其范围或界限。 <br />
                      12.4 IMCart可根据其自身运营状况，在提前三个工作日通知用户的前提下，将其在本协议项下的权利义务全部转让给第三方，而无需获得用户的事先同意。<br />
                      IMCart之受让人受本协议约束，IMCart与其受让人对本协议的履行承担连带责任。</p>
                    <p></p>
              </div>
                <div class="clear"></div>
                <div class="action_box">
                    <div class="agreement_check">
                        <input id="agreement" type="checkbox" name="agreement" value="1" /> <label for="agreement">我同意上述条款和条件</label>
                    </div>
                    <a id="agreement_next" href="javascript:;" class="next_btn">下一步</a>
                    <a href="javascript:;" class="cancel_btn">取消</a>
                </div>
                <div class="clearboth"></div>
            </div>
            <?php
                }
            ?>
        </div>
        <div id="step2" class="install_box" style="display: ;">
            <div class="install_top"><a class="close" href="javascript:;"></a></div>
            <div class="install_con">
                <h3>服务器环境检测<span class="green_box" style='display:none' id='right_div'>
                                        <font color="green"></font>
                                        ( 您的系统配置具备安装IMCart软件 )
                                    </span>
                                    <span class="red_box" style='display:none' id='error_div'>
                                        <font color="red"></font>
                                        ( 您的系统配置不具备安装IMCart软件，有疑问可以访问：<a href='http://www.imcart.com/download.html' target='_blank'>http://www.35zh.com/</a> )
                                    </span></h3>
                <div class="environment_explain">
                    <table border="0" cellspacing="0" cellpadding="0">
                        <tbody>
                            <tr>
                                <td width="210"><strong>操作系统：</strong><?=PHP_OS;?></td>
                                <td><strong>服务器软件：</strong><?=$_SERVER["SERVER_SOFTWARE"]?></td>
                            </tr>
                            <tr>
                                <td><strong>PHP版本：</strong><?=phpversion();?></td>
                                <td><strong>PHP运行模式：</strong><?=php_sapi_name();?></td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                <strong class="mb5">PHP内存限制： </strong>
                                <p><?=ini_get('memory_limit')?>M (<strong>请设置大于 256M</strong>)</p>
                                <strong class="mb5">超时： </strong>
                                <p><?=ini_get('max_execution_time')?>秒 (<strong>建议设置超过 60秒或者120秒</strong>)</p>
                                <strong class="mb5">PHP必备扩展：</strong>
                                    <?php
                                    //must_extension检查
                                    $mustExtensionArray = $checkObj->c_must_extension();
                                    foreach ($mustExtensionArray as $key => $val) {
                                        ?>
                                        <p><span><?php echo $key; ?></span>  -----------------------------------------------------------------------------------------------------  <span class="<?php echo $val ? '' : 'red'; ?>"><?php echo $val ? '已安装' : '未安装'; ?></span></p>
                                        <?php
                                    }
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2"><strong class="mb5">PHP必备函数：</strong>
                                    <?php
                                    //php_function检查
                                    $mustFunctionArray = $checkObj->c_functionExists();
                                    foreach ($mustFunctionArray as $key => $val) {
                                        ?>
                                            <p><span><?php echo $key; ?></span>  -----------------------------------------------------------------------------------------------------  <span class="<?php echo $val ? '' : 'red'; ?>"><?php echo $val ? '可用' : '未启用'; ?></span></p>
                                        <?php
                                    }
                                    ?>
                                    <!--<span class="tips">(红色为必备的但未启用，请联系网管启用)</span>-->
                                </td>
                            </tr>
                            
                            <tr>
                                <td colspan="2"><strong class="mb5">建议扩展配置：</strong>
                                    <?php
                                    //php_function检查
                                    $mustFunctionArray = $checkObj->c_recom_extension();
                                    foreach ($mustFunctionArray as $key => $val) {
                                        ?>
                                            <p><span><?php echo $key; ?></span>  -----------------------------------------------------------------------------------------------------  <span class="<?php echo $val ? '' : 'red'; ?>"><?php echo $val ? '已安装' : '未安装'; ?></span></p>
                                        <?php
                                    }
                                    ?>
                                    <!--<span class="tips">(红色为建议的但未安装，可联系网管安装)</span>-->
                                </td>
                            </tr>
                            <?php
                            $not_found_dir = $checkObj->c_dirExist();
                            if (count($not_found_dir) > 0) {
                                ?>
                            <tr>
                                <td colspan="2"><strong class="mb5">缺少目录：</strong>
                                    <?php
                                    foreach ($not_found_dir as $key => $val) {
                                        ?>
                                            <p><span><?php echo $val; ?></span>  -----------------------------------------------------------------  <span class="red">缺少目录</span></p>
                                        <?php
                                    }
                                    ?>
                                    <!--<span class="tips">(红色为缺少的目录，请联系网管增加)</span>-->
                                </td>
                            </tr>
                             <?php
                                }
                            ?>
                            <?php
                            $not_found_file = $checkObj->c_fileExist();
                            if (count($not_found_file) > 0) {
                                ?>
                            <tr>
                                <td colspan="2"><strong class="mb5">缺少配置文件：</strong>
                                    <?php
                                    foreach ($not_found_file as $key => $val) {
                                        ?>
                                            <p><span><?php echo $val; ?></span>  -----------------------------------------------------------------  <span class="red">缺少配置文件</span></p>
                                        <?php
                                    }
                                    ?>
                                    <!--<span class="tips">(红色为缺少的配置文件，请联系网管增加)</span>-->
                                </td>
                            </tr>
                             <?php
                                }
                            ?>
                            <tr>
                                <td colspan="2"><strong class="mb5">文件可写状态：</strong>
                                    <?php
                                    $writeableArray = $checkObj->c_writeableDir();
                                    foreach ($writeableArray as $key => $val) {
                                        ?>
                                            <p><span><?php echo $key; ?></span>  -------------------------------------------------------------------------------------  <span class="<?php echo $val ? '' : 'red'; ?>"><?php echo $val ? '可写入' : '无法写入'; ?></span></p>
                                        <?php
                                    }
                                    ?>
                                    <!--<span class="tips">(红色为必须可写，但未有写入权限)</span>-->
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2"><span class="red">注：</span>
                                    系统部分目录为可写权限否则会导致部分功能无法甚至系统无法运行
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>                
                <div class="clear"></div>
                <div class="action_box">
                    <a id="environment_btn" href="javascript:;" class="next_btn">下一步</a>
                    <a href="javascript:;" class="re_check">重新检测</a>
                    <a href="javascript:;" class="cancel_btn">取消</a>
                </div>
                <div class="clearboth"></div>
            </div>
        </div>
        <div id="step3" class="install_box" style="display: none;">
            <div class="install_top"><a class="close" href="javascript:;"></a></div>
            <div class="install_con">
                <h3>IMCart数据库相关信息配置</h3>
                <div class="database_config">
                    <table border="0" cellspacing="0" cellpadding="0">
                        <tbody>
                            <tr>
                                <td class="td_left" width="90"><span class="red">*</span>数据库主机：</td>
                                <td width="195">
                                    <input type="text" name="db_host" value="127.0.0.1" />
                                </td>
                                <td class="red">如果数据库服务器与网站服务器不在同一台主机上，请设置为数据库服务器的地址。</td>
                            </tr>
                            <tr>
                                <td class="td_left"><span class="red">*</span>数据库用户名：</td>
                                <td>
                                    <input type="text" name="db_username" value="root" />
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_left"><span class="red">*</span>数据库密码：</td>
                                <td>
                                    <input type="password" name="db_pwd" value="" />
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_left"><span class="red">*</span>数据库名称：</td>
                                <td>
                                    <input type="text" name="db_name" value="" />
                                </td>
                                <td><a href="javascript:;" id="test_db">测试链接</a></td>
                            </tr>
                            <tr>
                                <td class="td_left">数据库表前缀：</td>
                                <td>
                                    <input type="text" name="db_prefix" value="z" readonly/>
                                </td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="clear"></div>
                <div class="action_box">
                    <a id="database_next" href="javascript:;" class="next_btn">保存并进入下一步</a>
                    <a id="pre_database_btn" href="javascript:;" class="pre_btn">上一步</a>
                    <a href="javascript:;" class="cancel_btn">取消</a>
                </div>
                <div class="clearboth"></div>
            </div>
        </div>
        <div id="step4" class="install_box" style="display: none;">
            <div class="install_top"><a class="close" href="javascript:;"></a></div>
            <div class="install_con">
                <h3>建立管理员账号</h3>
                <div class="create_admin">
                    <table border="0" cellspacing="0" cellpadding="0">
                        <tbody>
                            <tr>
                                <td class="td_left" width="90"><span class="red">*</span>管理员用户名：</td>
                                <td width="195">
                                    <input type="text" name="username" value="admin" />
                                </td>
                                <td>用于显示给用户的等级名称</td>
                            </tr>
                            <tr>
                                <td class="td_left"><span class="red">*</span>管理员密码：</td>
                                <td>
                                    <input type="password" name="password" value="" />
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="td_left"><span class="red">*</span>再次输入密码：</td>
                                <td>
                                    <input type="password" name="confirmpassword" value="" />
                                </td>
                                <td></td>
                            </tr>
                             <tr>
                                <td class="td_left"><span class="red"></span>收款Paypal号：</td>
                                <td>
                                    <input type="text" name="paypal_account" value="paypal@<?=str_replace("www.","",$_SERVER['SERVER_NAME'])?>" />
                                </td>
                                <td>后台“支付管理” 可再次修改</td>
                            </tr>
                            <tr>
                                <td class="td_left"><span class="red"></span>修改后台路径：</td>
                                <td>
                                    <input type="text" name="adminpath" value="admin.php" />
                                </td>
                                <td></td>
                            </tr>
                            <tr>
                                <td style="background: #F9F9F9; border-top: 1px #E4E4E4 solid;">&nbsp;</td>
                                <td style="background: #F9F9F9; border-top: 1px #E4E4E4 solid;" colspan="2">
                                    <input id="install_data" type="checkbox" name="install_data" value="1" checked="chceked" /> <strong>同时安装体验数据</strong><br />
                                    装载体验数据后，您不用进行任何系统设置，可以用模拟数据体验IMCart网店系统的各项功能
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="clear"></div>
                <div class="action_box">
                    <a id="instal_btn" href="javascript:;" class="next_btn">立即安装</a>
                    <a id="pre_instal_btn" href="javascript:;" class="pre_btn">上一步</a>
                    <a href="javascript:;" class="cancel_btn">取消</a>
                </div>

                <div class="clearboth"></div>
            </div>
        </div>
        <div id="step5" class="install_box" style="display: none;">
            <div class="install_top"><a class="close" href="javascript:;"></a></div>
            <div class="install_con">
                <h3>恭喜您，IMCart已成功地完成安装！</h3>
                <div class="create_admin">
                    <p class="install_success"><a href="/" target="_blank" title="前往 IMCart 首页"> -- 前往 IMCart 首页</a></p>
                    <p class="install_success"><a href="/admin.php" target="_blank" title="前往 IMCart 后台管理中心" id="adminurl"> -- 前往 IMCart 后台管理中心</a> （后台账号：<span id="show_username"></span> 密码：<span id="show_password"></span>）</p>
                    <p class="install_success pb50"><span style="color: #ff0000;">提示：</span>请登录FTP删除根目录下的 zip.php以及安装压缩包。</p>
                </div>
                <div class="clear"></div>
                <div class="clearboth"></div>
                <div class="copyright">
                    Copyright © 2007 - 2014 厦门中恒天下网络科技有限公司 版权所有
                </div>
            </div>
        </div>
        <script>
            function createAjaxLoading()
            {
                $('<div/>').appendTo(document.body).addClass('ajax_loading');
            }
            function removeAjaxLoading()
            {
                $('.ajax_loading').remove();
            }
            $('#agreement_next').click(function(){
                if(!$('#agreement').attr("checked"))
                {
                    alert('必须同意本协议才能继续安装IMCart系统！');
                }
                else
                {
                    $('#step1').hide();
                    $('#step2').show();
                }
            });
            $('#database_next').click(function(){
                var db_host = $("input[name='db_host']").val();
                var db_username = $("input[name='db_username']").val();
                var db_pwd = $("input[name='db_pwd']").val();
                var db_name = $("input[name='db_name']").val();
                var db_prefix = $("input[name='db_prefix']").val();
                if(!db_host)
                {
                    alert('请填写数据库主机地址，一般是一个IP地址。');
                    return;
                }
                if(!db_username)
                {
                    alert('请填写数据库用户名！');
                    return;
                }
                if(!db_pwd)
                {
//                    alert('请填写数据库密码！');
//                    return;
                }
                if(!db_name)
                {
                    alert('请填写数据库名称！');
                    return;
                }
                if(!db_prefix)
                {
                    alert('必须填写一个表前缀！');
                    return;
                }

                $.ajax({
                    url :'install.php?action=checkdb',
                    type:'POST',
                    data:{
                        db_host  : db_host,
                        db_username  : db_username,
                        db_pwd  : db_pwd,
                        db_name  : db_name,
                        db_prefix  : db_prefix
                    },
                    dataType: 'json',
                    cache: false,
                    success: function(res) { 
                        if(res.status)
                        {
                            if(res.status==1)
                            {
                                $('#step1').hide();
                                $('#step2').hide();
                                $('#step3').hide();
                                $('#step4').show();
                            }
                            else if(res.status==2)
                            {
                                alert(res.msg);
                            }
                            else if(res.status==3)
                            {
                                alert('数据库找不到，请检查数据库是否存在！'+res.msg);
                            }
                            else
                            {
                                alert('连接失败，请检查你的填写的数据库信息！');
                            }
                        }
                        else
                        {
                            alert('连接失败，请检查你的填写的数据库信息！');
                        }                 
                    },
                    beforeSend: function(){
                        createAjaxLoading();
                    },
                    complete: function(){
                        removeAjaxLoading();
                    }
                });
            });
            $('#test_db').click(function(){
                var db_host = $("input[name='db_host']").val();
                var db_username = $("input[name='db_username']").val();
                var db_pwd = $("input[name='db_pwd']").val();
                var db_name = $("input[name='db_name']").val();
                var db_prefix = $("input[name='db_prefix']").val();
                if(!db_host)
                {
                    alert('请填写数据库主机地址，一般是一个IP地址。');
                    return;
                }
                if(!db_username)
                {
                    alert('请填写数据库用户名！');
                    return;
                }
                if(!db_pwd)
                {
//                    alert('请填写数据库密码！');
//                    return;
                }
                if(!db_name)
                {
                    alert('请填写数据库名称！');
                    return;
                }

                $.ajax({
                    url :'install.php?action=checkdb',
                    type:'POST',
                    data:{
                        db_host  : db_host,
                        db_username  : db_username,
                        db_pwd  : db_pwd,
                        db_name  : db_name,
                        db_prefix  : db_prefix
                    },
                    dataType: 'json',
                    cache: false,
                    success: function(res) { 
                        if(res.status)
                        {
                            if(res.status==1)
                            {
                                alert('恭喜！数据库信息正确。');
                            }
                            else if(res.status==2)
                            {
                                alert(res.msg);
                            }
                            else if(res.status==3)
                            {
                                alert('数据库找不到，请检查数据库是否存在！'+res.msg);
                            }
                            else
                            {
                                alert('连接失败，请检查你的填写的数据库信息！');
                            }
                        }
                        else
                        {
                            alert('连接失败，请检查你的填写的数据库信息！');
                        }                 
                    },
                    beforeSend: function(){
                        createAjaxLoading();
                    },
                    complete: function(){
                        removeAjaxLoading();
                    }
                });
            });
            $('#pre_database_btn').click(function(){
                $('#step1').hide();
                $('#step2').show();
                $('#step3').hide();
            });
            $('#environment_btn').click(function(){
                if(!check_config())
                {
                    alert('您的系统环境配置没有通过检查');
                }
                else
                {
                    $('#step1').hide();
                    $('#step2').hide();
                    $('#step3').show();
                }
            });
             $('#pre_instal_btn').click(function(){
                $('#step1').hide();
                $('#step2').hide();
                $('#step3').show();
                $('#step4').hide();
            });
            $('#instal_btn').click(function(){
                
                var username = $("input[name='username']").val();
				var paypal_account  = $("input[name='paypal_account']").val();
                var password = $("input[name='password']").val();
                var confirmpassword = $("input[name='confirmpassword']").val();
                var adminpath = $("input[name='adminpath']").val() ? $("input[name='adminpath']").val() : 'admin.php';
                var install_data = $('#install_data').attr("checked") ? 1:0;
                if(!username)
                {
                    alert('请填写管理员用户名！');
                    return;
                }
                if(!password)
                {
                    alert('请填写管理员密码！');
                    return;
                }
                if(!confirmpassword)
                {
                    alert('请再次填写管理员密码！');
                    return;
                }
                
                if(password!=confirmpassword)
                {
                    alert('两次密码不一致！');
                    return;
                }
                if(adminpath.substring(adminpath.length - 4)!='.php')
                {
                    alert('后台路径必须以.php结尾！');
                    return
                }
                $('#show_username').html(username);
                $('#show_password').html(password);
                $.ajax({
                    url :'install.php?action=install',
                    type:'POST',
                    data:{
                        install_data : install_data,
                        username : username,
                        password : password,
                        confirmpassword : confirmpassword,
						paypal_account : paypal_account,
                        adminpath : adminpath
                    },
                    dataType: 'json',
                    cache: false,
                    success: function(res) { 
                        if(res.status)
                        {
                            if(res.status==1)
                            {
                                $('#adminurl').attr("href", '/' + adminpath);
                                $('#step4').hide();
                                $('#step5').show();
                                $.ajax({
                                    url :'install.php?action=del',
                                    type:'POST',
                                    data:{},
                                    dataType: 'json',
                                    cache: false,
                                    success: function(res) {
                                        
                                    }
                                });
                            }
                            else if(res.status==2)
                            {
                                alert(res.msg);
                            }
                            else if(res.status==3)
                            {
                                alert('数据库找不到，请检查数据库是否存在！'+res.msg);
                            }
                            else if(res.status==4)
                            {
                                if(res.type==1)
                                {
                                    alert('请填写管理员用户名！');
                                }
                                else if(res.type==2)
                                {
                                    alert('请填写管理员密码！');
                                }
                                else if(res.type==3)
                                {
                                    alert('请再次填写管理员密码！');
                                }
                                else if(res.type==4)
                                {
                                    alert('两次密码不一致！');
                                }
                            }
                            else
                            {
                                alert('连接失败，请检查你的填写的数据库信息！');
                            }
                        }
                        else
                        {
                            alert('连接失败，请检查你的填写的数据库信息！');
                        }                 
                    },
                    beforeSend: function(){
                        createAjaxLoading();
                    },
                    complete: function(){
                        removeAjaxLoading();
                    }
                });
            });
            $('a.cancel_btn').click(function(){
                if(confirm('确定取消安装IMCart系统'))
                {
                    location.href = 'http://www.imcart.com/download.html';
                }
            });
            $('#returen_index').click(function(){
                location.href = '/';
            });
            $('.re_check').click(function(){
                location.href = '/install/?recheck=1';
            });
            <?php 
            if(@$_GET["recheck"]){
            ?>
                $('#step1').hide();
                $('#step2').show();
            <?php
            }
            ?>
            ErrorNum = <?php echo $checkObj->getNpassMustNum(); ?>
            //检查配置信息
            function check_config()
            {
                var error_num = ErrorNum;
                if (error_num > 0)
                {
                    return false;
                }
                return true;
            }
            if (ErrorNum > 0)
            {
                $('#error_div').show();
                $('.re_check').show();
            }
            else
            {
                $('#right_div').show();
                $('.re_check').hide();
            }
        </script>
    </body>
</html>