<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
require_once(APP_ROOT . "conf/order.conf.php");
require_once(APP_ROOT . "libary/Inputer.php");
require_once(APP_ROOT . 'libary/Common.php');
require_once(APP_ROOT . 'libary/Zhtx.php');
require_once(APP_ROOT . "libary/Upload.php");
require_once(APP_ROOT . "libary/Dir.php");
require_once(APP_ROOT . 'libary/ZhCurl.php');
require_once(APP_ROOT . 'libary/ReportFactory.php');
require_once(APP_ROOT . 'libary/EventFactory.php');
require_once(APP_ROOT . 'libary/GrowthFactory.php');
require_once(APP_ROOT . 'libary/CreditFactory.php');
if (!defined('IN_ZHTX'))
{
    exit('Access Denied');
}

abstract class AppController
{

    public function __construct()
    {
        
    }

    public function __destruct()
    {
        if ((XDEBUG || @$_REQUEST["open_debug"]) && Core::$htmlFile != "")
        {
            global $debug_info;
            $debug_html = "<table  cellspacing=\"0\" cellpadding=\"0\" border=\"1\" width=\"100%\"><thead><tr height=\"25\"><th>Behavior</th><th>Statement</th><th>Memory(KB)</th><th>Runtime(ms)</th></tr></thead>";
            foreach ($debug_info as $key => $val)
            {
                $debug_html .= "<tr height=\"25\" style=\"background-color:#efefef;\"><td>QUERY</td><td>" . $val["sql"] . "</td><td>" . $val["memory"] . "</td><td>" . $val["exec_time"] . "</td></tr> <tr height=\"25\" style=\"background-color:#ffffff;\"><td colspan=\"4\">" . $val["explain"] . "</td></tr>";
            }
            $debug_html .= "</table>";
            echo $debug_html;
        }
    }

    public static function load($logic_name, $table = '', $table_prefix = true)
    {
        return Zhtx::loadModule(Module::LOGIC, ucfirst($logic_name) . 'Logic', $table, $table_prefix);
    }

    public function setPageHeader($charset = "utf-8")
    {

        header('Content-type: text/html; charset=' . $charset);

        // TODO: maybe here we should put more settings in default header setting
    }

    /**
     * 提示信息页面跳转，跳转地址如果传入数组，页面会提示多个地址供用户选择，默认跳转地址为数组的第一个值，时间为5秒。
     * showMessage('登录成功', array('默认跳转地址'=>'http://www.zhtx.com'));
     * @param string $msg 提示信息
     * @param mixed(string/array) $url_forward 跳转地址
     * @param int $ms 跳转等待时间
     */
    function showMessage($msg, $url_forward = 'goback', $type = "error", $ms = 1500, $dialog = '', $returnjs = '')
    {
        $module = $_REQUEST["m"];
        $lang = Common::lang($_REQUEST["c"], $module, Core::getLanguage());
        Core::$tpl->set("type", $type);
        if(!$lang[$msg])
        Core::$tpl->set("msg", $msg); 
        else
        Core::$tpl->set("msg", $lang[$msg]);
        Core::$tpl->set("url_forward", $url_forward);
        Core::$tpl->set("ms", $ms);
        Core::$tpl->set("dialog", $dialog);
        Core::$tpl->set("returnjs", $returnjs);
        if (Core::$site == 'front')
        {
            Core::$htmlFile = "common/showmessage";
        }
        else
        {
            Core::$htmlFile = "../showmessage";
        }
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . ".htm");
        exit;
    }

    /**
     * showMessage 别名 success 用于提示成功消息
     */
    function success($msg, $url_forward = 'goback', $ms = 1500, $dialog = '', $returnjs = '')
    {
        self::showMessage($msg, $url_forward, 'success', $ms, $dialog, $returnjs);
    }

    /**
     * showMessage 别名 error 用于提示失败消息
     */
    function error($msg, $url_forward = 'goback', $ms = 1500, $dialog = '', $returnjs = '')
    {
        self::showMessage($msg, $url_forward, 'error', $ms, $dialog, $returnjs);
    }

    /**
     * showMessage 别名 redirect 用于跳转链接
     */
    function redirect($msg, $url_forward = 'goback', $ms = 15000, $dialog = '', $returnjs = '')
    {
        self::showMessage($msg, $url_forward, 'redirect', $ms, $dialog, $returnjs);
    }

    public static function sysLog($message)
    {
        $log = new Logger('3', SYS_LOG_PATH);
        $ip = $_SERVER['REMOTE_ADDR'];
        $hostName = $_SERVER['REMOTE_HOST'];
        $query = $_SERVER['QUERY_STRING'];
        //信息内容：时间 IP地址 主机名 用户名 操作（即GET提交的参数字符串）传递的消息信息
        $log->write_log("$ip $hostName $user $query $message");
    }

    /**
     * Ajax方式返回数据到客户端
     * @param mixed $data 要返回的数据
     * @param String $type AJAX返回数据格式
     */
    public function ajaxReturn($data)
    {
        header('Content-Type:application/json; charset=utf-8');
        exit(json_encode($data));
    }

    /**
     * 判断前台用户是否登录
     * @return type 
     */
    public static function checkLogin()
    {
        $user_id = _c('user_id') ? _c('user_id') : _s('user_id');
        $username = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
        $sign = _c('user_sign') ? _c('user_sign') : _s('user_sign');
        if (md5(md5($username . $user_id)) == $sign)
        {
            return $user_id;
        }
        return FALSE;
    }

    /**
     * 页面重定向
     *
     * @param string $url
     */
    protected function _redirect($url, $top = FALSE)
    {
		if(!$url)
		{
			$url = "/";	
		}
        $html .= '<script type="text/javascript">';
        $html .= ($top == TRUE ? 'top.' : '') . 'location.href = "' . ($url) . '";';
        $html .= '</script>';
        echo $html;
		die();
    }

    /**
     * 前台获取语言和货币
     * @return type 
     */
    public static function getLang()
    {
        $langLogic = self::load('language');
        $language_name = $langLogic->language_name;
        $theme_id = $langLogic->theme_id;
        $theme_name = $langLogic->theme_name;
        $language_id = $langLogic->language_id;
        $real_language_id = $langLogic->real_language_id;
        $is_mobible = $langLogic->is_mobile;
        if (!$language_id && _g('c') != 'module' && _g('c') != 'upload')
        {
            echo "<script type='text/javascript'>alert('域名未绑定，请到后台站点管理进行设置');</script>";
            die;
        }
        if (!_s('symbol_left') || !_s('exchange_rate') || !_s('decimal_num') || TRUE)
        {
            $currency = $langLogic->getCurrentCurrency();
            _setSession('currency_id', $currency['id']);
            _setSession('symbol_left', $currency['symbol_left']);
            _setSession('symbol_right', $currency['symbol_right']);
            _setSession('symbol_base_name', $currency['base_name']);
            _setSession('decimal_num', $currency['decimal_num']);
            _setSession('standard_code', $currency['standard_code']);
            _setSession('exchange_rate', $currency['exchange_rate']);
            _setSession('country_code', $currency['country_code']);
        }
        else
        {
            $currency = array(
                'id' => _s('currency_id'),
                'symbol_left' => _s('symbol_left'),
                'symbol_right' => _s('symbol_right'),
                'base_name' => _s('symbol_base_name'),
                'decimal_num' => _s('decimal_num'),
                'standard_code' => _s('standard_code'),
                'exchange_rate' => _s('exchange_rate'),
                'country_code' => _s('country_code'),
            );
        }
        return array('front_lang' => $language_name, 'language_id' => $language_id, 'real_language_id' => $real_language_id, 'currency' => $currency, 'theme_id' => $theme_id, 'theme_name' => $theme_name, 'is_mobile' => $is_mobible);
    }

    public static function getBaseCurrency()
    {
        global $cfg;
        if (!_s('base_symbol_left') || !_s('base_exchange_rate') || !_s('base_decimal_num'))
        {
            $base_currency_id = $cfg['sites'][0]['base_currency'];
            $currencyLogic = self::load('currency');
            if ($base_currency_id)
            {
                $base_currency = $currencyLogic->getOneById($base_currency_id);
            }
            else
            {
                $base_currency = $currencyLogic->getOne('status=1 and exchange_rate=1');
            }
            _setSession('base_currency_id', $base_currency['id']);
            _setSession('base_currency_name', $base_currency['base_name']);
            _setSession('base_symbol_left', $base_currency['symbol_left']);
            _setSession('base_symbol_right', $base_currency['symbol_right']);
            _setSession('base_decimal_num', $base_currency['decimal_num']);
            _setSession('base_standard_code', $base_currency['standard_code']);
            _setSession('base_exchange_rate', $base_currency['exchange_rate']);
            _setSession('base_country_code', $base_currency['country_code']);
        }
        else
        {
            $base_currency = array(
                'id' => _s('base_currency_id'),
                'base_name' => _s('base_currency_name'),
                'symbol_left' => _s('base_symbol_left'),
                'symbol_right' => _s('base_symbol_right'),
                'decimal_num' => _s('base_decimal_num'),
                'standard_code' => _s('base_standard_code'),
                'exchange_rate' => _s('base_exchange_rate'),
                'country_code' => _s('base_country_code'),
            );
        }
        return $base_currency;
    }

    /**
     * 获取当前页面URL地址(不包含http://或者 https://)
     */
    public static function getUrl()
    {
        $php_self = $_SERVER['PHP_SELF'] ? self::safeReplace($_SERVER['PHP_SELF']) : self::safeReplace($_SERVER['SCRIPT_NAME']);
        $path_info = isset($_SERVER['PATH_INFO']) ? self::safeReplace($_SERVER['PATH_INFO']) : '';
        $relate_url = isset($_SERVER['REQUEST_URI']) ? self::safeReplace($_SERVER['REQUEST_URI']) : $php_self . (isset($_SERVER['QUERY_STRING']) ? '?' . self::safeReplace($_SERVER['QUERY_STRING']) : $path_info);
        return (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '') . $relate_url;
    }

    /**
     * 安全过滤函数
     * @param $string
     * @return string
     */
    static function safeReplace($string)
    {
        $string = str_replace('%20', '', $string);
        $string = str_replace('%27', '', $string);
        $string = str_replace('%2527', '', $string);
        $string = str_replace('*', '', $string);
        $string = str_replace('"', '&quot;', $string);
        $string = str_replace("'", '', $string);
        $string = str_replace('"', '', $string);
        $string = str_replace(';', '', $string);
        $string = str_replace('<', '&lt;', $string);
        $string = str_replace('>', '&gt;', $string);
        $string = str_replace("{", '', $string);
        $string = str_replace('}', '', $string);
        return $string;
    }

    /**
     * 前台使用
     * 基准货币与其他货币之间的转换
     * @param type $price
     * @param type $tobase 是否转为基准货币
     * @return type 
     */
    public static function toolPrice($price, $tobase = FALSE)
    {
        global $cfg, $site_info;
        $current_currency = $site_info['currency'];
        $rate = $current_currency['exchange_rate'];
        $decimal = $current_currency['decimal_num']; //小数点问题
        $style = isset($cfg['sites'][0]['home_price_peri']) ? $cfg['sites'][0]['home_price_peri'] : 0; //进位
        if ($tobase)
        {
            $baseCurrency = self::getBaseCurrency();
            $decimal = $baseCurrency['decimal_num']; //基准货币小数点
            return Common::price_format($price / $rate, $decimal, $style);
        }
        return Common::price_format($price * $rate, $decimal, $style);
    }

    /**
     * 指定货币转换
     * @global type $cfg
     * @param type $price
     * @param type $currency
     * @param type $tobase
     * @return type 
     */
    public static function speChangePrice($price, $currency, $tobase = FALSE)
    {
        global $cfg;
        $rate = $currency['exchange_rate'];
        $decimal = $currency['decimal_num']; //小数点问题
        $style = isset($cfg['sites'][0]['home_price_peri']) ? $cfg['sites'][0]['home_price_peri'] : 0; //进位
        if ($tobase)
        {
            $baseCurrency = self::getBaseCurrency();
            $decimal = $baseCurrency['decimal_num']; //基准货币小数点
            return Common::price_format($price / $rate, $decimal, $style); //转换成基准货币
        }
        return Common::price_format($price * $rate, $decimal, $style); //基准货币转换到指定的货币
    }

    public static function setSource($day = 15)
    {
        if ($_COOKIE["MARK"] == "" && $_SERVER['HTTP_REFERER'] != "")
        {
            $arr_ref = parse_url($_SERVER['HTTP_REFERER']);
            $domain = str_replace($_SERVER['SERVER_NAME'], "", $arr_ref["host"]);
            $domain = str_replace("www.", "", $domain);
            if ($domain != "")
            {
                setcookie("MARK", "yes", time() + 3600 * 24 * $day, "/");
                setcookie("SOURCE", $domain, time() + 3600 * 24 * $day, "/");
            }
        }
        if (_g("source") != "")
        {
            $source = _g("source");
            setcookie("SOURCE", $source, time() + 3600 * 24 * $day, "/");
        }
    }
    
    public static function setUserSource($day = 365)
    {
        if (_g("source_user") != "")
        {
            $source_user = _g("source_user");
            setcookie("parent_user_id", $source_user, time() + 3600 * 24 * $day, "/");
        }
    }

    public static function setDeviceSource($day = 365)
    {
        if (_g("source_device") != "")
        {
            $source_device = _g("source_device");
            setcookie("DEVICE", $source_device, time() + 3600 * 24 * $day, "/");
        }
    }

    public function getSource()
    {
        return $_COOKIE["SOURCE"];
    }

    public function getUserSource()
    {
        return (int)$_COOKIE["parent_user_id"];
    }
    
    public function cleanSource()
    {
        setcookie("SOURCE", "", time() - 10*3600*24, "/");
        setcookie("MARK", "", time() - 10*3600*24, "/");
		setcookie("parent_user_id", "", time() - 10*3600*24, "/");
    }
    
    public function cleanUserSource()
    {
        //setcookie("parent_user_id", "");
       setcookie("parent_user_id", "", time() - 10*3600*24, "/") ;
    }

    public static function price_format($price)
    {
        global $cfg, $site_info;
        $current_currency = $site_info['currency'];
        $decimal = $current_currency['decimal_num']; //小数点问题        
        $style = isset($cfg['sites'][0]['home_price_peri']) ? $cfg['sites'][0]['home_price_peri'] : 0; //进位
        return Common::price_format($price, $decimal, $style);
    }

    /**
     * 检测访问权限
     */
    public static function checkVisitRight() {
        global $cfg;
        $continue = TRUE;
        if (strtolower($_REQUEST["c"]) != 'module' && strtolower($_REQUEST["a"]) != 'login' && !_s('front_user') && strtolower($_REQUEST["m"]) != 'wap' && strtolower($_REQUEST["a"]) != 'upload') {
            //限制所有访问
            if (isset($cfg['sites'][0]['authorize_visit_all']) && $cfg['sites'][0]['authorize_visit_all'] == 4) {
                $continue = FALSE;
            }
            //中文浏览器语言
            if (isset($cfg['sites'][0]['authorize_visit_lang']) && $cfg['sites'][0]['authorize_visit_lang'] == 1 && $continue) {
                $browserlang = strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE']);
                $langcount = preg_match("/zh-cn/i", $browserlang);
                if ($langcount == 1) {
                    $continue = FALSE;
                }
            }
            //黑名单
            if (isset($cfg['sites'][0]['authorize_visit_iplist']) && $cfg['sites'][0]['authorize_visit_iplist'] == 2 && $continue) {
                $ip = Common::_ip2long(Common::ip());
                $language_id = self::load('language')->language_id;
                $iplistLogic = self::load('iplist');
                $continue = $iplistLogic->visitRight($ip, $language_id);
            }
            //限制部分国家访问
            if (isset($cfg['sites'][0]['authorize_visit_cnip'])&&$cfg['sites'][0]['authorize_visit_cnip']==3 && (strpos($cfg['sites'][0]['authorize_visit_countrys'], $_COOKIE["clientCountryCode2"]) !== FALSE) && $continue) {
                $continue = FALSE;
            }
        }
        if (!$continue) {
            if ($cfg['sites'][0]['authorize_page_type'] == 1) {
                self::_redirect(FOLDER_ROOT . 'h-module-login.html');
            } else if ($cfg['sites'][0]['authorize_page_type'] == 2) {
                if($cfg['sites'][0]['authorize_page_content'])
                {
                    die($cfg['sites'][0]['authorize_page_content']);
                }
                else
                {
                    die('AUTH 404');
                }
            } else if ($cfg['sites'][0]['authorize_page_type'] == 3) {
                self::_redirect($cfg['sites'][0]['authorize_page_diyurl']);
            } else if ($cfg['sites'][0]['authorize_page_type'] == 4) {
                self::exception();
            } else {
                self::exception();
            }
        }
    }


    /**
     * 前台通知页面
     * @param type $nkey
     * @param type $status 
     */
    public function notice($nkey, $status = 0)
    {
        self::_redirect(Common::frontURL('home', 'module', 'notice', array('id' => $nkey, 'status' => $status)));
    }

    /**
     * 异常处理
     * @param type $status
     * @param type $msg 
     */
    public static function exception($status = 404, $msg = 'ERROR')
    {
        header("HTTP/1.0 404 Not Found");
		header("Status: 404 Not Found");
        $_GET['page_code'] = "404";
		Core::$htmlFile = "common/404";
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . ".htm");
        exit;
    }

    /**
     * 每天触发事件一次
     * @return type 
     */
    public static function triggerEvent()
    {
        if (_g('c') == 'email')
        {
            return;
        }
        $temp = APP_ROOT . 'temp.txt';
        $date = md5(md5(date('Y-m-d', time())));
        $res = md5(md5('success'));
        if (is_file($temp))
        {
            $content = trim(@file_get_contents($temp));
            if ($content && $content == $date)
            {
                $curl = SITE_PROTOCOL . SITE_URL . '/index.php?m=home&c=task&a=processPartTask';
                Common::getRemoteData($curl,'','',2);
                @file_put_contents($temp, $date . '-' . $res);
            }
            else if ($content != $date . '-' . $res)
            {
                @file_put_contents($temp, $date);
            }
        }
        else
        {
            @file_put_contents($temp, $date);
        }
    }

    public static function initUserCountry()
    {
        self::load('IpJoinCountry')->initUserCountry();
    }

}

?>
