<?php
/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
require_once(APP_ROOT . "libary/Common.php");
require_once(APP_ROOT . "libary/Logger.php");
require_once(APP_ROOT . "libary/CacheFactory.php");
require_once(APP_ROOT . "conf/log.conf.php");
require_once(APP_ROOT . 'libary/Zhtx.php');
 class BaseLogic {
  private $db_conn;
  protected $log;
  protected $table;
  protected $cache_type;
  function __construct() {
    @$this->log =  new Logger('3',LOGIC_LOG_PATH);
  }
  protected function getConn() {
    return $this->db_conn;
  }
  protected function beginTrans() {
    $this->db_conn = DBFactory::getDBConn();
    $this->db_conn->StartTrans();
  }

  protected function endTrans() {
    $this->db_conn->CompleteTrans();
  }

  protected function giveUpTrans() {
  //  $this->db_conn->FailTrans();
  }

  protected function checkTypes(&$data) {
    return $data->checkTypeValid();
  }
  protected function setLogMsg($message) {
    $this->log->write_log($message);
  }

  
  public function load($logic_name, $table='', $table_prefix=true)
  {
    return Zhtx::loadModule(Module::LOGIC, ucfirst($logic_name) . 'Logic', $table, $table_prefix);
  }  
  
  /**
   *
   * @param type $cond 查询条件
   * @param type $table 实体类名称
   * @param type $cols 获取的列 数组形式，字符串形式均可
   * @param type $is_count 是否需要统计
   * @return type 
   */
  public function getList($cond = "", $table = "", $cols = array("*"), $is_count = FALSE)
  {
      $result = array();
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    $list = $dao->getAllSelectiveWithCond($cols, null, $cond);
    if ($is_count)
    {
       $count = $dao->getCountWithCond($cond);
       $result['count'] = $count;
    }
    $result['list'] = $list;
    return $result;
  }
  /**
   *
   * @param type $cond 查询条件
   * @param type $table 实体类名称
   * @param type $cols 获取的列 数组形式，字符串形式均可
   * @param type $asArrayId 是否以ID作为下标
   * @return type 
   */
  public function findAll($cond = "", $asArrayId = false, $table = "", $cols = array("*"))
  {
      $result = array();
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    $list = $dao->getAllSelectiveWithCond($cols, null, $cond);
    if ($asArrayId)
    {
        foreach ($list as $value)
        {
            $result[$value['id']] = $value;
        }
    }
    else
    {
        $result = $list;
    }
    
    return $result;
  }
  

  /**
   *
   * @param type $cond 查询条件
   * @param type $table 实体类名称
   * @return type 
   */
  public function getOne($cond, $cols = array("*"), $table = "")
  {
    if (!$table)
    {
      $table = $this->table;
    }    
    //自动加limit 1 防止获取到大数据集
    if(!preg_match("/limit/i", $cond))
    {
        $cond .= ' limit 1';
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    $result = $dao->getRowWithCond($cols, $cond);
    return $result;
  }  
  /**
   * 
   * @param type $cond 查询条件
   * @param type $table 实体类名称
   * @return type 
   */
  public function getCount($cond = '1=1', $is_groupby=FALSE, $table = "")
  {
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO(Zhtx::getTable($table));
    if($is_groupby)
    {
      $result = $dao->getCountWithGroupBy($cond);
    }
    else
    {
      $result = $dao->getCountWithCond($cond);
    }    
    return $result;
  }
  /**
   *
   * @param type $cols 获取的列 数组形式
   * @param type $cond 查询条件
   * @param type $table 实体类名称
   * @return type 结果集 数组形式
   */
  public function getCols($cond, $cols = array("*"), $asArrayId = false, $table = "")
  {
     if (!$table)
     {
       $table = $this->table;
     }
     $dao = Zhtx::getDAO( Zhtx::getTable($table));
     $list = $dao->getAllSelectiveWithCond($cols, null, $cond);
     if ($asArrayId)
      {
          foreach ($list as $value)
          {
              $result[$value['id']] = $value;
          }
      }
      else
      {
          $result = $list;
      }
     return $result;
  }
  /**
   *
   * @param type $cond 查询条件
   * @param type $offset 页面数据量
   * @param type $page 当前页码
   * @param type $table 数据实体名
   * @param type $cols 所获取的列
   * @return type 数据结果集 数组形式
   */
  public function getCurrentDatas($cond, $offset = 20, $page = 1,  $cols = array("*"), $table = "")
  {
       if (!$table)
        {
             $table = $this->table;
        }
        $where = $cond . ' limit ' . $offset*($page-1) . ',' . $offset; 
        $dao = Zhtx::getDAO( Zhtx::getTable($table));
        return $dao->getAllSelectiveWithCond($cols, null, $where);
  }
   /**
    * 通过主键获取一条数据
    * @param type $primary 主键
    * @param type $cols
    * @param type $table
    * @return type 数组
    */
   public function getOneById($primary, $cols = array("*"), $table = "")
  {
        if (!$table)
        {
            $table = $this->table;
        }
        $where = 'id ='. $primary;
        $dao = Zhtx::getDAO( Zhtx::getTable($table));
        $result = $dao->getRowWithCond($cols, $where);
        return $result;
  }

  /**
   *
   * @param type $map 属性映射
   * @param type $table  实体类名称
   * @return boolean 
   */
  public function insert($map, $table = "")
  {
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    try
    {
      $this->beginTrans();
      $result = $dao->insert($map);
      $this->endTrans();
    }
    catch (Exception $e)
    {
      self::setLogMsg("Failed to insert  $table\n");
      $this->giveUpTrans();
      return false;
    }
    return $result;
  }
  
  
  /**
   *判断是否存在，如果存在更新，不存在增加。但是如果查询存在多条数据返回false
   * @param type $cond
   * @param type $map
   * @param type $table 
   */
  public function replaceByCond($map, $cond, $table = "")
  {
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    try
    {
      $result = $dao->replaceByCond($cond, $map);
    }
    catch (Exception $e)
    {
      self::setLogMsg("Failed to insert  $table\n");
      return false;
    }
    return $result;
  }
  
  /**
   *
   * replace into
   * @param type $map 数据映射
   * @param type $table 实体名称
   * @return boolean  返回值
   */
  public function replace($map, $table = "")
  {
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    try
    {
      $this->beginTrans();
      $result = $dao->replace($map);
      $this->endTrans();
    }
    catch (Exception $e)
    {
      self::setLogMsg("Failed to insert  $table\n");
      $this->giveUpTrans();
      return false;
    }
    return $result;
  }
  
  
  /**
   *
   * @param type $map  属性映射
   * @param type $cond 查询条件
   * @param type $table 实体类名称
   * @return boolean 
   */
  public function update($map, $cond, $table = "")
  {
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    try
    {
      $this->beginTrans();
      $dao->updateByCond($map, $cond);
      $this->endTrans();
    }
    catch (Exception $e)
    {
      self::setLogMsg("Failed to update by table $table cond:" . $cond . " \n");
      $this->giveUpTrans();
      return false;
    }
    return true;
  }
  /**
   *
   * @param type $map  属性映射
   * @param type $primary 主键
   * @param type $table 实体类名称
   * @return boolean 
   */
  public function updateById($map, $primary, $table = "")
  {
    if (!$table)
    {
      $table = $this->table;
    }
    $dao  = Zhtx::getDAO( Zhtx::getTable($table));
    $cond = 'id='. $primary;
    try
    {
      $this->beginTrans();
      $dao->updateByCond($map, $cond);
      $this->endTrans();
    }
    catch (Exception $e)
    {
      self::setLogMsg("Failed to update by table $table cond:" . $cond . " \n");
      $this->giveUpTrans();
      return false;
    }
    return true;
  }

  
/**
 *
 * @param type $cond   查询条件
 * @param type $table  实体类名称
 * @return boolean 
 */
  public function delete($cond, $table="")
  {
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    try
    {
      $this->beginTrans();
      $dao->deleteByCond($cond);
      $this->endTrans();
    }
    catch (Exception $e)
    {
      parent::setLogMsg("Failed to delete $table");
      $this->giveUpTrans();
      return false;
    }
    return true;
  }
  
  public function query($sql, $table="", $time_zone=null)
  {
    if (!$table)
    {
      $table = $this->table;
    }
    $dao = Zhtx::getDAO( Zhtx::getTable($table));
    return $dao->query($sql,$time_zone);
  }
  public function execute($sql)
  {
    $table = $this->table;
	$dao = Zhtx::getDAO( Zhtx::getTable($table));
    return $dao->execute($sql);
  }
  public function saveByCond($data, $cond='')
  {
      $map = Zhtx::createDataMap();
      $map->createEntry($data);
      if($cond)
      {
        return $this->update($map, $cond);
      }
      else
      {
        return $this->insert($map);
      }
    }
  
}


?>
