<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
abstract class BasePaymentInterface
{
	 public $cfg;
	 public $order_id;
	 public $orderpayment_id;
     public $post_pay_domain;
     public $orderNo;
	 
	 public function load($logic_name)
	 {
		return Zhtx::loadModule(Module::LOGIC, ucfirst($logic_name) . 'Logic');
	 }
  	
	/**
 	* 初始化配置参数
 	*/
	public function loadConfig($payment_id)
	{
        $this->post_pay_domain = FALSE;
		$paymentlogic=$this->load("payment");
        $payment = $paymentlogic->getOne('id='.$payment_id);
        if($payment)
		{
        	$this->cfg = json_decode($payment["config_param"],true);
        }
        if($payment['post_language_id'])
        {
          $language = $this->load('language')->getOneById($payment['post_language_id']);
          if($language)
          {
             $this->post_pay_domain = $language['domain_name'];
          }
        }
	}
	
	public function __construct()
    {
		
    }
	
	/**
 	* 初始化POST ORDER, ORDER_PAYMENT
 	*/
	public function initPost()
	{
		
	}
    public function getOrderPaymentTradeNo()
    {
      
    }

        /**
 	* 获取接口回调中的POST数组
 	*/
	public function getOrderPaymentId()
	{
		
	}
	
	/**
 	* 获取接口的表单数据
 	*/
	public function getInterfaceForm()
	{
		
	}
	
	/**
 	* 成功后返回
 	*/
	public function responseResult()
	{
		
	}
	
	/**
 	* 用于获取单据的MAP
 	*/
	public function getOrderPaymentMap()
	{
		
	}
	
	/**
 	* 用于获取回订单日志的MAP
 	*/
	public function getOrderLogMap()
	{
			
	}
	
	/**
 	* 用于获取回调页面结果的类型 0 为 客户端回调  1 为 服务器端回调
 	*/
	public function getResultType()
	{
		if(_g("p1")=="server")
			return 1;
		else
			return 0;
	}
}
?>