<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
require_once(APP_ROOT . "conf/site.conf.php");
require_once(APP_ROOT . "libary/util/MemcachedFactory.php");
require_once(APP_ROOT . "libary/util/MemcacheFactory.php");
class CacheFactory
{

  function __construct()
  {
    ;
  }

  /**
   * 设置缓存
   * @global type $data_cache_dir 缓存定义的目录
   * @param type $key
   * @param type $val
   * @param type $type   缓存类型，对应的是缓存目录的键值
   */
  public static function set($key, $val, $type, $time = null)
  {
    global $data_cache_dir;
    if ($data_cache_dir[$type])
    {
      if ($data_cache_dir[$type]["path"] == "memcache")
      {
        if(class_exists('Memcached'))
        {
           $mem = new MemcachedFactory();
        }
        else
        {
          $mem = new MemcacheFactory();
        }
        $mem->set($_SERVER['SERVER_NAME'] . "_" . $type . "_" . $key, $val);
        return true; 
      }   
    }
    else
    {
      return false;
    }
  }


  
  
    /**
   * 删除缓存
   * @param type $key
   * @param type $type 
   */
  public static function del($key, $type)
  {
    global $data_cache_dir;
    
    if ($data_cache_dir[$type]["path"] == "memcache")
    {
        if (class_exists('Memcached'))
        {
           $mem = new MemcachedFactory();
        }
        else
        {
          $mem = new MemcacheFactory();
        }
        $result = $mem->delete($_SERVER['SERVER_NAME'] . "_" . $type . "_" . $key);
        return $result; 
     }
    
    $file_name = $data_cache_dir[$type]["path"] . $key . ".php";
    if (file_exists($file_name))
    {
      
      if (@unlink($file_name))
      {
        return true;
      }
      else
      {
        @unlink($file_name);
      }
    }    
    return true;
  }
  
  /**
   *验证缓存是否存在，有效
   * @param type $key
   * @param type $type 
   * @param type $is_forever 
   */
  public static function chk($key, $type, $is_forever=false)
  {
    if (!CACHE && !$is_forever)
    {
      return false;
    }    
    global $data_cache_dir;
    if ($data_cache_dir[$type]["path"] == "memcache")
    {   
        if (class_exists('Memcached'))
        {
           $mem = new MemcachedFactory();
        }
        else
        {
          $mem = new MemcacheFactory();
        }
        $result = $mem->get($_SERVER['SERVER_NAME'] . "_" . $type . "_" . $key);
        return $result ? $result : false; 
     }
     else
     {
         return false;
     }

  }
  
   public static function crearAll($type)
   {
      global $data_cache_dir;
      $crear_dir = $data_cache_dir[$type]["path"];
      if ($crear_dir == "memcache")
      {
        if (class_exists('Memcached'))
        {
           $mem = new MemcachedFactory();
        }
        else
        {
          $mem = new MemcacheFactory();
        }
        return $mem->flush();
      }
      $fail_num = 0;
      if(is_dir($crear_dir))
      {
        $dh  = @opendir($crear_dir);
        while (false !== ($filename = readdir($dh))) {
          if ($filename != '.' && $filename != '..')
          {
             if(@is_file($crear_dir . $filename))
              {                       
                if(!@unlink($crear_dir . $filename))
                {
                  $fail_num++;
                }
              }
          }
          
        }
      }
      return $fail_num;
   }
}
if (!function_exists('_crearCahce'))
{
  function _crearCahce($type)
  {
    return CacheFactory::crearAll($type);
  }
}

if (!function_exists('_setcahce'))
{
  function _setcahce($key, $val, $type, $time = null)
  {
    return CacheFactory::set($key, $val, $type, $time);
  }
}



if (!function_exists('_delcahce'))
{
  function _delcahce($key, $val, $type, $time = 3600)
  {
    return CacheFactory::del($key, $type);
  }
}


if (!function_exists('_chkcahce'))
{
  function _chkcahce($key, $type, $is_forever=false)
  {
    return CacheFactory::chk($key, $type, $is_forever);
  }
}

?>
