<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class Common {
    
    public static function get_language() {
        $language_config = array();
        $fp = opendir('./languages/');
        while ($file = readdir($fp)) {
            if ($file != '.' && $file != '..' && $file != '.svn') {
                if (is_dir('./languages/' . $file)) {
                    $language_config[$file] = trim($file);
                }
            }
        }
        return $language_config;
    }
    
    public static function add_domain($arr, $domain) {
        
        $url_info = parse_url($domain);
        if(is_array($arr)){
            for ($index = 0; $index < count($arr); $index++) {
                $url = $arr[$index];
                $website = $url_info['scheme'] . '://' . $url_info['host'];
                if (strpos($url, '://') === FALSE) {
                    $first_str = substr($url, 0, 1);
                    $arr[$index] = $website . ($first_str=='/' ? '' : '/') . $url;
                }
            }
        }else{
            $url = $arr;
            $website = $url_info['scheme'] . '://' . $url_info['host'];
            if (strpos($url, '://') === FALSE) {
                $first_str = substr($url, 0, 1);
                $arr = $website . ($first_str=='/' ? '' : '/') . $url;
            }
        }
        return $arr;
    }

    public static function get_sub_content($str, $start, $end) {
        if ($start == '' || $end == '') {
            return;
        }
        $str = explode($start, $str);
        $str = explode($end, $str[1]);
        return $str[0];
    }

    public static function preg_info($pattern, $html, $url) {
        //$pattern="/<h3[\s]*class=\"itemTitle\"><a[\s]*href=\"([^>\"]+)\"[^>]*>/i";
        preg_match_all($pattern, $html, $matches);
        $parr = array();
        $parr = $matches[1];
        if ($url)
            $parr = Common::add_domain($parr, $url);
        return $parr;
    }
    
    /**
     * 计算两个时区间的差值
     * @param type $remote_tz
     * @param type $origin_tz
     * @return boolean
     */
    static function get_timezone_offset($remote_tz, $origin_tz = null)
    {
        if($origin_tz === null) {
            if(!is_string($origin_tz = date_default_timezone_get())) {
                return false; // A UTC timestamp was returned -- bail out!
            }
        }
        $origin_dtz = new DateTimeZone($origin_tz);
        $remote_dtz = new DateTimeZone($remote_tz);
        $origin_dt = new DateTime("now", $origin_dtz);
        $remote_dt = new DateTime("now", $remote_dtz);
        $offset = $origin_dtz->getOffset($origin_dt) - $remote_dtz->getOffset($remote_dt);
        return $offset;
    }
    
    /**
     * 反解js，escape功能函数
     */
    static function jsUnescape($str) 
    { 
        $ret = ''; 
        $len = strlen($str); 
        for ($i = 0; $i < $len; $i++) 
        { 
            if ($str[$i] == '%' && $str[$i+1] == 'u') 
            { 
                $val = hexdec(substr($str, $i+2, 4)); 
                if ($val < 0x7f) 
                    $ret .= chr($val); 
                else if($val < 0x800) 
                    $ret .= chr(0xc0|($val>>6)).chr(0x80|($val&0x3f)); 
                else 
                    $ret .= chr(0xe0|($val>>12)).chr(0x80|(($val>>6)&0x3f)).chr(0x80|($val&0x3f)); 
                $i += 5; 
            } 
            else if ($str[$i] == '%') 
            { 
                $ret .= urldecode(substr($str, $i, 3)); 
                $i += 2; 
            } 
            else $ret .= $str[$i]; 
        } 
        return $ret; 
    } 
    /**
     * 返回经addslashes处理过的字符串或数组
     * @param $string 需要处理的字符串或数组
     * @return mixed
     */
    static function newAddslashes($string) {
        if (!is_array($string))
            return addslashes($string);
        foreach ($string as $key => $val)
            $string[$key] = addslashes($val);
        return $string;
    }

    /**
     * 返回经stripslashes处理过的字符串或数组
     * @param $string 需要处理的字符串或数组
     * @return mixed
     */
    static function newStripslashes($string) {
        if (!is_array($string))
            return stripslashes($string);
        foreach ($string as $key => $val)
            $string[$key] = stripslashes($val);
        return $string;
    }

    /**
     * 返回经htmlspecialchars处理过的字符串或数组
     * @param $obj 需要处理的字符串或数组
     * @return mixed
     */
    static function newHtmlSpecialChars($string) {
        if (!is_array($string))
            return htmlspecialchars($string);
        foreach ($string as $key => $val)
            $string[$key] = htmlspecialchars($val);
        return $string;
    }

    /**
     * 安全过滤函数
     * @param $string
     * @return string
     */
    static function safeReplace($string) {
        //$string = str_replace('%20', '', $string);
        $string = str_replace('%27', '', $string);
        $string = str_replace('%2527', '', $string);
        $string = str_replace('*', '', $string);
        $string = str_replace('"', '&quot;', $string);
        $string = str_replace("'", '', $string);
        $string = str_replace('"', '', $string);
        $string = str_replace(';', '', $string);
        $string = str_replace('<', '&lt;', $string);
        $string = str_replace('>', '&gt;', $string);
        $string = str_replace("{", '', $string);
        $string = str_replace('}', '', $string);
        return $string;
    }

    /**
     * 过滤ASCII码从0-28的控制字符
     * @return String
     */
    static function trimUnsafeControlChars($str) {
        $rule = '/[' . chr(1) . '-' . chr(8) . chr(11) . '-' . chr(12) . chr(14) . '-' . chr(31) . ']*/';
        return str_replace(chr(0), '', preg_replace($rule, '', $str));
    }

    /**
     * 格式化文本域内容
     * @param $string 文本域内容
     * @return string
     */
    static function trimTextArea($string) {
        $string = nl2br(str_replace(' ', '&nbsp;', $string));
        return $string;
    }

    /**
     * 将文本格式成适合js输出的字符串
     * @param string $string 需要处理的字符串
     * @param intval $isjs 是否执行字符串格式化，默认为执行
     * @return string 处理后的字符串
     */
    static function formatJs($string, $isjs = 1) {
        $string = addslashes(str_replace(array("\r", "\n"), array('', ''), $string));
        return $isjs ? 'document.write("' . $string . '");' : $string;
    }

    /**
     * 转义 javascript 代码标记
     * @param $str
     * @return mixed
     */
    static function trimScript($str) {
        $str = preg_replace('/\<([\/]?)script([^\>]*?)\>/si', '&lt;\\1script\\2&gt;', $str);
        $str = preg_replace('/\<([\/]?)iframe([^\>]*?)\>/si', '&lt;\\1iframe\\2&gt;', $str);
        $str = preg_replace('/\<([\/]?)frame([^\>]*?)\>/si', '&lt;\\1frame\\2&gt;', $str);
        $str = preg_replace('/]]\>/si', ']] >', $str);
        return $str;
    }

    /**
     * 获取当前页面完整URL地址
     */
    static function getUrl() {
        $sys_protocal = isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '443' ? 'https://' : 'http://';
        $php_self = $_SERVER['PHP_SELF'] ? self::safeReplace($_SERVER['PHP_SELF']) : self::safeReplace($_SERVER['SCRIPT_NAME']);
        $path_info = isset($_SERVER['PATH_INFO']) ? self::safeReplace($_SERVER['PATH_INFO']) : '';
        $relate_url = isset($_SERVER['REQUEST_URI']) ? self::safeReplace($_SERVER['REQUEST_URI']) : $php_self . (isset($_SERVER['QUERY_STRING']) ? '?' . self::safeReplace($_SERVER['QUERY_STRING']) : $path_info);
        return $sys_protocal . (isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '') . $relate_url;
    }

    /**
     * 字符截取 支持UTF8/GBK
     * @param $string
     * @param $length
     * @param $dot
     */
    static function strCut($string, $length, $dot = '...') {
        $strlen = strlen($string);
        if ($strlen <= $length)
            return $string;
        $string = str_replace(array(' ', '&nbsp;', '&amp;', '&quot;', '&#039;', '&ldquo;', '&rdquo;', '&mdash;', '&lt;', '&gt;', '&middot;', '&hellip;'), array('∵', ' ', '&', '"', "'", '“', '”', '—', '<', '>', '·', '…'), $string);
        $strcut = '';
        if (strtolower(CHARSET) == 'utf-8') {
            $length = intval($length - strlen($dot) - $length / 3);
            $n = $tn = $noc = 0;
            while ($n < strlen($string)) {
                $t = ord($string[$n]);
                if ($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
                    $tn = 1;
                    $n++;
                    $noc++;
                } elseif (194 <= $t && $t <= 223) {
                    $tn = 2;
                    $n += 2;
                    $noc += 2;
                } elseif (224 <= $t && $t <= 239) {
                    $tn = 3;
                    $n += 3;
                    $noc += 2;
                } elseif (240 <= $t && $t <= 247) {
                    $tn = 4;
                    $n += 4;
                    $noc += 2;
                } elseif (248 <= $t && $t <= 251) {
                    $tn = 5;
                    $n += 5;
                    $noc += 2;
                } elseif ($t == 252 || $t == 253) {
                    $tn = 6;
                    $n += 6;
                    $noc += 2;
                } else {
                    $n++;
                }
                if ($noc >= $length) {
                    break;
                }
            }
            if ($noc > $length) {
                $n -= $tn;
            }
            $strcut = substr($string, 0, $n);
            $strcut = str_replace(array('∵', '&', '"', "'", '“', '”', '—', '<', '>', '·', '…'), array(' ', '&amp;', '&quot;', '&#039;', '&ldquo;', '&rdquo;', '&mdash;', '&lt;', '&gt;', '&middot;', '&hellip;'), $strcut);
        } else {
            $dotlen = strlen($dot);
            $maxi = $length - $dotlen - 1;
            $current_str = '';
            $search_arr = array('&', ' ', '"', "'", '“', '”', '—', '<', '>', '·', '…', '∵');
            $replace_arr = array('&amp;', '&nbsp;', '&quot;', '&#039;', '&ldquo;', '&rdquo;', '&mdash;', '&lt;', '&gt;', '&middot;', '&hellip;', ' ');
            $search_flip = array_flip($search_arr);
            for ($i = 0; $i < $maxi; $i++) {
                $current_str = ord($string[$i]) > 127 ? $string[$i] . $string[++$i] : $string[$i];
                if (in_array($current_str, $search_arr)) {
                    $key = $search_flip[$current_str];
                    $current_str = str_replace($search_arr[$key], $replace_arr[$key], $current_str);
                }
                $strcut .= $current_str;
            }
        }
        return $strcut . $dot;
    }

    /**
     * 获取请求ip
     * @return ip地址
     */
    static function ip() {
        if (!empty($_SERVER['HTTP_CLIENT_IP']))  
        {  
            $ip=$_SERVER['HTTP_CLIENT_IP'];  
        }  
        elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))  
        {  
            $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];  
        }  
        else 
        {  
            $ip=$_SERVER['REMOTE_ADDR'];  
        }
        $ips = explode(',', $ip);
        if(count($ips>1)){
            $ip	=$ips[0];
        }
        return $ip;

    }
	
	static function server_ip() 
	{ 
    if (isset($_SERVER)) { 
        if($_SERVER['SERVER_ADDR']) {
            $s_ip = $_SERVER['SERVER_ADDR']; 
        } else { 
            $s_ip = $_SERVER['LOCAL_ADDR']; 
        } 
    } else { 
        $s_ip = getenv('SERVER_ADDR');
    } 
    return $s_ip; 
	}

    static function getCostTime() {
        $microtime = microtime(TRUE);
        return $microtime - SYS_START_TIME;
    }

    /**
     * 程序执行时间
     * @return	int	单位ms
     */
    static function executeTime() {
        $stime = explode(' ', SYS_START_TIME);
        $etime = explode(' ', microtime());
        return number_format(($etime [1] + $etime [0] - $stime [1] - $stime [0]), 6);
    }

    /**
     * 产生随机字符串
     *
     * @param    int        $length  输出长度 
     * @param    string     $chars   可选的 ，默认为 0123456789
     * @return   string     字符串
     */
    static function random($length, $chars = '0123456789') {
        $hash = '';
        $max = strlen($chars) - 1;
        for ($i = 0; $i < $length; $i++) {
            $hash .= $chars[mt_rand(0, $max)];
        }
        return $hash;
    }

    /**
     * 将字符串转换为数组
     *
     * @param	string	$data	字符串
     * @return	array	返回数组格式，如果，data为空，则返回空数组
     */
    static function string2array($data) {
        if ($data == '')
            return array();
        eval("\$array = $data;");
        return $array;
    }

    /**
     * 将数组转换为字符串
     *
     * @param	array	$data		数组
     * @param	bool	$isformdata	如果为0，则不使用new_stripslashes处理，可选参数，默认为1
     * @return	string	返回字符串，如果，data为空，则返回空
     */
    static function array2string($data, $isformdata = 1) {
        if ($data == '')
            return '';
        if ($isformdata)
            $data = new_stripslashes($data);
        return addslashes(var_export($data, TRUE));
    }

    /**
     * 转换字节数为其他单位
     *
     * @param	string	$filesize	字节大小
     * @return	string	返回大小
     */
    static function sizeCount($filesize) {
        if ($filesize >= 1073741824) {
            $filesize = round($filesize / 1073741824 * 100) / 100 . ' GB';
        } elseif ($filesize >= 1048576) {
            $filesize = round($filesize / 1048576 * 100) / 100 . ' MB';
        } elseif ($filesize >= 1024) {
            $filesize = round($filesize / 1024 * 100) / 100 . ' KB';
        } else {
            $filesize = $filesize . ' Bytes';
        }
        return $filesize;
    }

    /**
     * 语言文件处理
     *
     * @param	string		$language	标示符
     * @param	string		$module
     * @return	string		语言字符
     */
    static function lang($ctl = '', $module = "admin", $language = "zh-cn", $themes='default') {
        static $LANG = array();
        static $LANG_MODULES = array();
        if (!$LANG) {
            require APP_ROOT . 'languages' . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . 'system.lang.php';
        }
        if (!empty($module)) {
            $filename = APP_ROOT . 'languages' . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . strtolower($module) . DIRECTORY_SEPARATOR . strtolower($ctl) . '.lang.php';
            if (file_exists($filename))
                require $filename;
        }
        $dev_file = APP_ROOT . 'languages' . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . 'develop.lang.php';
        if(file_exists($dev_file))
        {
          require $dev_file;
        }
        if($themes)
        {
          $theme_lang_file = THEME_ROOT.$themes.DIRECTORY_SEPARATOR.'language.conf.php';
          if(file_exists($theme_lang_file))
          {
            require $theme_lang_file;
          }
        }
        return $LANG;
    }

    /**
     * 输出自定义错误
     * 
     * @param $errno 错误号
     * @param $errstr 错误描述
     * @param $errfile 报错文件地址
     * @param $errline 错误行号
     * @return string 错误提示
     */
    static function myErrorHandler($errno, $errstr, $errfile, $errline) {
        if ($errno == 8)
            return '';
        $errfile = str_replace(ROOT_PATH, '', $errfile);
        $str = '<div style="font-size:12px;text-align:left; border-bottom:1px solid #9cc9e0; border-right:1px solid #9cc9e0;padding:1px 4px;color:#000000;font-family:Arial, Helvetica,sans-serif;"><span>errorno:' . $errno . ',str:' . $errstr . ',file:<font color="blue">' . $errfile . '</font>,line' . $errline . '</span></div>';
        echo $str;
    }

    /**
     * 查询字符是否存在于某字符串
     * 
     * @param $haystack 字符串
     * @param $needle 要查找的字符
     * @return bool
     */
    static function strExists($haystack, $needle) {
        return !(strpos($haystack, $needle) === FALSE);
    }

    /**
     * 取得文件扩展
     * 
     * @param $filename 文件名
     * @return 扩展名
     */
    static function fileext($filename) {
        return strtolower(trim(substr(strrchr($filename, '.'), 1, 10)));
    }


    /**
     * 生成sql语句，如果传入$in_cloumn 生成格式为 IN('a', 'b', 'c')
     * @param $data 条件数组或者字符串
     * @param $front 连接符
     * @param $in_column 字段名称
     * @return string
     */
    static function toSqls($data, $front = ' AND ', $in_column = false) {
        if ($in_column && is_array($data)) {
            $ids = '\'' . implode('\',\'', $data) . '\'';
            $sql = "$in_column IN ($ids)";
            return $sql;
        } else {
            if ($front == '') {
                $front = ' AND ';
            }
            if (is_array($data) && count($data) > 0) {
                $sql = '';
                foreach ($data as $key => $val) {
                    $sql .= $sql ? " $front `$key` = '$val' " : " `$key` = '$val' ";
                }
                return $sql;
            } else {
                return $data;
            }
        }
    }

    /**
     * 分页函数
     * 
     * @param $num 信息总数
     * @param $curr_page 当前分页
     * @param $perpage 每页显示数
     * @param $urlrule URL规则
     * @param $array 需要传递的数组，用于增加额外的方法
     * @return 分页
     */
    static function pages($num, $curr_page, $perpage = 20, $urlrule = '', $array = array(), $setpages = 5) {
        if (defined('URLRULE') && $urlrule == '') {
            $urlrule = URLRULE;
            $array = $GLOBALS['URL_ARRAY'];
        } elseif ($urlrule == '') {
            $urlrule = self::urlPar('page={$page}');
        }
        $multipage = '';
        if ($num > $perpage) {
            $page = $setpages + 1;
            $offset = ceil($setpages / 2 - 1);
            $pages = ceil($num / $perpage);
            $curr_page = $curr_page > $pages ? $pages : $curr_page;
            if (defined('IN_ADMIN') && !defined('PAGES'))
                define('PAGES', $pages);
            $from = $curr_page - $offset;
            $to = $curr_page + $offset;
            $more = 0;
            if ($page >= $pages) {
                $from = 2;
                $to = $pages - 1;
            } else {
                if ($from <= 1) {
                    $to = $page - 1;
                    $from = 2;
                } elseif ($to >= $pages) {
                    $from = $pages - ($page - 2);
                    $to = $pages - 1;
                }
                $more = 1;
            }

            $multipage .= '<span class="text">共' . $num . '条&nbsp;</span> ';
            if ($curr_page > 0) {

                if ($curr_page == 1) {
                    $multipage .= ' <a class="goleft" href="###"><span>&nbsp;</span></a>';
                    $multipage .= ' <a class="cur" href="###"><span>1</span></a>';
                } elseif ($curr_page > 4 && $more) {
                    $multipage .= ' <a href="' . self::pageurl($num, $urlrule, $curr_page - 1, $array) . '" class="prev goleft"><span>&nbsp;</span></a>';
                    $multipage .= ' <a href="' . self::pageurl($num, $urlrule, 1, $array) . '">1</a><span class="ellipsis">...</span>';
                } else {
                    $multipage .= ' <a href="' . self::pageurl($num, $urlrule, $curr_page - 1, $array) . '" class="prev goleft"><span>&nbsp;</span></a>';
                    $multipage .= ' <a href="' . self::pageurl($num, $urlrule, 1, $array) . '"><span>1</span></a>';
                }
            }
            for ($i = $from; $i <= $to; $i++) {
                if ($i != $curr_page) {
                    $multipage .= ' <a href="' . self::pageurl($num, $urlrule, $i, $array) . '"><span>' . $i . '</span></a>';
                } else {
                    $multipage .= ' <a href="#" class="cur"><span>' . $i . '</span></a>';
                }
            }
            if ($curr_page < $pages) {
                if ($curr_page < $pages - 5 && $more) {

                    $multipage .= '<span class="ellipsis">...</span> <a href="' . self::pageurl($num, $urlrule, $pages, $array) . '"><span>' . $pages . '</span></a> <a href="' . self::pageurl($num, $urlrule, $curr_page + 1, $array) . '" class="next goright"><span>&nbsp;</span></a>';
                } else {

                    $multipage .= ' <a href="' . self::pageurl($num, $urlrule, $pages, $array) . '"><span>' . $pages . '</span></a> <a href="' . self::pageurl($num, $urlrule, $curr_page + 1, $array) . '" class="next goright"><span>&nbsp;</span></a>';
                }
            } elseif ($curr_page == $pages) {

                $multipage .= ' <a class="cur" href="#"><span>' . $pages . '</span></a> <span class="next goright"><span>&nbsp;</span></span>';
            } else {

                $multipage .= ' <a href="' . self::pageurl($num, $urlrule, $pages, $array) . '"><span>' . $pages . '</span></a> <a href="' . sepageurl($num, $urlrule, $curr_page + 1, $array) . '" class="next goright"><span>&nbsp;</span></a>';
            }

//加入跳转
            parse_str($_SERVER['QUERY_STRING'], $parqs);
            $querystr = "";
            foreach ($parqs as $k => $v) {
                if ($k == 'pxhash' || $k == 'page' || $k == 'pagenum') {
                    continue;
                }
                if (is_array($v)) {
                    foreach ($v AS $sk => $sv) {
                        $querystr .= '<input type="hidden" name="' . $k . '[' . $sk . ']' . '" value="' . $sv . '" />';
                    }
                } else {
                    $querystr .= '<input type="hidden" name="' . $k . '" value="' . $v . '" />';
                }
            }
            $multipage .= ' <form method="get" action="" style="margin:0px;display:inline;">' . $querystr . '跳转到: <input type="text" class="pageinput" name="page" /> <input type="submit" class="pagego" value="" /></form>';
        }
        return $multipage;
    }

    /**
     * 列表上方简洁页码
     * @param $pageinfo 页码信息
     * @param $urlrule URL规则
     * @param $array 需要传递的数组，用于增加额外的方法
     */
    static function topPages($pageinfo, $urlrule = '', $array = array()) {
        if (defined('URLRULE') && $urlrule == '') {
            $urlrule = URLRULE;
            $array = $GLOBALS['URL_ARRAY'];
        } elseif ($urlrule == '') {
            $urlrule = url_par('page={$page}');
        }
        $pagestr = '<span class="text">' . $pageinfo['page'] . "/" . $pageinfo['pagenums'] . "&nbsp;</span> ";
        if ($pageinfo['page'] > 1) {
            $pagestr .= '<a href="' . pageurl($pageinfo['pagenums'], $urlrule, $pageinfo['page'] - 1, $array) . '" class="prev"></a>';
        } else {
            $pagestr .= '<span class="prev"></span>';
        }

        if ($pageinfo['page'] < $pageinfo['pagenums']) {
            $pagestr .= '<a href="' . pageurl($pageinfo['pagenums'], $urlrule, $pageinfo['page'] + 1, $array) . '" class="next">下一页</a>';
        } else {
            $pagestr .= '<span class="next">下一页</span>';
        }
        return $pagestr;
    }

    /**
     * 返回分页路径
     * 
     * @param $pages 总页数
     * @param $urlrule 分页规则
     * @param $page 当前页
     * @param $array 需要传递的数组，用于增加额外的方法
     * @return 完整的URL路径
     */
    static function pageUrl($nums, $urlrule, $page, $array = array()) {
        if (strpos($urlrule, '~')) {
            $urlrules = explode('~', $urlrule);
            $urlrule = $page < 2 ? $urlrules[0] : $urlrules[1];
        }
        $findme = array('{$page}');
        $replaceme = array($page);
        if (is_array($array))
            foreach ($array as $k => $v) {
                $findme[] = '{$' . $k . '}';
                $replaceme[] = $v;
            }
        $url = str_replace($findme, $replaceme, $urlrule);
        $url = str_replace(array('http://', '//', '~'), array('~', '/', 'http://'), $url);
        $url .= "&nums=" . $nums;
        return $url;
    }

    /**
     * URL路径解析，pages 函数的辅助函数
     *
     * @param $par 传入需要解析的变量 默认为，page={$page}
     * @param $url URL地址
     * @return URL
     */
    static function urlPar($par, $url = '') {
        if ($url == '') {
            $url = self::getUrl();
        }
        $pos = strpos($url, '?');
        if ($pos === false) {
            $url .= '?' . $par;
        } else {
            $querystring = substr(strstr($url, '?'), 1);
            parse_str($querystring, $pars);
            $query_array = array();
            foreach ($pars as $k => $v) {
                if ($k == 'pxhash' || $k == 'page' || $k == 'nums' || $k == 'pagenum') {
                    continue;
                }
                $query_array[$k] = $v;
            }
            $querystring = http_build_query($query_array) . '&' . $par;
            $url = substr($url, 0, $pos) . '?' . $querystring;
        }
        return $url;
    }

    /**
     * 判断email格式是否正确
     * @param $email
     */
    static public function isEmail($email)
    {
        return (bool)preg_match('/^[-_a-z0-9\'+*$^&%=~!?{}]++(?:\.[-_a-z0-9\'+*$^&%=~!?{}]+)*+@(?:(?![-.])[-a-z0-9.]+(?<![-.])\.[a-z]{2,6}|\d{1,3}(?:\.\d{1,3}){3})(?::\d++)?$/iD', $email);
    }

    /**
     * 获取当前的站点ID
     */
    function getSiteid() {
        static $siteid;
        if (!empty($siteid))
            return $siteid;
        if (defined('IN_ADMIN')) {
            if ($d = param::get_cookie('siteid')) {
                $siteid = $d;
            } else {
                return '';
            }
        } else {
            $data = getcache('sitelist', 'commons');
            $site_url = SITE_PROTOCOL . SITE_URL;
            foreach ($data as $v) {
                if ($v['url'] == $site_url . '/')
                    $siteid = $v['siteid'];
            }
        }
        if (empty($siteid))
            $siteid = 1;
        return $siteid;
    }

    /**
     * 调用关联菜单
     * @param $linkageid 联动菜单id
     * @param $id 生成联动菜单的样式id
     * @param $defaultvalue 默认值
     */
    static function menuLinkage($linkageid = 0, $id = 'linkid', $defaultvalue = 0) {
        $linkageid = intval($linkageid);
        $datas = array();
        $datas = getcache($linkageid, 'linkage');
        $infos = $datas['data'];

        if ($datas['style'] == '1') {
            $title = $datas['title'];
            $container = 'content' . random(3) . date('is');
            if (!defined('DIALOG_INIT_1')) {
                define('DIALOG_INIT_1', 1);
                $string .= '<script type="text/javascript" src="' . JS_PATH . 'dialog.js"></script>';
//TODO $string .= '<link href="'.CSS_PATH.'dialog.css" rel="stylesheet" type="text/css">';
            }
            if (!defined('LINKAGE_INIT_1')) {
                define('LINKAGE_INIT_1', 1);
                $string .= '<script type="text/javascript" src="' . JS_PATH . 'linkage/js/pop.js"></script>';
            }
            $var_div = $defaultvalue && (ROUTE_A == 'edit' || ROUTE_A == 'account_manage_info' || ROUTE_A == 'info_publish' || ROUTE_A == 'orderinfo') ? menu_linkage_level($defaultvalue, $linkageid, $infos) : $datas['title'];
            $var_input = $defaultvalue && (ROUTE_A == 'edit' || ROUTE_A == 'account_manage_info' || ROUTE_A == 'info_publish') ? '<input type="hidden" name="info[' . $id . ']" value="' . $defaultvalue . '">' : '<input type="hidden" name="info[' . $id . ']" value="">';
            $string .= '<div name="' . $id . '" value="" id="' . $id . '" class="ib">' . $var_div . '</div>' . $var_input . ' <input type="button" name="btn_' . $id . '" class="button" value="' . L('linkage_select') . '" onclick="open_linkage(\'' . $id . '\',\'' . $title . '\',' . $container . ',\'' . $linkageid . '\')">';
            $string .= '<script type="text/javascript">';
            $string .= 'var returnid_' . $id . '= \'' . $id . '\';';
            $string .= 'var returnkeyid_' . $id . ' = \'' . $linkageid . '\';';
            $string .= 'var ' . $container . ' = new Array(';
            foreach ($infos AS $k => $v) {
                if ($v['parentid'] == 0) {
                    $s[] = 'new Array(\'' . $v['linkageid'] . '\',\'' . $v['name'] . '\',\'' . $v['parentid'] . '\')';
                } else {
                    continue;
                }
            }
            $s = implode(',', $s);
            $string .=$s;
            $string .= ')';
            $string .= '</script>';
        } else {
            $title = $defaultvalue ? $infos[$defaultvalue]['name'] : $datas['title'];
            $colObj = random(3) . date('is');
            $string = '';
            if (!defined('LINKAGE_INIT')) {
                define('LINKAGE_INIT', 1);
                $string .= '<script type="text/javascript" src="' . JS_PATH . 'linkage/js/mln.colselect.js"></script>';
                if (defined('IN_ADMIN')) {
                    $string .= '<link href="' . JS_PATH . 'linkage/style/admin.css" rel="stylesheet" type="text/css">';
                } else {
                    $string .= '<link href="' . JS_PATH . 'linkage/style/css.css" rel="stylesheet" type="text/css">';
                }
            }
            $string .= '<input type="hidden" name="info[' . $id . ']" value="1"><div id="' . $id . '"></div>';
            $string .= '<script type="text/javascript">';
            $string .= 'var colObj' . $colObj . ' = {"Items":[';

            foreach ($infos AS $k => $v) {
                $s .= '{"name":"' . $v['name'] . '","topid":"' . $v['parentid'] . '","colid":"' . $k . '","value":"' . $k . '","fun":function(){}},';
            }

            $string .= substr($s, 0, -1);
            $string .= ']};';
            $string .= '$("#' . $id . '").mlnColsel(colObj' . $colObj . ',{';
            $string .= 'title:"' . $title . '",';
            $string .= 'value:"' . $defaultvalue . '",';
            $string .= 'width:100';
            $string .= '});';
            $string .= '</script>';
        }
        return $string;
    }

    /**
     * 联动菜单层级
     */
    static function menuLinkageLevel($linkageid, $keyid, $infos, $result = array()) {
        if (array_key_exists($linkageid, $infos)) {
            $result[] = $infos[$linkageid]['name'];
            return menu_linkage_level($infos[$linkageid]['parentid'], $keyid, $infos, $result);
        }
        krsort($result);
        return implode(' > ', $result);
    }

    /**
     * 通过catid获取显示菜单完整结构
     * @param  $menuid 菜单ID
     * @param  $cache_file 菜单缓存文件名称
     * @param  $cache_path 缓存文件目录
     * @param  $key 取得缓存值的键值名称
     * @param  $parentkey 父级的ID
     * @param  $linkstring 链接字符
     */
    static function menuLevel($menuid, $cache_file, $cache_path = 'commons', $key = 'catname', $parentkey = 'parentid', $linkstring = ' > ', $result = array()) {
        $menu_arr = getcache($cache_file, $cache_path);
        if (array_key_exists($menuid, $menu_arr)) {
            $result[] = $menu_arr[$menuid][$key];
            return menu_level($menu_arr[$menuid][$parentkey], $cache_file, $cache_path, $key, $parentkey, $linkstring, $result);
        }
        krsort($result);
        return implode($linkstring, $result);
    }

    /**
     * 通过id获取显示联动菜单
     * @param  $linkageid 联动菜单ID
     * @param  $keyid 菜单keyid
     * @param  $space 菜单间隔符
     * @param  $tyoe 1 返回间隔符链接，完整路径名称 3 返回完整路径数组，2返回当前联动菜单名称，4 直接返回ID
     * @param  $result 递归使用字段1
     * @param  $infos 递归使用字段2
     */
    static function getLinkage($linkageid, $keyid, $space = '>', $type = 1, $result = array(), $infos = array()) {
        if ($space == '' || !isset($space))
            $space = '>';
        if (!$infos) {
            $datas = getcache($keyid, 'linkage');
            $infos = $datas['data'];
        }
        if ($type == 1 || $type == 3 || $type == 4) {
            if (array_key_exists($linkageid, $infos)) {
                $result[] = ($type == 1) ? $infos[$linkageid]['name'] : (($type == 4) ? $linkageid : $infos[$linkageid]);
                return get_linkage($infos[$linkageid]['parentid'], $keyid, $space, $type, $result, $infos);
            } else {
                if (count($result) > 0) {
                    krsort($result);
                    if ($type == 1 || $type == 4)
                        $result = implode($space, $result);
                    return $result;
                } else {
                    return $result;
                }
            }
        } else {
            return $infos[$linkageid]['name'];
        }
    }

    /**
     * IE浏览器判断
     */
    static function isIe() {
        $useragent = strtolower($_SERVER['HTTP_USER_AGENT']);
        if ((strpos($useragent, 'opera') !== false) || (strpos($useragent, 'konqueror') !== false))
            return false;
        if (strpos($useragent, 'msie ') !== false)
            return true;
        return false;
    }

    /**
     * 文件下载
     * @param $filepath 文件路径
     * @param $filename 文件名称
     */
    static function fileDown($filepath, $filename = '') {
        if (!$filename)
            $filename = basename($filepath);
        if (is_ie())
            $filename = rawurlencode($filename);
        $filetype = fileext($filename);
        $filesize = sprintf("%u", filesize($filepath));
        if (ob_get_length() !== false)
            @ob_end_clean();
        header('Pragma: public');
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
        header('Cache-Control: no-store, no-cache, must-revalidate');
        header('Cache-Control: pre-check=0, post-check=0, max-age=0');
        header('Content-Transfer-Encoding: binary');
        header('Content-Encoding: none');
        header('Content-type: ' . $filetype);
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Content-length: ' . $filesize);
        readfile($filepath);
        exit;
    }

    /**
     * 判断字符串是否为utf8编码，英文和半角字符返回ture
     * @param $string
     * @return bool
     */
    static function isUtf8($string) {
        return preg_match('%^(?:
					[\x09\x0A\x0D\x20-\x7E] # ASCII
					| [\xC2-\xDF][\x80-\xBF] # non-overlong 2-byte
					| \xE0[\xA0-\xBF][\x80-\xBF] # excluding overlongs
					| [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2} # straight 3-byte
					| \xED[\x80-\x9F][\x80-\xBF] # excluding surrogates
					| \xF0[\x90-\xBF][\x80-\xBF]{2} # planes 1-3
					| [\xF1-\xF3][\x80-\xBF]{3} # planes 4-15
					| \xF4[\x80-\x8F][\x80-\xBF]{2} # plane 16
					)*$%xs', $string);
    }

    /**
     * 组装生成ID号
     * @param $modules 模块名
     * @param $contentid 内容ID
     * @param $siteid 站点ID
     */
    static function idEncode($modules, $contentid, $siteid) {
        return urlencode($modules . '-' . $contentid . '-' . $siteid);
    }

    /**
     * 解析ID
     * @param $id 评论ID
     */
    static function idDecode($id) {
        return explode('-', $id);
    }

    /**
     * 对用户的密码进行加密
     * @param $password
     * @param $encrypt //传入加密串，在修改密码时做认证
     * @return array/password
     */
    static function password($password, $encrypt = '') {
        $pwd = array();
        $pwd['encrypt'] = $encrypt ? $encrypt : self::createRandomstr();
        $pwd['password'] = md5(md5(trim($password)) . $pwd['encrypt']);
        return $encrypt ? $pwd['password'] : $pwd;
    }

    /**
     * 生成随机字符串
     * @param string $lenth 长度
     * @return string 字符串
     */
    static function createRandomstr($lenth = 6) {
        return random($lenth, '123456789abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ');
    }

    /**
     * 检查密码长度是否符合规定以及字符
     *
     * @param STRING $password
     * @return 	TRUE or FALSE
     */
    static function isPassword($password) {
      
       $strlen = strlen($password);
        if (!preg_match("/^[a-zA-Z0-9]+$/", $password)) {
            return false;
        } elseif (30 <= $strlen || $strlen < 6) {
            return false;
        }
        return true;
    }

    /**
     * 检测输入中是否含有错误字符
     *
     * @param char $string 要检查的字符串名称
     * @return TRUE or FALSE
     */
    static function isBadword($string) {
        $badwords = array("\\", '&', ' ', "'", '"', '/', '*', ',', '<', '>', "\r", "\t", "\n", "#");
        foreach ($badwords as $value) {
            if (strpos($string, $value) !== FALSE) {
                return TRUE;
            }
        }
        return FALSE;
    }

    /**
     * 检查用户名是否符合规定
     *
     * @param STRING $username 要检查的用户名
     * @return 	TRUE or FALSE
     */
    static function isUsername($username) {
        $strlen = strlen($username);
        if (is_badword($username) || !preg_match("/^[a-zA-Z0-9_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]+$/", $username)) {
            return false;
        } elseif (20 <= $strlen || $strlen < 2) {
            return false;
        }
        return true;
    }

    /**
     * 检查id是否存在于数组中
     * 
     * @param $id
     * @param $ids
     * @param $s
     */
    static function checkIn($id, $ids = '', $s = ',') {
        if (!$ids)
            return false;
        $ids = explode($s, $ids);
        return is_array($id) ? array_intersect($id, $ids) : in_array($id, $ids);
    }

    /**
     * 对数据进行编码转换
     * @param array/string $data       数组
     * @param string $input     需要转换的编码
     * @param string $output    转换后的编码
     */
    static function arrayIconv($data, $input = 'gbk', $output = 'utf-8') {
        
    }

    /**
     * 生成缩略图函数
     * @param  $imgurl 图片路径
     * @param  $width  缩略图宽度
     * @param  $height 缩略图高度
     * @param  $autocut 是否自动裁剪 默认裁剪，当高度或宽度有一个数值为0是，自动关闭
     * @param  $smallpic 无图片是默认图片路径
     */
    function thumb($imgurl, $width = 100, $height = 100, $autocut = 1, $smallpic = 'nopic.gif') {
        
    }

    /**
     * 水印添加
     * @param $source 原图片路径
     * @param $target 生成水印图片途径，默认为空，覆盖原图
     * @param $siteid 站点id，系统需根据站点id获取水印信息
     */
    function waterMark($source, $target = '', $siteid) {
        
    }

    /**
     * 获取站点的信息
     * @param $siteid   站点ID
     */
    function siteinfo($siteid) {
        static $sitelist;
        if (empty($sitelist))
            $sitelist = getcache('sitelist', 'commons');
        return isset($sitelist[$siteid]) ? $sitelist[$siteid] : '';
    }

    /**
     * 文本转换为图片
     * @param string $txt 图形化文本内容
     * @param int $fonttype 无外部字体时生成文字大小，取值范围1-5
     * @param int $fontsize 引入外部字体时，字体大小
     * @param string $font 字体名称 字体请放于phpcms\libs\data\font下
     * @param string $fontcolor 字体颜色 十六进制形式 如FFFFFF,FF0000
     */
    function string2img($txt, $fonttype = 5, $fontsize = 16, $font = '', $fontcolor = 'FF0000', $transparent = '1') {
        if (empty($txt))
            return false;
        if (function_exists("imagepng")) {
            $txt = urlencode(sys_auth($txt));
            $txt = '<img src="' . APP_PATH . 'api.php?op=creatimg&txt=' . $txt . '&fonttype=' . $fonttype . '&fontsize=' . $fontsize . '&font=' . $font . '&fontcolor=' . $fontcolor . '&transparent=' . $transparent . '" align="absmiddle">';
        }
        return $txt;
    }

    /**
     * 获取完整时间=Unix时间戳+微秒数
     * @return type
     */
    function getMicrotime() {
        list($usec, $sec) = explode(" ", microtime());
        return ((float) $usec + (float) $sec);
    }

    /**
     *
     * @param type $name   文本域名称
     * @param type $value  值
     * @param type $width  宽度
     * @param type $height 高度
     * @param type $toobarset 功能图标
     * @param type $skinpath  皮肤
     */
    function getFck($name = 'content', $value = '', $width = "95%", $height = "350px", $toobarset = 'default', $skinpath = 'skins/default/') {
        $editor = new FCKeditor($name);
        $editor->Value = $value;
        $editor->BasePath = FCK_ROOT;
        $editor->Height = $height;
        $editor->Width = $width;
        $editor->ToolbarSet = $toobarset;
        $editor->Config["SkinPath"] = $editor->BasePath . $skinpath;
        $content_html = $editor->CreateHtml();
        return $content_html;
    }

    /**
     * 后台路径处理
     * @param type $m 文件夹
     * @param type $c 控制器
     * @param type $a action
     * @param type $data 其他参数
     * @return string 路径url
     */
    static function adminURL($model = 'admin', $controller = 'admin', $action = 'default', $data = array()) {
        $url = ADMIN_ROOT . "?m=" . $model . "&c=" . $controller . "&a=" . $action;
        if (!empty($data) && is_array($data)) {
            foreach ($data as $key => $value) {
                $url .= '&' . $key . '=' . $value;
            }
        }
        return $url;
    }

    /**
     * 字符集GBK转换成utf8
     * @param type $content
     * @return type 
     */
    static function gbk2Utf8($content) {
        if (!self::isUtf8) {
            $content = iconv("gb2312", "utf-8//IGNORE", $content);
        }
        return $content;
    }
	 /**
     * 查找菜单子节点
     * 用于菜单
     * @param array $categories
     * @param int $parentId
     * @param int $level
     * @return array
     */
    public static function getMenuTree(& $categories, $parentId = 0, $level = 0) {
        $children = array();
        foreach ($categories as $category) {
            $level = substr_count( $category["path_id"] , ',');
            if ($parentId == $category['parent_id']) {
                $children[$category['id']] = $category;
                $children[$category['id']]['child'] = self::hasSon($categories, $category['id']);
				if($children[$category['id']]['child']=="has_son")
				{
					$children[$category['id']]['has_son'] = 1;
				}
                foreach (self::getMenuTree($categories, $category['id'], $level) as $child) {
                    $children[$child['id']] = $child;
                }
            }
        }
        return $children;
    }
    /**
     * 完善分类的附属信息
     * 用于商品分类
     */
   public static function setTreeData ($categories)
	{
		foreach ($categories as $key => $value) 
	   {
		   //$result[$value["id"]] = $key; 
		   $result[$value["id"]] = $value; 
	   }
       foreach ($result as $key => $value) 
	   {
		  if($value["parent_id"]==0)
		  {
			$result[0]["son"][] = $value["id"];
			continue;
		  }
		  $result[$value["parent_id"]]["child"] = "has_son";
		  $result[$value["parent_id"]]["has_son"] = 1;
		  $result[$value["parent_id"]]["son"][] = $value["id"];
		  $level = substr_count( $value["path_id"] , ',');
		  $result[$key]["level"] = $level;
       }
	   return $result;
	}
	/**
     * 返回递归结构的数组
     * 用于商品分类
     */
    public static function getTree( $categories,&$tree,$id) 
	{

	//die();
		$son = $categories[$id]["son"];
		if($id!=0)
		{
			$tree[$id] = $categories[$id];	
		}
		foreach ($son as $item) 
		{
			self::getTree($categories,$tree, $item);
		}
    
    }
    /**
     * 判断是否有子节点
     * @param type $categories
     * @param type $parentId
     * @return string 
     */
   public static function hasSon($categories, $parentId=0)
   {
       $result = 'not_son';
       foreach ($categories as $value) {
           if($value['parent_id'] == $parentId)
           {
               $result = 'has_son';
               break;
           }
       }
       return $result;
   }

   /**
     * 默认查找子节点方法
     * @param type $array
     * @param type $parentId
     * @return type 
     */
    public static function _getTree(& $array, $parentId = 0) {
        $children = array();
        foreach ($array as $item) {
            if ($parentId == $item['parent_id']) {
                $children[$item['id']] = $item;
                foreach (self::_getTree($array, $item['id']) as $child) {
                    $children[$child['id']] = $child;
                }
            }
        }
        return $children;
    }

    /**
     * ip转换成整型
     * @param type $ip
     */
    public static function _ip2long($ip) {
        if (self::_checkip($ip)) {
            return bindec(decbin(ip2long($ip)));
        } else {
            //ip不合法
            return 0;
        }
    }

    /**
     * 验证Ip是否有效
     * @param type $ip
     * @return boolean
     */
   public static function _checkip($ip) {
        if (ip2long($ip) == "-1") {
            return false;
        }else{
            return true;
        }
  }   
    /**
     * DEBUG 打印数据格式化函数
     * @param mixed $value
     */
    public function P($value){
        echo "<pre>";
        print_r($value);
        echo "</pre>";
        exit;
    }
	
	/**
     * 获取语言变量值
     * @param mixed $value
     */
    public function L($value){
        $lang = self::lang(Core::$controller, Core::$module, Core::$language);
		return $lang[$value];
    }
	
    /**
     * 直接生成select选择框
     * @param type $array
     * @param type $name
     * @param type $defaultValue
     * @param type $defaultName
     * @return string 
     */
    public static function htmlSelect($array, $name, $defaultValue=0, $defaultName='', $disabled='')
    {
        $id = str_replace('[]', '', $name);
        $disabled = $disabled ? 'disabled=" '.$disabled . '"': '';
        $select='<select name="'.$name.'" id="'.$id.'"'.$disabled . '>';
        if($defaultName)
        {
            $select .= '<option value="0">'.$defaultName.'</option>';
        }
        foreach ($array as $item)
        {
            $checked = $item['id'] == $defaultValue ? 'selected="selected"' : '';
            $select .= '<option value="'.$item['id'].'"'.$checked.'>'.$item['base_name'].'</option>';
        }
        return $select.= '</select>';
    }
    /**
     * 构造多选框html
     * @param type $array
     * @param type $name
     * @param type $defaultValue
     * @return type 
     */
    public static function htmlMultipleSelect($array, $name, $defaultValue=array(0))
    {
        $id = str_replace('[]', '', $name);
        $select='<select multiple="multiple" size="5" name="'.$name.'" id="'.$id.'">';
        foreach ($array as $item)
        {
            $checked =  in_array($item['id'], $defaultValue)  ? 'selected="selected"' : '';
            $select .= '<option value="'.$item['id'].'"'.$checked.'>'.$item['base_name'].'</option>';
        }
        return $select.= '</select>';
    }
    /**
     * 构造checkbox
     * @param type $array 
     * @param type $name 
     * @param type $defaultArray 默认现在的数组
     * @return string 
     */
    public static function htmlCheckbox($array, $name, $defaultArray=array(0))
    {
        $checkbox = '';
        $id = str_replace('[]', '', $name);
        foreach($array as $key => $item)
        {
            $checked = in_array($item['id'], $defaultArray) ? 'checked="checked"' : '';
            $checkbox .= '<label for="'.$id.$key.'"><input type="checkbox" name="' . $name . '" value="' . $item['id'] . '"' .$checked.' id="'.$id.$key.'"> '.$item['base_name'] . '</label> ';
        }
         return $checkbox;
    }
    /**
     * 构造 radio 选择的html
     * @param type $array
     * @param type $name
     * @param type $defaultValue 默认选中
     * @return string 
     */
    public static function htmlRadio($array, $name, $defaultValue=0)
    {
        $checkbox = '';
        foreach($array as $key => $item)
        {
            $checked = $item['id'] == $defaultValue ? 'checked="checked"' : '';
            $checkbox .= '<label for="'.$name.$key.'"><input type="radio" name="' . $name . '" value="' . $item['id'] . '"' .$checked.' id="'.$name.$key.'"> '.$item['base_name'] . '</label> ';
        }
         return $checkbox;
    }   
     public static function log($message)
    {
        $fp = @fopen('log.txt', "a+");
        @fwrite($fp, date("Y-m-d H:i:s").":    $message\n");
        @fclose($fp);
    }
    /**
     * 获取整形
     * @param type $id
     * @param type $default 
     */
    public static function queryInt($string, $default = 0)
    {
        $num = $default;
        if($string)
        {
            $num = intval($string);
            if(!$num)
            {
                $num = $default;
            }
        }
        return $num;
    }
    /**
     * 获取string
     * @param type $id
     * @param type $default 
     */
    public static function queryStr($string, $default = '')
    {
        return $string ? $string : $default;
    }
    /**
     * 读取分页的参数
     * @param type $count 记录总数
     * @param type $current_page 当前页码
     * @param type $page_size 每页记录数
     * @param type $prev 上一页
     * @param type $next 下一页
     */
    public static function getPages($count, $current_page = 1, $page_size = 20)
    {
        $total_pages = ceil($count/$page_size);       
        return array(
          'url'        => self::getCurrentUrl(),
          'cur'        => $current_page,
          'count'      => $count,
          'total_pages'=> $total_pages,
          'next'       => $current_page < $total_pages ? $current_page+1 : $current_page,
          'prev'       => $current_page > 1 ? $current_page-1 : 1,
        );
    }
    /**
     * 读取当前url移除分页参数
     */
    static function getCurrentUrl() {       
          $url = self::getUrl();   
          $querystring = substr(strstr($url, '?'), 1);
          parse_str($querystring, $pars);
          $query_array = array();
          foreach ($pars as $k => $v) {
              if ($k == 'prev' || $k == 'page' || $k == 'next' || $k == 'pagenum') {
                  continue;
              }
              $query_array[$k] = $v;
          }
          $querystring = http_build_query($query_array);
          $pos = strpos($url, '?');
          $url = substr($url, 0, $pos) . '?' . $querystring;
        
        return $url;
    }
    public static function  checkRef($ref)
    {
      foreach (explode('-', $ref) as $k => $v) {
          if ($v == 'login.html' || $v == 'register.html' || $v='' || $v=='login'|| $v == 'register') {
              return  self::frontURL('home', 'account', 'index');
          }         
      }
      return $rel;
    }

    /**
     * 前台路径构造
     * @param type $m
     * @param type $c
     * @param type $a
     * @param type $data
     * @return string 
     */
    public static function frontURL($model = 'home', $controller = 'index', $action = 'index', $data = array(), $rewrite=TRUE) 
    {              
	$url = INDEX_ROOT . "?m=" . $model . "&c=" . $controller . "&a=" . $action;
        if($rewrite)
        {
            if(strtolower($model)=='home'){
                $url = FOLDER_ROOT . "h-" . $controller . "-" . $action . ".html";
            }
            else if(strtolower($model)=='wap'){
                $url = FOLDER_ROOT . "m-" . $controller . "-" . $action . ".html";
            }
             
        }
        if (!empty($data) && is_array($data)) {
          if($rewrite)
          {
			$url = $url . "?";
			$index=0;
          }
          else
          {
            $index = 1;
          }
          foreach ($data as $key => $value) {
              if($index==0)
                  $url .=  $key . '=' . $value;
              else
                  $url .= '&' . $key . '=' . $value;

              $index++;
          }
        }
        return $url;
    }
    /**
     * Detect Browser type
     * @return type 
     */
    public static function getBrowser() {
        $ua = strtolower($_SERVER['HTTP_USER_AGENT']);
        if(preg_match('/(chromium)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'chromium';
        }      
        elseif(preg_match('/(chrome)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Chrome';
        }
        elseif(preg_match('/(safari)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Safari';
        }
        elseif(preg_match('/(opera)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Opera';
        }
        elseif(preg_match('/(360se)[ \/]([\w.]+)/', $ua))
        {
            $browser = '360se';    
        }
        elseif(preg_match('/(maxthon)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Maxthon';
        }
        elseif(preg_match('/(tencent)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Tencent';
        }
        elseif(preg_match('/(green)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Green';
        }
        elseif(preg_match('/(baidu)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'baidu';
        }
        elseif(preg_match('/(theworld)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'The World';
        }
        elseif(preg_match('/(metasr)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Sogou';
        }
        elseif(preg_match('/(netscape)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Netscape';    
        }
        elseif(preg_match('/(msie)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'IE';
        }
        elseif(preg_match('/(firefox)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Firefox';
        }
        elseif(preg_match('/(gecko)[ \/]([\w.]+)/', $ua))
        {
            $browser = 'Gecko';
        }
        elseif(preg_match('/(rv)[:]([\w.]+)/', $ua))
        {
            return 'IE 11';
        }
        else 
        {
            $browser = "Unknow browser";
        }

        preg_match('/('.strtolower($browser).')[ \/]([\w]+)/', $ua, $version);

        return isset($version[2]) ? $browser . ' ' . $version[2] : $browser;       
    }
    /**
     * Detect operation system
     * @return string 
     */
    public static function getOS(){
		$os = $_SERVER['HTTP_USER_AGENT'];
		if(preg_match('/NT\s5\.1/',$os)){
			$os = "Windows XP";
		}elseif(preg_match('/NT\s6\.0/',$os)){
			$os =  "Windows Vista \ server 2008";
		}elseif(preg_match('/NT\s5\.2/',$os)){
			$os = "Windows Server 2003";
		}elseif(preg_match('/NT\s5/',$os)){
			$os = "Windows 2000";	
		}elseif(preg_match('/NT\s6\.1/',$os)){
			$os = "Windows 7";
		}elseif(preg_match('/Linux/',$os)){
			$os ="Linux";
		}elseif(preg_match('/Unix/',$os)){
			$os = "Unix";
		}elseif(preg_match('/Mac/',$os)){
			$os = "Macintosh";
		}elseif(preg_match('/NT\s6\.2/',$os)){
			$os ="Windows 8";
		}elseif(preg_match('/NT/',$os)){
		    $os ="Windows NT";
		}else{
			$os ="Unknow OS";
		}
		return $os;
	}
    /**
     * 生成sql 转义特殊字符
     * @param type $string
     * @return type 
     */
     public static function strEscape($string, $flag=TRUE) {
          if($flag)
          {
            $string = str_replace('"', " ", $string);
          }          
          $string =  mysql_escape_string($string);
        return $string;
     }
     /**
      *检测后台操作权限
      * @global type $data_cache_dir
      * @param type $role_id
      * @return boolean 
      */
     public static function validAdminRight($role_id)
     {
        $action = strtolower(_g('a'));
         if(strpos($action, 'public') !== FALSE || 
            strpos($action, 'default') !== FALSE || 
            strpos($action, 'login') !== FALSE  ||
            strpos($action, 'panel') !== FALSE  ||
            strpos($action, 'getimagesize') !== FALSE)
            {
               
            }
            else
            {
                $to = 'm=' . _g('m') . '&c=' . _g('c') ;//. '&a=' . _g('a')
                global $data_cache_dir;       
                $key = md5($role_id."_admin_right_menus"); //缓存key        
                $chk = _chkcahce($key, 'menus', TRUE);
                if(!$chk)
                {
                    $rolePrivLogic = AppController::load('adminPrivMenu');
                    $cond = 'r.role_id ='. $role_id;
                    $res  = $rolePrivLogic->getList($cond); 
                    $chk = array();
                    foreach($res['list'] as $list)
                    {
                        $right_url = 'm=' . $list['m'] . '&c=' . $list['c'];// . '&a=' . $list['a']
                        $chk[$list['id']] = $right_url;
                    }
                }
                if(!in_array($to, $chk))
                {        
                    if($action=='del' && !_g('ids'))
                    {
                        $lang = Common::lang('admin', 'admin', Core::$language);
                        $staus = 0;
                        $flag = $lang['not_permissions'];
                        echo json_encode(array('status' => $staus, 'msg' => $flag));
                        exit;
                    }
                    else
                    {
                        header("location:".Common::adminURL('admin', 'admin', 'publicNotRight'));
                        exit;
                    }
                }
            }
     }
     /**
     * 读取后台菜单语言包
     *
     * @param	string		$language	语言
     */
    public static function menuLang($language = "zh-cn") {
        static $LANG = array();
        if (!$LANG) {
            require APP_ROOT . 'languages' . DIRECTORY_SEPARATOR . $language . DIRECTORY_SEPARATOR . 'menus.lang.php';
        }      
        return $LANG;
    }
    /**
     * 验证是否进行了网站设置
     * @global type $cfg
     * @param type $key
     * @param type $language_id
     * @return type 
     */
    public static function validSiteConfig($key = 'base_site', $language_id = 0)
    {
        global $cfg;
        return isset($cfg['sites'][$language_id][$key]) ? $cfg['sites'][$language_id][$key] : FALSE;
    }
    /**
     * 创建目录
     * @param type $path
     * @param type $mode
     * @return type 
     */
    public static function rmkdir($path, $mode = 0777) {
        return is_dir($path) || ( self::rmkdir(dirname($path), $mode) && self::_mkdir($path, $mode) );
    }
    /**
     * 创建目录
     * @param type $path
     * @param type $mode
     * @return type 
     */
    public static function _mkdir($path, $mode = 0777) {
        $old = umask(0);
        $res = @mkdir($path, $mode);
        umask($old);
        return $res;
    }	
    /**
     * 检查是否为 URL
     *
     * @param string $url
     * @return bool
     */
    static public function isUrl($url)
    {
        if (!preg_match(
            '~^

            # scheme
            [-a-z0-9+.]++://

            # username:password (optional)
            (?:
                    [-a-z0-9$_.+!*\'(),;?&=%]++   # username
                (?::[-a-z0-9$_.+!*\'(),;?&=%]++)? # password (optional)
                @
            )?

            (?:
                # ip address
                \d{1,3}+(?:\.\d{1,3}+){3}+

                | # or

                # hostname (captured)
                (
                        (?!-)[-a-z0-9]{1,63}+(?<!-)
                    (?:\.(?!-)[-a-z0-9]{1,63}+(?<!-)){0,126}+
                )
            )

            # port (optional)
            (?::\d{1,5}+)?

            # path (optional)
            (?:/.*)?

            $~iDx', $url, $matches)) {
            return FALSE;
        }

        if (!isset($matches[1])) {
            return TRUE;
        }

        if (strlen($matches[1]) > 253) {
            return FALSE;
        }

        $tld = ltrim(substr($matches[1], (int)strrpos($matches[1], '.')), '.');
        return ctype_alpha($tld[0]);
    }
	
	public static function getRemoteData($url,$charsetfrom="",$charsetto="",$timeout=60, $post_data=array())
	{
		$ch  = @curl_init();
		$a   = array(" ");
		$b   = array("%20");
		$url = str_replace($a, $b, $url);
		@curl_setopt($ch, CURLOPT_URL, $url);
                @curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		@curl_setopt($ch,CURLOPT_HEADER,0);   
		@curl_setopt($ch,CURLOPT_TIMEOUT,$timeout);   
		@curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		@curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout); 
        if(count($post_data)>0)
        {
            @curl_setopt($ch, CURLOPT_POST, 1 );
            @curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        }
		//在需要用户检测的网页里需要增加下面两行 
		//curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY); 
		//curl_setopt($ch, CURLOPT_USERPWD, US_NAME.":".US_PWD); 
		$contents = @curl_exec($ch); 
		@curl_close($ch); 
		if( $charsetfrom!="" && $charsetto!="" )
		{
			$contents = iconv($charsetfrom, $charsetto,$contents);
		}
		return $contents; 
	}
	
	public static function getLocalData($url,$host,$charsetfrom="",$charsetto="",$timeout=60, $post_data=array())
	{
		$ch  = @curl_init();
		$a   = array(" ");
		$b   = array("%20");
		$host['AUTHZH'] = "aGZoZjg5N3N4Y3Zoc2FmaDk4";
		$url = str_replace($a, $b, $url);
		@curl_setopt($ch, CURLOPT_URL, $url);
		@curl_setopt($ch,CURLOPT_HTTPHEADER,$host);  
        @curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		@curl_setopt($ch,CURLOPT_HEADER,0);   
		@curl_setopt($ch,CURLOPT_TIMEOUT,$timeout);   
		@curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		@curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout); 
        if(count($post_data)>0)
        {
            @curl_setopt($ch, CURLOPT_POST, 1 );
            @curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        }
		//在需要用户检测的网页里需要增加下面两行 
		//curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY); 
		//curl_setopt($ch, CURLOPT_USERPWD, US_NAME.":".US_PWD); 
		$contents = @curl_exec($ch); 
		@curl_close($ch); 
		if( $charsetfrom!="" && $charsetto!="" )
		{
			$contents = iconv($charsetfrom, $charsetto,$contents);
		}
		return $contents; 
	}
	
	public static function sort_rows(&$data,$field,$sort_way=SORT_ASC)
	{
		foreach ($data as $key => $row)
		{
			$volume[$key]  = $row[$field];
		}
		array_multisort($volume, $sort_way, $data);
	}
	
	public static function makeUrlName($name)
	{
		$arr_check = array('&','"',"'",'-','`','.',',','(',')','+','#','/',":");
		$arr_replace = array_fill ( 0 , count( $arr_check ) , ' ');
		$tmp = str_replace($arr_check,$arr_replace,$name);
		$tmp = preg_replace("/[\s]{2,}/"," ",$tmp);
		$tmp = urlencode(str_replace(" ","-",(trim($tmp))));
		return $tmp;	
	}
    /**
     * 价格格式
     * @param type $price
     * @param type $decimal 默认2位
     * @param type $style 默认四舍五入
     * @return type 
     */
    public static function price_format($price, $decimal = 2, $style = 0)
    {      
      $result = 0;
      if(!$style)
      {
        $result = round($price, $decimal);
      }
      else if($style == 1)
      {
        //向上取
        $pow    = pow(10, $decimal);
        $floor1 = $price*$pow;
        $floor  = floor($floor1)/$pow;
        $flag   = substr($floor1, strlen($floor1)-1);//最后一位为零的时候 
        $result = $flag ? $floor + 1/$pow : $floor;
      }
      else if($style == 2)
      {
        //向上取
        $pow    = pow(10, $decimal);
        $floor1 = $price*$pow;
        $floor  = floor($floor1)/$pow;
        $flag   = substr($floor1, strlen($floor1)-1);//最后一位为零的时候
        $result = $flag ? $floor - 1/$pow : $floor;
      }
      return $result;
    }
    /**
     * 前台价格格式
     * @param type $price
     * @param type $decimal 默认2位，补零
     * @param type $style 默认四舍五入
     * @return type 
     */
    public static function front_price_format($price, $decimal = 2, $style = 0)
    {      
        $result = self::price_format($price,$decimal,$style);
        $result = sprintf('%01.'.$decimal.'f',$result);
      return $result;
    }
     /**
     * 前台使用
     * 货币转换
     * @param type $price
     * @param type $tobase 是否转为基准货币
     * @return type 
     */
    public static function toolPrice($price, $tobase=FALSE)
    {
       global $cfg, $current_currency;
       $rate      = isset($current_currency['exchange_rate']) ? $current_currency['exchange_rate'] : 1;
       $decimal   = isset($cfg['sites'][0]['home_decimal']) ? $cfg['sites'][0]['home_decimal'] : 2;//小数点问题
       $style     = isset($cfg['sites'][0]['home_price_peri']) ? $cfg['sites'][0]['home_price_peri'] : 0;//进位
       return $tobase ? $price / $rate : self::price_format($price * $rate, $decimal, $style);
    }
     /**
   * 读取该日期的月份有多少天
   * @param type $date
   * @return int 
   */
     public static function get_days( $date )    
    {
        $time   = strtotime($date);
        $year   = date('Y', $time);;
        $month  = date('m', $time);
        if( in_array($month , array( 1 , 3 , 5 , 7 , 8 , 01 , 03 , 05 , 07 , 08 , 10 , 12)))
        {
            $days = 31;
        }
        elseif( $month == 2 )
        {
            if ( $year%400 == 0  || ($year%4 == 0 && $year%100 !== 0) )        //判断是否是闰年
            {
                $days = 29;
            }
            else{
                $days = 28;
            }
        }
        else{

            $days = 30;
        }
        return $days;
    }
    /**
     * 订单状态对应语言
     * @global type $order_cfg
     * @param type $status
     * @param type $type
     * @return type 
     */
    public static function orderStatus($status, $type='order_status')
    {
      $lang = self::lang(Core::$controller, Core::$module, Core::$language);
      global $order_cfg;
      $eg = substr($status, 0, 1);
      if($status == $eg.'00')
      {
          $return  = $lang[$order_cfg[$type][$eg.'00']['0']];
      }
      else
      {
        foreach($order_cfg[$type][$eg.'00'][1] as $key => $item)
        {
            if($key == $status)
            {
              $return  = $lang[$item];
                          break;
            }
        }
      }
      return $return;
    }
    /**
     * 读取模板配置
     */
    public static function getTplConf()
    {
       $dir = THEME_ROOT;
       if ($handle = @opendir($dir))
        {
             $tplConf = array();
             while (false !== ($file = readdir($handle))) {
               if($file != '.' && $file != '..')
               {
                 $conf = $dir. $file . '/template.conf.php';
                 if(file_exists($conf))
                 { 
                   require_once $conf;
                   $tplConf[$file] = $template;
                 }                
               }              
            }
            closedir($handle);
            return $tplConf;
        }
    }
    
    public static function getThemeDir($dir, $dirname)
    {    
        $dirfile = array();
        if($handle = @opendir($dir))
        {    
          $key = 0;
          while (false !== ($file = @readdir($handle))) {
            if($file != '.' && $file != '..' && $file != 'template.conf.php' && $file != '.svn')
            {
               $path = $dir. $file;
               $dirfile[$key] = array(
                   'name' => $file,
                   'path' => $path,
                   'dirname' => $dirname.'/'.$file
               );
               if(is_dir($path))
               {
                 $dirfile[$key]['suffix']    = 'Folder';
               }
               else
               {
                 $path_parts = pathinfo($path);
                 $dirfile[$key]['suffix'] = $path_parts['extension'];
               }
               $key++;
             }
          }
        
        }        
        return $dirfile;
    }
    /**
     * 
     * @global type $cfg
     * @global type $site_info
     * @param type $price
     * @param type $cur_market_price
     * @param type $change
     * @return type 
     */
    public static function getMarketPrice($price, $cur_market_price, $change=0)
    {
      global $cfg, $site_info;
      $symbol = $cfg['sites'][0]['marketprice_formula'];
      $diff   = $cfg['sites'][0]['marketprice'];
      if(!$cur_market_price)
      {
        switch ($symbol)
        {
          case 0: $cur_market_price = $price + $diff;
            break;
          case 1: $cur_market_price = $price - $diff;
            break;
          case 2: $cur_market_price = $price * $diff;
            break;
          case 3: $cur_market_price = $price / $diff;
            break;
          default :break;
        }
      }
      if($change)
      {//前台才会用到
        $rate      = isset($site_info['currency']['exchange_rate'])? $site_info['currency']['exchange_rate'] : 1;
        $decimal   = isset($cfg['sites'][0]['home_decimal']) ? $cfg['sites'][0]['home_decimal'] : 0;//小数点问题
        $style     = isset($cfg['sites'][0]['home_price_peri']) ? $cfg['sites'][0]['home_price_peri'] : 0;//进位
        $result    = $cur_market_price*$rate;
        $cur_market_price = self::price_format($result, $decimal, $style);
      }
      return $cur_market_price;
    }
    /**
     * 二维数组排序
     * @param type $array
     * @return type 
     */
    public static function array_sort($array, $order='asc')
    {
      $result = array();
      if($order == 'asc')
      {
          ksort($array);
      }
      else
      {
        krsort($array);
      }
      foreach ($array as $key => $value)
      {
        if(is_array($value))
        {          
          if($order == 'asc')
          {
              ksort($value);
          }
          else
          {
            krsort($value);
          }
        } 
        
        $result[$key] = $value;
      }
      return $result;
    }
    public static function unzip_file($file, $destination,$isajax=false){ 
      $zip = new ZipArchive() ; 
      if ($zip->open($file) !== TRUE ){
          if($isajax)
              return false;
          else
          die ('Could not open archive'); 
      } 
      $zip->extractTo($destination); 
      $zip->close();
      return TRUE;
    }
    /**
     * 创建一个zip压缩包
     * @param type $files
     * @param type $destination
     * @param type $overwrite
     * @return boolean 
     */
    public static function create_zip($files = array(), $destination = '', $overwrite = false)
    {
      if (file_exists($destination) && !$overwrite)
      {
        return false;
      }
      $valid_files = array(); 
      if (is_array($files))
      {
        foreach ($files as $file)
        {
          if (file_exists($file))
          {
            $valid_files[] = $file;
          }
        }
      }
      if (count($valid_files))
      {
        $zip = new ZipArchive();
        if ($zip->open($destination, $overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true)
        {
          return false;
        }
        foreach ($valid_files as $file)
        {
          $target_file = str_replace(APP_ROOT, '', $file);
          $zip->addFile($file, $target_file);
        }
        $zip->close();
        return file_exists($destination);
      }
      else
      {
        return false;
      }
    }
    
	public static function alertRedirect($msg,$url)
	{
		echo "<script>";
		echo "alert('$msg');";
		echo "location.href='$url';";
		echo "</script>";
		die();	
	}
	
    public static function unzip ($file,$fileDir) {
      if (!function_exists(zip_open)) exit("zip_* functions not found! Please check your php environment!");
      $zip = zip_open($file);
      if ($zip) {
        while ($zip_entry = zip_read($zip)) {
          $name	=	zip_entry_name($zip_entry);_debug($zip_entry);
          if (zip_entry_open($zip, $zip_entry, "r")) {
            $buf = zip_entry_read($zip_entry, zip_entry_filesize($zip_entry));
            $fileHandle=fopen("$fileDir/$name",'w+');	 // Write to a new file 
            fwrite($fileHandle,$buf,zip_entry_filesize($zip_entry));
            fclose($fileHandle);
            zip_entry_close($zip_entry);
          }else{
             return false;
          }
        }
        return true;
      }
      die ('Could not open archive'); 
    }
	
	public static function redirect($url)
	{
		header("location: ".$url);
		die();
	}
    
}
?>
