<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
require_once(APP_ROOT . "conf/site.conf.php");
require_once(APP_ROOT . "libary/BaseLogic.php");
class CreditFactory
{
  function __construct()
  {
    ;
  }
  public static function chkData()
  {
    self::userRegisterAfter();
    self::orderPayAfter();
    self::backOrderPayAfter();
    /*  
    self::editPasswordAfter();
    self::addOrderAfter();  
    self::orderRefundAfter();
    self::orderReturnAfter();
    self::orderCancelAfter();
    self::addCartAfter();
    self::stockAlert();
     * 
     */
  }
  /**
   * 每日登陆后触发事件
   */
  public static function dailyLoginAfter($user)
  {          
    $loginLogic = BaseLogic::load('userLoginLog');
    $cond = 'user_id =' . $user['id'] . ' and create_day="' . date('Ymd') . '"';
    $logs = $loginLogic->getCount($cond);
    if ($logs==1)
    {
        $creditLogic = BaseLogic::load('creditDetail');       
        $creditLogic->getCredit('daily_login_sent_credit', $user['id'], $user['language_id']);
    }
  }
  /**
   * 用户评论审核通过(一个产品只赠送一次)
   */
  public static function goodsCommentAfter($comment)
  {          
    
    $goodsCommentLogic = BaseLogic::load('goodsComment');
    $count = $goodsCommentLogic->getCount('user_id='.$comment['user_id'].' and goods_id =' . $comment['goods_id'] . ' and status=1');
    if($count == 1)
    {
        $creditLogic = BaseLogic::load('creditDetail');       
        $creditLogic->getCredit('goods_comment_sent_credit', $comment['user_id'], $comment['language_id']); 
    }
          
    
  }
  /**
   * 用户注册后触发事件
   * 检查是否是推荐的会员 
   */
  public static function userRegisterAfter($user)
  {          
    $creditLogic = BaseLogic::load('creditDetail');       
    $creditLogic->getCredit('register', $user['id'], $user['language_id']);       
    
  }
  /**
   * 前台
   * 订单支付成功后 
   */
  public static function orderPayAfter($order)
  {
   
        $itemno  = $order['itemno'];
        $language_id = $order['language_id'];
        $creditLogic = BaseLogic::load('creditDetail');       
        $creditLogic->getCredit('order', $order['user_id'], $language_id, '', $order['id']);
  }
  /**
   * 后台
   * 订单支付成功后 
   */
  public static function backOrderPayAfter($order)
  {
   
      $order_id    = $order['id'];
      $language_id = $order['language_id'];
      $creditLogic = BaseLogic::load('creditDetail');       
      $creditLogic->getCredit('order', $order['user_id'], $language_id, '', $order_id);
  }
  /**
   * 订单取消时 
   */
  public static function orderCancelAfter()
  {
    $url = array("m"=>"order", "c"=>"order", "a"=>"handle");
    if(self::chkUrl($url))
    {    
      if(_p('order_status') >= 600)
      {
        
      }
    }
  } 
  /**
   *
   * @param $url 需要拦截的路径
   */
  public static function chkUrl($url)
  {
    $flag = TRUE;
    foreach ($url as $k => $v)
    {
      if ($v == _g($k))
      {
        continue;
      }
      else
      {
        $flag = FALSE;
        break;
      }
    }
    return $flag;
  }
  /**
   * 执行curl
   * @param type $url
   * @param type $post_data
   * @param type $charsetfrom
   * @param type $charsetto
   * @param type $timeout
   * @return type 
   */
  public static function getRemoteData($url,$post_data=array(), $charsetfrom="",$charsetto="",$timeout=60)
	{
		$ch = curl_init();
		$a = array(" ");
		$b = array("%20");
		$url = str_replace($a, $b, $url);
		curl_setopt($ch, CURLOPT_URL, $url); 
		curl_setopt($ch,CURLOPT_HEADER,0);   
		curl_setopt($ch,CURLOPT_TIMEOUT,$timeout);   
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout); 
        if(count($post_data)>0)
        {
            curl_setopt($ch, CURLOPT_POST, 1 );
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        }
		//在需要用户检测的网页里需要增加下面两行 
		//curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY); 
		//curl_setopt($ch, CURLOPT_USERPWD, US_NAME.":".US_PWD); 
		$contents = curl_exec($ch); 
		curl_close($ch); 
		if( $charsetfrom!="" && $charsetto!="" )
		{
			$contents = iconv($charsetfrom, $charsetto,$contents);
		}
		return $contents; 
	}
    /**
     * 读取事件所需参数
     * @param type $codeno
     * @return type 
     */
    public static function getEvnetParams($codeno, $language_id=0, $params=array())
    {
      $eventLogic = BaseLogic::load('event');
      return $eventLogic->getCond($codeno, $language_id, $params);
    }

}

?>
