<?php
/*
 * Copyright 2012 Zhtx Systems, Inc.
 */

require_once(APP_ROOT . "conf/db.conf.php");

/*
 * DB type definitions
 * 
 * Only libary common DB types
 */
class DB {
  const BOOL                = 0; // 'true' or 'false'

  const INT                 = 100;  // -2147483648 to 2147483647
  const UNSIGNED_INT        = 101; // 0 to 4294967295
  const TINYINT             = 102; // -128 to 127
  const UNSIGNED_TINYINT    = 103; // 0 to 255
  const SMALLINT            = 104; // -32768 to 32767
  const UNSIGNED_SMALLINT   = 105; // 0 to 65535
  const MEDIUMINT           = 106; // -8388608 to 8388607
  const UNSIGNED_MEDIUMINT  = 107; // 0 to 16777215
  const BIGINT              = 108; // -9223372036854775808 to 9223372036854775807
  const UNSIGNED_BIGINT     = 109; // 0 to 18446744073709551615

  const FLOAT               = 200;
  const UNSIGNED_FLOAT      = 201;
  const DOUBLE              = 202;
  const UNSIGNED_DOUBLE     = 203;
  const DECIMAL             = 204;
  const UNSIGNED_DECIMAL    = 205;

  const CHAR                = 300;
  const VARCHAR             = 301;
  const ENUM                = 302;
  const TEXT                = 303;
  const BLOB                = 304;

  const DATE                = 400; 
  const DATETIME            = 401; 
  const TIMESTAMP           = 402; 
  const TIME                = 403; 
  const YEAR                = 404; 
  const SQL                 = 504; 

  public static function DB_TABLE($table_alias, $table_prefix = true) {
    if ($table_prefix)
    {
      return TABLE_PREFIX . "_" . $table_alias;
    }
    else
    {
      return $table_alias;
    }
  }

  public static function isStrType($type) {
    switch ($type) {
    case DB::CHAR:
    case DB::VARCHAR:
    case DB::TEXT:
    case DB::ENUM:
      return true;
    default:
      return false;
    }
  }
}

?>
