<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */

require_once(APP_ROOT . "conf/db.conf.php");
require_once(APP_ROOT . "libary/DBFactory.php");
require_once(APP_ROOT . "libary/DB.php");
require_once(APP_ROOT . "libary/exception/DBException.php");
require_once(APP_ROOT . "libary/Logger.php");
require_once(APP_ROOT . "conf/log.conf.php");

/*
 * This is the data access object which contacts with ADOdb lib.
 */

class Dao
{

  private $table;
  private $db;
  private $view;
  private $logger;
  private $spec_char = array ("'","\"");
  public function Dao(&$db_conn, &$view)
  {
    $this->db = $db_conn;
    $this->view = $view;
    $this->table = $view->getTableStmt();
    $this->logger = new Logger('0', SQL_LOG_PATH);
  }
  
  public function __destruct()
  {
   // $this->db->Disconnect();
  }

  /*
   * Get all data with all columns without any condition 
   */

  public function getAll($with_alias = false, $extra = null, $params = false)
  {
    $col_stmt = $this->getAllColStmt($with_alias);
    $sql = "select " . $col_stmt . " from " . $this->table;

    if ($this->view->isMultiple())
    {
      $where = $this->view->getConjStmt();
      $sql .= " where " . $where;
    }

    if ($extra != null)
    {
      $sql .= " " . $extra;
    }
	$this->put_query_mysql_log($sql);
    $res = $this->db->GetAll($sql, $params);
    $this->put_mysql_log($sql);
    return $res;
  }

  /*
   * Get all data with all columns with the given condition
   */

  public function getAllWithCond($cond, $with_alias = false, $extra = null, $params = false)
  {
    $col_stmt = $this->getAllColStmt($with_alias);
    $sql = "select " . $col_stmt . " from " . $this->table;


    if ($this->view->isMultiple())
    {
      $cond_stmt = " (" . $cond;
      $where = $this->view->getConjStmt();
      $cond_stmt .= ") AND " . $where;
    }
    else
    {
      $cond_stmt = " " . $cond;
    }

    $sql_stmt = $sql . " where " . $cond_stmt;
    if ($extra != null)
    {
      $sql_stmt .= " " . $extra;
    }
	$this->put_query_mysql_log($sql_stmt);
     $res = $this->db->GetAll($sql_stmt, $params);
     $this->put_mysql_log($sql_stmt);
     return $res;
  }

  /*
   * Get all data with selective columns without any condition 
   */

  public function getAllSelective($cols, $alias)
  {
    $col_stmt = $this->convColStmt($cols, $alias);

    $sql = "select " . $col_stmt . " from " . $this->table;

    if ($this->view->isMultiple())
    {
      $where = $this->view->getConjStmt();
      $sql .= " where " . $where;
    }
	$this->put_query_mysql_log($sql);
    $res = $this->db->GetAll($sql);
    $this->put_mysql_log($sql);
    return $res;
  }

  /*
   * Get all data with selective columns with the given condition 
   */

  public function getAllSelectiveWithCond($cols, $alias, $cond, $extra = null, $params = false)
  {
    if ($cols == "" || $cols == array("*") || $cols == "*")
    {
      $col_stmt = $this->getAllColStmt(true);
    }
    else
    {
      $col_stmt = $this->getSelectiveColStmt($cols);
    }

    $sql = "select " . $col_stmt . " from " . $this->table;

    /*
      $condStmt = " (". $cond;
      if ($this->view->isMultiple()) {
      $where = $this->view->getConjStmt();
      $condStmt .= ") AND " . $where;
      } else {
      $condStmt .= ") ";
      }
     */
    $cond_stmt = "";
    if ($this->view->isMultiple())
    {
      $conj = $this->view->getConjStmt();
      //$condStmt .= ") AND " . $where;
      $cond_stmt = $conj . " AND (" . $cond . ")";
    }
    else
    {
      $cond_stmt .= $cond;
    }
    if ($cond_stmt && strtolower(substr(trim($cond),0,6)) != "order " && strtolower(substr(trim($cond),0,6)) != "group " && strtolower(substr(trim($cond),0,6)) != "limit ")
    {
      $sql_stmt = $sql . " where " . $cond_stmt;
      if ($extra != null)
      {
        $sql_stmt .= " " . $extra;
      }
    }
    else
    {
      $sql_stmt = $sql . " " . $cond;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->GetAll($sql_stmt, $params);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }

  /*
   * TODO: delete this function
   */

  public function getAllSelectiveWithCondUnionAll($cols, $alias, $cond, $extra = null)
  {
    $union_num = count($cols);
    for ($i = 0; $i < $union_num; $i++)
    {
      if ($i > 0)
      {
        $sql_stmt .= "union all";
      }
      $col_stmt = $this->convColStmt($cols, $alias);

      $sql = "(select " . $col_stmt . " from " . $this->table;

      $cond_stmt = " (" . $cond;
      if ($this->view->isMultiple())
      {
        $where = $this->view->getConjStmt();
        $cond_stmt .= ") AND " . $where;
      }
      else
      {
        $cond_stmt .= ") ";
      }

      if ($cond_stmt)
      {
        $sql_stmt = $sql . " where " . $cond_stmt;
      }
      else
      {
        $sql_stmt = $sql;
      }
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->GetAll($sql_stmt);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }

  /*
   * Get data by id
   *
   * TODO: should get by PK(not necessary by 'id')
   */

  public function getById($id, $with_alias = true)
  {
    $col_stmt = $this->getAllColStmt($with_alias);

    $sql = "select " . $col_stmt . " from " . $this->table . " where id=" . $id;

    if ($this->view->isMultiple())
    {
      $where = $this->view->getConjStmt();
      $sql .= " where " . $where;
    }
	$this->put_query_mysql_log($sql);
    $res = $this->db->GetRow($sql);
    $this->put_mysql_log($sql);
    return $res;
  }

  /*
   * Get data by id with the given condition
   *
   * TODO: delete this function(should be called 'getAllSelectiveWithCond')
   */

  public function getByIdWithCond($id, $cond, $withAlias = true, $extra = null)
  {
    $col_stmt = $this->getAllColStmt($with_alias);

    $sql = "select " . $col_stmt . " from " . $this->table . " where id=" . $id;

    $cond_stmt = " (" . $cond;
    if ($this->view->isMultiple())
    {
      $where = $this->view->getConjStmt();
      $cond_stmt .= ") AND " . $where;
    }
    else
    {
      $cond_stmt .= ") ";
    }

    $sql_stmt = $sql . " and " . $cond_stmt;
    if ($extra != null)
    {
      $sql_stmt .= " " . $extra;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->GetRow($sql_stmt);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }

  public function getRowWithCond($cols, $cond, $with_alias = true, $extra = null)
  {
    if ($cols == "" || $cols == array("*") || $cols == "*")
    {
      $col_stmt = $this->getAllColStmt($with_alias);
    }
    else
    {
      $col_stmt = $this->getSelectiveColStmt($cols);
    }

    $sql = "select " . $col_stmt . " from " . $this->table;


    if ($this->view->isMultiple())
    {
      $cond_stmt = " (" . $cond;
      $where = $this->view->getConjStmt();
      $cond_stmt .= ") " . $where;
    }
    else
    {
      $cond_stmt = $cond;
    }
    if ($cond_stmt && strtolower(substr(trim($cond),0,6)) != "order " && strtolower(substr(trim($cond),0,6)) != "group " && strtolower(substr(trim($cond),0,6)) != "limit ")
    {
      $sql_stmt = $sql . " where " . $cond_stmt;
      if ($extra != null)
      {
        $sql_stmt .= " " . $extra;
      }
    }
    else
    {
      $sql_stmt = $sql . " " . $cond;
    }
    
    if ($extra != null)
    {
      $sql_stmt .= " " . $extra;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->GetRow($sql_stmt);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }

  public function getRowWithCond2($cols, $cond, $alias = null, $extra = null)
  {
    $col_stmt = $this->convColStmt($cols, $alias);

    $sql = "select " . $col_stmt . " from " . $this->table;

    $cond_stmt = "";
    if ($this->view->isMultiple())
    {
      $conj = $this->view->getConjStmt();
      //$condStmt .= ") AND " . $where;
      $cond_stmt = $conj . " AND (" . $cond . ")";
    }
    else
    {
      $cond_stmt .= $cond;
    }

    $sql_stmt = $sql . " where " . $cond_stmt;
    if ($extra != null)
    {
      $sql_stmt .= " " . $extra;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->GetRow($sql_stmt);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }

  /*
   * Get count without any condition 
   */

  public function getCount()
  {
    $sql = "select count(*) from " . $this->table;

    if ($this->view->isMultiple())
    {
      $where = $this->view->getConjStmt();
      $sql .= " where " . $where;
    }
	$this->put_query_mysql_log($sql);
    $res = $this->db->GetOne($sql);
    $this->put_mysql_log($sql);
    return $res;
  }

  /*
   * Get count with the given condition 
   */

  public function getCountWithCond($cond, $subject = null, $extra = null, $params = false)
  {
    if ($subject != null)
    {
      $sql = "select count(distinct " . $subject . ") from " . $this->table;
    }
    else
    {
      $sql = "select count(*) from " . $this->table;
    }

    /*
      $condStmt = " (". $cond;
      if ($this->view->isMultiple()) {
      $where = $this->view->getConjStmt();
      $condStmt .= ") AND " . $where;
      } else {
      $condStmt .= ") ";
      }
     */
    $cond_stmt = "";
    if ($this->view->isMultiple())
    {
      $conj = $this->view->getConjStmt();
      //$condStmt .= ") AND " . $where;
      $cond_stmt = $conj . " AND (" . $cond . ")";
    }
    else
    {
      $cond_stmt .= $cond;
    }

    if ($cond_stmt && strtolower(substr(trim($cond),0,6)) != "order " && strtolower(substr(trim($cond),0,6)) != "group " && strtolower(substr(trim($cond),0,6)) != "limit ")
    {
      $sql_stmt = $sql . " where " . $cond_stmt;
      if ($extra != null)
      {
        $sql_stmt .= " " . $extra;
      }
    }
    else
    {
      $sql_stmt = $sql . $cond;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->GetOne($sql_stmt, $params);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }
  /**
   * 分组统计返回记录条数
   * @param type $cond
   * @param type $subject
   * @param type $extra
   * @param type $params
   * @return type 
   */
  public function getCountWithGroupBy($cond, $subject = null, $extra = null, $params = false)
  {
    if ($subject != null)
    {
      $sql = "select count(distinct " . $subject . ") from " . $this->table;
    }
    else
    {
      $sql = "select count(*) from " . $this->table;
    }

    /*
      $condStmt = " (". $cond;
      if ($this->view->isMultiple()) {
      $where = $this->view->getConjStmt();
      $condStmt .= ") AND " . $where;
      } else {
      $condStmt .= ") ";
      }
     */
    $cond_stmt = "";
    if ($this->view->isMultiple())
    {
      $conj = $this->view->getConjStmt();
      //$condStmt .= ") AND " . $where;
      $cond_stmt = $conj . " AND (" . $cond . ")";
    }
    else
    {
      $cond_stmt .= $cond;
    }

    if ($cond_stmt && strtolower(substr(trim($cond),0,6)) != "order " && strtolower(substr(trim($cond),0,6)) != "group " && strtolower(substr(trim($cond),0,6)) != "limit ")
    {
      $sql_stmt = $sql . " where " . $cond_stmt;
      if ($extra != null)
      {
        $sql_stmt .= " " . $extra;
      }
    }
    else
    {
      $sql_stmt = $sql . $cond;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->getAll($sql_stmt, $params);
    $this->put_mysql_log($sql_stmt);
    return count($res);
  }



  /*
   * Insert one row  
   */

  public function insert(&$data)
  {
    $cols = $data->getKeys();
    $vals = $data->getValues();
    $types = $data->getTypes();

    $col_stmt = "";
    $cols_num = count($cols);
    for ($i = 0; $i < $cols_num; $i++)
    {
      $col_stmt .= $cols[$i];
      if ($i < $cols_num - 1)
        $col_stmt .= ",";
    }
    $val_stmt = "";
    $vals_num = count($vals);
    for ($i = 0; $i < $vals_num; $i++)
    {

      if ($this->needAppendQuote($types[$i]))
      {
        $db = $this->db;
        //$valStmt .= $db->qstr($vals[$i]);
        $val_stmt .= "'" . $vals[$i] . "'";
      }
      else
      {
        /*
        foreach ($this->spec_char as $char)
        {
          $vals[$i] = str_replace($char, '\\'.$char, $vals[$i]);
        }
         * 
         */
        $val_stmt .= $vals[$i];
      }

      if ($i < $vals_num - 1)
        $val_stmt .= ",";
    }

    $sql = "insert into " . $this->table . " (" . $col_stmt . ") values(" . $val_stmt . ")";
    $this->put_query_mysql_log($sql);
	$res = $this->db->Execute($sql);
    $this->put_mysql_log($sql);
    if ($res)
    {
      return $this->getLastInsertId();
    }
    else
    {
      return false;
    }
    
  }
  
 /**
  *
  * @param type $sql
  * @return boolean 
  */
 public function query($sql, $time_zone = null)
 {
   if($time_zone)
   {
	   $this->db->Execute($time_zone);
   }
   $res = $this->db->getAll($sql);
   $this->put_mysql_log($sql);
   if ($res)
   {
     return $res;
   }
   else
   {
     return false;
   }
 }
 
 public function execute($sql)
 {
	 $this->put_query_mysql_log($sql);
	 return $this->db->Execute($sql);
 }  
  
  public function replaceByCond($cond, &$data)
  {
    if ($cond == "")
    {
      return false;
    }
    else
    {
      $res = $this->getAllWithCond($cond);
      if (count($res) == 1)
      {
        return $this->updateByCond($data, $cond);
      }
      if (count($res) > 1)
      {
        return false;
      }
      if (count($res) == 0)
      {
        return $this->insert($data);
      }
    }
  }
  
  public function replace(&$data)
  {
    $cols = $data->getKeys();
    $vals = $data->getValues();
    $types = $data->getTypes();

    $col_stmt = "";
    $cols_num = count($cols);
    for ($i = 0; $i < $cols_num; $i++)
    {
      $col_stmt .= $cols[$i];
      if ($i < $cols_num - 1)
        $col_stmt .= ",";
    }
    $val_stmt = "";
    $vals_num = count($vals);
    for ($i = 0; $i < $vals_num; $i++)
    {

      if ($this->needAppendQuote($types[$i]))
      {
        $db = $this->db;
        //$valStmt .= $db->qstr($vals[$i]);
        $val_stmt .= "'" . $vals[$i] . "'";
      }
      else
      {
        $val_stmt .= $vals[$i];
      }

      if ($i < $vals_num - 1)
        $val_stmt .= ",";
    }

    $sql = "replace into " . $this->table . " (" . $col_stmt . ") values(" . $val_stmt . ")";
    $this->put_query_mysql_log($sql);
    $this->db->Execute($sql);

    return $this->getLastInsertId();
  }

  public function insertAsync(&$data)
  {
    $col_param = $this->buildRemoteColParam($data->getKeys());
    $val_param = $this->buildRemoteValueParam($data->getValues(), $data->getTypes());

    $ret = $this->asyncClient->invoke(AsyncOper::INSERT, $col_param, $val_param);
    // TODO: handle ret

    return $ret;
  }

  /*
   * For LAST_INSERT_ID(), the most recently generated ID is maintained in the server on a per-connection basis. It is not changed by another client.
   */

  public function getLastInsertId()
  {
    $sql = "select LAST_INSERT_ID()";
	$this->put_query_mysql_log($sql);
    $id = $this->db->GetRow($sql);
    if ($id > 0)
    {
        $this->put_mysql_log($sql);
    }
    return $id[0];
  }

  /*
   *
   */

  public function updateById(&$data)
  {
    $cols = $data->getKeys();
    $vals = $data->getValues();
    $types = $data->getTypes();

    $sql = "update " . $this->table . " set ";
    $id_value = "";

    $cols_num = count($cols);
    for ($i = 0; $i < $cols_num; $i++)
    {
      if ($cols[$i] == "id")
      {
        $id_value = $vals[$i];
        //continue;
      }

      $sql .= $cols[$i] . "=";
      if ($this->needAppendQuote($types[$i]))
      {
        //$sql .= $this->db->qstr($vals[$i]);
        $sql .= "'" . $vals[$i] . "'";
      }
      else
      {
        $sql .= $vals[$i];
      }

      if ($i < $cols_num - 1)
        $sql .= ",";
    }

    if ($id_value == "")
    {
      $this->logger->write_log($sql);
      throw new DBException("Lack of ID when process update");
    }

    $sql .= " where id=" . $id_value;
	$this->put_query_mysql_log($sql);
    $res = $this->db->Execute($sql);
    $this->put_mysql_log($sql);
    return $res;
  }

  /*
   *
   */

  public function updateByCond(&$data, $cond, $extra = null, $params = false)
  {
    $cols = $data->getKeys();
    $vals = $data->getValues();
    $types = $data->getTypes();

    $sql = "update " . $this->table . " set ";

    $cols_num = count($cols);
    for ($i = 0; $i < $cols_num; $i++)
    {
      $sql .= $cols[$i] . " = ";

      if ($this->needAppendQuote($types[$i]))
      {
        //$sql .= $this->db->qstr($vals[$i]);
        /*
        foreach ($this->spec_char as $char)
        {
          $vals[$i] = str_replace($char, '\\'.$char, $vals[$i]);
        }
         * 
         */
        $sql .= "'" . $vals[$i] . "'";
      }
      else
      {

        $sql .= $vals[$i];
      }

      if ($i < $cols_num - 1)
        $sql .= ",";
    }

    if (is_null($cond) || $cond == "")
    {
      throw new DBException("Lack of Condition when process update");
    }

    $sql .= " where " . $cond;
    $sql_stmt = $sql;
    if ($extra != null)
    {
      $sql_stmt .= " " . $extra;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res =$this->db->Execute($sql_stmt, $params);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }

  /*
   * TODO: should delete this function (replace by 'updateByCond')
   */

  public function increaseOneByCond(&$data, $cond, $extra = null)
  {
    $cols = $data->getKeys();
    $vals = $data->getValues();
    $types = $data->getTypes();

    $sql = "update " . $this->table . " set ";

    $cols_num = count($cols);
    for ($i = 0; $i < $cols_num; $i++)
    {
      $sql .= $cols[$i] . " = ";

      /* if ($this->needAppendQuote($types[$i])) {
        $sql .= $this->db->qstr($vals[$i]);
        } else {
        $sql .= $vals[$i];
        } */

      $sql .= $cols[$i] . " + 1";
      if ($i < $cols_num - 1)
        $sql .= ",";
    }

    if (is_null($cond) || $cond == "")
    {
      throw new DBException("Lack of Condition when process update");
    }

    $sql .= " where " . $cond;
    $sql_stmt = $sql;
    if ($extra != null)
    {
      $sql_stmt .= " " . $extra;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->Execute($sql_stmt);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }

  public function deleteById($id)
  {
    $sql = "delete from " . $this->table . " where id=" . $id;
    $this->put_query_mysql_log($sql);
	$res = $this->db->Execute($sql);
    $this->put_mysql_log($sql);
    return $res;
  }

  public function deleteByCond($cond, $extra = null, $params = false)
  {
    $sql = "delete from " . $this->table . " where " . $cond;

    $sql_stmt = $sql;
    if ($extra != null)
    {
      $sql_stmt .= " " . $extra;
    }
	$this->put_query_mysql_log($sql_stmt);
    $res = $this->db->Execute($sql_stmt, $params);
    $this->put_mysql_log($sql_stmt);
    return $res;
  }

  public function filterStr($str)
  {
    $qstr = $this->db->qstr($str);
    return $qstr;
  }

  public function beginTrans()
  {
    $this->db->StartTrans();
    $this->logger->write_log("beginTrans:{");
  }

  public function endTrans()
  {
    $this->db->CompleteTrans();
    $this->logger->write_log("}:endTrans");
  }

	public function FailTrans()
  {
    $this->db->FailTrans();
    $this->logger->write_log("}:failTrans");
  }

  public function rollBack()
  {
    $this->db->rollback();
    $this->logger->write_log("}:rollBack");
  }

  // Helper functions
  //
  private function getAllColStmt($with_alias)
  {
    $cols = $this->view->getNames();

    $alias = null;
    if ($with_alias)
    {
      $alias = $this->view->getAliases($cols);
    }

    return $this->convColStmt($cols, $alias);
  }

  private function getSelectiveColStmt($aliases)
  {
    $cols = $this->view->getNames($aliases);
    return $this->convColStmt($aliases, $cols);
  }

  private function convColStmt($cols, $alias)
  {
    $col_stmt = "";
    $cols_num = count($cols);
    $has_alias = (!is_null($alias)) && (count($alias) > 0);
    if ($cols_num > 0)
    {
      for ($i = 0; $i < $cols_num; $i++)
      {
        $col_stmt .= $cols[$i];

        if ($has_alias)
        {
          if ($cols[$i] != $alias[$i])
          {
            $col_stmt .= " as " . $alias[$i];
          }
        }

        if ($i < $cols_num - 1)
          $col_stmt .= ",";
      }
    }else
    {
      $col_stmt = "*";
    }
    return $col_stmt;
  }

  private function needAppendQuote($type)
  {
    switch ($type)
    {
      case DB::CHAR:
      case DB::VARCHAR:
      case DB::TEXT:
      case DB::ENUM:
        return true;
      default:
        return false;
    }
  }

  private function buildRemoteColParam($cols)
  {
    $param = "cols=";
    $cols_num = count($cols);
    for ($i = 0; $i < $cols_num; $i++)
    {
      $col_str = urlencode($cols[$i]);
      $param .= $colStr;

      if ($i < $cols_num - 1)
        $param .= ",";
    }
    return $param;
  }

  private function buildRemoteValueParam($vals, $types)
  {
    $param = "vals=";
    $vals_num = count($vals);
    for ($i = 0; $i < $vals_num; $i++)
    {

      if (DB::isStrType($types[$i]))
      {
        $db = $this->db;
        $val_str = urlencode($db->qstr($vals[$i]));
        $param .= $val_str;
      }
      else
      {
        $param .= urlencode($vals[$i]);
      }

      if ($i < $vals_num - 1)
        $param .= ",";
    }
    return $param;
  }

  // debug
  public function getTable()
  {
    return $this->table;
  }
  
  private function put_query_mysql_log($sql)
  {
	 if (isset($_GET['debug']) || XDEBUG || $_SESSION['sql_debug'])
    {
      $this->logger->write_log($sql); 
	  $_SESSION['sql_log'][]  = $sql ;
    } 
  }
  
  private function put_mysql_log($sql)
  {
    if (isset($_GET['debug']) || XDEBUG || $_SESSION['sql_debug'])
    {
      //$this->logger->write_log($sql); 
	  //$_SESSION['sql_log'][]  = $sql ;
    }
    /*
    if(strpos($sql, 'update') !== false || strpos($sql, 'insert') !== false)
    {
      print_r($sql);die;
    }
     * 
     */
    if ((isset($_GET['debug']) || XDEBUG) && mysql_error())
    {
      $this->logger->write_log("########################################################");
      throw new Exception(mysql_error());
    }
  }

}

?>
