<?php
/*
 * Copyright 2012 Zhtx Systems, Inc.
 */

require_once(APP_ROOT . "libary/DB.php");

class DataMap {
  private $data;
  private $types;

  public function DataMap() {
    $this->data = array();
  }

  public function assign($data) {
    $this->data = $data->data;
    $this->types = $data->types;
  }
 
  public function addEntry($key, $value, $type = DB::VARCHAR)
  {
    $this->data[$key] = $value;
    if ($key == $value || strtolower($value) == "now()")
    {
      $this->types[$key] = DB::INT;
    }
    else
    {
      $this->types[$key] = $type;
    }
  }

  public function setValue($key, $value) {
    $this->data[$key] = $value;
  }

  public function getValue($key) {
    return $this->data[$key];
  }

  public function getType($key) {
    return $this->types[$key];
  }

  public function &getKeys() {
    return array_keys($this->data);
  }

  public function getValues() {
    return array_values($this->data);
  }

  public function getTypes() {
    return array_values($this->types);
  }

  public function mergeWith($other) {
  }

  public function checkTypeValid() {
    $keys = &$this->getKeys();

    foreach ($keys as $key) {
      $value = $this->data[$key];
      $db_type = $this->types[$key];

      $typeName = "";
      switch ($db_type) {
      case DB::BOOL:
        if (!is_bool($value))
          return false;
        break;

      case DB::INT:
      case DB::UNSIGNED_INT:
      case DB::TINYINT:
      case DB::UNSIGNED_TINYINT:
      case DB::SMALLINT:
      case DB::UNSIGNED_SMALLINT:
      case DB::MEDIUMINT:
      case DB::UNSIGNED_MEDIUMINT:
        if (!is_int($value))
          return false;
        break;

      case DB::FLOAT:
      case DB::UNSIGNED_FLOAT:
      case DB::DOUBLE:
      case DB::UNSIGNED_DOUBLE:
        if (!is_float($value))
          return false;
        break;

      case DB::CHAR:
      case DB::VARCHAR:
      case DB::TEXT:
      case DB::ENUM:
        if (!is_string($value))
          return false;
        break;



      case DB::BIGINT:
      case DB::UNSIGNED_BIGINT:
        // TODO:

      case DB::DECIMAL:
      case DB::UNSIGNED_DECIMAL:
        // TODO:

      case DB::BLOB:
      
      default:
        return false;
      }
    }
    return true;
  }
  

  // debug
  public function getData() {
    return $this->data;
  }
  /**
   * 
   * @param type $data
   * @return type 
   */
  public function createEntry($data)
  {
      foreach ($data as $key => $value)
     {
        $this->addEntry($key, $value);
     }   
  }
}

?>
