<?php

/**
 * 目录管理
 * @author HHH
 */
class Dir
{

    /**
     * 创建文件夹
     */
    public static function mkdirs($dir)
    {
        return is_dir($dir) or (self::mkdirs(dirname($dir)) and mkdir($dir, 0755));
    }

    /**
     * 获取目录下的图片
     * 默认排序 1 按时间排序
     * 2 按名称排序
     */
    public static function getImgList($dir, $orderby=1, $search_name='')
    {
        if (!empty($dir))
        {
            if ($fp = @opendir($dir))
            {
                $fileList = array();
                $i = 0;
                while ($file = readdir($fp))
                {
                    if ($file != '.' && $file != '..' && substr($file, 0, 1) != '.')
                    {
                        if (is_file($dir . $file))
                        {
                            $ext = strtolower(substr(strrchr($file, '.'), 1));
                            $fileName = str_replace(strrchr($file, '.'), '', $file);
                            if($search_name && strpos(strtolower($fileName), strtolower($search_name)) !== FALSE)
                            {                                                                                      
                                  $fileList[$i]['name'] = $fileName;
                                  $fileList[$i]['imgpath'] = $dir . $file;
                                  $fileList[$i]['size'] = self::sizeFormat(filesize($dir . $file));
                                  $fileList[$i]['type'] = $ext;
                                  $fileList[$i]['time'] = date('Y-m-d H:s:i' , filemtime($dir . $file));
                                  $i++;
                            }
                            else if(!$search_name)
                            {                                   
                                $fileList[$i]['name'] = $fileName;
                                $fileList[$i]['imgpath'] = $dir . $file;
                                $fileList[$i]['size'] = self::sizeFormat(filesize($dir . $file));
                                $fileList[$i]['type'] = $ext;
                                $fileList[$i]['time'] = date('Y-m-d H:s:i' , filemtime($dir . $file));                                   
                                $i++;
                            }
                        }
                        else if(is_dir($dir . $file))
                        {
                            if($search_name && strpos(strtolower($file), strtolower($search_name)) !== FALSE)
                            {                                                                                      
                                  $fileList[$i]['name'] = $file;
                                  $fileList[$i]['imgpath'] = $dir . $file;
                                  $fileList[$i]['size'] = self::sizeFormat(filesize($dir . $file));
                                  $fileList[$i]['type'] = 'folder';
                                  $fileList[$i]['time'] = date('Y-m-d H:s:i' , filemtime($dir . $file));
                                  $i++;
                            }
                        }
                    }
                }
                closedir($fp);
                if($orderby == 1)
                {
                  $fileList = self::listorder($fileList);
                }
                else
                {
                 $fileList = self::listorderByName($fileList); 
//                  array_multisort($fileList, SORT_DESC,SORT_STRING);
                }
                return $fileList; 
            }
        }
        return false;
    }
    /**
     * 图片按修改时间从大到小排序(冒泡排序)
     * @param type $i
     * @param type $filename
     * @param type $time
     * @param type $m 
     */
    public static function listorder($fileList)
    {          
        $len = count($fileList);
        for ($i = 0; $i < $len; $i++)
        {
            $i_time = strtotime($fileList[$i]['time']);
            for ($j = $len; $j > $i+1; $j--)
            {
                $j_time = strtotime($fileList[$j]['time']);
                if ($j_time > $i_time)
                {
                    $temp = $fileList[$i];
                    $fileList[$i] = $fileList[$j];
                    $fileList[$j] = $temp;
                }
            }
        }
        return $fileList;
    }
    /**
     * 获取目录下的文件
     */
    static public function getFileList($dir)
    {
        if (!empty($dir))
        {
            if ($fp = @opendir($dir))
            {
                $fileList = array();
                while ($file = readdir($fp))
                {
                    if ($file != '.' && $file != '..' && substr($file, 0, 1) != '.')
                    {
                        if (is_file($dir . $file))
                        {
                            $fileList[] = $dir . $file;
                        }
                    }
                }
                closedir($fp);
                return $fileList;
            }
        }
        return false;
    }
    static public function getAllFiles($dir)
    {
        if ($fp = @opendir($dir))
        {
            $fileList = array();
            while ($file = readdir($fp))
            {
                if ($file != '.' && $file != '..' && substr($file, 0, 1) != '.')
                {
                    if (is_file($dir . $file))
                    {                                          
                        $fileList[] = $dir . $file;
                    }
                    else if(is_dir($dir . $file))
                    {  
                      $fileList = array_merge($fileList, self::getAllFiles($dir . $file . '/'));
                    }                  
                }
            }
            closedir($fp);
            return $fileList;
        }
    }
    /*
     * 获取目录列表
     * @param string dir 必须, 文件路径,需要加 "/"
     */

    static public function getDirectory($dir = '/', $imgpath)
    {

        $path_array = split("\/", $imgpath);
        $path_dir = split("\/", $dir);
        $levelCur = count($path_dir) - 2;
        if ($path_array[$levelCur] != $path_dir[$levelCur])
        {
            return;
        }
        if ($fp = @opendir($dir))
        {
            $dirTree = array();
            $i = 0;
            while ($file = readdir($fp))
            {
                if ($file != '.' && $file != '..' && substr($file, 0, 1) != '.')
                {
                    $subDir = $dir . $file . '/';
                    if (is_dir($subDir))
                    {
                        $dirTree[$i]['name'] = $file;
                        $dirTree[$i]['path'] = $subDir;
                        //if(in_array(basename($dir.$file), $path_array))
                        $dirTree[$i]['subdir'] = self::getDirectory($subDir, $imgpath);
                        $i++;
                    }
                }
            }
            closedir($fp);           
            array_multisort($dirTree);
            return $dirTree;
        }
        return false;
    }    
    /**
     * 格式化字节
     * @param number size 必须
     * @param string unit 可选, 单位
     */
    static public function sizeFormat($size, $unit = 'B')
    {

        $units = array('B', ' KB', 'MB', 'GB', 'TB');
        $unit = strtoupper($unit);
        $unitNumber = array_search($unit, $units);
        for ($i = $unitNumber; $size >= 1024 && $i < 4; $i++)
        {
            $size /= 1024;
        }
        return round($size, 2) . $units[$i];
    }
   /**
     * 按名称排序
     * @param type $dirTree
     * @return type 
     */
   public static function listorderByName($fileList)
   { 
     $names = array();
     foreach ($fileList as $key => $value)
     {
       $names[$key] = $value['name'];      
     }
     natsort($names);
     $result = array();
     foreach ($names as $key => $name)
     {
       $result[] = $fileList[$key];
     }
      return $result;
   }
   //循环删除目录和文件函数
   public static function delDirAndFile( $dirName )
    {
        if (substr($dirName, strlen($dirName)-1, 1) != '/')
        $dirName .= '/';
       if ( $handle = opendir($dirName ) ) {
          while ( false !== ( $item = readdir( $handle ) ) ) {
            if ( $item != "." && $item != ".." ) {
                $file = $dirName .$item;
                if ( is_dir( $file ) && !@rmdir($file)) {
                    self::delDirAndFile( $file );
                } else {
                    @unlink( $file );
                }
            }
          }
          closedir( $handle );
          @rmdir( $dirName );
        }        
    }
   
}

?>