<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
require_once(APP_ROOT . "conf/site.conf.php");
require_once(APP_ROOT . "libary/BaseLogic.php");
require_once(APP_ROOT . "libary/Common.php");

class EventFactory
{

    public function __construct()
    {

    }

    public static function getCoupons($offer_id,$num,$user_id)
    {
            $offer_id = isset($offer_id) ? $offer_id : 0;
            $num = isset($num) ? $num : 0;
            $offerLogic = AppController::load('offer');
            $offer = $offerLogic->getOneById($offer_id);
            $coupons = array();
            if ($offer && $offer['offer_type'] == 2)
            {
                if($offer['coupon_type']==1)
                {
                    $coupons[] = $offer['prefix'];
                }
                else
                {
                    $send_limit = $offer['send_limit'];
                    $send_num = $offer['send_num'];
                    //$limit = $num < $offer['send_limit'] ? $num : $offer['send_limit'];
                    if($offer['send_limit']==0)
                    {
                        $limit = $num;
                    }
                    else
                    {
                        $limit = $num + $offer['send_num'] < $offer['send_limit'] ? $num : $offer['send_limit'] - $offer['send_num'];
                    }
                    for ($i = 0; $i < $limit; $i++)
                    {
                        //优惠券编号构造
                        $coupon_code = strtoupper($offer['prefix'] . date('ymdHis', time()) . Common::random(3));
                        $coupon_data = array(
                            'user_id' => $user_id,
                            'offer_id' => $offer_id,
                            'coupon_code' => $coupon_code,
                            'create_time' => SYS_TIME,
                            'status' => 1,
                        );
                        $c_result = AppController::load('coupon')->save($coupon_data);
                        if ($c_result)
                        {
                            $coupons[$i] = $coupon_code;
                            //$send_limit--;
                            $send_num++;
                        }
                    }
                    $offer_data = array(
                        //'send_limit' => $send_limit,
                        'send_num' => $send_num,
                    );
                    $offerLogic->save($offer_data, $offer_id);
                }
            }
            return $coupons;
    }

    /**
     * 用户注册后触发事件
     */
    public static function userRegisterAfter($user)
    {
        $event_codeno = 'user_register_after';
        $base_name = $user['base_name'];
        $language_id = $user['language_id'];
        $cond = self::getEvnetParams($event_codeno, $language_id);
        if (!$cond)
        {
            return;
        }

        $coupons = array();
        if($cond['is_coupon'])
        {
            $coupons = self::getCoupons($cond['coupon']['offer_id'], $cond['coupon']['coupon_num'], $user['id']);
        }
        $params = array(
            'sent_to' => $base_name,
            'language_id' => $language_id,
            'content' => array(
                'id' => $user['id'],
                'username' => $base_name,
				'realpwd' => $user['realpwd'],
                'domain' => SITE_URL,
            ),
            'coupons' => $coupons,
        );
        $params = array_merge($params, $cond);
        $security_key = date('ymdhis') . Common::random(5);
        $data = array(
            'task_stage_id' => $cond['task_id'],
            'codeno' => $event_codeno,
            'base_name' => '接收邮箱：' . $base_name,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'language_id' => $language_id,
            'trigger_time' => $cond['trigger_time'],
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'remark' => '注册验证邮件',
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res)
        {
            //即时触发处理
            if ($cond['trigger_type'])
            {
                $taskListLogic->process(array($res), array($security_key));
            }
        }
    }

    /**
     *  找回密码
     *  激活邮件 重设密码 (24小时内失效)
     *  发送到邮箱的地址如 http://www.35zh.com?index.php?m=home&c=user&a=forgetPasswordReset&user_id=$user_id&t=$seng_time&sign=$sign
     *  user_id 用户ID
     *  timestamp 发送时间
     *  sign md5(md5(user_id.base_name.ip.timestamp))签名方式
     */
    public static function forgotPassword($user)
    {
        $event_codeno = 'forgot_password';
        $language_id = $user['language_id'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }

        $coupons = array();
        if($event['is_coupon'])
        {
            $coupons = self::getCoupons($event['coupon']['offer_id'], $event['coupon']['coupon_num'], $user['id']);
        }
        //发邮件
        $sign = md5(md5($user['id'] . $user['base_name'] . $user['ip'] . SYS_TIME));
        $auth_url = SITE_PROTOCOL . SITE_URL . '/h-user-forgetPasswordReset.html?user_id=' . $user['id'] . '&t=' . SYS_TIME . '&sign=' . $sign;
        $domain = SITE_PROTOCOL . SITE_URL;
        $params = array(
            'sent_to' => $user['base_name'],
            'language_id' => $language_id,
            'content' => array(
                'username' => $user['base_name'],
                'auth_url' => $auth_url,
                'domain' => SITE_URL,
            ),
            'coupons' => $coupons,
        );
        $params = array_merge($params, $event);
        $security_key = date('ymdhis') . Common::random(5);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮件：' . $user['base_name'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'remark' => '找回密码邮件',
            'create_time' => SYS_TIME,
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     *  找回密码
     *  密码邮件 发送密码
     */
    public static function sendPassword($user)
    {
        $event_codeno = 'send_password';
        $language_id = $user['language_id'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }

        $coupons = array();
        if($event['is_coupon'])
        {
            $coupons = self::getCoupons($event['coupon']['offer_id'], $event['coupon']['coupon_num'], $user['id']);
        }
        //发邮件
        srand((double)microtime()*1000000);//create a random number feed.
        $ychar="0,1,2,3,4,5,6,7,8,9,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z";
        $list=explode(",",$ychar);
        for($i=0;$i<8;$i++){
            $randnum=rand(0,35);
            $new_password.=$list[$randnum];
        }
        $security_password = md5(md5($new_password));
        $user_data = array(
                'password'    => $security_password,
        );
        $res = AppController::load('user')->save($user_data, $user['id']);
        if(!$res){
            return;
        }
        $domain = SITE_PROTOCOL . SITE_URL;
        $params = array(
            'sent_to' => $user['base_name'],
            'language_id' => $language_id,
            'content' => array(
                'username' => $user['base_name'],
                'new_password' => $new_password,
                'domain' => SITE_URL,
            ),
            'coupons' => $coupons,
        );
        $params = array_merge($params, $event);
        $security_key = date('ymdhis') . Common::random(5);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮件：' . $user['base_name'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'remark' => '找回密码邮件(发送密码)',
            'create_time' => SYS_TIME,
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 会员修改密码后提醒
     */
    public static function editPasswordAfter($user)
    {
        $event_codeno = 'edit_password_tip';
        $language_id = BaseLogic::load('language')->language_id;
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }

        $coupons = array();
        if($event['is_coupon'])
        {
            $coupons = self::getCoupons($event['coupon']['offer_id'], $event['coupon']['coupon_num'], $user['id']);
        }
        $user_email = $user['base_name'];
        $domain = SITE_PROTOCOL . SITE_URL;
        $params = array(
            'sent_to' => $user_email,
            'language_id' => $language_id,
            'content' => array(
                'username' => $user_email,
                'domain' => SITE_URL,
            ),
            'coupons' => $coupons,
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $user_email,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '修改密码提醒',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 到货通知
     */
    public static function stockAlert()
    {

    }

    /**
     * 添加到购物车时
     */
    public static function addCartAfter($user_id)
    {
        $language_id = BaseLogic::load('language')->language_id;
        if (!$user_id)
        {
            return;
        }
        $event_codeno = 'add_cart_after';
        //$username     = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
        $userLogic = BaseLogic::load('user');
        $user = $userLogic->getOne('id=' . $user_id);
        if (!$user)
        {
            return;
        }
        $username = $user['base_name'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $username,
            'language_id' => $language_id,
            'user_id' => $user_id,
            'content' => array(
                'username' => $username,
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $username,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '添加商品到购物车提醒',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 下订单成功提醒
     */
    public static function addOrderAfter($order)
    {
        $order_id = $order['id'];
        if ($order_id)
        {
            $event_codeno = 'add_order_after';
            //$sentto     = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
            $itemno = $order['itemno'];
            $language_id = $order['language_id'];
            $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
            $country = BaseLogic::load('country')->getOneById($address['country_id']);
            $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
            $userLogic = BaseLogic::load('user');
            $user = $userLogic->getOne('id=' . $order['user_id']);
            if (!$user)
            {
                return;
            }
            $sentto = $user['base_name'];
            $event = self::getEvnetParams($event_codeno, $language_id, $order);
            if (!$event)
            {
                self::addOrderAfterRemindAdmin($order);
                self::remindPayForOrder($order);
                return;
            }

            $coupons = array();
            if($event['is_coupon'])
            {
                $coupons = self::getCoupons($event['coupon']['offer_id'], $event['coupon']['coupon_num'], $user['id']);
            }
            $params = array(
                'sent_to' => $sentto,
                'language_id' => $language_id,
                'content' => array(
                    'username' => $sentto,
                    'itemno' => $itemno,
                    'id' => $order_id,
                    'currency_code' => $order['currency_code'],
                    'currency_rate' => $order['currency_rate'],
                    'first_name' => $address['first_name'],
                    'last_name' => $address['last_name'],
                    'street' => $address['address'],
                    'state' => $address['state'],
                    'city' => $address['city'],
                    'country' => $country['base_name'],
                    'postcode' => $address['postcode'],
                    'telephone' => $address['telephone'],
                    'email' => $address['email'],
                    'domain' => $order['domain'],
                    'final_amount' => $order['final_amount'],
                    'cost_shipping' => $order['cost_shipping'],
                    'remark' => $order['remark'],
                    'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                    'express' => $shipping['base_name'],
                ),
                'coupons' => $coupons,
            );
            $params = array_merge($params, $event);
            $security_key = date('ymdhis') . Common::random(5);
            $params = array_merge($params, $event);
            $data = array(
                'task_stage_id' => $event['task_id'],
                'base_name' => '接收邮箱：' . $sentto . ' 订单：' . $itemno,
                'codeno' => $event_codeno,
                'params' => json_encode($params),
                'security_key' => $security_key,
                'remark' => '下订单提醒',
                'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
                'language_id' => $language_id,
                'trigger_time' => $event['trigger_time'],
                'create_time' => SYS_TIME,
            );
            $taskListLogic = BaseLogic::load('taskList');
            $res = $taskListLogic->save($data);
            if ($res && $event['trigger_type'])
            {
                $taskListLogic->process(array($res), array($security_key));
            }
            self::addOrderAfterRemindAdmin($order);
            self::remindPayForOrder($order);
        }
    }

    /**
     * 提醒用户付款
     * @param type $sentto
     * @param type $language_id
     * @param type $order
     */
    public static function remindPayForOrder($order)
    {
        $event_codeno = 'remind_pay_for_order';
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $language_id = $order['language_id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $userLogic = BaseLogic::load('user');
        $user = $userLogic->getOne('id=' . $order['user_id']);
        if (!$user)
        {
            return;
        }
        $sentto = $user['base_name'];
        $event = self::getEvnetParams($event_codeno, $language_id, $order);
        if (!$event)
        {
            return;
        }

        $coupons = array();
        if($event['is_coupon'])
        {
            $coupons = self::getCoupons($event['coupon']['offer_id'], $event['coupon']['coupon_num'], $user['id']);
        }
        $params = array(
            'sent_to' => $sentto,
            'language_id' => $language_id,
            'content' => array(
                'username' => $sentto,
                'itemno' => $order['itemno'],
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
            'coupons' => $coupons,
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $sentto . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '下订单提醒用户付款',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $map = Zhtx::createDataMap();
            $map->addEntry('is_email_unpaid', 'is_email_unpaid+1', DB::UNSIGNED_TINYINT);
            $where = 'id='.$order_id;
            $orderLogic = BaseLogic::load('order');
            $orderLogic->update($map, $where);
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 订单支付成功后
     */
    public static function orderPayAfter($order)
    {
        $event_codeno = 'order_pay_success_tip';
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $language_id = $order['language_id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $orderItem = BaseLogic::load('orderItem')->findAll('order_id=' . $order_id);
        $goodsLogic = BaseLogic::load('goods');
        $map = Zhtx::createDataMap();
        foreach ($orderItem as $value) {
            $map->addEntry('buy_counts', 'buy_counts+' . $value['buy_num'], DB::UNSIGNED_TINYINT);
            $where = 'id=' . $value['goods_id'];
            $goodsLogic->update($map, $where);
        }
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $sentto = $user['base_name'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            //self::orderPayAfterRemindAdmin($order); //支付成功后提醒管理员
            return;
        }

        $coupons = array();
        if($event['is_coupon'])
        {
            $coupons = self::getCoupons($event['coupon']['offer_id'], $event['coupon']['coupon_num'], $user['id']);
        }
        $params = array(
            'sent_to' => $sentto,
            'language_id' => $language_id,
            'content' => array(
                'username' => $sentto,
                'itemno' => $itemno,
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
            'coupons' => $coupons,
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $sentto . ' 订单：' . $itemno,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '下订单支付成功通知',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
        self::orderPayAfterRemindAdmin($order); //支付成功后提醒管理员
    }

    /**
     * 推荐用户订单首次支付成功后
     */
    public static function recommendUserFirstPayAfter($order)
    {
        $event_codeno = 'recommend_user_first_pay_after';
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $language_id = $order['language_id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $user = BaseLogic::load('user')->getOne('id='.$order['user_id'].' and parent_user_id>0');

        if (!$user)
        {
            return;
        }
        $parent_user = BaseLogic::load('user')->getOne('id='.$user['parent_user_id']);
        $cond = 'user_id='.$order['user_id'].' and payment_status=201';
        $count = BaseLogic::load('order')->getCount($cond);
        if($count!=1)
        {
            return;
        }
        $sentto = $parent_user['base_name'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $coupons = array();
        if($event['is_coupon'])
        {
            $coupons = self::getCoupons($event['coupon']['offer_id'], $event['coupon']['coupon_num'], $user['parent_user_id']);
        }
        $params = array(
            'sent_to' => $sentto,
            'language_id' => $language_id,
            'content' => array(
                'username' => $sentto,
                'sub_username' => $user['base_name'],
                'itemno' => $itemno,
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
            'coupons' => $coupons,
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $sentto . ' 订单：' . $itemno,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '推荐会员首次付款成功通知',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 管理员收到付款
     */
    public static function adminReceivePayment($order)
    {
        global $cfg;
        $language_id = $order['language_id'];
        $admin_email = $cfg['sites'][$language_id]['admin_email'];
        $event_codeno = 'admin_receive_payment';
        if (!$admin_email)
        {
            return;
        }
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $username = $user['base_name'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $admin_email,
            'language_id' => $language_id,
            'content' => array(
                'username' => $username,
                'itemno' => $order['itemno'],
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $admin_email . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '管理员收到付款',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $order['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 订单发货通知
     * @return type
     */
    public static function orderShipAfter($order)
    {
        $event_codeno = 'order_ship_notice';
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $language_id = $order['language_id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $event = self::getEvnetParams($event_codeno, $order['language_id']);
        if (!$event)
        {
            return;
        }

        $coupons = array();
        if($event['is_coupon'])
        {
            $coupons = self::getCoupons($event['coupon']['offer_id'], $event['coupon']['coupon_num'], $user['id']);
        }
        $params = array(
            'sent_to' => $user['base_name'],
            'language_id' => $order['language_id'],
            'content' => array(
                'username' => $user['base_name'],
                'itemno' => $order['itemno'],
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
            'coupons' => $coupons,
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $user['base_name'] . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '订单发货通知',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $order['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 订单退货提醒
     */
    public static function orderReturnAfter($order)
    {
        $event_codeno = 'order_return_tip';
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $language_id = $order['language_id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $event = self::getEvnetParams($event_codeno, $order['language_id']);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $user['base_name'],
            'language_id' => $order['language_id'],
            'content' => array(
                'username' => $user['base_name'],
                'itemno' => $order['itemno'],
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $user['base_name'] . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '订单退货通知',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $order['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 订单退款时
     */
    public static function orderRefundAfter($order)
    {
        $event_codeno = 'order_refund_tip';
        $amount = $order['refund_amount'];
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $language_id = $order['language_id'];
        $orderPayment = BaseLogic::load('orderPayment')->getOne('order_id=' . $order_id . ' order by create_time desc');
        $currency = BaseLogic::load('currency')->getOne('id=' . $orderPayment['real_currency_id']);
        $amount = $currency['symbol_left'] . ' ' . sprintf('%01.2f', $orderPayment['real_currency_amount']);
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $event = self::getEvnetParams($event_codeno, $order['language_id']);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $user['base_name'],
            'language_id' => $order['language_id'],
            'content' => array(
                'username' => $user['base_name'],
                'itemno' => $order['itemno'],
                'amount' => $amount,
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $user['base_name'] . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '订单退款通知',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $order['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 系统后台订单取消时
     */
    public static function orderCancelAfter($order)
    {
        $event_codeno = 'order_cancel_notice';
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $language_id = $order['language_id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $user['base_name'],
            'language_id' => $language_id,
            'content' => array(
                'username' => $user['base_name'],
                'itemno' => $order['itemno'],
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $user['base_name'] . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '订单取消通知',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $order['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }
 /**
     * 订单完成通知会员
     */
    public static function orderCompleteAfter($order)
    {
        $event_codeno = 'order_complete_tip';
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $language_id = $order['language_id'];
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $user['base_name'],
            'language_id' => $language_id,
            'content' => array(
                'username' => $user['base_name'],
                'id' => $order['id'],
				'itemno' => $order['itemno'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $user['base_name'] . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '订单完成通知',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $order['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }
    /**
     * 下订单后提醒管理员
     */
    public static function addOrderAfterRemindAdmin($order)
    {
        global $cfg;
        $language_id = $order['language_id'];
        $admin_email = $cfg['sites'][$language_id]['admin_email'];
        if (!$admin_email)
        {
            return;
        }
        $order_id = $order['id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $username = $user['base_name'];

        $event_codeno = 'add_order_remind_admin';
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $admin_email,
            'language_id' => $language_id,
            'content' => array(
                'username' => $username,
                'itemno' => $order['itemno'],
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'mobilephone' => $address['mobilephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $username . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '下订单提醒管理员',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $order['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     * 订单支付成功后提醒管理员
     */
    public static function orderPayAfterRemindAdmin($order)
    {
        global $cfg;
        $language_id = $order['language_id'];
        $admin_email = $cfg['sites'][$language_id]['admin_email'];
        $event_codeno = 'order_pay_success_remind_admin';
        if (!$admin_email)
        {
            return;
        }
        $itemno = $order['itemno'];
        $order_id = $order['id'];
        $address = BaseLogic::load('orderAddress')->getOne('order_id=' . $order_id);
        $country = BaseLogic::load('country')->getOneById($address['country_id']);
        $shipping = BaseLogic::load('shipping')->getOneById($order['shipping_id']);
        $user = BaseLogic::load('user')->getOneById($order['user_id']);
        if (!$user)
        {
            return;
        }
        $username = $user['base_name'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $admin_email,
            'language_id' => $language_id,
            'content' => array(
                'username' => $username,
                'itemno' => $order['itemno'],
                'id' => $order['id'],
                'currency_code' => $order['currency_code'],
                'currency_rate' => $order['currency_rate'],
                'first_name' => $address['first_name'],
                'last_name' => $address['last_name'],
                'street' => $address['address'],
                'state' => $address['state'],
                'city' => $address['city'],
                'country' => $country['base_name'],
                'postcode' => $address['postcode'],
                'telephone' => $address['telephone'],
                'email' => $address['email'],
                'domain' => $order['domain'],
                'final_amount' => $order['final_amount'],
                'cost_shipping' => $order['cost_shipping'],
                'remark' => $order['remark'],
                'create_time' => date('Y-m-d H:s:i', $order['create_time']),
                'express' => $shipping['base_name'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $admin_email . ' 订单：' . $order['itemno'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '订单支付成功提醒管理员',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $order['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    public static function messageReplyAfter($message)
    {
        $event_codeno = 'message_reply_tip';
        $language_id = $message['language_id'];
        $sent_to = '';
        if ($message['user_id'])
        {
            $user = BaseLogic::load('user')->getOneById($message['user_id']);
            if (!$user)
            {
                return;
            }
            $sent_to = $user['base_name'];
        }
        else
        {
            if ($message["contact"] != "")
            {
                $message["contact"] = json_decode($message["contact"], true);
            }
            else
            {
                $message["contact"] = array();
            }
            $sent_to = $message["contact"]['email'];
        }
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $sent_to,
            'language_id' => $message['language_id'],
            'content' => array(
                'username' => $sent_to,
                'id' => $message['id'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $sent_to . ' 回复留言：' . $message['base_name'],
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '留言回复',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $message['language_id'],
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    /**
     *
     * @param $url 需要拦截的路径
     */
    public static function chkUrl($url)
    {
        $flag = TRUE;
        foreach ($url as $k => $v)
        {
            if ($v == _g($k))
            {
                continue;
            }
            else
            {
                $flag = FALSE;
                break;
            }
        }
        return $flag;
    }

    /**
     * 执行curl
     * @param type $url
     * @param type $post_data
     * @param type $charsetfrom
     * @param type $charsetto
     * @param type $timeout
     * @return type
     */
    public static function getRemoteData($url, $post_data = array(), $charsetfrom = "", $charsetto = "", $timeout = 60)
    {
        $ch = curl_init();
        $a = array(" ");
        $b = array("%20");
        $url = str_replace($a, $b, $url);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        if (count($post_data) > 0)
        {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        }
        //在需要用户检测的网页里需要增加下面两行
        //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        //curl_setopt($ch, CURLOPT_USERPWD, US_NAME.":".US_PWD);
        $contents = curl_exec($ch);
        curl_close($ch);
        if ($charsetfrom != "" && $charsetto != "")
        {
            $contents = iconv($charsetfrom, $charsetto, $contents);
        }
        return $contents;
    }

    /**
     * 读取事件所需参数
     * @param type $codeno
     * @return type
     */
    public static function getEvnetParams($codeno, $language_id = 0, $params = array())
    {
        $eventLogic = BaseLogic::load('event');
        return $eventLogic->getCond($codeno, $language_id, $params);
    }

    /**
   * 商品到货通知
   * @return type
   */
    public static function goodsArrivalAfter($outStock)
    {
        $event_codeno = 'goods_arrival_notice';
        if($outStock['order_id']){
            $order    = BaseLogic::load('order')->getOneById($outStock['order_id']);
            if(!$order)
            {
              return;
            }
            $event = self::getEvnetParams($event_codeno, $order['language_id']);
            if(!$event)
            {
              return;
            }
            $language_id = $order['language_id'];
        }else{
            global $cfg;
            $language_id = $cfg['sites'][0]['base_site'];
            $event = self::getEvnetParams($event_codeno, $language_id);
            if(!$event)
            {
              return;
            }
        }
        $params = array(
            'sent_to'  => $outStock['email'],
            'language_id' => $language_id,
            'content' => array(
                'goods_id'       => $outStock['goods_id'],
				'username'       => $outStock['email'],
                'domain' => SITE_URL,
            ),
      );
      $security_key = date('ymdhis').Common::random(5);
      $params = array_merge($params, $event);
      $data = array(
          'task_stage_id' => $event['task_id'],
          'base_name'  => '接收邮箱：' . $outStock['email'] . ' 商品名称：'.$outStock['base_name'],
          'codeno' => $event_codeno,
          'params' => json_encode($params),
          'security_key' => $security_key,
          'remark'  => '商品到货通知',
          'remote_url'   => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
          'language_id'  => $language_id,
          'trigger_time' => $event['trigger_time'],
          'create_time'  => SYS_TIME,
      );
      $taskListLogic = BaseLogic::load('taskList');
      $res = $taskListLogic->save($data);
      if ($res && $event['trigger_type'])
      {
         $taskListLogic->process(array($res), array($security_key));
      }

    }


    public static function shopcartReminder($user_id,$language_id)
    {
        //$language_id = BaseLogic::load('language')->language_id;
        if (!$user_id)
        {
            return;
        }
        $event_codeno = 'shop_cart_reminder';
        //$username     = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
        $userLogic = BaseLogic::load('user');
        $user = $userLogic->getOne('id=' . $user_id);
        if (!$user)
        {
            return;
        }
        $username = $user['base_name'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $username,
            'language_id' => $language_id,
            'user_id' => $user_id,
            'content' => array(
                'username' => $username,
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $username,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '购物车有商品提醒',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $send_result = $taskListLogic->process(array($res), array($security_key));
            if($send_result)
            {

            }
            else
            {

            }
        }
    }

    public static function wishlistReminder($user_id,$language_id)
    {
        //$language_id = BaseLogic::load('language')->language_id;
        if (!$user_id)
        {
            return;
        }
        $event_codeno = 'wishlist_reminder';
        //$username     = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
        $userLogic = BaseLogic::load('user');
        $user = $userLogic->getOne('id=' . $user_id);
        if (!$user)
        {
            return;
        }
        $username = $user['base_name'];
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event)
        {
            return;
        }
        $params = array(
            'sent_to' => $username,
            'language_id' => $language_id,
            'user_id' => $user_id,
            'content' => array(
                'username' => $username,
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $username,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '收藏列表有商品提醒',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type'])
        {
            $taskListLogic->process(array($res), array($security_key));
        }
    }

    //游客会员留言发邮件
    public static function userLeaveMessageAfter($email,$message_id,$language_id) {
        global $cfg;
        $admin_email = $cfg['sites'][$language_id]['admin_email'];
        if (!$admin_email || !$message_id) {
            return;
        }
        $where = "id=" . $message_id;
        $messageLogic = BaseLogic::load('message');
        $message = $messageLogic->getOne($where);
        $event_codeno = 'user_leavemessage_after';
        $event = self::getEvnetParams($event_codeno, $language_id);
        if (!$event) {
            return;
        }
        $params = array(
            'sent_to' => $admin_email,
            'language_id' => $language_id,
            'user_id' => $user_id,
            'content' => array(
                'username' => $email,
                'id' => $message_id,
                'message_title' => $message['base_name'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $admin_email,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '留言提醒',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type']) {
            $taskListLogic->process(array($res), array($security_key));
        }
    }
    /**
     * 游客会员留言自动回复给会员
     * @global type $cfg
     * @param type $email
     * @param type $message_id
     * @param type $language_id
     * @return type
     */
    public static function userLeaveMessageGuest($email,$message_id,$language_id){
        global $cfg;		
		$admin_email = $cfg['sites'][$language_id]['admin_email'];
        if (!$email || !$message_id) {
            return;
        }		
        $where = "id=" . $message_id;
        $messageLogic = BaseLogic::load('message');
        $message = $messageLogic->getOne($where);
        $event_codeno = 'leavemessage_sendto_guest';
        $event = self::getEvnetParams($event_codeno, $language_id);        
        if (!$event) {
            return;
        }
        $params = array(
            'sent_to' => $email,
            'language_id' => $language_id,
            'user_id' => $user_id,
            'content' => array(
                'username' => $email,
                'id' => $message_id,
                'message_title' => $message['base_name'],
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $email,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '留言提醒',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type']) {
            $taskListLogic->process(array($res), array($security_key));
        }
    }
	/**
	* 游客会员前台首页订阅邮件回复订阅成功
	* @global type $cfg
	* @param type $email	
	* @param type $language_id
	* @return type
	*/
	public static function userSubmitNewsletter($email,$language_id){
		global $cfg;
		if(!$email){
			return;
		}
        $event_codeno = 'user_submitnewsletter';
        $event = self::getEvnetParams($event_codeno, $language_id);        
        if (!$event) {
            return;
        }
        $params = array(
            'sent_to' => $email,
            'language_id' => $language_id,            
            'content' => array(
                'username' => $email,
				'domain' => SITE_URL,
            ),
        );
        $security_key = date('ymdhis') . Common::random(5);
        $params = array_merge($params, $event);
        $data = array(
            'task_stage_id' => $event['task_id'],
            'base_name' => '接收邮箱：' . $email,
            'codeno' => $event_codeno,
            'params' => json_encode($params),
            'security_key' => $security_key,
            'remark' => '留言提醒',
            'remote_url' => Common::frontURL('home', 'email', 'sentEmail', array('codeno' => $event_codeno, 'key' => $security_key)),
            'language_id' => $language_id,
            'trigger_time' => $event['trigger_time'],
            'create_time' => SYS_TIME,
        );
        $taskListLogic = BaseLogic::load('taskList');
        $res = $taskListLogic->save($data);
        if ($res && $event['trigger_type']) {			
            $taskListLogic->process(array($res), array($security_key));
        }
	}
}

?>
