<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
require_once(APP_ROOT . "conf/site.conf.php");
require_once(APP_ROOT . "libary/BaseLogic.php");
class GrowthFactory
{
  function __construct()
  {
    ;
  }
  public static function chkData()
  {
    self::userRegisterAfter();    
    self::orderPayAfter(); 
    self::backOrderPayAfter();
     /* 
      *
    self::userLoginAfter(); 
    self::addOrderAfter();
    self::userFastLoginAfter(); 
    self::orderReturnAfter();
    self::orderCancelAfter();
    self::addCartAfter();
    self::stockAlert();
     * 
     */
  }
  /**
   * 每日登陆
   */
  public static function dailyLoginAfter($user)
  {
      $codeno  = 'daily_login_sent_growth';
      $user_id = $user['id'];
      $language_id = $user['language_id'];       
      $growthEventLogic = BaseLogic::load('growthEvent');
      $growth = $growthEventLogic->manageGrowth($codeno, $user_id, $language_id);
      if($growth['is_notice'])
      {
         //发送通知处理
         $login_name   = $user['base_name'];
         $post_data =  array( 
                      'codeno' => '',
                      'sent_to'   => $login_name,
                      'username'  => $login_name,
                      'email_tpl_id' => $growth['email_tpl_id'],
                      'msg_tpl_id'   => $growth['msg_tpl_id'],
                      'sms_tpl_id'   => $growth['sms_tpl_id'],                     
                      'title'        => $codeno,
                      'var_descript' => 'growth',
                      'language_id'  => $language_id,
                      'domain'       => SITE_URL,
                      'growth_value' => $growth['growth'],
                );                 
             $curl = SITE_PROTOCOL . SITE_URL . '/index.php?m=home&c=email&a=sent';
             self::getRemoteData($curl, $post_data, '', '', 2);
       }
  }
  /**
   * 用户注册后触发事件
   * 用户注册赠送 codeno  : user_register_sent_growth
   */
  public static function userRegisterAfter($user)
  {           
       $codeno = 'user_register_sent_growth';
       $user_id = $user['id'];
       $language_id = $user['language_id'];       
       $growthEventLogic = BaseLogic::load('growthEvent');
       $growth = $growthEventLogic->manageGrowth($codeno, $user_id, $language_id);
       if($growth['is_notice'])
       {
         //发送通知处理
         $login_name   = $user['base_name'];
         $post_data =  array( 
                      'codeno' => '',
                      'sent_to'   => $login_name,
                      'username'  => $login_name,
                      'email_tpl_id' => $growth['email_tpl_id'],
                      'msg_tpl_id'   => $growth['msg_tpl_id'],
                      'sms_tpl_id'   => $growth['sms_tpl_id'],                     
                      'title'        => $codeno,
                      'var_descript' => 'growth',
                      'language_id'  => $language_id,
                      'domain'       => SITE_URL,
                      'growth_value' => $growth['growth'],
                );                 
             $curl = SITE_PROTOCOL . SITE_URL . '/index.php?m=home&c=email&a=sent';
             self::getRemoteData($curl, $post_data, '', '', 2);
       }
  }
  /**
   * 用户注册后触发事件
   * 推荐用户赠送 condeno : recommend_user_sent
   */
  public static function recommendUserAfter($user)
  {           
       $codeno = 'recommend_user_sent';
       $user_id = $user['id'];
       $language_id = $user['language_id'];       
       $growthEventLogic = BaseLogic::load('growthEvent');
       $growth = $growthEventLogic->manageGrowth($codeno, $user_id, $language_id);
       if($growth['is_notice'])
       {
         //发送通知处理
         $login_name   = $user['base_name'];
         $post_data =  array( 
                      'codeno' => '',
                      'sent_to'   => $login_name,
                      'username'  => $login_name,
                      'email_tpl_id' => $growth['email_tpl_id'],
                      'msg_tpl_id'   => $growth['msg_tpl_id'],
                      'sms_tpl_id'   => $growth['sms_tpl_id'],                     
                      'title'        => $codeno,
                      'var_descript' => 'growth',
                      'language_id'  => $language_id,
                      'domain'       => SITE_URL,
                      'growth_value' => $growth['growth'],
                );                 
             $curl = SITE_PROTOCOL . SITE_URL . '/index.php?m=home&c=email&a=sent';
             self::getRemoteData($curl, $post_data, '', '', 2);
       }
  }
  /**
   * 用户评论审核通过(一个产品只赠送一次)
   */
  public static function goodsCommentAfter($comment)
  {
      $codeno  = 'goods_comment_sent_growth';     
      $goodsCommentLogic = BaseLogic::load('goodsComment');
      $count = $goodsCommentLogic->getCount('user_id='.$comment['user_id'].' and goods_id =' . $comment['goods_id'] . ' and status=1');
      if($count == 1)
      {
          $growthEventLogic = BaseLogic::load('growthEvent');       
          $growth = $growthEventLogic->manageGrowth($codeno, $comment['user_id'], $comment['language_id']);
      } 
  }

  /**
   * 
   * 订单支付成功后 
   */
  public static function orderPayAfter($order)
  {
      $codeno  = 'order_paid_sent';     
      $orderLogic = BaseLogic::load('order');
      if(true)
      {
          $count = $orderLogic->getCount('user_id='.$order['user_id'].' and create_time <' . $order['create_time']);
          if($count <= 0)
          {
            $order['first'] = 1;
          }
          $growthEventLogic = BaseLogic::load('growthEvent');       
          $growth = $growthEventLogic->manageGrowth($codeno, $order['user_id'], $order['language_id'], $order);
          if($growth['is_notice'])
          {
            //发送通知处理
            $login_name   = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
            $base_name    = _p('email');
          }
      }      
  }
  
  /**
   * 
   * 订单支付成功后 
   */
  public static function recommendUserFirstPayAfter($order)
  {
      $codeno  = 'recommend_user_first_pay_sent';     
      $orderLogic = BaseLogic::load('order');
      $user = BaseLogic::load('user')->getOne('id='.$order['user_id'].' and parent_user_id>0');
      if(!$user)
      {
          return;
      }
      if(true)
      {
          $count = $orderLogic->getCount('user_id='.$order['user_id'].' and create_time <' . $order['create_time']);
          if($count <= 0)
          {
            $growthEventLogic = BaseLogic::load('growthEvent');
            $parent_user = BaseLogic::load('user')->getOne('id='.$user['parent_user_id']);
            $growth = $growthEventLogic->manageGrowth($codeno, $parent_user['id'], $order['language_id'], $order);
            if($growth['is_notice'])
            {
              //发送通知处理
              $login_name   = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
              $base_name    = _p('email');
            }
          }
      }      
  }
  
  /**
   * 连续未登录天数 减少 
   * codno : continue_no_login_reduce;
   */
  public static function userLoginAfter()
  {
    $url = array("m"=>"home", "c"=>"user", "a"=>"login");
    if(self::chkUrl($url))
    {
      $codeno  = 'continue_no_login_reduce';
      $growthEventLogic = BaseLogic::load('growthEvent');
      $language_id      = BaseLogic::load('language')->language_id;
      $user_id = _c('user_id') ? _c('user_id') : _s('user_id');
       $growth = $growthEventLogic->manageGrowth($codeno, $user_id, $language_id);
       if($growth['is_notice'])
       {
         //发送通知处理
         $login_name   = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
         $base_name    = _p('email');
         //
       }
    }
  }
  
 
  /**
   * 下订单后
   * 连续下单未支付减少 codeno : 'continue_order_unpaid_reduce';
   * 
   */
  public static function addOrderAfter()
  {
    $url = array("m"=>"home", "c"=>"order", "a"=>"step2");
    if(self::chkUrl($url))
    {
        $codeno  = 'continue_order_unpaid_reduce';
        $growthEventLogic = BaseLogic::load('growthEvent'); 
        $language_id      = BaseLogic::load('language')->language_id;
        $user_id = _c('user_id') ? _c('user_id') : _s('user_id');
        $growth  = $growthEventLogic->manageGrowth($codeno, $user_id, $language_id);
        if($growth['is_notice'])
        {
          //发送通知处理
          $login_name   = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
          $base_name    = _p('email');
        }
    }
  }
  /**
   * 订单退货减少
   */
  public static function orderReturnAfter()
  {
    $url = array("m"=>"order", "c"=>"order", "a"=>"returnGoods");
    if(self::chkUrl($url))
    {
      $codeno  = 'order_return_sent';             
    }
  }
  /**
   * 连续未登录天数 减少 
   * codno : continue_no_login_reduce;
   */
  public static function userFastLoginAfter()
  {
    $url = array("m"=>"home", "c"=>"user", "a"=>"loginAjax");
    if(self::chkUrl($url))
    {
      $codeno  = 'continue_no_login_reduce';
      $growthEventLogic = BaseLogic::load('growthEvent');
      $language_id      = BaseLogic::load('language')->language_id;
       $user_id = _c('user_id') ? _c('user_id') : _s('user_id');
       $growth = $growthEventLogic->manageGrowth($codeno, $user_id, $language_id);
       if($growth['is_notice'])
       {
         //发送通知处理
         $login_name   = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
         $base_name    = _p('email');
         
       }
    }
  }

  /**
   *
   * @param $url 需要拦截的路径
   */
  public static function chkUrl($url)
  {
    $flag = TRUE;
    foreach ($url as $k => $v)
    {          
      if (strtolower($v) == strtolower(_g($k)))
      {
        continue;
      }
      else
      {
        $flag = FALSE;
        break;
      }
    }
    return $flag;
  }
  /**
   * 执行curl
   * @param type $url
   * @param type $post_data
   * @param type $charsetfrom
   * @param type $charsetto
   * @param type $timeout
   * @return type 
   */
  public static function getRemoteData($url,$post_data=array(), $charsetfrom="",$charsetto="",$timeout=60)
	{
		$ch = curl_init();
		$a = array(" ");
		$b = array("%20");
		$url = str_replace($a, $b, $url);
		curl_setopt($ch, CURLOPT_URL, $url); 
		curl_setopt($ch,CURLOPT_HEADER,0);   
		curl_setopt($ch,CURLOPT_TIMEOUT,$timeout);   
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout); 
        if(count($post_data)>0)
        {
            curl_setopt($ch, CURLOPT_POST, 1 );
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        }
		//在需要用户检测的网页里需要增加下面两行 
		//curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY); 
		//curl_setopt($ch, CURLOPT_USERPWD, US_NAME.":".US_PWD); 
		$contents = curl_exec($ch); 
		curl_close($ch); 
		if( $charsetfrom!="" && $charsetto!="" )
		{
			$contents = iconv($charsetfrom, $charsetto,$contents);
		}
		return $contents; 
	}
    /**
     * 读取事件所需参数
     * @param type $codeno
     * @return type 
     */
    public static function getEvnetParams($codeno, $language_id=0, $params=array())
    {
      $eventLogic = BaseLogic::load('event');
      return $eventLogic->getCond($codeno, $language_id, $params);
    }

}

?>
