<?php

/**
 * Description of Image
 *
 * @author xrx
 */
require_once(APP_ROOT . 'conf/site.conf.php');
class Image
{
    public static function makethumb($srcFile,$dstFile,$dstW,$dstH,$rate=100,$markwords=null,$markimage=null) 
    {
        global $cfg;
        $data = getimagesize($srcFile); 
		// 图片过小的情况
		if($data[0]<$dstW && $data[1]<$dstH)
		{
			copy($srcFile,$dstFile);
			return ;
		}
        switch($data[2]) 
        { 
        case 1: 
            $im=@imagecreatefromgif($srcFile); 
            break; 
        case 2: 
            $im=@imagecreatefromjpeg($srcFile); 
            break; 
        case 3: 
            $im=@imagecreatefrompng($srcFile); 
            break; 
        } 
        if(!$im) return false; 
        $srcW=ImageSX($im); 
        $srcH=ImageSY($im); 
        $dstX=0; 
        $dstY=0; 
        //图像比例——宽高计算
        $resize_ratio=$dstW/$dstH;
        $ratio=$srcW/$srcH;
        if(THUMB_X_WHITE || THUMB_Y_WHITE)
        {
            if(THUMB_X_WHITE && THUMB_Y_WHITE)
            {

            }
            else if(THUMB_X_WHITE)
            {
                if($ratio>=$resize_ratio)
                {
                    $dstH=$dstW/$ratio;
                }
            }
            else if(THUMB_Y_WHITE)
            {
                if($ratio<=$resize_ratio)
                {
                    $dstW=$dstH*$ratio;
                }
            }
        }
        else
        {
            if($ratio>=$resize_ratio)
            {
                $dstH=$dstW/$ratio;
            }
            else
            {
                $dstW=$dstH*$ratio;
            }
        }
        //
        if ($srcW*$dstH>$srcH*$dstW) 
        { 
          $fdstH = round($srcH*$dstW/$srcW); 
          $dstY = floor(($dstH-$fdstH)/2); 
          $fdstW = $dstW; 
        } 
        else 
        { 
          $fdstW = round($srcW*$dstH/$srcH); 
          $dstX = floor(($dstW-$fdstW)/2); 
          $fdstH = $dstH; 
        } 
        $ni=ImageCreateTrueColor($dstW,$dstH); 
        $dstX=($dstX<0)?0:$dstX; 
        $dstY=($dstX<0)?0:$dstY; 
        $dstX=($dstX>($dstW/2))?floor($dstW/2):$dstX; 
        $dstY=($dstY>($dstH/2))?floor($dstH/s):$dstY; 
        $white = ImageColorAllocate($ni,255,255,255); 
        $black = ImageColorAllocate($ni,0,0,0); 
        imagefilledrectangle($ni,0,0,$dstW,$dstH,$white);// 填充背景色 
        imagecopyresampled($ni,$im,$dstX,$dstY,0,0,$fdstW,$fdstH,$srcW,$srcH); 

        ImageJpeg($ni,$dstFile,$rate);
        if(intval($dstW)>=intval($cfg['sites'][0]['markwaters_width'])||intval($dstH)>=intval($cfg['sites'][0]['markwaters_height'])){
         if($cfg['sites'][0]['markwaters_status']){
        $markwords=$markwords?$markwords:''.$cfg['sites'][0]['watermark_fontstring'];
        if(substr(UPLOAD_DOMAIN,0,1)=='/')
        {
            $markimage=$markimage?$markimage: UPLOAD_DIR .$cfg['sites'][0]['watermark_image'];
        }
        else
        {
            $markimage=$markimage?$markimage:UPLOAD_DOMAIN . UPLOAD_DIR .$cfg['sites'][0]['watermark_image'];
        }
        $fontsize=$fontsize?$fontsize:$cfg['sites'][0]['watermark_fontsize'];
        $xcolor=$xcolor?$xcolor:$cfg['sites'][0]['watermark_fontcolor'];
        $xangle=$xangle?$xangle:$cfg['sites'][0]['watermark_angle'];
        $xfont=$xfont?$xfont:  realpath(  UPLOAD_DIR .'font/'.$cfg['sites'][0]['watermark_font']);
        $xfont=$xfont?$xfont:'simhei.ttf';
        $xangle=  empty($xangle)?0:$xangle;
        $xcolor=  empty($xcolor)?'#000000':$xcolor;
        $fontsize=  empty($fontsize)?18:$fontsize;
        }
        
            $niimage_data = getimagesize($dstFile);
            switch($niimage_data[2]) 
            { 
                case 1: 
                    $niimage=@imagecreatefromgif($dstFile); 
                    break; 
                case 2: 
                    $niimage=@imagecreatefromjpeg($dstFile); 
                    break; 
                case 3: 
                    $niimage=@imagecreatefrompng($dstFile); 
                    break; 
            } 
//        if($markwords!=null) 
//        {
//            $hrgb=self::hColor2RGB($xcolor);
//            $xcolort=ImageColorAllocate($niimage, $hrgb["r"] ,$hrgb["g"], $hrgb["b"]);
//            $wh=self::getwatermarkpos($niimage_data,array($cfg['sites'][0]['watermark_fontwidth'],$cfg['sites'][0]['watermark_fontheight']),"text");
//            $markwords=iconv("gb2312","UTF-8",$markwords);
//            //转换文字编码 
//           $res= ImageTTFText($niimage,$fontsize,$xangle,$wh[0],$wh[1],$xcolort,$xfont,$markwords); //写入文字水印 
//            //参数依次为，文字大小|偏转度|横坐标|纵坐标|文字颜色|文字类型|文字内容 
//            switch($niimage_data[2]) 
//            { 
//                case 1: 
//               imagegif($niimage,$dstFile);
//                    break; 
//                case 2: 
//               imagejpeg($niimage,$dstFile);
//                    break; 
//                case 3: 
//               imagepng($niimage,$dstFile);
//                    break; 
//            }
//            imagedestroy($wimage);
//        }
        if($markimage!=null){ 
            $wimage_data = getimagesize($markimage); 
            switch($wimage_data[2]) 
            { 
                case 1: 
                    $wimage=@imagecreatefromgif($markimage); 
                    break; 
                case 2: 
                    $wimage=@imagecreatefromjpeg($markimage); 
                    break; 
                case 3: 
                    $wimage=@imagecreatefrompng($markimage); 
                    break; 
            } 
            $watermarkpos=self::getwatermarkpos($niimage_data,$wimage_data);
            $res=imagecopy($niimage,$wimage,$watermarkpos[0],$watermarkpos[1],0,0,$wimage_data[0],$wimage_data[1]); //写入图片水印,水印图片大小默认为88*31 
            
            switch($niimage_data[2]) 
            { 
                case 1: 
               imagegif($niimage,$dstFile);
                    break; 
                case 2: 
               imagejpeg($niimage,$dstFile);
                    break; 
                case 3: 
               imagepng($niimage,$dstFile);
                    break; 
            }  
            imagedestroy($wimage);
        } 
            
        }
        imagedestroy($ni);
    }
    public static function getImageURL($file,$style)
    {          
        if(trim($file)=="")
        {
              return APP_ROOT . UPLOAD_DIR .  "system/nopic.png"; 
        }
        $thumb_config = self::getImageFormat();
        $imagestyle   = in_array($style, $thumb_config) ? $style : ''; 
        $show_url     = '';
        if($imagestyle)
        {
          $file_info   = self::file_format(trim($file), $imagestyle);
          $show_url    = str_replace('#','%23',($file_info['imageurl'])); 
          $style_split = explode('x', $imagestyle) ;
          $width       = $style_split[0]; 
          $height      = $style_split[1];
          if ( is_file( $file_info['target'] ) )
          {
              return $show_url;
          }
          else if ( !is_file( $file_info['source'] ) )
          { //没有源图片
            $format = $width . 'x' . $height;
            $system_source = APP_ROOT . UPLOAD_DIR .  "system/nopic.png";
            $imageurl      =  UPLOAD_DOMAIN . UPLOAD_DIR . 'thumb/' . $format . "/nopic.png";
            $target        =   APP_ROOT . UPLOAD_DIR . 'thumb/' . $format . "/nopic.png";
            if (!is_file( $target ) ){                                     
                $path_parts = pathinfo( $target );
                $todir = $path_parts["dirname"] ;
                if( !is_dir($todir) )
                {
                    self::rmkdir($todir);
                }
                self::makethumb($system_source, $target,$width, $height);
				
            }   
			return false;         
            $show_url = str_replace('#','%23', $imageurl);           
          }
          if (!is_file( $file_info['target'] ) )
          {                                     
              $path_parts = pathinfo( $file_info['target'] );
              $todir = $path_parts["dirname"] ;
              if( !is_dir($todir) )
              {
                  self::rmkdir($todir);
              }
              self::makethumb($file_info['source'],$file_info['target'],$width, $height);               
          }
        }
        else
        {
          return is_file( $file_info['source'] ) ? $file_info['source'] : APP_ROOT . UPLOAD_DIR .  "system/nopic.png";
        }        
        return $show_url;
    }

    public static function getImageResize($path,$maxwidth,$maxheight)
    {
        $resize_ratio = $maxwidth / $maxheight ;
        $filearray = getimagesize (  $path );
        $ratio = $filearray[0] / $filearray[1] ;
        if( $ratio >= $resize_ratio)
        {
            return array( $maxwidth , ( $filearray[1] * $maxwidth ) / $filearray[0] ) ;
        }
        else
        {
            return array( ( $filearray[0] * $maxheight ) / $filearray[1] , $maxheight ) ;
        }
    }

    public static function deleteImage($file,$arr,$folder="../uploadImage/",$urlstyle=0)
    {
        if($file=="")
            return ;
        if($urlstyle!=1)
        {
            $pic2 = $folder . $file ;
            if ( file_exists( $pic2 ) )
            {
                unlink( $pic2 ) ;
            }
            for($index=1;$index<count($arr);$index++)
            {
                $pic = "../smallImage/" . $arr[$index] . "/" . $file ;
                if ( file_exists( $pic ) )
                {
                    unlink( $pic ) ;
                }
            }
            return true;
        }
        else
        {
            //debug(DELETECDN);
            if( DELETECDN == 1 )
            {
                $http = CGIBIN . "serviceFordeletepimage.php?" . "file=" . urlencode($file) . "&arr=" . urlencode( join('|',$arr) ) . "&folder=" . urlencode($folder) . "&" . REMOTECOMMAND ;
                $text =  file_get_contents( $http ) ;
            }
            //debug($http);
            //debug($text . $http );
        }
    }
    /**
     * 创建目录
     * @param type $path
     * @param type $mode
     * @return type 
     */
    public static function rmkdir($path, $mode = 0777) {
        return is_dir($path) || ( self::rmkdir(dirname($path), $mode) && self::_mkdir($path, $mode) );
    }
    /**
     * 创建目录
     * @param type $path
     * @param type $mode
     * @return type 
     */
    public static function _mkdir($path, $mode = 0777) {
        $old = umask(0);
        $res = @mkdir($path, $mode);
        umask($old);
        return $res;
    }
    public static function file_format($file, $format)
    {
      if(substr($file, 0, 6) != 'upload')
      {
        $source   =  APP_ROOT . UPLOAD_DIR . $file ;
        $imageurl =  UPLOAD_DOMAIN . UPLOAD_DIR . 'thumb/' . $format . "/" . $file ;
        $target   =   APP_ROOT . UPLOAD_DIR . 'thumb/' . $format . "/" . $file ;
      }
      else
      {
         $source   =  APP_ROOT . $file ;
         $imageurl =  UPLOAD_DOMAIN . 'thumb/' . $format . "/" . $file ;
         $target   =   APP_ROOT . 'thumb/' . $format . "/" . $file ;
      }
            
      return array('source' => $source, 'imageurl' => $imageurl, 'target' => $target);
    }
    /**
     * 读取配置参数
     * @global type $thumb_config
     * @global type $cfg
     * @return string 
     */
    public static function getImageFormat(){
       global $thumb_config , $cfg;
       $cfg_base_info =  $cfg['sites'][0];
       $thumb_config['mainpic']  = $cfg_base_info['mainpic_width'] . 'x' . $cfg_base_info['mainpic_height'];
       $thumb_config['list1pic'] = $cfg_base_info['list1pic_width'] . 'x' . $cfg_base_info['list1pic_height'];
       $thumb_config['list2pic'] = $cfg_base_info['list2pic_width'] . 'x' . $cfg_base_info['list2pic_height'];
       $thumb_config['list3pic'] = $cfg_base_info['list3pic_width'] . 'x' . $cfg_base_info['list3pic_height'];       
       $thumb_config['syspic']   = $cfg_base_info['syspic_width'] . 'x' . $cfg_base_info['syspic_height']; 
       $thumb_config['singlepropic'] = $cfg_base_info['singlepropic_width'] . 'x' . $cfg_base_info['singlepropic_height'];
       
       //导入模板缩略图配置
      $theme_name = isset($_SESSION['theme_name'])? $_SESSION['theme_name'] : 'newdefault';
      include_once THEME_ROOT.$theme_name. '/template.conf.php';
      $tpl_thumb_config = isset($result['thumb_config']) ? $result['thumb_config'] : array();
      return array_merge($thumb_config, $tpl_thumb_config);
    } 
     /**
     * 颜色字段转换
     */
    public static function hColor2RGB($hexColor){
        $color = str_replace('#', '', $hexColor);
        if (strlen($color) > 3)
        {
            $rgb = array(
                'r' => hexdec(substr($color, 0, 2)),
                'g' => hexdec(substr($color, 2, 2)),
                'b' => hexdec(substr($color, 4, 2))
            );
        } else
        {
            $color = str_replace('#', '', $hexColor);
            $r = substr($color, 0, 1) . substr($color, 0, 1);
            $g = substr($color, 1, 1) . substr($color, 1, 1);
            $b = substr($color, 2, 1) . substr($color, 2, 1);
            $rgb = array(
                'r' => hexdec($r),
                'g' => hexdec($g),
                'b' => hexdec($b)
            );
        }
        return $rgb;
    }
    
     /**
     * 水印位置
     */
    private function getwatermarkpos($x,$y,$type=false){
        global $cfg;
        $res=array(0,0);
        if($type){
            $watemarkpos=$cfg['sites'][0]['watermark_fontpos'];
        }else{
            $watemarkpos=$cfg['sites'][0]['watermarkpos'];
        }
        switch (intval($watemarkpos)) {
            case 0://随机 
            $res[0] = rand(0,($x[0] - $y[0])); 
            $res[1] = rand(0,($x[1] - $y[1])); 
            break; 
            case 1://1为顶端居左 
            $res[0] = 0; 
            $res[1] = 0;
                break;
            case 2://2为顶端居中 
            $res[0] = ($x[0] - $y[0]) / 2;
            $res[1] = 0;
                break;
        case 3://3为顶端居右 
            $res[0]= $x[0] - $y[0]; 
            $res[1] = 0; 
            break; 
        case 4://4为中部居左 
            $res[0]= 0; 
            $res[1] = ($x[1] - $y[1]) / 2; 
            break; 
        case 5://5为中部居中 
            $res[0]= ($x[0] - $y[0]) / 2; 
            $res[1] = ($x[1] - $y[1]) / 2; 
            break; 
        case 6://6为中部居右 
            $res[0]= $x[0] - $y[0]; 
            $res[1] = ($x[1] - $y[1]) / 2; 
            break; 
        case 7://7为底端居左 
            $res[0]= 0; 
            $res[1] = $x[1] - $y[1]; 
            break; 
        case 8://8为底端居中 
            $res[0]= ($x[0] - $y[0]) / 2; 
            $res[1] = $x[1] - $y[1]; 
            break; 
        case 9://9为底端居右 
            $res[0]= $x[0] - $y[0]; 
            $res[1] = $x[1] - $y[1]; 
            break; 
            default:
            $res[0] = 0; 
            $res[1] = 0;
                break;
        }
        return $res;
    }
     /**
     * 验证码生成 
     */
    public static function getValidateCode()
    {
       header("Cache-Control: no-cache, must-revalidate");       
       require_once(APP_ROOT . 'libary/ValidateCode.php');
       $codeObj = new ValidateCode();
       $codeObj->createImg();
       $_SESSION['validate_code'] = $codeObj->getCode();
//     print_r($codeObj->getCode());die;
       $codeObj->outPut();       
    }
}

?>
