<?php

/**
 * 用户输入处理组件
 *
 * @author xrx
 * @package libary
 * @version 1.0
 */
class Inputer
{

  /**
   * 是否开启了 GPC 自动转义
   *
   * @var bool
   */
  static protected $_magicQuote = FALSE;
  static public $_p = null;
  static public $_g = null;
  static public $_c = null;
  static public $_s = null;

  /**
   * 获取 GET 参数
   *
   * @param string $key
   * @param mixed $default
   * @return mixed
   */
  public static function get($key = NULL, $default = NULL)
  {
    if (!empty($key))
    {
      return isset($_GET[$key]) ? $_GET[$key] : $default;
    }
    else
    {
      return $_GET;
    }
  }

  /**
   * 获取 POST 参数
   *
   * @param string $key
   * @param mixed $default
   * @return mixed
   */
  public static function post($key = NULL, $default = NULL)
  {
    if (!empty($key))
    {
      return isset($_POST[$key]) ? $_POST[$key] : $default;
    }
    else
    {
      return $_POST;
    }
  }

  /**
   * 获取 COOKIE 参数
   *
   * @param string $key
   * @param mixed $default
   * @return mixed
   */
  public static function cookie($key = NULL, $default = NULL)
  {
    if (!empty($key))
    {
      return isset($_COOKIE[$key]) ? $_COOKIE[$key] : $default;
    }
    else
    {
      return $_COOKIE;
    }
  }

  /**
   * 获取 SESSION 参数
   *
   * @param string $key
   * @param mixed $default
   * @return mixed
   */
  public static function session($key = NULL, $default = NULL)
  {
    if (!empty($key))
    {
      return isset($_SESSION[$key]) ? $_SESSION[$key] : $default;
    }
    else
    {
      return $_SESSION;
    }
  }

  /**
   * 组件初始化
   */
  public static function init()
  {
    Inputer::$_magicQuote = get_magic_quotes_gpc();
    Inputer::$_p = $_POST;
    Inputer::$_g = $_GET;
    Inputer::$_c = $_COOKIE;
    Inputer::$_s = $_SESSION;
    $_GET = Inputer::_filterGParams($_GET);
    $_POST = Inputer::_filterPParams($_POST);
    $_COOKIE = Inputer::_filterCParams($_COOKIE);
    $_SESSION = Inputer::_filterCParams($_SESSION);
  }

  /**
   * 过滤 GET 参数
   *
   * @param array $params
   * @return array
   */
  protected static function _filterGParams($params)
  {
    $result = array();
    foreach ($params as $key => $value)
    {
      if (Inputer::_isAllowedGKey($key))
      {
        if (is_array($value))
        {
          $result[$key] = Inputer::_filterGParams($value);
        }
        else
        {
          $result[$key] = Inputer::_filterGValue($value);
        }
      }
    }
    return $result;
  }

  /**
   * 过滤 POST 参数
   *
   * @param array $params
   * @return array
   */
  protected static function _filterPParams($params)
  {
    $result = array();
    foreach ($params as $key => $value)
    {
      if (Inputer::_isAllowedPKey($key))
      {
        if (is_array($value))
        {
          $result[$key] = Inputer::_filterPParams($value);
        }
        else
        {
          $result[$key] = Inputer::_filterPValue($value);
        }
      }
    }
    return $result;
  }

  /**
   * 过滤 COOKIE 参数
   *
   * @param array $params
   * @return array
   */
  protected static function _filterCParams($params)
  {
    $result = array();
    foreach ($params as $key => $value)
    {
      if (Inputer::_isAllowedCKey($key))
      {
        if (is_array($value))
        {
          $result[$key] = Inputer::_filterCParams($value);
        }
        else
        {
          $result[$key] = Inputer::_filterCValue($value);
        }
      }
    }
    return $result;
  }

  /**
   * 指示 GET 参数名是否合法
   *
   * @param string $key
   * @return bool
   */
  protected static function _isAllowedGKey($key)
  {
    return $key{0} !== '_' ? TRUE : FALSE;
  }

  /**
   * 指示 POST 参数名是否合法
   *
   * @param string $key
   * @return bool
   */
  protected static function _isAllowedPKey($key)
  {
    return $key{0} !== '_' ? TRUE : FALSE;
  }

  /**
   * 指示 COOKIE 参数名是否合法
   *
   * @param string $key
   * @return bool
   */
  protected static function _isAllowedCKey($key)
  {
    return $key{0} !== '_' ? TRUE : FALSE;
  }

  /**
   * 过滤 GET 参数值
   *
   * @param string $value
   * @return string
   */
  protected static function _filterGValue($value)
  {

    if (Inputer::$_magicQuote)
    {
      $value = stripslashes(trim($value));
    }
    $get_filter = "'|<[^>]*?>|^\\+\/v(8|9)|\\b(and|or)\\b.+?(>|<|=|\\bin\\b|\\blike\\b)|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)";
    if (preg_match("/" . $get_filter . "/is", trim($value)) == 1)
    {
      $value = preg_replace("/" . $get_filter . "/is", ' ', trim($value));
    }
    return trim($value);
  }

  /**
   * 过滤 POST 参数值
   *
   * @param string $value
   * @return string
   */
  protected static function _filterPValue($value)
  {
    if (Inputer::$_magicQuote)
    {
      $value = stripslashes(trim($value));
    }
    $post_filter = array(
        "/<(\/?)(script|style|html|body|title|link|meta|a|\?|\%)([^>]*?)>/isU", //过滤 <script 等可能引入恶意内容或恶意改变显示布局的代码,如果不需要插入flash等,还可以加入<object的过滤
        "/(<[^>]*)on[a-zA-Z] \s*=([^>]*>)/isU" //过滤javascript的on事件
    );
    $tarr = array("", "");
    $value = preg_replace($post_filter, $tarr, $value);
    return $value;
  }

  /**
   * 过滤 COOKIE 参数值
   *
   * @param string $value
   * @return string
   */
  protected static function _filterCValue($value)
  {
    if (Inputer::$_magicQuote)
    {
      $value = stripslashes(trim($value));
    }
    $cookie_filter = "\\b(and|or)\\b.{1,6}?(=|>|<|\\bin\\b|\\blike\\b)|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)";
    if (preg_match("/" . $cookie_filter . "/is", trim($value)) == 1)
    {
      $value = preg_replace("/" . $cookie_filter . "/is", ' ', trim($value));
    }
    return trim($value);
  }

  public static function setSession($key, $value)
  {
    $_SESSION[$key] = $value;
  }

  public static function getOrgPost($key=NULL)
  {
    $bak_post = Inputer::$_p;
    if (!empty($key))
    {
        if (get_magic_quotes_gpc())
        {  
            if (is_array($bak_post[$key]))
            {
              $bak_post[$key] = array_map('stripslashes', $bak_post[$key]);
              return $bak_post[$key];
            }
            else
            {
                return stripslashes(trim($bak_post[$key]));
            }
        }
        else
          return $bak_post[$key];
    }
    else
    {
        if (get_magic_quotes_gpc())
        {
		$bak_post = array_map('stripslashes', $bak_post);
		}
        return $bak_post;
    }
  }

}

if (!function_exists('_g'))
{

  function _g($key = NULL, $default = NULL)
  {
    return Inputer::get($key, $default);
  }

}

if (!function_exists('_p'))
{

  function _p($key = NULL, $default = NULL)
  {
    return Inputer::post($key, $default);
  }

}

if (!function_exists('_c'))
{

  function _c($key = NULL, $default = NULL)
  {
    return Inputer::cookie($key, $default);
  }

}
if (!function_exists('_s'))
{

  function _s($key = NULL, $default = NULL)
  {
    return Inputer::session($key, $default);
  }

}
if (!function_exists('_setSession'))
{

  function _setSession($key = NULL, $default = NULL)
  {
    return Inputer::setSession($key, $default);
  }

}

if (!function_exists('_debug'))
{

  function _debug($default = NULL)
  {
    echo "<pre>";
    print_r($default);
    echo "</pre>";
    die;
  }

}
?>