<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */

require_once(APP_ROOT . "libary/exception/TypeException.php");

/*
 * Module type definitions
 */

class Module
{

  const LOGIC = 1;
  const TABLE = 2;
  const DAO = 3;

  // TODO: other types shuold be included...
}

class ModuleFactory
{

  /**
   * Load module for the given type and name
   * 
   */
  public static function load($type, $className, $table='', $table_prefix=true)
  {
    $typeName = "";
    switch ($type)
    {
      case Module::LOGIC:
        $typeName = "logic";
        break;
      case Module::TABLE:
        $typeName = "table";
        break;
      case Module::DAO:
        $typeName = "dao";
        break;
      default:
        throw new TypeException("Module type of '" . $type . "' can't be found.");
    }
    $user_file = APP_ROOT . "app/user/"  . $typeName . "/" . ucfirst($className) . ".php";
    $system_file = APP_ROOT . "app/system/"  . $typeName . "/" . ucfirst($className) . ".php";
    
    if (!file_exists($user_file) && !file_exists($system_file))
    {      
      throw new Exception($className.'['.$typeName. '] class not found');
    }
    else
    {
      if (file_exists($user_file))
      {
        require_once $user_file;
        return $table ? new $className($table, $table_prefix) : new $className;
      }
      else if (file_exists($system_file))
      {
        require_once $system_file;
        return $table ? new $className($table, $table_prefix) : new $className;
      }

    }

  }

}

?>
