<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
require_once(APP_ROOT . "conf/site.conf.php");

class ReportFactory
{

  function __construct()
  {
    ;
  } 
  /**
   *价格记录报表
   * @param type $params[goods_id] 商品ID
   * @param type $params[sku_code] SKUCODE
   * @param type $params[pre_price] 修改前销售价
   * @param type $params[pre_cost_price] 修改前成本价
   * @param type $params[pre_market_price] 修改前市场价
   * @param type $params[price] 修改后销售价
   * @param type $params[cost_price] 修改后成本价
   * @param type $params[market_price] 修改后市场价
   */
  public static function goodsPriceReport($params)
  {
     return true;
     $goodsPriceReportLogic = self::load('goodsPriceReport');
     return $goodsPriceReportLogic->save($params);    
  }  
/**
 * 商品总趋势报表、商品分站点趋势报表、商品总销售报表
 * @param type $goods_id
 * @param type $params 
 */
  public static function goodsReportAndGoodsLanguageReport($goods_id, $language_id, $country_id, $params)
  {
      return true;
      $goodsReportLogic = self::load('goodsReport');
      $goodsLanguageReportLogic = self::load('goodsLanguageReport');
      $salesReportLogic   = self::load('salesReport');
      $year  = date('Y', SYS_TIME);
      $month = date('Ym', SYS_TIME);
      $today = date('Ymd', SYS_TIME);      
      $cond  = 'goods_id ='. $goods_id . ' and create_day =' . $today;
      $cond2 = 'goods_id ='. $goods_id . ' and create_day =' . $today . ' and language_id=' . $language_id;
      $cond3 = 'country_id ='. $country_id . ' and create_day =' . $today . ' and language_id=' . $language_id;
      $goodsReport = $goodsReportLogic->getOne($cond);      
      $salesReport = $salesReportLogic->getOne($cond3);
      $goodsLanguageReport = $goodsLanguageReportLogic->getOne($cond2);
      $map   = Zhtx::createDataMap();
      $map2  = Zhtx::createDataMap();
      $map3  = Zhtx::createDataMap();
      $map->addEntry('goods_id', $goods_id, DB::INT);
      $map2->addEntry('goods_id', $goods_id, DB::INT);
      if(isset($params['customer_unit']) || isset($params['passenger_volume']))
      {
        $payed = 0;
        $fee   = 0;      
        $pay_counts    = 0;
        $cost_shipping = 0;      
        $order_counts      = 0;
        $order_item_counts = 0;
        if($salesReport)
        {
            $payed = $salesReport['pay_amount'];
            $fee   = $salesReport['payment_fee'];
            $cost_shipping = $salesReport['cost_shipping'];
            $pay_counts    = $salesReport['pay_counts'];
            $order_counts  = $salesReport['order_counts'];
            $order_item_counts  = $salesReport['order_item_counts'];
        }
        if(isset($params['pay_amount']) && $params['pay_amount'])
        {
          $payed += $params['pay_amount']; 
        }
        if(isset($params['payment_fee']) && $params['payment_fee'])
        {
          $fee += $params['payment_fee']; 
        }
        if(isset($params['cost_shipping']) && $params['cost_shipping'])
        {
          $cost_shipping += $params['cost_shipping']; 
        }
        if(isset($params['pay_counts']) && $params['pay_counts'])
        {
          $pay_counts += $params['pay_counts']; 
        }
        if(isset($params['order_counts']) && $params['order_counts'])
        {
          $order_counts += $params['order_counts']; 
        }
        if(isset($params['order_item_counts']) && $params['order_item_counts'])
        {
          $order_item_counts += $params['order_item_counts']; 
        }
        $customer_unit    = ($payed-$fee-$cost_shipping)/$pay_counts;
        $passenger_volume = $order_item_counts/$order_counts;
        $map3->addEntry('customer_unit', $customer_unit, DB::DECIMAL);
        $map3->addEntry('passenger_volume', $passenger_volume, DB::INT);
      }
      foreach ($params as $key => $value)
      {
        switch ($key)
        {
              case 'brand_id':
                $map->addEntry('brand_id', $value, DB::INT);            
                break;
              case 'category_ids':
                $map->addEntry('category_ids', $value, DB::VARCHAR);
                $map2->addEntry('category_ids', $value, DB::VARCHAR);
                break;
              case 'visit_counts':
                $map->addEntry('visit_counts', 'visit_counts + (' . $value . ')', DB::INT);
                $map2->addEntry('visit_counts', 'visit_counts + (' . $value. ')', DB::INT);
                $map3->addEntry('visit_counts', 'visit_counts + (' . $value. ')', DB::INT);
                break;
              case 'buy_counts':
                $map->addEntry('buy_counts', 'buy_counts + (' . $value. ')', DB::INT);
                $map2->addEntry('buy_counts', 'buy_counts + (' . $value. ')', DB::INT);
                break;
              case 'cart_counts':
                $map->addEntry('cart_counts', 'cart_counts + (' . $value . ')', DB::INT);
                $map2->addEntry('cart_counts', 'cart_counts + (' . $value . ')', DB::INT);                
                break;
              case 'pay_counts':
                $map->addEntry('pay_counts', 'pay_counts + (' . $value . ')', DB::INT);
                $map2->addEntry('pay_counts', 'pay_counts + (' . $value . ')', DB::INT);
                $map3->addEntry('pay_counts', 'pay_counts + (' . $value . ')', DB::INT);
                break;
              case 'pay_amount':
                $map->addEntry('pay_amount', 'pay_amount + (' . $value . ')', DB::DECIMAL);
                $map2->addEntry('pay_amount', 'pay_amount + (' . $value . ')', DB::DECIMAL);
                $map3->addEntry('pay_amount', 'pay_amount + (' . $value . ')', DB::DECIMAL);
                break;
              case 'cost_amount':
                $map->addEntry('cost_amount', 'cost_amount + (' . $value . ')', DB::DECIMAL);
                $map2->addEntry('cost_amount', 'cost_amount + (' . $value . ')', DB::DECIMAL);
                $map3->addEntry('cost_amount', 'cost_amount + (' . $value . ')', DB::DECIMAL);
                break;
              case 'cost_offer':
                $map->addEntry('cost_offer', 'cost_offer + (' . $value . ')', DB::DECIMAL);
                $map2->addEntry('cost_offer', 'cost_offer + (' . $value . ')', DB::DECIMAL);
                $map3->addEntry('cost_offer', 'cost_offer + (' . $value . ')', DB::DECIMAL);
                break;
              case 'wishlist_counts':
                $map->addEntry('wishlist_counts', 'wishlist_counts + (' . $value . ')', DB::INT);
                $map2->addEntry('wishlist_counts', 'wishlist_counts + (' . $value . ')', DB::INT);
                $map3->addEntry('wishlist_counts', 'wishlist_counts + (' . $value . ')', DB::INT);
                break;
              case 'comment_counts':
                $map->addEntry('comment_counts', 'comment_counts + (' . $value . ')', DB::INT);
                $map2->addEntry('comment_counts', 'comment_counts + (' . $value . ')', DB::INT);
                $map3->addEntry('comment_counts', 'comment_counts + (' . $value . ')', DB::INT);
                break;
              case 'comment_value':
                $map->addEntry('comment_value', 'comment_value + (' . $value . ')', DB::INT); 
                $map2->addEntry('comment_value', 'comment_value + (' . $value . ')', DB::INT);
                $map3->addEntry('comment_value', 'comment_value + (' . $value . ')', DB::INT);
                break;
              case 'returned_counts':
                $map->addEntry('returned_counts', 'returned_counts + (' . $value . ')', DB::INT);
                $map2->addEntry('returned_counts', 'returned_counts + (' . $value . ')', DB::INT);
                break;
              case 'stock_out_counts':
                $map->addEntry('stock_out_counts', 'stock_out_counts + (' . $value . ')', DB::INT);
                $map2->addEntry('stock_out_counts', 'stock_out_counts + (' . $value . ')', DB::INT);
                $map3->addEntry('stock_out_counts', 'stock_out_counts + (' . $value . ')', DB::INT);
                break;
              case 'order_counts':
                $map3->addEntry('order_counts', 'order_counts + (' . $value . ')', DB::INT);
                break;
              case 'domain':
                $map2->addEntry('domain', $value, DB::VARCHAR);
                $map3->addEntry('domain', $value, DB::VARCHAR);
                break;
              case 'order_item_counts':
                $map3->addEntry('order_item_counts', 'order_item_counts + (' . $value . ')', DB::INT);
                break;
              case 'pay_item_counts':
                $map3->addEntry('pay_item_counts', 'pay_item_counts + (' . $value . ')', DB::INT);
                break;
              case 'payment_fee':
                 $map3->addEntry('payment_fee', 'payment_fee + (' . $value . ')', DB::DECIMAL);
                break;              
              case 'cost_offer':
                $map3->addEntry('cost_offer', 'cost_offer + (' . $value . ')', DB::DECIMAL);
                break;
              case 'cost_shipping':
                $map3->addEntry('cost_shipping', 'cost_shipping + (' . $value . ')', DB::DECIMAL);
                break;
              case 'refund_amount':
                $map3->addEntry('refund_amount', 'refund_amount + (' . $value . ')', DB::DECIMAL);
                break;              
              default : break;
        }        
      }
      if($goodsReport)
      {
        $goodsReportLogic->update($map, $cond);
      }
      else
      {
        $map->addEntry('create_year', $year, DB::INT);
        $map->addEntry('create_month', $month, DB::INT);
        $map->addEntry('create_day', $today, DB::INT);
        $goodsReportLogic->insert($map);
      }
      if($goodsLanguageReport)
      {
        $goodsLanguageReportLogic->update($map2, $cond2);
      }
      else
      {
          $map2->addEntry('create_year', $year, DB::INT);
          $map2->addEntry('create_month', $month, DB::INT);
          $map2->addEntry('create_day', $today, DB::INT);
          $map2->addEntry('language_id', $language_id, DB::INT);
          $map2->addEntry('country_id', $country_id, DB::INT);
          $goodsLanguageReportLogic->insert($map2);  
      }
      if($salesReport)
      {
        if(count($map3->getData()) > 0)
        {
           $salesReportLogic->update($map3, $cond3);
        }
      }
      else
      {
        $map3->addEntry('create_month', $month, DB::INT);
        $map3->addEntry('create_year', $year, DB::INT);     
        $map3->addEntry('create_day', $today, DB::INT);
        $map3->addEntry('language_id', $language_id, DB::INT);      
        $map3->addEntry('country_id', $country_id, DB::INT);
        $salesReportLogic->insert($map3);
      }
  }
  /**
   * 用户注册报表
   * @param type $user
   * @return type 
   */
  public static function userReport($user)
  {
      return true;
    $userReportLogic = self::load('userReport');
    return $userReportLogic->save($user);
  }
  /**
   * 用户销售报表采集
   * @param type $user_id
   * @param type $params 
   */
  public static function userSalesReport($user_id, $params)
  {
      return true;
      $userSalseReportLogic = self::load('userSalesReport');     
      $year  = date('Y', SYS_TIME);
      $month = date('Ym', SYS_TIME);
      $today = date('Ymd', SYS_TIME);      
      $cond  = 'user_id=' . $user_id . ' and create_day =' . $today;     
      $salesReport = $userSalseReportLogic->getOne($cond);
      $map   = Zhtx::createDataMap();       
      if(isset($params['customer_unit']) || isset($params['passenger_volume']))
      {
        $payed = 0;
        $fee   = 0;      
        $pay_counts    = 0;
        $cost_shipping = 0;      
        $order_counts      = 0;
        $order_item_counts = 0;
        if($salesReport)
        {
            $payed = $salesReport['pay_amount'];
            $fee   = $salesReport['payment_fee'];
            $cost_shipping = $salesReport['cost_shipping'];
            $pay_counts    = $salesReport['pay_counts'];
            $order_counts  = $salesReport['order_counts'];
            $order_item_counts  = $salesReport['order_item_counts'];
        }
        if(isset($params['pay_amount']) && $params['pay_amount'])
        {
          $payed += $params['pay_amount']; 
        }
        if(isset($params['payment_fee']) && $params['payment_fee'])
        {
          $fee += $params['payment_fee']; 
        }
        if(isset($params['cost_shipping']) && $params['cost_shipping'])
        {
          $cost_shipping += $params['cost_shipping']; 
        }
        if(isset($params['pay_counts']) && $params['pay_counts'])
        {
          $pay_counts += $params['pay_counts']; 
        }
        if(isset($params['order_counts']) && $params['order_counts'])
        {
          $order_counts += $params['order_counts']; 
        }
        if(isset($params['order_item_counts']) && $params['order_item_counts'])
        {
          $order_item_counts += $params['order_item_counts']; 
        }
        $customer_unit    = ($payed-$fee-$cost_shipping)/$pay_counts;
        $passenger_volume = $order_item_counts/$order_counts;
        $map->addEntry('customer_unit', $customer_unit, DB::DECIMAL);
        $map->addEntry('passenger_volume', $passenger_volume, DB::INT);
      }
      foreach ($params as $key => $value)
      {
        switch ($key)
        {            
              case 'cart_counts':
                $map->addEntry('cart_counts', 'cart_counts + (' . $value . ')', DB::INT);               
                break;
              case 'pay_counts':
                $map->addEntry('pay_counts', 'pay_counts + (' . $value . ')', DB::INT);               
                break;
              case 'order_amount':
                $map->addEntry('order_amount', 'order_amount + (' . $value . ')', DB::DECIMAL);               
                break;  
              case 'pay_amount':
                $map->addEntry('pay_amount', 'pay_amount + (' . $value . ')', DB::DECIMAL);               
                break;             
              case 'wishlist_counts':
                $map->addEntry('wishlist_counts', 'wishlist_counts + (' . $value . ')', DB::INT);
                break;
              case 'comment_counts':
                $map->addEntry('comment_counts', 'comment_counts + (' . $value . ')', DB::INT);               
                break;
              case 'order_counts':
                $map->addEntry('order_counts', 'order_counts + (' . $value . ')', DB::INT);
                break;              
              case 'order_item_counts':
                $map->addEntry('order_item_counts', 'order_item_counts + (' . $value . ')', DB::INT);
                break;
              case 'pay_item_counts':
                $map->addEntry('pay_item_counts', 'pay_item_counts + (' . $value . ')', DB::INT);
                break;
              case 'payment_fee':
                 $map->addEntry('payment_fee', 'payment_fee + (' . $value . ')', DB::DECIMAL);
                break;              
              case 'cost_shipping':
                $map->addEntry('cost_shipping', 'cost_shipping + (' . $value . ')', DB::DECIMAL);
                break;
              case 'refund_amount':
                $map->addEntry('refund_amount', 'refund_amount + (' . $value . ')', DB::DECIMAL);
                break;              
               case 'returned_counts':
                $map->addEntry('returned_counts', 'returned_counts + (' . $value . ')', DB::INT);               
                break;
              default : break;
        }
      }
        
        if($salesReport)
        {
          $userSalseReportLogic->update($map, $cond);
        }
        else
        {
          $map->addEntry('user_id', $user_id, DB::INT);
          $map->addEntry('create_year', $year, DB::INT);       
          $map->addEntry('create_month', $month, DB::INT);       
          $map->addEntry('create_day', $today, DB::INT);
          $userSalseReportLogic->insert($map);
        }
      
  }
  /**
   * 购物车数量减少
   * @param type $goods_id 商品ID
   * @param type $reduct_count 减少的数量
   * @param type $create_time  添加到购物车的时间
   * @param type $user_id 用户ID
   */
  public static function reduceCartCount($goods_id, $reduce_count, $create_time, $user_id=0)
  {
      return true;
    $create_day = date('Ymd', $create_time);
    $cond = 'goods_id=' . $goods_id . ' and create_day=' . $create_day;
    $goodsReportLogic = self::load('goodsReport');
    $goodsReport = $goodsReportLogic->getOne($cond);
    if($goodsReport)
    {
      $cart_counts = $goodsReport['cart_counts'] > $reduce_count ? $goodsReport['cart_counts']- $reduce_count : 0;
      $map   = Zhtx::createDataMap();
      $map->addEntry('cart_counts', $cart_counts, DB::INT);
      $goodsReportLogic->update($map, $cond);
    }
    $language_id = self::load('language')->language_id;
    $country_id  = self::load('ipJoinCountry')->getCountryId(Common::_ip2long(Common::ip()));
    $cond3 = 'goods_id=' . $goods_id . ' and create_day=' . $create_day . ' and language_id=' . $language_id . ' and country_id=' . $country_id;
    $goodsLanguageReportLogic = self::load('goodsLanguageReport');
    $glangRep = $goodsLanguageReportLogic->getOne($cond3);
    if($glangRep)
    {
      $cart_counts = $glangRep['cart_counts'] > $reduce_count ? $glangRep['cart_counts']- $reduce_count : 0;
      $map   = Zhtx::createDataMap();
      $map->addEntry('cart_counts', $cart_counts, DB::INT);
      $goodsLanguageReportLogic->update($map, $cond);
    }
    if ($user_id)
    {
      $cond2 = 'user_id=' . $user_id . ' and create_day =' . $create_day;
      $userSalesReportLogic = self::load('userSalesReport');
      $salesReport = $userSalesReportLogic->getOne($cond2);
      if($salesReport)
      {
        $cart_counts = $salesReport['cart_counts'] > $reduce_count ? $salesReport['cart_counts']- $reduce_count : 0;
        $map2   = Zhtx::createDataMap();
        $map2->addEntry('cart_counts', $cart_counts, DB::INT);
        $userSalesReportLogic->update($map2, $cond2);
      }
    }
  }
  /**
   * 更新报表数据
   * @param type $user_id
   * @param type $params 
   */
  public static function salesReportAndUserSalesReport($user_id, $language_id, $country_id, $params)
  {
      return true;
    $salesReportLogic     = self::load('salesReport');
    $userSalesReportLogic =  self::load('userSalesReport');
    $map  = Zhtx::createDataMap();
    $map2 = Zhtx::createDataMap();
    foreach($params as $key => $value)
    {
      switch ($key)
      {
        case 'order_counts':
          $map->addEntry('order_counts', 'order_counts + (' . $value . ')', DB::INT);
          $map2->addEntry('order_counts', 'order_counts + (' . $value . ')', DB::INT);
          break;
        case 'order_amount':
          $map->addEntry('order_amount', 'order_amount + (' . $value . ')', DB::DECIMAL);
          $map2->addEntry('order_amount', 'order_amount + (' . $value . ')', DB::DECIMAL);
          break;
        case 'order_item_counts':
          $map->addEntry('order_item_counts', 'order_item_counts + (' . $value . ')', DB::INT);
          $map2->addEntry('order_item_counts', 'order_item_counts + (' . $value . ')', DB::INT);
          break;
        case 'cost_shipping':
          $map->addEntry('cost_shipping', 'cost_shipping + (' . $value . ')', DB::INT);
          $map2->addEntry('cost_shipping', 'cost_shipping + (' . $value . ')', DB::INT);
          break;
         case 'cost_offer':
          $map->addEntry('cost_offer', 'cost_offer + (' . $value . ')', DB::DECIMAL);
          break;
        default : break;
      }
    }
    $year  = date('Y', SYS_TIME);
    $month = date('Ym', SYS_TIME);
    $today = date('Ymd', SYS_TIME);    
    $cond  = 'country_id ='. $country_id . ' and create_day =' . $today . ' and language_id=' . $language_id;
    $cond2 = 'user_id=' . $user_id . ' and create_day =' . $today;    
    if($salesReportLogic->getOne($cond))
    {
      $salesReportLogic->update($map, $cond);
    }
    else
    {
      $map->addEntry('language_id', $language_id, DB::INT);       
      $map->addEntry('country_id', $country_id, DB::INT);
      $map->addEntry('create_year', $year, DB::INT);       
      $map->addEntry('create_month', $month, DB::INT);       
      $map->addEntry('create_day', $today, DB::INT);
      $salesReportLogic->insert($map);
    }
    if($userSalesReportLogic->getOne($cond2))
    {
      $userSalesReportLogic->update($map2, $cond2);
    }
    else
    {      
      $map2->addEntry('user_id', $user_id, DB::INT);
      $map2->addEntry('create_year', $year, DB::INT);       
      $map2->addEntry('create_month', $month, DB::INT);       
      $map2->addEntry('create_day', $today, DB::INT);
      $userSalesReportLogic->insert($map2);
    }
  }

  /**
   *
   * @param type $keywords 用户搜索词
   * @param type $reslut   返回结果集
   */
  public static function userKeywords($keywords, $reslut)
  {
    $userKeywordsLogic = self::load('userKeywords');
    $language_id = self::load('language')->language_id;
    $map = Zhtx::createDataMap();
    $map->addEntry('keywords', $keywords, DB::VARCHAR);
    $map->addEntry('user_id', isset($reslut['user_id']) && $reslut['user_id'] ? $reslut['user_id'] : 0, DB::INT);
    $map->addEntry('result_num', isset($reslut['result_num']) && $reslut['result_num'] ? $reslut['result_num'] : 0, DB::INT);
    $map->addEntry('create_time', SYS_TIME, DB::INT);
    $map->addEntry('language_id', $language_id, DB::INT);
    $userKeywordsLogic->insert($map);
    $searchKeywordsLogic = self::load('searchkeywords');
    $search_map = Zhtx::createDataMap();
    $search_map->addEntry('search_num', 'search_num+1', DB::INT);
    $searchKeywordsLogic->update($search_map,"base_name='".$keywords."'");
  }
  public static function load($logic_name)
  {
    return Zhtx::loadModule(Module::LOGIC, ucfirst($logic_name) . 'Logic');
  }
}
?>
