<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */

require_once(APP_ROOT . "conf/db.conf.php");
require_once(APP_ROOT . "libary/DataMap.php");
require_once(APP_ROOT . "libary/DB.php");
require_once(APP_ROOT . 'conf/auth.conf.php');

abstract class Table
{

  protected $name_alias_map;
  protected $alias_name_map;
  protected $table;
  protected $table_stmt;
  protected $conj_stmt;
  protected $table_prefix = true;

  public function init()
  {   
    $this->getAliasNameMap();
    $this->getAliases();
    if (is_array($this->table))
    {
      $tableNum = count($this->table);

      for ($i = 0; $i < $tableNum; $i++)
      {
        $this->table_stmt .= DB::DB_TABLE($this->table[$i], $this->table_prefix);

        if ($i < $tableNum - 1)
          $this->table_stmt .= ",";
      }
    } 
    else
    {
      $this->table_stmt = DB::DB_TABLE($this->table, $this->table_prefix);
    }


  }

  public function isMultiple()
  {
    return is_array($this->table);
  }

  public function getTableStmt()
  {

    return $this->table_stmt;
  }

  public function getConjStmt()
  {
    return $this->conj_stmt;
  }

  public function getNames($aliases = null)
  {
    if ($aliases == null)
    {
      return @array_keys($this->name_alias_map);
    }
    else
    {
      $names = array();
      foreach ($aliases as $alias)
      {
        @$name = $this->alias_name_map[$alias];
        if (is_null($name))
          array_push($names, $alias);
        else
          array_push($names, $name);
      }
      return $names;
    }
  }

  public function aliasesToNames(&$data)
  {
    $newData = new DataMap();

    $keys = $data->getKeys();
    foreach ($keys as $key)
    {
      $n = $this->atn($key);
      $v = $data->getValue($key);
      $t = $data->getType($key);
      $newData->addEntry($n, $v, $t);
    }

    $data->assign($newData);
  }

  public function namesToAliases($data)
  {
    $this->aliasesToNames($data);
  }

  public function atn($alias)
  {
    return $this->aliasToName($alias);
  }

  public function nta($name)
  {
    return $this->nameToAlias($name);
  }

  public function getAliases($names = null)
  {
    if ($names == null)
    {
      return array_keys($this->alias_name_map);
    }
    else
    {
      $aliases = array();
      foreach ($names as $name)
      {
        $alias = $this->name_alias_map[$name];
        if (is_null($alias))
          array_push($aliases, $name);
        else
          array_push($aliases, $alias);
      }
      return $aliases;
    }
  }

  public function aliasToName($alias)
  {
    $name = $this->alias_name_map[$alias];
    if (is_null($name))
      return $alias;
    else
      return $name;
  }

  public function nameToAlias($name)
  {
    $alias = $this->name_alias_map[$name];
    if (is_null($alias))
      return $name;
    else
      return $alias;
  }

  protected function getAliasNameMap()
  {
    $this->alias_name_map = array();
    if (count($this->name_alias_map) > 0)
    {
      foreach ($this->name_alias_map as $name => $alias)
      {
        $this->alias_name_map[$alias] = $name;
      }
    }

  }
  
  

  public static function getRemoteData($url, $charsetfrom="", $charsetto="", $timeout=5, $post_data=array())
  {
      $ch = curl_init();
      $url = self::parseUrl($url);
      curl_setopt($ch, CURLOPT_URL, $url); 
      curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
      curl_setopt($ch,CURLOPT_HEADER,0);   
      curl_setopt($ch,CURLOPT_TIMEOUT,$timeout);   
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
      curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);  
      if(count($post_data)>0)
      {
          curl_setopt($ch, CURLOPT_POST, 1 );
          curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
      }

      //在需要用户检测的网页里需要增加下面两行
      /*
      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY); 
      curl_setopt($ch, CURLOPT_USERPWD, US_NAME.":".US_PWD); 
       * *
       */
      $contents = curl_exec($ch);      
      curl_close($ch); //print_r($contents);die;
      if( $charsetfrom != "" && $charsetto != "" )
      {
          $contents = iconv($charsetfrom, $charsetto,$contents);
      }
      return $contents; 

  }
  public static function parseUrl($url="")
  {
    $a = array(" ");
    $b = array("%20");
    $url = str_replace($a, $b, $url);
    return $url;
  }
}

?>
